package be.recipe.common.util;

import java.util.Calendar;

import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;

@XmlTransient
public class CalendarAdapter extends XmlAdapter<String, Calendar> {

	 @Override
	public Calendar unmarshal(String dateStr) {
		return javax.xml.bind.DatatypeConverter.parseDateTime(dateStr);
	}

	 @Override
	public String marshal(Calendar dateTime)  {
		return javax.xml.bind.DatatypeConverter.printDateTime(dateTime);
	}
}