package be.recipe.common.util;

import static org.joda.time.format.DateTimeFormat.forPattern;

import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

@XmlTransient
public class JodaDateTimeAdapter extends XmlAdapter<String, DateTime> {
  private static final DateTimeFormatter formatter = forPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");

  @Override
  public DateTime unmarshal(String dateStr) {
    return formatter.parseDateTime(dateStr);
  }

  @Override
  public String marshal(DateTime dateTime) {
    return formatter.print(dateTime);
  }
}
