package be.recipe.common;

import be.recipe.api.crypto.Message;
import be.recipe.services.executor.PrescriptionWithSecurityToken;
import be.recipe.services.executor.TimestampedPrescription;

import javax.xml.bind.*;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class JAXBTimestampingContext implements Message.Encrypted.Timestamped.Context {
  private static final JAXBContext ctx;

  static {
    try {
      ctx = JAXBContext.newInstance(TimestampedPrescription.class);
    } catch (JAXBException e) {
      throw new RuntimeException(e);
    }
  }

  @Override
  public byte[] compact(byte[] it) {
    try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
      Marshaller marshaller = ctx.createMarshaller();
      TimestampedPrescription timestamped = new TimestampedPrescription();
      PrescriptionWithSecurityToken prescription = new PrescriptionWithSecurityToken();
      prescription.setPrescriptionSealed(it);
      timestamped.setPrescriptionWithSecurityToken(prescription);
      marshaller.marshal(timestamped, out);
      return out.toByteArray();
    } catch (JAXBException | IOException e) {
      throw new RuntimeException(e);
    }
  }

  @Override
  public byte[] encrypted(byte[] it) {
    try (ByteArrayInputStream input = new ByteArrayInputStream(it)) {
      Unmarshaller unmarshaller = ctx.createUnmarshaller();
      TimestampedPrescription prescription =
          (TimestampedPrescription) unmarshaller.unmarshal(input);
      return prescription.getPrescriptionWithSecurityToken().getPrescriptionSealed();
    } catch (UnmarshalException e) {
      throw new Message.Encrypted.Timestamped.ExtractionFailed(e);
    } catch (JAXBException | IOException e) {
      throw new RuntimeException(e);
    }
  }
}
