/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.utils;

import be.business.connector.core.ehealth.services.KgssServiceImpl;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.technical.connector.utils.Crypto;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.IOUtils;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.recipe.services.executor.ListReservationsResultItem;
import java.util.concurrent.Semaphore;
import org.perf4j.aop.Profiled;

public class ReservationDecryptorThread
extends Thread {
    private ListReservationsResultItem item;
    private Semaphore semaphore;
    private byte[] pharmacyEtk;
    private byte[] kgssEtk;
    private IntegrationModuleException error;
    private Crypto crypto;

    public ReservationDecryptorThread(Semaphore available, ListReservationsResultItem item, byte[] userEtk, byte[] kgssEtk) {
        this.semaphore = available;
        this.item = item;
        this.pharmacyEtk = userEtk;
        this.kgssEtk = kgssEtk;
        this.crypto = new Crypto();
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ReservationDecryptorThread#decryption", logger="org.perf4j.TimingLogger_Common")
    public void run() {
        try {
            KeyResult keyResult = KgssServiceImpl.getInstance().retrieveKeyFromKgss(this.item.getPrescription().getEncryptionKeyId().getBytes(), this.pharmacyEtk, this.kgssEtk);
            byte[] unsealedPrescription = this.crypto.unsealForUnknown(keyResult, this.item.getPrescription().getPrescription());
            this.item.getPrescription().setPrescription(IOUtils.decompress(unsealedPrescription));
        }
        catch (Exception e) {
            this.error = new IntegrationModuleException(I18nHelper.getLabel("technical.connector.error.retrieve.key"), e);
        }
        finally {
            this.semaphore.release();
        }
    }

    public ListReservationsResultItem getListReservationsResultItem() {
        return this.item;
    }

    public void clean() {
        this.semaphore = null;
        this.item = null;
        this.pharmacyEtk = null;
        this.kgssEtk = null;
        this.error = null;
    }

    public IntegrationModuleException getError() {
        return this.error;
    }
}

