/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.utils;

import be.business.connector.common.StandaloneRequestorProvider;
import be.business.connector.core.domain.KgssIdentifierType;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.ETKHelper;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.recipe.executor.dto.ListOpenPrescriptionsResultWithExceptions;
import be.business.connector.recipe.executor.dto.ListReservationsResultWithExceptions;
import be.business.connector.recipe.utils.PrescriptionDecryptorThread;
import be.business.connector.recipe.utils.ReservationDecryptorThread;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.recipe.services.executor.GetOpenPrescriptionForExecutor;
import be.recipe.services.executor.ListOpenPrescriptionsResult;
import be.recipe.services.executor.ListReservationsResult;
import be.recipe.services.executor.ListReservationsResultItem;
import java.security.Key;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.commons.collections.CollectionUtils;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorDecryptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorDecryptionUtils.class);
    private final ETKHelper etkHelper;
    private final Map<String, KeyResult> keyCache = new HashMap<String, KeyResult>();
    private final PropertyHandler propertyHandler;
    private Key symmKey;

    public ExecutorDecryptionUtils(PropertyHandler propertyHandler, EncryptionUtils encryptionUtils) {
        this.propertyHandler = propertyHandler;
        this.etkHelper = new ETKHelper(propertyHandler, encryptionUtils);
        this.symmKey = EncryptionUtils.getInstance().generateSecretKey();
    }

    @Profiled(logFailuresSeparately=true, tag="0.DecompressionUtil#decryptPrescriptions")
    public ListOpenPrescriptionsResult decryptPrescriptions(ListOpenPrescriptionsResult listOpenPrescriptionsResult) throws IntegrationModuleException {
        if (listOpenPrescriptionsResult == null || listOpenPrescriptionsResult != null && CollectionUtils.isEmpty((Collection)listOpenPrescriptionsResult.getPrescriptions())) {
            return listOpenPrescriptionsResult;
        }
        return this.doDecryptions(listOpenPrescriptionsResult);
    }

    @Profiled(logFailuresSeparately=true, tag="0.DecompressionUtil#decryptReservations")
    public ListReservationsResult decryptReservations(ListReservationsResult listReservationsResult) throws IntegrationModuleException {
        if (listReservationsResult == null || listReservationsResult != null && CollectionUtils.isEmpty((Collection)listReservationsResult.getItems())) {
            return listReservationsResult;
        }
        return this.doDecryptions(listReservationsResult);
    }

    @Profiled(logFailuresSeparately=true, tag="0.DecompressionUtil#decryptPrescriptionsWithException")
    public ListOpenPrescriptionsResultWithExceptions decryptPrescriptionsWithException(ListOpenPrescriptionsResult listOpenPrescriptionsResult) throws IntegrationModuleException {
        if (listOpenPrescriptionsResult == null || listOpenPrescriptionsResult != null && CollectionUtils.isEmpty((Collection)listOpenPrescriptionsResult.getPrescriptions())) {
            return new ListOpenPrescriptionsResultWithExceptions();
        }
        Map<GetOpenPrescriptionForExecutor, PrescriptionDecryptorThread> dataMap = this.createThreads(listOpenPrescriptionsResult);
        ListOpenPrescriptionsResultWithExceptions result = new ListOpenPrescriptionsResultWithExceptions();
        for (PrescriptionDecryptorThread thread : dataMap.values()) {
            result.addPrescription(thread.getPrescription(), thread.getError());
        }
        result.setHasMoreResults(listOpenPrescriptionsResult.isHasMoreResults());
        result.setSession(listOpenPrescriptionsResult.getSession());
        return result;
    }

    @Profiled(logFailuresSeparately=true, tag="0.DecompressionUtil#decryptReservationsWithExceptions")
    public ListReservationsResultWithExceptions decryptReservationsWithExceptions(ListReservationsResult listReservationsResult) throws IntegrationModuleException {
        if (listReservationsResult == null || listReservationsResult != null && CollectionUtils.isEmpty((Collection)listReservationsResult.getItems())) {
            return new ListReservationsResultWithExceptions();
        }
        Map<ListReservationsResultItem, ReservationDecryptorThread> dataMap = this.createThreads(listReservationsResult);
        ListReservationsResultWithExceptions finalResult = new ListReservationsResultWithExceptions();
        for (ReservationDecryptorThread decryptorThread : dataMap.values()) {
            finalResult.addItem(decryptorThread.getListReservationsResultItem(), decryptorThread.getError());
        }
        finalResult.setHasMoreResults(listReservationsResult.isHasMoreResults());
        finalResult.setSession(listReservationsResult.getSession());
        return finalResult;
    }

    private ListOpenPrescriptionsResult doDecryptions(ListOpenPrescriptionsResult prescriptionList) {
        Map<GetOpenPrescriptionForExecutor, PrescriptionDecryptorThread> dataMap = this.createThreads(prescriptionList);
        ListOpenPrescriptionsResult finalResult = new ListOpenPrescriptionsResult();
        for (PrescriptionDecryptorThread thread : dataMap.values()) {
            finalResult.getPrescriptions().add(thread.getPrescription());
        }
        finalResult.setHasMoreResults(prescriptionList.isHasMoreResults());
        finalResult.setSession(prescriptionList.getSession());
        Collections.sort(finalResult.getPrescriptions(), new Comparator<GetOpenPrescriptionForExecutor>(){

            @Override
            public int compare(GetOpenPrescriptionForExecutor f1, GetOpenPrescriptionForExecutor f2) {
                return f2.getCreationDate().compareTo(f1.getCreationDate());
            }
        });
        return finalResult;
    }

    private ListReservationsResult doDecryptions(ListReservationsResult listReservationsResult) {
        Map<ListReservationsResultItem, ReservationDecryptorThread> dataMap = this.createThreads(listReservationsResult);
        ListReservationsResult finalResult = new ListReservationsResult();
        for (ReservationDecryptorThread thread : dataMap.values()) {
            finalResult.getItems().add(thread.getListReservationsResultItem());
        }
        finalResult.setHasMoreResults(listReservationsResult.isHasMoreResults());
        finalResult.setSession(listReservationsResult.getSession());
        Collections.sort(finalResult.getItems(), new Comparator<ListReservationsResultItem>(){

            @Override
            public int compare(ListReservationsResultItem f1, ListReservationsResultItem f2) {
                return f2.getCreationDate().compareTo(f1.getCreationDate());
            }
        });
        return finalResult;
    }

    private Map<GetOpenPrescriptionForExecutor, PrescriptionDecryptorThread> createThreads(ListOpenPrescriptionsResult listOpenPrescriptionsResult) {
        HashMap<GetOpenPrescriptionForExecutor, PrescriptionDecryptorThread> dataMap = new HashMap<GetOpenPrescriptionForExecutor, PrescriptionDecryptorThread>();
        int threadLimit = PropertyHandler.getInstance().getIntegerProperty("decryption.thread.number", "50");
        Semaphore semaphore = new Semaphore(threadLimit, true);
        String requestorIdInformation = StandaloneRequestorProvider.getRequestorIdInformation();
        byte[] pharmacyEtk = this.etkHelper.getEtks(KgssIdentifierType.NIHII_PHARMACY, requestorIdInformation).get(0).getEncoded();
        byte[] kgssEtk = this.etkHelper.getKGSS_ETK().get(0).getEncoded();
        for (GetOpenPrescriptionForExecutor getOpenPrescription : listOpenPrescriptionsResult.getPrescriptions()) {
            if (getOpenPrescription.getPrescription() == null) continue;
            PrescriptionDecryptorThread decryptorThread = new PrescriptionDecryptorThread(semaphore, getOpenPrescription, pharmacyEtk, kgssEtk);
            dataMap.put(getOpenPrescription, decryptorThread);
        }
        for (PrescriptionDecryptorThread decryptorThread : dataMap.values()) {
            semaphore.acquireUninterruptibly();
            decryptorThread.start();
        }
        try {
            semaphore.acquireUninterruptibly(threadLimit);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Incorrect Thread configuration : " + e);
        }
        return dataMap;
    }

    private Map<ListReservationsResultItem, ReservationDecryptorThread> createThreads(ListReservationsResult listReservationsResult) {
        int threadLimit = PropertyHandler.getInstance().getIntegerProperty("decryption.thread.number", "50");
        Semaphore semaphore = new Semaphore(threadLimit, true);
        HashMap<ListReservationsResultItem, ReservationDecryptorThread> dataMap = new HashMap<ListReservationsResultItem, ReservationDecryptorThread>();
        String requestorIdInformation = StandaloneRequestorProvider.getRequestorIdInformation();
        byte[] pharmacyEtk = this.etkHelper.getEtks(KgssIdentifierType.NIHII_PHARMACY, requestorIdInformation).get(0).getEncoded();
        byte[] kgssEtk = this.etkHelper.getKGSS_ETK().get(0).getEncoded();
        for (ListReservationsResultItem listReservationResultItem : listReservationsResult.getItems()) {
            if (listReservationResultItem.getPrescription() == null || listReservationResultItem.getPrescription().getPrescription() == null) continue;
            ReservationDecryptorThread decryptorThread = new ReservationDecryptorThread(semaphore, listReservationResultItem, pharmacyEtk, kgssEtk);
            dataMap.put(listReservationResultItem, decryptorThread);
        }
        for (ReservationDecryptorThread decryptorThread : dataMap.values()) {
            semaphore.acquireUninterruptibly();
            decryptorThread.start();
        }
        try {
            semaphore.acquireUninterruptibly(threadLimit);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Incorrect Thread configuration : " + e);
        }
        return dataMap;
    }
}

