/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.patient;

import be.business.connector.common.ApplicationConfig;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.handlers.InsurabilityHandler;
import be.business.connector.core.utils.Exceptionutils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.MarshallerHelper;
import be.business.connector.recipe.AbstractRecipeClient;
import be.business.connector.recipe.patient.AbstractPatientIntegrationModule;
import be.business.connector.recipe.patient.PatientIntegrationModuleV4;
import be.business.connector.recipe.patient.services.RecipePatientServiceV4Impl;
import be.business.connector.recipe.utils.RidValidator;
import be.fgov.ehealth.recipe.core.v4.SecuredContentType;
import be.fgov.ehealth.recipe.protocol.v4.CreateReservationRequest;
import be.fgov.ehealth.recipe.protocol.v4.CreateReservationResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetVisionRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetVisionResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListOpenPrescriptionsRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListOpenPrescriptionsResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListOpenRidsRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListOpenRidsResponse;
import be.fgov.ehealth.recipe.protocol.v4.PutVisionForPatientRequest;
import be.fgov.ehealth.recipe.protocol.v4.PutVisionForPatientResponse;
import be.fgov.ehealth.recipe.protocol.v4.RevokePrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v4.RevokePrescriptionResponse;
import be.recipe.services.core.ResponseType;
import be.recipe.services.patient.CreateReservationParam;
import be.recipe.services.patient.CreateReservationResult;
import be.recipe.services.patient.GetPrescriptionForPatientResult;
import be.recipe.services.patient.GetPrescriptionStatusParam;
import be.recipe.services.patient.GetPrescriptionStatusResult;
import be.recipe.services.patient.GetVisionParam;
import be.recipe.services.patient.GetVisionResult;
import be.recipe.services.patient.ListOpenRidsParam;
import be.recipe.services.patient.ListOpenRidsResult;
import be.recipe.services.patient.ListPatientPrescriptionsParam;
import be.recipe.services.patient.ListPatientPrescriptionsResult;
import be.recipe.services.patient.PutVisionParam;
import be.recipe.services.patient.PutVisionResult;
import be.recipe.services.patient.RevokePrescriptionResult;
import javax.xml.ws.WebServiceException;
import org.joda.time.DateTime;
import org.perf4j.aop.Profiled;

public class PatientIntegrationModuleV4Impl
extends AbstractPatientIntegrationModule
implements PatientIntegrationModuleV4 {
    public SecuredContentType createSecuredContentTypeV4(byte[] content) {
        SecuredContentType secured = new SecuredContentType();
        secured.setSecuredContent(content);
        return secured;
    }

    @Override
    public void revokePrescription(String rid, String reason) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidSession();
        try {
            byte[] sealedRevokePrescriptionParam = this.getSealedRevokePrescriptionParam(rid, reason);
            RevokePrescriptionRequest request = new RevokePrescriptionRequest();
            request.setSecuredRevokePrescriptionRequest(this.createSecuredContentTypeV4(sealedRevokePrescriptionParam));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            try {
                RevokePrescriptionResponse response = RecipePatientServiceV4Impl.getInstance().revokePrescription(request);
                MarshallerHelper<RevokePrescriptionResult, RevokePrescriptionResult> helper = new MarshallerHelper<RevokePrescriptionResult, RevokePrescriptionResult>(RevokePrescriptionResult.class, RevokePrescriptionResult.class);
                RevokePrescriptionResult result = helper.unsealWithSymmKey(response.getSecuredRevokePrescriptionResponse().getSecuredContent(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
        }
    }

    @Override
    public GetPrescriptionForPatientResult getPrescription(String rid) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidSession();
        InsurabilityHandler.setInsurability(null);
        InsurabilityHandler.setMessageId(null);
        try {
            byte[] sealedContent = this.getSealedGetPrescriptionForPatientParam(rid);
            GetPrescriptionRequest request = new GetPrescriptionRequest();
            request.setSecuredGetPrescriptionRequest(this.createSecuredContentTypeV4(sealedContent));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            GetPrescriptionResponse response = null;
            try {
                response = RecipePatientServiceV4Impl.getInstance().getPrescriptionForPatient(request);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
            GetPrescriptionForPatientResult finalResult = this.unsealPrescription(response.getSecuredGetPrescriptionResponse().getSecuredContent());
            return finalResult;
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PatientIntegrationModuleV4#getData(GetVisionParam)")
    public GetVisionResult getData(GetVisionParam data) {
        RidValidator.validateRid(data.getRid());
        ApplicationConfig.getInstance().assertValidSession();
        try {
            try {
                byte[] sealedContent = this.getSealedData(data);
                GetVisionRequest request = new GetVisionRequest();
                request.setSecuredGetVisionRequest(this.createSecuredContentTypeV4(sealedContent));
                request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
                request.setId(this.getId());
                request.setIssueInstant(new DateTime());
                GetVisionResponse getDataResponse = RecipePatientServiceV4Impl.getInstance().getVision(request);
                GetVisionResult getVisionResult = this.unsealGetVisionResponse(getDataResponse);
                this.checkStatus((ResponseType)getVisionResult);
                return getVisionResult;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    private GetVisionResult unsealGetVisionResponse(GetVisionResponse getVisionResponse) {
        MarshallerHelper<GetVisionResult, Object> marshaller = new MarshallerHelper<GetVisionResult, Object>(GetVisionResult.class, Object.class);
        GetVisionResult result = marshaller.unsealWithSymmKey(getVisionResponse.getSecuredGetVisionResponse().getSecuredContent(), this.getSymmKey());
        return result;
    }

    private PutVisionResult unsealPutVisionResponse(PutVisionForPatientResponse putVisionResponse) {
        MarshallerHelper<PutVisionResult, Object> marshaller = new MarshallerHelper<PutVisionResult, Object>(PutVisionResult.class, Object.class);
        PutVisionResult result = marshaller.unsealWithSymmKey(putVisionResponse.getSecuredPutVisionForPatientResponse().getSecuredContent(), this.getSymmKey());
        return result;
    }

    private CreateReservationResult unsealCreateReservationResponse(CreateReservationResponse dataResponse) {
        MarshallerHelper<CreateReservationResult, Object> marshaller = new MarshallerHelper<CreateReservationResult, Object>(CreateReservationResult.class, Object.class);
        CreateReservationResult result = marshaller.unsealWithSymmKey(dataResponse.getSecuredCreateReservationResponse().getSecuredContent(), this.getSymmKey());
        return result;
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PatientIntegrationModuleV4#putVision")
    public PutVisionResult putData(PutVisionParam putVisionParam) {
        RidValidator.validateRid(putVisionParam.getRid());
        ApplicationConfig.getInstance().assertValidSession();
        try {
            byte[] sealedContent = this.getSealedData(putVisionParam);
            PutVisionForPatientRequest request = new PutVisionForPatientRequest();
            request.setSecuredPutVisionForPatientRequest(this.createSecuredContentTypeV4(sealedContent));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            try {
                PutVisionForPatientResponse response = RecipePatientServiceV4Impl.getInstance().putVision(request);
                PutVisionResult result = this.unsealPutVisionResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PatientIntegrationModuleV4#putReservation")
    public CreateReservationResult putData(CreateReservationParam param) {
        RidValidator.validateRid(param.getRid());
        ApplicationConfig.getInstance().assertValidSession();
        try {
            CreateReservationRequest createReservationRequest = this.getCreateReservationRequest(param);
            try {
                CreateReservationResponse response = RecipePatientServiceV4Impl.getInstance().createReservation(createReservationRequest);
                CreateReservationResult result = this.unsealCreateReservationResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    @Override
    public ListPatientPrescriptionsResult listOpenPrescriptions(ListPatientPrescriptionsParam param) {
        ApplicationConfig.getInstance().assertValidSession();
        try {
            param.setSymmKey(this.getSymmKey().getEncoded());
            byte[] sealedContent = this.getSealedData(param);
            ListOpenPrescriptionsRequest request = new ListOpenPrescriptionsRequest();
            request.setSecuredListOpenPrescriptionsRequest(this.createSecuredContentTypeV4(sealedContent));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            ListOpenPrescriptionsResponse response = null;
            try {
                response = RecipePatientServiceV4Impl.getInstance().listOpenPrescriptions(request);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.prescriber"), cte);
            }
            MarshallerHelper<ListPatientPrescriptionsResult, ListPatientPrescriptionsParam> helper = new MarshallerHelper<ListPatientPrescriptionsResult, ListPatientPrescriptionsParam>(ListPatientPrescriptionsResult.class, ListPatientPrescriptionsParam.class);
            ListPatientPrescriptionsResult result = helper.unsealWithSymmKey(response.getSecuredListOpenPrescriptionsResponse().getSecuredContent(), this.getSymmKey());
            this.checkStatus((ResponseType)result);
            return result;
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PatientIntegrationModuleV4#getData(GetPrescriptionStatusParam)")
    public GetPrescriptionStatusResult getData(GetPrescriptionStatusParam data) {
        RidValidator.validateRid(data.getRid());
        ApplicationConfig.getInstance().assertValidSession();
        try {
            byte[] sealedContent = this.getSealedData(data);
            GetPrescriptionStatusRequest request = new GetPrescriptionStatusRequest();
            request.setSecuredGetPrescriptionStatusRequest(this.createSecuredContentTypeV4(sealedContent));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            try {
                GetPrescriptionStatusResponse response = RecipePatientServiceV4Impl.getInstance().getPrescriptionStatus(request);
                GetPrescriptionStatusResult result = this.unsealGetPrescriptionStatusResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    private GetPrescriptionStatusResult unsealGetPrescriptionStatusResponse(GetPrescriptionStatusResponse response) {
        MarshallerHelper<GetPrescriptionStatusResult, Object> marshaller = new MarshallerHelper<GetPrescriptionStatusResult, Object>(GetPrescriptionStatusResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getSecuredGetPrescriptionStatusResponse().getSecuredContent(), this.getSymmKey());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PatientIntegrationModuleV4#getData(ListOpenPrescriptionsParam)")
    public ListOpenRidsResult getData(ListOpenRidsParam data) {
        ApplicationConfig.getInstance().assertValidSession();
        try {
            ListOpenRidsRequest request = this.getListOpenRids(data);
            try {
                ListOpenRidsResponse getDataResponse = RecipePatientServiceV4Impl.getInstance().listOpenRids(request);
                ListOpenRidsResult unsealedResponse = this.unsealListOpenPrescriptionResponse(getDataResponse);
                this.checkStatus((ResponseType)unsealedResponse);
                return unsealedResponse;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    private ListOpenRidsResult unsealListOpenPrescriptionResponse(ListOpenRidsResponse response) {
        MarshallerHelper<ListOpenRidsResult, Object> marshaller = new MarshallerHelper<ListOpenRidsResult, Object>(ListOpenRidsResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getSecuredListOpenRidsResponse().getSecuredContent(), this.getSymmKey());
    }

    protected GetVisionRequest getVisionRequest(GetVisionParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        GetVisionRequest request = new GetVisionRequest();
        request.setSecuredGetVisionRequest(this.createSecuredContentTypeV4(this.getSealedData(data)));
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setIssueInstant(new DateTime());
        request.setId(this.getId());
        return request;
    }

    protected PutVisionForPatientRequest putVision(PutVisionParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        PutVisionForPatientRequest request = new PutVisionForPatientRequest();
        request.setSecuredPutVisionForPatientRequest(this.createSecuredContentTypeV4(this.getSealedData(data)));
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setIssueInstant(new DateTime());
        request.setId(this.getId());
        return request;
    }

    public CreateReservationRequest getCreateReservationRequest(CreateReservationParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        CreateReservationRequest request = new CreateReservationRequest();
        request.setSecuredCreateReservationRequest(this.createSecuredContentTypeV4(this.getSealedData(data)));
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setIssueInstant(new DateTime());
        request.setId(this.getId());
        return request;
    }

    protected ListOpenRidsRequest getListOpenRids(ListOpenRidsParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        ListOpenRidsRequest request = new ListOpenRidsRequest();
        request.setSecuredListOpenRidsRequest(this.createSecuredContentTypeV4(this.getSealedData(data)));
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setIssueInstant(new DateTime());
        request.setId(this.getId());
        return request;
    }

    public byte[] getSealedData(GetPrescriptionStatusParam request) {
        request.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(request, GetPrescriptionStatusParam.class);
    }

    private byte[] getSealedData(ListOpenRidsParam request) {
        request.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(request, ListOpenRidsParam.class);
    }

    private byte[] getSealedData(CreateReservationParam request) {
        request.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(request, CreateReservationParam.class);
    }

    private byte[] getSealedData(GetVisionParam request) {
        request.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(request, GetVisionParam.class);
    }

    public byte[] getSealedData(PutVisionParam request) {
        request.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(request, PutVisionParam.class);
    }
}

