/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.executor.dto;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.recipe.services.core.ResponseType;
import be.recipe.services.executor.ListReservationsResultItem;
import java.util.Calendar;
import java.util.Map;
import java.util.TreeMap;
import java8.util.Comparators;
import java8.util.Objects;
import java8.util.function.Function;
import java8.util.function.Predicate;
import java8.util.stream.StreamSupport;

public class ListReservationsResultWithExceptions
extends ResponseType {
    protected final Map<ListReservationsResultItem, IntegrationModuleException> items = new TreeMap<ListReservationsResultItem, IntegrationModuleException>(Comparators.comparing(ListReservationsResultWithExceptions.byCreationDate()));
    protected Boolean hasMoreResults;
    protected byte[] session;

    private static Function<ListReservationsResultItem, Calendar> byCreationDate() {
        return new Function<ListReservationsResultItem, Calendar>(){

            public Calendar apply(ListReservationsResultItem it) {
                return it.getCreationDate();
            }
        };
    }

    public boolean exceptionOccurred() {
        return StreamSupport.stream(this.items.values()).anyMatch(ListReservationsResultWithExceptions.nonNull());
    }

    private static Predicate<IntegrationModuleException> nonNull() {
        return new Predicate<IntegrationModuleException>(){

            public boolean test(IntegrationModuleException e) {
                return Objects.nonNull((Object)e);
            }
        };
    }

    public void addItem(ListReservationsResultItem item, IntegrationModuleException exception) {
        this.items.put(item, exception);
    }

    public Map<ListReservationsResultItem, IntegrationModuleException> getItems() {
        return this.items;
    }

    public Boolean isHasMoreResults() {
        return this.hasMoreResults;
    }

    public void setHasMoreResults(Boolean value) {
        this.hasMoreResults = value;
    }

    public byte[] getSession() {
        return this.session;
    }

    public void setSession(byte[] value) {
        this.session = value;
    }

    public Boolean getHasMoreResults() {
        return this.hasMoreResults;
    }
}

