/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe;

import be.business.connector.common.ehealth.EhealthCipher;
import be.business.connector.common.ehealth.EhealthKeyRegistry;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.recipe.RoutingMandateService;
import be.business.connector.recipe.RoutingPrescriptionService;
import be.business.connector.recipe.RoutingReservationService;
import be.business.connector.recipe.executor.RecipeExecutorClient;
import be.business.connector.recipe.executor.TimestampingContext;
import be.business.connector.recipe.patient.RecipePatientClient;
import be.business.connector.recipe.prescriber.RecipePrescriberClient;
import be.recipe.api.MandateService;
import be.recipe.api.Prescription;
import be.recipe.api.PrescriptionService;
import be.recipe.api.Recipe;
import be.recipe.api.crypto.Message;
import be.recipe.api.reservation.ReservationService;
import java.util.UUID;
import java8.util.function.Supplier;
import javax.xml.datatype.DatatypeConfigurationException;

public class RecipeClientInfrastructure
implements Recipe.Infrastructure {
    private final EhealthKeyRegistry ehealthKeyRegistry = new EhealthKeyRegistry();
    private final EhealthCipher cipher = new EhealthCipher();
    private final RecipePrescriberClient prescriberClient;
    private final RecipeExecutorClient executorClient;
    private final RecipePatientClient patientClient;

    public RecipeClientInfrastructure(Dependencies deps) throws DatatypeConfigurationException {
        this.prescriberClient = new RecipePrescriberClient((Message.Cipher.Key.DB<Prescription.OnContent>)this.ehealthKeyRegistry, (Message.Cipher)this.cipher, RecipeClientInfrastructure.traceId(deps));
        this.executorClient = new RecipeExecutorClient(this.ehealthKeyRegistry, this.cipher, RecipeClientInfrastructure.traceId(deps));
        this.patientClient = new RecipePatientClient(this.ehealthKeyRegistry, this.cipher, RecipeClientInfrastructure.traceId(deps));
    }

    private static Supplier<String> traceId(final Dependencies deps) {
        return new Supplier<String>(){

            public String get() {
                return deps.traceId();
            }
        };
    }

    public RecipeClientInfrastructure(PropertyHandler props) throws DatatypeConfigurationException {
        this(new Dependencies(){

            @Override
            public String traceId() {
                return UUID.randomUUID().toString();
            }
        });
        this.refresh(props);
    }

    public RoutingPrescriptionService prescriptionService() {
        return new RoutingPrescriptionService(this.prescriberClient, this.executorClient, this.patientClient);
    }

    public RecipePrescriberClient prescriberClient() {
        return this.prescriberClient;
    }

    public RecipeExecutorClient executorClient() {
        return this.executorClient;
    }

    public RecipePatientClient patientClient() {
        return this.patientClient;
    }

    public EhealthCipher cipher() {
        return this.cipher;
    }

    public EhealthKeyRegistry keyRegistry() {
        return this.ehealthKeyRegistry;
    }

    public Message.Encrypted.Timestamped.Extractor timestampingContext() {
        return new TimestampingContext();
    }

    public ReservationService.Simplified reservationService() {
        return new RoutingReservationService(this.executorClient, this.patientClient);
    }

    public MandateService.Simplified mandateService() {
        return new RoutingMandateService(this.executorClient);
    }

    public static PrescriptionService.Ciphering client() throws DatatypeConfigurationException {
        RecipeClientInfrastructure infrastructure = new RecipeClientInfrastructure(PropertyHandler.getInstance());
        Recipe recipe = new Recipe((Recipe.Infrastructure)infrastructure);
        PrescriptionService.Ciphering.Simplified client = recipe.cipheringPrescriptionService();
        return client;
    }

    private void refresh(PropertyHandler props) {
        this.prescriberClient.refresh(props);
    }

    public static interface Dependencies {
        public String traceId();
    }
}

