/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import be.business.connector.common.Initializer;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.Exceptionutils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.IOUtils;
import be.business.connector.core.utils.OsUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java8.util.function.Consumer;
import java8.util.function.Function;
import java8.util.function.Predicate;
import java8.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyHandler {
    private static Logger LOG = LoggerFactory.getLogger(PropertyHandler.class);
    private static PropertyHandler instance = null;
    private static Function<Path, String> parentPathGenerator = new Function<Path, String>(){

        public String apply(Path path) {
            return path.toAbsolutePath().toString();
        }
    };
    private Properties properties;
    private boolean log4jInitialized = false;

    public PropertyHandler() {
        this(null, new InputStream[]{null, null});
    }

    public PropertyHandler(String propertyfile, String validationFile) {
        this(propertyfile, validationFile, null);
    }

    public PropertyHandler(String propertyfile, String validationFile, String ignored) {
        this(PropertyHandler.parentPath(propertyfile), PropertyHandler.inputStream(propertyfile), PropertyHandler.inputStream(validationFile));
    }

    public static String parentPath(String propertyfile) {
        return ((String)parentPathGenerator.apply((Object)PropertyHandler.path(propertyfile).getParent())).replace("\\", "/");
    }

    private static InputStream inputStream(String propertyfile) {
        try {
            return Files.newInputStream(PropertyHandler.path(propertyfile), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Path path(String propertyfile) {
        return Paths.get(OsUtils.isWindows() ? propertyfile.replaceAll("^/+", "") : propertyfile, new String[0]);
    }

    public PropertyHandler(String configDir, InputStream stream) {
        this(configDir, new InputStream[]{stream});
    }

    public PropertyHandler(final String configDir, InputStream ... inputStreams) {
        try {
            this.properties = new Properties();
            if (this.log4jInitialized) {
                LOG.debug("Loading the default File");
            }
            this.properties.load(IOUtils.getResourceAsStream("/connector-default.properties"));
            if (this.log4jInitialized && inputStreams.length > 0) {
                LOG.debug("Loading custom configuration...");
            }
            for (InputStream stream : inputStreams) {
                this.properties.load(stream);
            }
            StreamSupport.stream(this.properties.entrySet()).filter((Predicate)new Predicate<Map.Entry<Object, Object>>(){

                public boolean test(Map.Entry<Object, Object> it) {
                    return ((String)it.getValue()).contains("%CONF%");
                }
            }).forEach((Consumer)new Consumer<Map.Entry<Object, Object>>(){

                public void accept(Map.Entry<Object, Object> it) {
                    PropertyHandler.this.properties.put(it.getKey(), ((String)it.getValue()).replaceAll("%CONF%", configDir));
                }
            });
            instance = this;
            for (Initializer initializer : ServiceLoader.load(Initializer.class)) {
                initializer.initialize(this);
            }
            LOG.debug("Properties updated.....");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Current folder is : " + new File(".").getCanonicalPath());
                LOG.debug("Current properties are : ");
                for (Object e : this.properties.keySet()) {
                    LOG.debug(e + " = " + this.properties.getProperty((String)e));
                }
            }
            LOG.debug("Log4j initialized.....");
        }
        catch (Exception e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.propertyfile"), e);
        }
        finally {
            for (InputStream inputStream : inputStreams) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.warn("Failed closing inputstream: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public PropertyHandler(Properties properties) {
        this.properties = properties;
        instance = this;
    }

    @Profiled(logFailuresSeparately=true, tag="0.PropertyHandler#getInstance", logger="org.perf4j.TimingLogger_Common")
    public static PropertyHandler getInstance() {
        return instance;
    }

    public static PropertyHandler create(InputStream props, InputStream validationProps, String confDir) throws IOException {
        try (InputStream x = props;){
            PropertyHandler propertyHandler;
            block12: {
                InputStream y = validationProps;
                try {
                    propertyHandler = new PropertyHandler(confDir, x, y);
                    if (y == null) break block12;
                }
                catch (Throwable throwable) {
                    if (y != null) {
                        try {
                            y.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                y.close();
            }
            return propertyHandler;
        }
    }

    public static void withParentPathGenerator(Function<Path, String> generator, Runnable task) {
        Function<Path, String> defaultGenerator = parentPathGenerator;
        try {
            parentPathGenerator = generator;
            task.run();
        }
        finally {
            parentPathGenerator = defaultGenerator;
        }
    }

    public String getProperty(String string) {
        return this.getProperty(string, null);
    }

    public Integer getIntegerProperty(String string) {
        return Integer.parseInt(this.getProperty(string));
    }

    public URL getURLProperty(String string) {
        try {
            String prop = this.getProperty(string);
            if (prop != null && prop.contains("META-INF")) {
                return this.getClass().getResource(prop);
            }
            String wsdl = this.getProperty(string);
            if (wsdl == null) {
                return null;
            }
            File f = new File(wsdl);
            if (f.exists()) {
                return f.toURI().toURL();
            }
            URL url = null;
            try {
                url = new URL(wsdl);
            }
            catch (MalformedURLException e) {
                throw new IntegrationModuleException(I18nHelper.getLabel("wsdl.not.found", new String[]{prop}));
            }
            try {
                LOG.debug("Checking connection with " + wsdl);
                url.openStream().close();
            }
            catch (IOException e) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.could.not.reach.url", new Object[]{wsdl}), e);
            }
            return url;
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    public Integer getIntegerProperty(String string, String defaultValue) {
        return Integer.parseInt(this.getProperty(string, defaultValue));
    }

    public String getProperty(String string, String defaultValue) {
        if (this.properties == null) {
            LOG.warn("Properties are not initialized");
            return defaultValue;
        }
        if (!this.properties.containsKey(string)) {
            LOG.warn("Undefined property : " + string);
        }
        String propertyValue = this.properties.getProperty(string, defaultValue);
        if (!StringUtils.contains((CharSequence)string.toLowerCase(), (CharSequence)"password")) {
            LOG.debug("loading property " + string + " DefaultValue : " + defaultValue + " value returned : " + propertyValue);
        }
        return propertyValue != null ? propertyValue.trim() : propertyValue;
    }

    public boolean hasProperty(String key) {
        return this.properties != null && this.properties.containsKey(key);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Properties getPropertiesCopy() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.properties);
        return copy;
    }

    public List<String> getMatchingProperties(String rootKey) {
        int i = 1;
        ArrayList<String> ret = new ArrayList<String>();
        String key;
        while (this.properties.getProperty(key = rootKey + "." + i) != null) {
            ret.add(this.getProperty(key));
            ++i;
        }
        return ret;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public boolean isLog4jInitialized() {
        return this.log4jInitialized;
    }

    public void setLog4jInitialized(boolean log4jInitialized) {
        this.log4jInitialized = log4jInitialized;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean getBooleanProperty(String value, String defaultValue) {
        return Boolean.valueOf(this.getProperty(value, defaultValue));
    }
}

