/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import be.business.connector.core.exceptions.IntegrationModuleException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class PersistentCache {
    private Map<String, byte[]> cache = new LinkedHashMap<String, byte[]>();
    private static PersistentCache persistenceCache;

    private PersistentCache() throws IntegrationModuleException {
    }

    public static PersistentCache getInstance() {
        if (persistenceCache == null) {
            persistenceCache = new PersistentCache();
        }
        return persistenceCache;
    }

    public byte[] get(String keyId) {
        Validate.notNull((Object)keyId, (String)"keyId can't be Null", (Object[])new Object[0]);
        if (this.cache.containsKey(keyId)) {
            return this.cache.get(keyId);
        }
        return new byte[0];
    }

    public boolean containsKey(String keyId) {
        return this.cache.containsKey(keyId);
    }

    public void put(String key, byte[] value) {
        Validate.notNull((Object)key, (String)"key can't be Null", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"value can't be Null", (Object[])new Object[0]);
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, value);
        }
    }

    public static String rewriteKey(String key) {
        Validate.notNull((Object)key, (String)"key can't be Null", (Object[])new Object[0]);
        return key.replaceAll("\\/", "_");
    }

    public void clear() {
        this.cache.clear();
    }
}

