/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import be.business.connector.core.exceptions.IntegrationModuleEhealthException;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.exceptions.IntegrationModuleRuntimeException;
import be.business.connector.core.exceptions.IntegrationModuleValidationException;
import be.business.connector.core.exceptions.XMLGenerationException;
import be.business.connector.core.exceptions.XMLValidationException;
import be.business.connector.core.utils.I18nHelper;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exceptionutils {
    private static final Logger LOG = LoggerFactory.getLogger(Exceptionutils.class);

    private Exceptionutils() {
    }

    public static void errorHandler(Throwable t) {
        if (t instanceof IntegrationModuleRuntimeException) {
            LOG.error("", t);
            throw (IntegrationModuleRuntimeException)t;
        }
        if (t instanceof IntegrationModuleEhealthException) {
            LOG.error("", t);
            throw (IntegrationModuleEhealthException)t;
        }
        if (t.getCause() instanceof IntegrationModuleEhealthException) {
            LOG.error("", t);
            throw (IntegrationModuleEhealthException)t.getCause();
        }
        if (t instanceof IntegrationModuleValidationException) {
            List<String> list = ((IntegrationModuleValidationException)t).getValidationErrors();
            if (!CollectionUtils.isEmpty(list)) {
                LOG.info("***************** ValidationErrors begin *****************");
                for (String error : list) {
                    LOG.info("ValidationError occured: " + error);
                }
                LOG.info("***************** ValidationErrors  end  *****************");
            }
            throw (IntegrationModuleValidationException)t;
        }
        if (t instanceof IntegrationModuleException) {
            LOG.error("", t);
            throw (IntegrationModuleException)t;
        }
        LOG.error("", t);
        throw new IntegrationModuleException(I18nHelper.getLabel("error.technical"), t);
    }

    public static void errorHandler(Throwable t, String errorMsg) {
        if (t instanceof IntegrationModuleRuntimeException) {
            LOG.error("", t);
            throw (IntegrationModuleRuntimeException)t;
        }
        if (t instanceof IntegrationModuleEhealthException) {
            LOG.error("", t);
            throw (IntegrationModuleEhealthException)t;
        }
        if (t.getCause() instanceof IntegrationModuleEhealthException) {
            LOG.error("", t);
            throw (IntegrationModuleEhealthException)t.getCause();
        }
        if (t instanceof IntegrationModuleValidationException) {
            List<String> list = ((IntegrationModuleValidationException)t).getValidationErrors();
            if (!CollectionUtils.isEmpty(list)) {
                LOG.info("***************** ValidationErrors begin *****************");
                for (String error : list) {
                    LOG.info("ValidationError occured: " + error);
                }
                LOG.info("***************** ValidationErrors  end  *****************");
            }
            throw (IntegrationModuleValidationException)t;
        }
        if (t instanceof IntegrationModuleException) {
            LOG.error("", t);
            throw (IntegrationModuleException)t;
        }
        if (t instanceof XMLValidationException) {
            LOG.error("", t);
            throw (XMLValidationException)t;
        }
        if (t instanceof XMLGenerationException) {
            LOG.error("", t);
            throw (XMLGenerationException)t;
        }
        LOG.error("", t);
        throw new IntegrationModuleException(I18nHelper.getLabel(errorMsg), t);
    }
}

