/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import be.business.connector.core.domain.KgssIdentifierType;
import be.business.connector.core.ehealth.services.KeyDepotService;
import be.business.connector.core.ehealth.services.KeyDepotServiceImpl;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.exceptions.IntegrationModuleRuntimeException;
import be.business.connector.core.utils.CertificateParser;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.Exceptionutils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.IOUtils;
import be.business.connector.core.utils.PropertyHandler;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionTokenFactory;
import java.io.InputStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETKHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ETKHelper.class);
    private static final String RIZIV_CBE = "0206653946";
    private static final String EHEALTH_CBE = "0809394427";
    private static final String MY_ETK_PROPERTY = "MY_ETK";
    private PropertyHandler propertyHandler;
    private EncryptionUtils encryptionUtils;
    private static Map<String, List<EncryptionToken>> etksCache = new HashMap<String, List<EncryptionToken>>();
    private KeyDepotService keyDepotService = KeyDepotServiceImpl.getInstance();

    public ETKHelper(PropertyHandler propertyHandler, EncryptionUtils encryptionUtils) {
        this.propertyHandler = propertyHandler;
        this.encryptionUtils = encryptionUtils;
    }

    @Profiled(logFailuresSeparately=true, tag="0.ETKHelper#getKGSS_ETK", logger="org.perf4j.TimingLogger_Common")
    public List<EncryptionToken> getKGSS_ETK() throws IntegrationModuleException {
        return this.getEtks(KgssIdentifierType.CBE, EHEALTH_CBE, "KGSS");
    }

    @Profiled(logFailuresSeparately=true, tag="0.ETKHelper#getRecipe_ETK", logger="org.perf4j.TimingLogger_Common")
    public List<EncryptionToken> getRecipe_ETK() throws IntegrationModuleException {
        String recipeCbe = this.propertyHandler.getProperty("etk-helper.recipe-cbe");
        if (StringUtils.isBlank((String)recipeCbe)) {
            recipeCbe = RIZIV_CBE;
        }
        return this.getEtks(KgssIdentifierType.CBE, recipeCbe, "RECIPE");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Profiled(logFailuresSeparately=true, tag="0.ETKHelper#getSystemETK", logger="org.perf4j.TimingLogger_Common")
    public List<EncryptionToken> getSystemETK() throws IntegrationModuleException {
        String identifierValue;
        KgssIdentifierType identifierType;
        String application;
        block11: {
            block9: {
                String myETK;
                block10: {
                    application = "";
                    identifierType = null;
                    identifierValue = "";
                    if (!this.propertyHandler.hasProperty(MY_ETK_PROPERTY)) break block9;
                    myETK = this.propertyHandler.getProperty(MY_ETK_PROPERTY);
                    if (myETK.indexOf(59) <= -1) break block10;
                    String[] etk = myETK.split(";");
                    if (etk.length > 1) {
                        identifierType = KgssIdentifierType.lookup(etk[0].toUpperCase());
                        identifierValue = etk[1];
                        if (etk.length >= 3) {
                            application = etk[2];
                        }
                    }
                    break block11;
                }
                try {
                    InputStream etkStream = IOUtils.getResourceAsStream(myETK);
                    byte[] etk = IOUtils.getBytes(etkStream);
                    ArrayList<EncryptionToken> encryptionTokens = new ArrayList<EncryptionToken>();
                    EncryptionToken etkToken = EncryptionTokenFactory.getInstance().create(etk);
                    encryptionTokens.add(etkToken);
                    return encryptionTokens;
                }
                catch (Exception e) {
                    throw new IntegrationModuleException("Invalid ETK", e);
                }
            }
            X509Certificate certificate = this.encryptionUtils.getCertificate();
            if (certificate == null) {
                throw new IntegrationModuleRuntimeException(I18nHelper.getLabel("error.notfound.system.certificate"));
            }
            try {
                certificate.checkValidity();
            }
            catch (CertificateExpiredException e) {
                throw new IntegrationModuleRuntimeException(I18nHelper.getLabel("error.expired.system.certificate"), e);
            }
            catch (CertificateNotYetValidException e) {
                throw new IntegrationModuleRuntimeException(I18nHelper.getLabel("error.invalid.system.certificate"), e);
            }
            CertificateParser parser = new CertificateParser(certificate);
            identifierType = KgssIdentifierType.lookup(parser.getType());
            identifierValue = parser.getValue();
            application = parser.getApplication();
        }
        if (identifierType != null && identifierValue != null && !"".equals(identifierValue)) {
            return this.getEtks(identifierType, Long.valueOf(identifierValue), application);
        }
        throw new IntegrationModuleException(I18nHelper.getLabel("error.invalid.system.certificate"));
    }

    public List<EncryptionToken> getEtks(KgssIdentifierType identifierType, String identifierValue) throws IntegrationModuleException {
        if (StringUtils.isBlank((String)identifierValue)) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.invalid.etk"));
        }
        return this.getEtks(identifierType, identifierValue, "");
    }

    public List<EncryptionToken> getEtks(KgssIdentifierType identifierType, Long identifierValue, String applicationid) throws IntegrationModuleException {
        if (null != identifierType) {
            switch (identifierType) {
                case CBE: {
                    return this.getEtks(KgssIdentifierType.CBE, ETKHelper.longToString(identifierValue, 10), applicationid);
                }
                case SSIN: {
                    return this.getEtks(KgssIdentifierType.SSIN, ETKHelper.longToString(identifierValue, 11), applicationid);
                }
                case NIHII_PHARMACY: {
                    return this.getEtks(KgssIdentifierType.NIHII_PHARMACY, ETKHelper.longToString(identifierValue, 8), applicationid);
                }
                case NIHII_HOSPITAL: {
                    return this.getEtks(KgssIdentifierType.NIHII_HOSPITAL, ETKHelper.longToString(identifierValue, 8), applicationid);
                }
            }
        }
        return this.getEtks(KgssIdentifierType.NIHII, ETKHelper.longToString(identifierValue / 1000L, 8), applicationid);
    }

    private List<EncryptionToken> getEtks(KgssIdentifierType identifierType, String identifierValue, String application) throws IntegrationModuleException {
        String etkCacheId = (Object)((Object)identifierType) + "/" + identifierValue + "/" + application;
        if (etksCache.containsKey(etkCacheId)) {
            LOG.info("ETK retrieved from the cache : " + etkCacheId);
            return etksCache.get(etkCacheId);
        }
        List<EncryptionToken> encryptionTokens = this.getEtksFromDepot(identifierType, identifierValue, application);
        etksCache.put(etkCacheId, encryptionTokens);
        return encryptionTokens;
    }

    private List<EncryptionToken> getEtksFromDepot(KgssIdentifierType identifierType, String identifierValue, String application) throws IntegrationModuleException {
        try {
            List<EncryptionToken> encryptiontokens = this.keyDepotService.retrieveEtk(identifierType, identifierValue, application);
            return encryptiontokens;
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    public static String longToString(Long id, int numberOfDigits) {
        if (id == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(Long.toString(id));
        int delta = numberOfDigits - buffer.length();
        if (delta == 0) {
            return buffer.toString();
        }
        if (delta < 0) {
            throw new IllegalArgumentException("numberOfDigits < input length");
        }
        while (delta > 0) {
            buffer.insert(0, "0");
            --delta;
        }
        return buffer.toString();
    }

    public static String subString(String id, int numberOfDigits) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(id);
        int delta = numberOfDigits - buffer.length();
        if (delta == 0) {
            return buffer.toString();
        }
        if (delta < 0) {
            throw new IllegalArgumentException("numberOfDigits < input length");
        }
        while (delta > 0) {
            buffer.insert(0, "0");
            --delta;
        }
        return buffer.toString();
    }
}

