/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.technical.connector.utils;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.EncryptionUtils;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.fgov.ehealth.etee.crypto.decrypt.DataUnsealer;
import be.fgov.ehealth.etee.crypto.decrypt.UnsealedData;
import be.fgov.ehealth.etee.crypto.encrypt.DataSealer;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import java.util.List;
import javax.crypto.SecretKey;

public class Crypto {
    private static final String TECHNICAL_CONNECTOR_ERROR_DATA_SEAL = "technical.connector.error.data.seal";
    private static DataSealer dataSealer;
    private static DataUnsealer dataUnsealer;
    private static EncryptionUtils encryptionUtils;

    public Crypto() {
        try {
            dataSealer = EncryptionUtils.getInstance().initSealing();
            dataUnsealer = EncryptionUtils.getInstance().initUnsealing();
            encryptionUtils = EncryptionUtils.getInstance();
        }
        catch (Exception ex) {
            throw new IntegrationModuleException(TECHNICAL_CONNECTOR_ERROR_DATA_SEAL, ex);
        }
    }

    public byte[] seal(EncryptionToken etk, byte[] data) {
        try {
            return Crypto.getDataSealer().seal(etk, data);
        }
        catch (Exception ex) {
            throw new IntegrationModuleException(TECHNICAL_CONNECTOR_ERROR_DATA_SEAL, ex);
        }
    }

    public byte[] seal(byte[] data, SecretKey secretKey, String keyId) {
        try {
            return Crypto.getDataSealer().seal(data, secretKey, keyId);
        }
        catch (Exception ex) {
            throw new IntegrationModuleException(TECHNICAL_CONNECTOR_ERROR_DATA_SEAL, ex);
        }
    }

    public byte[] seal(List<EncryptionToken> etks, byte[] data) {
        return this.seal(etks.get(0), data);
    }

    public byte[] unseal(byte[] data) throws IntegrationModuleException {
        try {
            return Crypto.getEncryptionUtils().unsealingData((CryptoResult<UnsealedData>)Crypto.getDataUnsealer().unseal(data));
        }
        catch (Exception ex) {
            throw new IntegrationModuleException(TECHNICAL_CONNECTOR_ERROR_DATA_SEAL, ex);
        }
    }

    public byte[] unsealForUnknown(KeyResult keyResult, byte[] data) {
        return this.unseal(keyResult.getSecretKey(), data);
    }

    public byte[] unseal(SecretKey secretKey, byte[] data) {
        try {
            return Crypto.getEncryptionUtils().unsealingData((CryptoResult<UnsealedData>)Crypto.getDataUnsealer().unseal(data, secretKey));
        }
        catch (Exception ex) {
            throw new IntegrationModuleException(TECHNICAL_CONNECTOR_ERROR_DATA_SEAL, ex);
        }
    }

    private static DataSealer getDataSealer() throws Exception {
        if (dataSealer == null) {
            dataSealer = EncryptionUtils.getInstance().initSealing();
        }
        return dataSealer;
    }

    private static DataUnsealer getDataUnsealer() throws Exception {
        if (dataUnsealer == null) {
            dataUnsealer = EncryptionUtils.getInstance().initUnsealing();
        }
        return dataUnsealer;
    }

    private static EncryptionUtils getEncryptionUtils() {
        if (encryptionUtils == null) {
            encryptionUtils = EncryptionUtils.getInstance();
        }
        return encryptionUtils;
    }
}

