/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.common.ehealth;

import be.business.connector.core.ehealth.services.KgssService;
import be.business.connector.core.ehealth.services.KgssServiceImpl;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.ETKHelper;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.PropertyHandler;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.recipe.api.Prescription;
import be.recipe.api.crypto.Message;
import be.recipe.api.executor.Executor;
import be.recipe.api.patient.Patient;
import be.recipe.api.prescriber.Prescriber;
import be.recipe.api.prescriber.PrescriberType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java8.util.function.Consumer;
import java8.util.function.Functions;
import java8.util.stream.RefStreams;
import java8.util.stream.Stream;
import javax.crypto.SecretKey;

public class EhealthKeyRegistry
implements Message.Cipher.Key.DB<Prescription.OnContent> {
    private static final String the_prescription_prescriber = "urn:be:fgov:identification-namespace,urn:be:fgov:person:ssin:ehealth:1.0:nihii:%TYPE%:nihii11,%PRESCRIBER_NIHII%";
    private static final String the_patient = "urn:be:fgov:identification-namespace,urn:be:fgov:person:ssin,%PATIENT_SSIN%";
    private static final String known_dentists = "urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:person:ssin:ehealth:1.0:dentist:nihii11,";
    private static final String known_physicians = "urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:person:ssin:ehealth:1.0:doctor:nihii11,";
    private static final String known_midwifes = "urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:person:ssin:ehealth:1.0:nihii:midwife:nihii11,";
    private static final String known_nurses = "urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:person:ssin:ehealth:1.0:nurse:nihii11,";
    private static final String known_hospitals = "urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:ehealth:1.0:hospital:nihii-number,";
    private static final String known_executors = "urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:ehealth:1.0:pharmacy:nihii-number:recognisedpharmacy:boolean,true";
    private final KgssService kgss = KgssServiceImpl.getInstance();
    private PropertyHandler configuration;
    private ETKHelper etkHelper;

    public EhealthKeyRegistry() {
        this(PropertyHandler.getInstance());
    }

    public EhealthKeyRegistry(PropertyHandler configuration) {
        this.configuration = configuration;
    }

    public final Message.Cipher.Key create(String patientId) {
        ArrayList<Object> owners = new ArrayList<Object>();
        owners.add(Executor.All.all());
        owners.add(Patient.ID.patientID((String)patientId));
        owners.add(PrescriberType.DOCTOR);
        owners.add(PrescriberType.HOSPITAL);
        owners.add(PrescriberType.DENTIST);
        owners.add(PrescriberType.MIDWIFE);
        return new CreateKeyCommand().execute(owners.toArray(new Message.Cipher.Key.Owner[0]));
    }

    public Message.Cipher.Key get(Message.Cipher.Key.ID id) {
        try {
            EncryptionToken token = this.etkHelper.getKGSS_ETK().get(0);
            EncryptionToken systemToken = this.etkHelper.getSystemETK().get(0);
            KeyResult result = this.kgss.retrieveKeyFromKgss(id.toString().getBytes(StandardCharsets.UTF_8), systemToken.getEncoded(), token.getEncoded());
            return this.key(result);
        }
        catch (IntegrationModuleException e) {
            throw new Message.Cipher.Key.NotFound();
        }
    }

    private Message.Cipher.Key key(KeyResult result) {
        return Message.Cipher.Key.Simple.key((Message.Cipher.Key.ID)Message.Cipher.Key.ID.keyID((String)result.getKeyId()), (SecretKey)result.getSecretKey());
    }

    public void refresh(PropertyHandler props) {
        this.refresh(new ETKHelper(props, new EncryptionUtils(props)), props);
    }

    public void refresh(ETKHelper etkHelper, PropertyHandler props) {
        this.etkHelper = etkHelper;
        this.configuration = props;
        this.kgss.clear();
    }

    private Prescriber.Simple prescriber() {
        return Prescriber.Simple.prescriber((PrescriberType)EhealthKeyRegistry.prescriberType(this.configuration.getProperty("sessionmanager.samlattributedesignator.3")), (Prescriber.ID)Prescriber.ID.prescriberID((String)this.configuration.getProperty("user.nihii")));
    }

    public static PrescriberType prescriberType(String type) {
        switch (type) {
            case "urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:person:ssin:ehealth:1.0:doctor:nihii11": {
                return PrescriberType.DOCTOR;
            }
            case "urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:person:ssin:ehealth:1.0:dentist:nihii11": {
                return PrescriberType.DENTIST;
            }
            case "urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:person:ssin:ehealth:1.0:nihii:dentist:nihii11": {
                return PrescriberType.DENTIST;
            }
            case "urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:person:ssin:ehealth:1.0:nihii:midwife:nihii11": {
                return PrescriberType.MIDWIFE;
            }
            case "urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:person:ssin:ehealth:1.0:nihii:nurse:nihii11": {
                return PrescriberType.NURSE;
            }
            case "urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:person:ssin:ehealth:1.0:nihii:physiotherapist:nihii11": {
                return PrescriberType.PHYSIOTHERAPIST;
            }
            case "urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:ehealth:1.0:certificateholder:hospital:nihii-number": {
                return PrescriberType.HOSPITAL;
            }
        }
        throw new IllegalArgumentException("Unknown prescriber type! [" + type + "]");
    }

    private class CreateKeyCommand
    implements Prescription.OnContent {
        private final List<String> credentialTypes = new ArrayList<String>();

        private CreateKeyCommand() {
        }

        @SafeVarargs
        public final Message.Cipher.Key execute(Message.Cipher.Key.Owner<Prescription.OnContent> ... owners) {
            RefStreams.of((Object[])new Stream[]{RefStreams.of((Object)EhealthKeyRegistry.this.prescriber()), RefStreams.of((Object[])owners)}).flatMap(Functions.identity()).forEach((Consumer)new Consumer<Message.Cipher.Key.Owner<Prescription.OnContent>>(){

                public void accept(Message.Cipher.Key.Owner<Prescription.OnContent> it) {
                    it.process((Object)CreateKeyCommand.this);
                }
            });
            EncryptionToken token = EhealthKeyRegistry.this.etkHelper.getKGSS_ETK().get(0);
            EncryptionToken systemToken = EhealthKeyRegistry.this.etkHelper.getSystemETK().get(0);
            return EhealthKeyRegistry.this.key(EhealthKeyRegistry.this.kgss.retrieveNewKey(token.getEncoded(), this.credentialTypes, null, null, null, systemToken.getEncoded()));
        }

        public void process(Patient.ID patient) {
            this.credentialTypes.add(EhealthKeyRegistry.the_patient.replaceAll("%PATIENT_SSIN%", patient.toString()));
        }

        public void process(Executor.ID executor) {
            throw new UnsupportedOperationException();
        }

        public void process(Executor.All executor) {
            this.credentialTypes.add(EhealthKeyRegistry.known_executors);
        }

        public void process(PrescriberType type) {
            switch (type) {
                case DOCTOR: {
                    this.credentialTypes.add(EhealthKeyRegistry.known_physicians);
                    break;
                }
                case HOSPITAL: {
                    this.credentialTypes.add(EhealthKeyRegistry.known_hospitals);
                    break;
                }
                case DENTIST: {
                    this.credentialTypes.add(EhealthKeyRegistry.known_dentists);
                    break;
                }
                case MIDWIFE: {
                    this.credentialTypes.add(EhealthKeyRegistry.known_midwifes);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type " + type + "!");
                }
            }
        }

        public void process(Prescriber prescriber) {
            if (prescriber.type() != PrescriberType.HOSPITAL) {
                this.credentialTypes.add(EhealthKeyRegistry.the_prescription_prescriber.replaceAll("%TYPE%", prescriber.type().name().toLowerCase()).replaceAll("%PRESCRIBER_NIHII%", prescriber.id().toString()));
            }
        }
    }
}

