package be.business.connector.recipe.utils;

import be.recipe.api.executor.ExecutorViewer;
import be.recipe.api.viewer.AllViewer;
import be.recipe.api.viewer.PatientViewer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static be.recipe.api.viewer.AllViewer.all;
import static be.recipe.api.viewer.PatientViewer.patient;

public class PrescriptionViewerFormat implements ExecutorViewer.Visitor {
  public static final Pattern executor_id = Pattern.compile("(.+)-([A-Z]+)\\.NIHII");
  private String value;

  public static String toString(ExecutorViewer it) {
    PrescriptionViewerFormat formatter = new PrescriptionViewerFormat();
    it.visit(formatter);
    return formatter.toString();
  }

  public static ExecutorViewer parse(String it) {
    if (it == null) return all();
    if (it.equals("locked")) return patient();
    return executor(it.toUpperCase());
  }

  private static ExecutorViewer executor(String it) {
    Matcher matcher = executor_id.matcher(it);
    if (!matcher.matches()) throw new Invalid();
    return be.recipe.api.viewer.ExecutorViewer.executor(
        matcher.group(1), matcher.group(2));
  }

  @Override
  public void on(AllViewer it) {}

  @Override
  public void on(PatientViewer it) {
    value = "locked";
  }

  @Override
  public void on(be.recipe.api.viewer.ExecutorViewer it) {
    value = it.executor.toString() + "-" + it.type.toString() + ".NIHII";
  }

  @Override
  public String toString() {
    return value;
  }

  public static class Invalid extends IllegalArgumentException {
    public Invalid() {
      super("Expected format: " + executor_id.pattern() + "!");
    }
  }
}
