package be.business.connector.recipe.executor.dto;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.recipe.services.core.ResponseType;
import be.recipe.services.executor.ListReservationsResultItem;
import java8.util.Objects;
import java8.util.function.Function;
import java8.util.function.Predicate;

import java.util.Calendar;
import java.util.Map;
import java.util.TreeMap;

import static java8.util.Comparators.comparing;
import static java8.util.stream.StreamSupport.stream;

public class ListReservationsResultWithExceptions extends ResponseType {

  protected final Map<ListReservationsResultItem, IntegrationModuleException> items =
      new TreeMap<>(comparing(byCreationDate()));

  private static Function<ListReservationsResultItem, Calendar> byCreationDate() {
    return new Function<ListReservationsResultItem, Calendar>() {
      @Override
      public Calendar apply(ListReservationsResultItem it) {
        return it.getCreationDate();
      }
    };
  }

  protected Boolean hasMoreResults;
  protected byte[] session;

  public boolean exceptionOccurred() {
    return stream(items.values()).anyMatch(nonNull());
  }

  private static Predicate<IntegrationModuleException> nonNull() {
    return new Predicate<IntegrationModuleException>() {
      @Override
      public boolean test(IntegrationModuleException e) {
        return Objects.nonNull(e);
      }
    };
  }

  public void addItem(ListReservationsResultItem item, IntegrationModuleException exception) {
    items.put(item, exception);
  }

  public Map<ListReservationsResultItem, IntegrationModuleException> getItems() {
    return items;
  }

  public Boolean isHasMoreResults() {
    return hasMoreResults;
  }

  public void setHasMoreResults(Boolean value) {
    this.hasMoreResults = value;
  }

  public byte[] getSession() {
    return session;
  }

  public void setSession(byte[] value) {
    this.session = value;
  }

  public Boolean getHasMoreResults() {
    return this.hasMoreResults;
  }
}
