package be.business.connector.recipe.executor;

import be.business.connector.recipe.executor.domain.GetAllReservationsParam;
import be.recipe.services.executor.GetOpenPrescriptionForExecutor;
import be.recipe.services.executor.GetPrescriptionStatusParam;
import be.recipe.services.executor.GetPrescriptionStatusResult;
import be.recipe.services.executor.ListOpenPrescriptionsParam;
import be.recipe.services.executor.ListOpenPrescriptionsResult;
import be.recipe.services.executor.ListRelationsParam;
import be.recipe.services.executor.ListRelationsResult;
import be.recipe.services.executor.ListReservationsParam;
import be.recipe.services.executor.ListReservationsResult;
import be.recipe.services.executor.ListRidsHistoryParam;
import be.recipe.services.executor.ListRidsHistoryResult;
import be.recipe.services.executor.ListRidsInProcessParam;
import be.recipe.services.executor.ListRidsInProcessResult;
import be.recipe.services.executor.PutRidsInProcessParam;
import be.recipe.services.executor.PutRidsInProcessResult;

/**
 * The Interface ExecutorIntegrationModuleDevV4.
 */
public interface ExecutorIntegrationModuleDevV4 extends ExecutorIntegrationModuleV4 {

	/**
	 * Gets the {@link ListOpenPrescriptionsResult}.
	 *
	 * @param request
	 *            a {@link ListOpenPrescriptionsParam}
	 * @return the {@link ListOpenPrescriptionsResult}
	 */
	@Override
	ListOpenPrescriptionsResult getData(ListOpenPrescriptionsParam request);

	/**
	 * Decrypt a {@link GetOpenPrescriptionForExecutor}.
	 *
	 * @param getOpenPrescriptionForExecutor
	 *           the GetOpenPrescriptionListParam
	 * @return a {@link GetOpenPrescriptionForExecutor}
	 * 
	 */
	@Override
	GetOpenPrescriptionForExecutor decryptGetOpenPrescriptionForExecutor(
			final GetOpenPrescriptionForExecutor getOpenPrescriptionForExecutor);

	/**
	 * Gets the {@link GetPrescriptionStatusResult}.
	 *
	 * @param request
	 *            the {@link GetPrescriptionStatusParam}
	 * @return the {@link GetPrescriptionStatusResult}
	 * 
	 */
	@Override
	GetPrescriptionStatusResult getData(GetPrescriptionStatusParam request);

	/**
	 * Gets the {@link ListRidsHistoryResult}.
	 *
	 * @param request
	 *            the {@link ListRidsHistoryParam}
	 * @return the ListPrescriptionHistoryParam
	 * 
	 */
	@Override
	ListRidsHistoryResult getData(ListRidsHistoryParam request);

	/**
	 * Gets the {@link ListReservationsResult}.
	 *
	 * @param request
	 *            the {@link GetAllReservationsParam}
	 * @return the {@link ListReservationsResult}
	 */
	@Override
	ListReservationsResult getData(ListReservationsParam request);

	/**
	 * Gets the {@link ListRidsInProcessResult}.
	 *
	 * @param request
	 *            the {@link ListRidsInProcessParam}
	 * @return the {@link ListRidsInProcessResult}
	 * 
	 */
	@Override
	ListRidsInProcessResult getData(ListRidsInProcessParam request);

	/**
	 * Puts the {@link PutRidsInProcessResult}.
	 *
	 * @param request
	 *            the {@link PutRidsInProcessParam}
	 * @return the {@link PutRidsInProcessResult}
	 */
	@Override
	PutRidsInProcessResult putData(PutRidsInProcessParam request);

	/**
	 * Gets the
	 * {@link be.business.connector.recipe.executor.domain.GetPrescriptionForExecutorResult}
	 * and marks it as delivered.
	 *
	 * @param rid
	 *            the rid
	 * @return the
	 *         {@link be.business.connector.recipe.executor.domain.GetPrescriptionForExecutorResult}
	 */
	@Override
	be.business.connector.recipe.executor.domain.GetPrescriptionForExecutorResult getAndMarkAsDelivered(String rid);

	/**
	 * Gets the {@link be.recipe.services.executor.ListRelationsResult}.
	 */
	@Override
	ListRelationsResult getData(ListRelationsParam patientRelationParam);

}