package be.business.connector.core.utils;

import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

import java.io.InputStream;
import java.io.Reader;
import java.util.Map;

import static java.nio.charset.StandardCharsets.UTF_8;

public class ClasspathLSResourceResolver implements LSResourceResolver {

    private final Map<String, String> fileMapping;

    public ClasspathLSResourceResolver(Map<String, String> fileMapping) {
        this.fileMapping = fileMapping;
    }


    @Override
    public LSInput resolveResource(String type, String namespaceURI, final String publicId, final String systemId, String baseURI) {
        return new ClasspathLSInput(publicId, systemId, ClasspathLSResourceResolver.class.getResourceAsStream(getResource(namespaceURI)));
    }


    private String getResource(final String namespace) {
        if (fileMapping.containsKey(namespace)) {
            return fileMapping.get(namespace);
        }

        throw new IllegalStateException("No mapping found for " + namespace);
    }

    public static class ClasspathLSInput implements LSInput {

        private final String publicId;
        private final String systemId;
        private final InputStream inputStream;

        public ClasspathLSInput(final String publicId, final String systemId, final InputStream inputStream) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.inputStream = inputStream;
        }


        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {

        }

        @Override
        public InputStream getByteStream() {
            return inputStream;
        }

        @Override
        public void setByteStream(InputStream byteStream) {

        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {

        }

        @Override
        public String getSystemId() {
            return systemId;
        }

        @Override
        public void setSystemId(String systemId) {

        }

        @Override
        public String getPublicId() {
            return publicId;
        }

        @Override
        public void setPublicId(String publicId) {

        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {

        }

        @Override
        public String getEncoding() {
            return UTF_8.toString();
        }

        @Override
        public void setEncoding(String encoding) {

        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {

        }
    }
}
