package be.business.connector.common.ehealth;

import be.business.connector.core.technical.connector.utils.Crypto;
import be.business.connector.core.utils.EncryptionUtils;
import be.recipe.api.crypto.Message;

public class EhealthCipher implements Message.Cipher {
  public Crypto crypto;

  @Override
  public byte[] encrypt(byte[] decryptedMessage, Key key) {
    init();
    if (key instanceof EhealthSystemKey)
      return crypto.seal(((EhealthSystemKey) key).token(), decryptedMessage);
    return crypto.seal(decryptedMessage, key.secret(), key.id().toString());
  }

  private void init() {
    if (crypto == null) crypto = new Crypto();
  }

  @Override
  public byte[] decrypt(byte[] encryptedMessage, Key key) {
    init();
    if (key instanceof EhealthResponseKey)
      return EncryptionUtils.unsealWithSymmKey(key.secret(), encryptedMessage);
    return crypto.unseal(key.secret(), encryptedMessage);
  }
}
