/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.session;

import be.business.connector.core.utils.SAML10Converter;
import be.business.connector.session.SessionType;
import be.ehealth.technicalconnector.beid.BeIDFactory;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.service.sts.security.impl.KeyStoreCredential;
import be.ehealth.technicalconnector.service.sts.security.impl.SAMLHolderOfKeyToken;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.ehealth.technicalconnector.session.SessionManager;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SessionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SessionUtil.class);
    public static final String SESSIONMANAGER_SAMLATTRIBUTE_MANDATE = "sessionmanager.samlattribute.mandate";
    public static final String SESSIONMANAGER_SAMLATTRIBUTEDESIGNATOR_MANDATE = "sessionmanager.samlattributedesignator.mandate";
    public static final String SESSIONMANAGER_SAMLATTRIBUTE = "sessionmanager.samlattribute";
    public static final String SESSIONMANAGER_SAMLATTRIBUTEDESIGNATOR = "sessionmanager.samlattributedesignator";
    public static final String SYSTEM_KEYSTORE_PASSWORD = "KEYSTORE_PASSWORD";
    public static final String USER_PASSWORD = "user.password";
    public static final String USER_INSS = "user.inss";
    public static final String SYSTEM_KEYSTORE_FILE = "sessionmanager.holderofkey.keystore";
    public static final String AUTHENTICATION_ALIAS = "authentication";
    public static final String HOLDER_OF_KEY_PASSWORD = "holder.of.key.password";
    public static final String ENCRYPTION_PASSWORD = "encryption.password";
    public static final String IDENTIFICATION_PASSWORD = "identification.password";

    public static SessionItem createSession(SessionType sessionType, Properties configuration, String inss, String password) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)inss)) {
            configuration.put(USER_INSS, inss);
        }
        if (StringUtils.isNotBlank((CharSequence)password)) {
            configuration.put(USER_PASSWORD, password);
        }
        switch (sessionType) {
            case EID_SESSION: {
                return SessionUtil.createNewSession(configuration);
            }
            case FALLBACK_SESSION: {
                return SessionUtil.createNewFallbackSession(configuration);
            }
            case MANDATE_SESSION: {
                return SessionUtil.createNewMandateSession(configuration);
            }
        }
        throw new IllegalArgumentException("Unsupported sessionType " + (Object)((Object)sessionType));
    }

    public static SessionItem createNewSession(Properties configuration) throws Exception {
        configuration.setProperty(USER_INSS, SessionUtil.retrieveUserInss(configuration));
        String systemKeystorePassword = configuration.getProperty(SYSTEM_KEYSTORE_PASSWORD);
        String holderOfKeyPassword = configuration.getProperty(HOLDER_OF_KEY_PASSWORD);
        String encryptionPassword = configuration.getProperty(ENCRYPTION_PASSWORD);
        LOG.info("Creating a new session");
        SessionManager sessionManager = SessionUtil.initEHealthSessionManager(configuration);
        SessionItem sessionItem = sessionManager.createSession(StringUtils.isNotBlank((CharSequence)holderOfKeyPassword) ? holderOfKeyPassword : systemKeystorePassword, StringUtils.isNotBlank((CharSequence)encryptionPassword) ? encryptionPassword : systemKeystorePassword);
        LOG.info("new session created");
        return sessionItem;
    }

    public static SessionItem createNewFallbackSession(Properties configuration) throws Exception {
        String systemKeystorePassword = configuration.getProperty(SYSTEM_KEYSTORE_PASSWORD);
        String user = configuration.getProperty(USER_PASSWORD);
        String identificationPassword = configuration.getProperty(IDENTIFICATION_PASSWORD);
        String holderOfKeyPassword = configuration.getProperty(HOLDER_OF_KEY_PASSWORD);
        String encryptionPassword = configuration.getProperty(ENCRYPTION_PASSWORD);
        LOG.info("Creating a new fallback session");
        SessionManager sessionManager = SessionUtil.initEHealthSessionManager(configuration);
        SessionItem sessionItem = sessionManager.createFallbackSession(StringUtils.isNotBlank((CharSequence)identificationPassword) ? identificationPassword : user, StringUtils.isNotBlank((CharSequence)holderOfKeyPassword) ? holderOfKeyPassword : systemKeystorePassword, StringUtils.isNotBlank((CharSequence)encryptionPassword) ? encryptionPassword : systemKeystorePassword);
        LOG.info("New fallback session created");
        return sessionItem;
    }

    public static SessionItem createNewMandateSession(Properties configuration) throws Exception {
        String mandateAttributeValue;
        configuration.setProperty(USER_INSS, SessionUtil.retrieveUserInss(configuration));
        LOG.info("Creating a new mandated session");
        int i = 1;
        while (configuration.containsKey("sessionmanager.samlattribute." + i)) {
            configuration.remove("sessionmanager.samlattribute." + i);
            ++i;
        }
        i = 1;
        while (configuration.containsKey("sessionmanager.samlattributedesignator." + i)) {
            configuration.remove("sessionmanager.samlattributedesignator." + i);
            ++i;
        }
        i = 1;
        while (configuration.containsKey("sessionmanager.samlattribute.mandate." + i)) {
            mandateAttributeValue = configuration.getProperty("sessionmanager.samlattribute.mandate." + i);
            configuration.setProperty("sessionmanager.samlattribute." + i, mandateAttributeValue);
            LOG.info("using samlAttribute: " + mandateAttributeValue);
            ++i;
        }
        i = 1;
        while (configuration.containsKey("sessionmanager.samlattributedesignator.mandate." + i)) {
            mandateAttributeValue = configuration.getProperty("sessionmanager.samlattributedesignator.mandate." + i);
            configuration.setProperty("sessionmanager.samlattributedesignator." + i, mandateAttributeValue);
            LOG.info("using samlAttributeDesignator: " + mandateAttributeValue);
            ++i;
        }
        String systemKeystorePassword = configuration.getProperty(SYSTEM_KEYSTORE_PASSWORD);
        String holderOfKeyPassword = configuration.getProperty(HOLDER_OF_KEY_PASSWORD);
        String encryptionPassword = configuration.getProperty(ENCRYPTION_PASSWORD);
        SessionManager sessionManager = SessionUtil.initEHealthSessionManager(configuration);
        SessionItem sessionItem = sessionManager.createSession(StringUtils.isNotBlank((CharSequence)holderOfKeyPassword) ? holderOfKeyPassword : systemKeystorePassword, StringUtils.isNotBlank((CharSequence)encryptionPassword) ? encryptionPassword : systemKeystorePassword);
        LOG.info("New fallback session created");
        return sessionItem;
    }

    public static SAMLToken loadExistingSession(Properties configuration, SAMLToken samlToken) throws Exception {
        return SessionUtil.loadExistingSession(configuration, samlToken, true);
    }

    public static SAMLToken loadExistingSession(Properties configuration, SAMLToken samlToken, boolean performValidation) throws Exception {
        String systemKeystorePassword = configuration.getProperty(SYSTEM_KEYSTORE_PASSWORD);
        String userPassword = configuration.getProperty(USER_PASSWORD);
        String holderOfKeyPassword = configuration.getProperty(HOLDER_OF_KEY_PASSWORD);
        String encryptionPassword = configuration.getProperty(ENCRYPTION_PASSWORD);
        LOG.info(String.format("Loading session [%s] from cache", samlToken.getAssertionID()));
        SessionManager sessionManager = SessionUtil.initEHealthSessionManager(configuration);
        sessionManager.loadSession(samlToken, StringUtils.isNotBlank((CharSequence)holderOfKeyPassword) ? holderOfKeyPassword : systemKeystorePassword, StringUtils.isNotBlank((CharSequence)encryptionPassword) ? encryptionPassword : systemKeystorePassword);
        if (performValidation && !sessionManager.hasValidSession()) {
            throw new IllegalArgumentException("Invalid session loaded from " + System.getProperty("session"));
        }
        LOG.info(String.format("Session [%s] loaded from cache", samlToken.getAssertionID()));
        return samlToken;
    }

    public static SAMLToken createSAMLToken(Properties configuration, String samlTokenString) throws Exception {
        String systemKeystoreFile = configuration.getProperty(SYSTEM_KEYSTORE_FILE);
        String systemKeystorePassword = configuration.getProperty(SYSTEM_KEYSTORE_PASSWORD);
        String holderOfKeyPassword = configuration.getProperty(HOLDER_OF_KEY_PASSWORD);
        SessionUtil.loadEHealthConfig(configuration);
        Element sessionElement = SAML10Converter.toElement(samlTokenString);
        KeyStoreCredential credential = new KeyStoreCredential(systemKeystoreFile, StringUtils.isNotBlank((CharSequence)systemKeystoreFile) ? systemKeystorePassword : holderOfKeyPassword, AUTHENTICATION_ALIAS, StringUtils.isNotBlank((CharSequence)systemKeystoreFile) ? systemKeystorePassword : holderOfKeyPassword);
        return new SAMLHolderOfKeyToken(sessionElement, (Credential)credential);
    }

    private static String retrieveUserInss(Properties configuration) throws Exception {
        String userInss;
        LOG.debug("retrieving user INSS for session creation");
        if (StringUtils.isNotBlank((CharSequence)configuration.getProperty("user"))) {
            LOG.debug("retrieving user INSS for session creation");
            userInss = configuration.getProperty("user");
        } else {
            LOG.debug("retrieving user INSS for session creation");
            userInss = BeIDFactory.getBeIDInfo((String)"test", (boolean)false).getIdentity().getNationalNumber();
        }
        LOG.debug(String.format("user INSS successfully retrieved: %s", userInss));
        return userInss;
    }

    private static SessionManager initEHealthSessionManager(Properties configuration) throws Exception {
        SessionUtil.loadEHealthConfig(configuration);
        SessionManager sessionManager = Session.getInstance();
        sessionManager.unloadSession();
        return sessionManager;
    }

    private static void loadEHealthConfig(Properties configuration) throws Exception {
        File tempConfigurationFile = File.createTempFile("tempConfig", ".properties");
        tempConfigurationFile.deleteOnExit();
        configuration.store(new FileOutputStream(tempConfigurationFile), "configuration file in which the placeholders are processed");
        ConfigFactory.setConfigLocation((String)tempConfigurationFile.getAbsolutePath());
    }
}

