/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.utils;

import be.business.connector.core.utils.ETKHelper;
import be.business.connector.core.utils.IOUtils;
import be.business.connector.core.utils.MarshallerHelper;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.projects.common.utils.ValidationUtils;
import be.business.connector.recipe.AbstractRecipeClient;
import be.business.connector.recipe.prescriber.AbstractPrescriberIntegrationModule;
import be.business.connector.recipe.prescriber.RecipePrescriberClient;
import be.business.connector.recipe.prescriber.dto.CreatePrescriptionDTO;
import be.business.connector.recipe.prescriber.services.RecipePrescriberServiceV4Impl;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.recipe.core.v4.CreatePrescriptionAdministrativeInformationType;
import be.fgov.ehealth.recipe.protocol.v4.CreatePrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v4.CreatePrescriptionResponse;
import be.recipe.services.core.ResponseType;
import be.recipe.services.prescriber.CreatePrescriptionParam;
import be.recipe.services.prescriber.CreatePrescriptionResult;
import java.security.Key;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.joda.time.DateTime;
import org.perf4j.aop.Profiled;

public class PrescriptionEncryptorThread
extends Thread {
    private CreatePrescriptionDTO createPrescriptionDTO;
    private Semaphore semaphore;
    private KeyResult key;
    private Key symmKey;
    private ETKHelper etkHelper;
    private AbstractPrescriberIntegrationModule prescriptionIntegrationModule;

    public PrescriptionEncryptorThread(Semaphore available, CreatePrescriptionDTO createPrescriptionDTO, KeyResult key, Key symmKey, ETKHelper etkHelper, AbstractPrescriberIntegrationModule prescriptionIntegrationModule) {
        this.semaphore = available;
        this.createPrescriptionDTO = createPrescriptionDTO;
        this.key = key;
        this.symmKey = symmKey;
        this.etkHelper = etkHelper;
        this.prescriptionIntegrationModule = prescriptionIntegrationModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriptionEncryptorThread#encryption", logger="org.perf4j.TimingLogger_Common")
    public void run() {
        try {
            ValidationUtils.validatePatientId(this.createPrescriptionDTO.getPatientId());
            ValidationUtils.validateVisi(this.createPrescriptionDTO.getVisi(), false);
            PropertyHandler propertyHandler = PropertyHandler.getInstance();
            String expirationDate = this.prescriptionIntegrationModule.extractExpirationDateFromKmehr(this.createPrescriptionDTO.getPrescription());
            ValidationUtils.validateExpirationDate(expirationDate);
            this.prescriptionIntegrationModule.validateKmehr(this.createPrescriptionDTO.getPrescription(), this.createPrescriptionDTO.getPrescriptionType(), expirationDate);
            List<EncryptionToken> etkRecipes = this.etkHelper.getRecipe_ETK();
            byte[] message = IOUtils.compress(this.createPrescriptionDTO.getPrescription());
            byte[] sealedMessage = this.prescriptionIntegrationModule.sealPrescriptionForUnknown(this.key, message);
            CreatePrescriptionParam params = new CreatePrescriptionParam();
            params.setPrescription(sealedMessage);
            params.setPrescriptionType(this.createPrescriptionDTO.getPrescriptionType());
            params.setFeedbackRequested(this.createPrescriptionDTO.isFeedbackRequested());
            params.setKeyId(this.key.getKeyId());
            params.setSymmKey(this.symmKey.getEncoded());
            params.setPatientId(this.createPrescriptionDTO.getPatientId());
            params.setExpirationDate(expirationDate);
            params.setVision(this.createPrescriptionDTO.getVisi());
            params.setVisionOtherPrescribers(RecipePrescriberClient.toJAXB(this.createPrescriptionDTO.getVisionOtherPrescribers()));
            MarshallerHelper<CreatePrescriptionResult, CreatePrescriptionParam> helper = new MarshallerHelper<CreatePrescriptionResult, CreatePrescriptionParam>(CreatePrescriptionResult.class, CreatePrescriptionParam.class);
            CreatePrescriptionRequest request = new CreatePrescriptionRequest();
            request.setSecuredCreatePrescriptionRequest(this.prescriptionIntegrationModule.createSecuredContentType(this.prescriptionIntegrationModule.sealRequest(etkRecipes.get(0), helper.toXMLByteArray(params))));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setId(this.prescriptionIntegrationModule.getId());
            request.setIssueInstant(new DateTime());
            CreatePrescriptionAdministrativeInformationType adminValue = new CreatePrescriptionAdministrativeInformationType();
            adminValue.setKeyIdentifier(this.key.getKeyId().getBytes());
            adminValue.setPrescriptionVersion(PropertyHandler.getInstance().getProperty("prescription.version"));
            adminValue.setReferenceSourceVersion(AbstractPrescriberIntegrationModule.extractReferenceSourceVersionFromKmehr(this.createPrescriptionDTO.getPrescription()));
            adminValue.setPrescriptionType(this.createPrescriptionDTO.getPrescriptionType());
            request.setAdministrativeInformation(adminValue);
            CreatePrescriptionResponse response = RecipePrescriberServiceV4Impl.getInstance().createPrescription(request);
            CreatePrescriptionResult result = helper.unsealWithSymmKey(response.getSecuredCreatePrescriptionResponse().getSecuredContent(), this.symmKey);
            this.prescriptionIntegrationModule.checkStatus((ResponseType)result);
            this.createPrescriptionDTO.setRid(result.getRid());
            this.createPrescriptionDTO.setErrorOccured(false);
        }
        catch (Exception exception) {
            this.createPrescriptionDTO.setException(exception);
            this.createPrescriptionDTO.setErrorOccured(true);
        }
        finally {
            this.semaphore.release();
        }
    }

    public void clean() {
        this.semaphore = null;
    }

    public CreatePrescriptionDTO getCreatePrescriptionDTO() {
        return this.createPrescriptionDTO;
    }
}

