/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.utils;

import be.business.connector.common.ehealth.EhealthKeyRegistry;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.ETKHelper;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.recipe.prescriber.AbstractPrescriberIntegrationModule;
import be.business.connector.recipe.prescriber.dto.CreatePrescriptionDTO;
import be.business.connector.recipe.utils.PrescriptionEncryptorThread;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.recipe.api.crypto.Message;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrescriberEncryptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PrescriberEncryptionUtils.class);
    private final ETKHelper etkHelper;
    private final Map<String, KeyResult> keyCache;
    private EhealthKeyRegistry keyRegistry;
    private final PropertyHandler propertyHandler;
    private final Key symmKey;

    public PrescriberEncryptionUtils(PropertyHandler propertyHandler, EncryptionUtils encryptionUtils, Map<String, KeyResult> keyCache) {
        this.propertyHandler = propertyHandler;
        this.etkHelper = new ETKHelper(propertyHandler, encryptionUtils);
        this.symmKey = EncryptionUtils.getInstance().generateSecretKey();
        this.keyCache = keyCache;
        this.keyRegistry = new EhealthKeyRegistry(propertyHandler);
        this.keyRegistry.refresh(this.etkHelper, propertyHandler);
    }

    public List<CreatePrescriptionDTO> doEncryptions(List<CreatePrescriptionDTO> createPrescriptionDTOs, AbstractPrescriberIntegrationModule prescriberIntegrationModuleV4) {
        int threadLimit = PropertyHandler.getInstance().getIntegerProperty("encryption.thread.number", "50");
        Semaphore semaphore = new Semaphore(threadLimit, true);
        ArrayList<PrescriptionEncryptorThread> dataList = new ArrayList<PrescriptionEncryptorThread>();
        for (CreatePrescriptionDTO createPrescriptionDTO : createPrescriptionDTOs) {
            if (createPrescriptionDTO.getPrescription() == null) continue;
            KeyResult key = this.getNewKey(createPrescriptionDTO.getPatientId(), createPrescriptionDTO.getPrescriptionType());
            PrescriptionEncryptorThread encryptorThread = new PrescriptionEncryptorThread(semaphore, createPrescriptionDTO, key, this.symmKey, this.etkHelper, prescriberIntegrationModuleV4);
            dataList.add(encryptorThread);
        }
        for (PrescriptionEncryptorThread encryptorThread : dataList) {
            semaphore.acquireUninterruptibly();
            encryptorThread.start();
        }
        try {
            semaphore.acquireUninterruptibly(threadLimit);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Incorrect Thread configuration : " + e);
            throw new IntegrationModuleException(e.getMessage(), e);
        }
        ArrayList<CreatePrescriptionDTO> finalResult = new ArrayList<CreatePrescriptionDTO>();
        for (PrescriptionEncryptorThread decryptorThread : dataList) {
            finalResult.add(decryptorThread.getCreatePrescriptionDTO());
        }
        for (CreatePrescriptionDTO createPrescriptionDTO : createPrescriptionDTOs) {
            for (CreatePrescriptionDTO finalDTO : finalResult) {
                if (createPrescriptionDTO.getSequenceNumber() != finalDTO.getSequenceNumber()) continue;
                createPrescriptionDTO.setRid(finalDTO.getRid());
                createPrescriptionDTO.setErrorOccured(finalDTO.isErrorOccured());
                createPrescriptionDTO.setException(finalDTO.getException());
                if (!finalDTO.isErrorOccured()) continue;
                LOG.info(String.format("Error occured during doEncryptions-operations[%s]:[%s] ", finalDTO.getSequenceNumber(), finalDTO.getException()));
            }
        }
        return createPrescriptionDTOs;
    }

    public KeyResult getNewKey(String patientId, String prescriptionType) {
        KeyResult key;
        if (this.keyCache.containsKey(patientId)) {
            key = this.keyCache.get(patientId);
        } else {
            key = this.getNewKeyFromKgss(patientId);
            this.keyCache.put(patientId, key);
        }
        return key;
    }

    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#getNewKeyFromKgss")
    protected KeyResult getNewKeyFromKgss(String patientId) {
        Message.Cipher.Key key = this.keyRegistry.create(patientId);
        return new KeyResult(key.secret(), key.id().toString());
    }
}

