/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.prescriber;

import be.business.connector.common.StandaloneRequestorProvider;
import be.business.connector.common.ehealth.EhealthCipher;
import be.business.connector.common.ehealth.EhealthKeyRegistry;
import be.business.connector.common.module.AbstractIntegrationModule;
import be.business.connector.core.domain.KgssIdentifierType;
import be.business.connector.core.ehealth.services.KgssService;
import be.business.connector.core.ehealth.services.KgssServiceImpl;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.exceptions.IntegrationModuleValidationException;
import be.business.connector.core.technical.connector.utils.Crypto;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.Exceptionutils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.MarshallerHelper;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.core.utils.STSHelper;
import be.business.connector.core.utils.SessionValidator;
import be.business.connector.recipe.RoutingPrescriptionService;
import be.business.connector.recipe.prescriber.RecipePrescriberClient;
import be.business.connector.recipe.prescriber.dto.CreatePrescriptionDTO;
import be.business.connector.recipe.utils.KmehrHelper;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.fgov.ehealth.commons.core.v1.IdentifierType;
import be.fgov.ehealth.commons.core.v1.LocalisedString;
import be.fgov.ehealth.commons.core.v1.StatusType;
import be.fgov.ehealth.commons.protocol.v1.ResponseType;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.recipe.core.v4.SecuredContentType;
import be.recipe.api.CipheringPrescriptionService;
import be.recipe.api.PrefetchingPrescriptionService;
import be.recipe.api.Prescription;
import be.recipe.api.PrescriptionContent;
import be.recipe.api.PrescriptionService;
import be.recipe.api.crypto.Message;
import be.recipe.api.prescriber.GetPrescription;
import be.recipe.api.prescriber.ListPrescriptions;
import be.recipe.api.prescriber.PrescriptionService;
import be.recipe.api.prescriber.PutVisionOtherPrescribers;
import be.recipe.common.JAXBTimestampingContext;
import be.recipe.services.prescriber.GetPrescriptionStatusParam;
import be.recipe.services.prescriber.ListOpenRidsParam;
import be.recipe.services.prescriber.ListRidsHistoryParam;
import be.recipe.services.prescriber.PutVisionParam;
import be.recipe.services.prescriber.ValidationPropertiesParam;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java8.util.Optional;
import java8.util.function.Consumer;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractPrescriberIntegrationModule
extends AbstractIntegrationModule
implements ListPrescriptions.Command<ListPrescriptions, ListPrescriptions.Response.PlainText>,
PutVisionOtherPrescribers.Command<PutVisionOtherPrescribers>,
GetPrescription.Command<GetPrescription, Prescription.PlainText> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPrescriberIntegrationModule.class);
    private final Map<String, String> prescriptionCache = new HashMap<String, String>();
    private final KmehrHelper kmehrHelper = new KmehrHelper();
    public final PrescriptionService.Ciphering.Simplified target;
    protected Map<String, KeyResult> keyCache = new HashMap<String, KeyResult>();
    protected KgssService kgssService = KgssServiceImpl.getInstance();
    private Crypto crypto;
    private EhealthCipher cipher;
    private EhealthKeyRegistry keyRegistry;
    protected PrescriptionContent.Factory prescriptionContentFactory;

    public AbstractPrescriberIntegrationModule() {
        try {
            PropertyHandler props = PropertyHandler.getInstance();
            this.cipher = new EhealthCipher();
            this.keyRegistry = new EhealthKeyRegistry();
            this.crypto = new Crypto();
            this.keyRegistry.refresh(props);
            this.prescriptionContentFactory = new PrescriptionContent.Factory(new Message.Factory((Message.Cipher)this.cipher, (Message.Encrypted.Timestamped.Extractor)new JAXBTimestampingContext()), (Message.Cipher.Key.DB)this.keyRegistry);
            this.target = new PrefetchingPrescriptionService((PrescriptionService.Ciphering.Simplified)new CipheringPrescriptionService((PrescriptionService.Simplified)new RoutingPrescriptionService(new RecipePrescriberClient(props), null, null), this.prescriptionContentFactory));
            LOG.info("*************** Prescriber System module init correctly *******************");
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void checkStatus(ResponseType response) {
        if (!"100".equals(response.getStatus().getCode()) && !"200".equals(response.getStatus().getCode())) {
            LOG.error("Error Status received : " + response.getStatus().getCode());
            throw new IntegrationModuleException(this.getLocalisedMsg(response.getStatus()));
        }
    }

    public void checkStatus(final be.recipe.services.core.ResponseType response) {
        if (!"100".equals(response.getStatus().getCode()) && !"200".equals(response.getStatus().getCode())) {
            LOG.error("Error Status received : " + response.getStatus().getCode());
            Optional.ofNullable((Object)response.getStatus().getMessageCode()).ifPresent((Consumer)new Consumer<String>(){

                public void accept(String code) {
                    if (code.equals("error.validation.expirationdate2")) {
                        throw AbstractPrescriberIntegrationModule.validationException(I18nHelper.getLabel(code, new Object[]{AbstractPrescriberIntegrationModule.extractLastValidExpirationDate(response.getStatus().getMessages())}));
                    }
                    if (code.equals("error.validation.expirationdate3")) {
                        throw AbstractPrescriberIntegrationModule.validationException(I18nHelper.getLabel(code));
                    }
                }
            });
            throw new IntegrationModuleException(this.getLocalisedMsg(response.getStatus()), response);
        }
    }

    private static String extractLastValidExpirationDate(List<be.recipe.services.core.LocalisedString> messages) {
        for (be.recipe.services.core.LocalisedString msg : messages) {
            if (!msg.getLang().value().equals("EN")) continue;
            return msg.getValue().substring(51, 61);
        }
        throw new IllegalStateException("Expected to be able to extract the last valid expiration date from the english message!");
    }

    private static IntegrationModuleValidationException validationException(String label) {
        return new IntegrationModuleValidationException(label, label);
    }

    private String getLocalisedMsg(StatusType status) {
        String locale = IntegrationModuleException.getUserLocale();
        for (LocalisedString msg : status.getMessages()) {
            if (msg.getLang() == null || !locale.equalsIgnoreCase(msg.getLang().value())) continue;
            return msg.getValue();
        }
        if (!status.getMessages().isEmpty()) {
            return ((LocalisedString)status.getMessages().get(0)).getValue();
        }
        return status.getCode();
    }

    private String getLocalisedMsg(be.recipe.services.core.StatusType status) {
        String locale = IntegrationModuleException.getUserLocale();
        for (be.recipe.services.core.LocalisedString msg : status.getMessages()) {
            if (msg.getLang() == null || !locale.equalsIgnoreCase(msg.getLang().value())) continue;
            return msg.getValue();
        }
        if (!status.getMessages().isEmpty()) {
            return ((be.recipe.services.core.LocalisedString)status.getMessages().get(0)).getValue();
        }
        return status.getCode();
    }

    protected IdentifierType createIdentifierType(String id, String type) {
        IdentifierType ident = new IdentifierType();
        ident.setId(id);
        ident.setType(type);
        return ident;
    }

    public void setPersonalPassword(String personalPassword) {
        SessionItem sessionItem = Session.getInstance().getSession();
        SessionValidator.assertValidSession(sessionItem);
        try {
            String niss = STSHelper.getNiss(sessionItem.getSAMLToken().getAssertion());
            String nihii = STSHelper.getNihii(sessionItem.getSAMLToken().getAssertion());
            EncryptionUtils encryptionUtils = EncryptionUtils.getInstance();
            encryptionUtils.unlockPersonalKey(StringUtils.isNotBlank((CharSequence)niss) ? niss : nihii, personalPassword);
            this.dataUnsealer = encryptionUtils.initUnsealing();
            List<EncryptionToken> tokens = this.getEtkHelper().getEtks(this.getIdentifierType(), StandaloneRequestorProvider.getRequestorIdInformation());
            encryptionUtils.verifyDecryption(tokens.get(0));
        }
        catch (Exception e) {
            throw new IntegrationModuleException(e);
        }
    }

    private KgssIdentifierType getIdentifierType() {
        String type = STSHelper.getType(Session.getInstance().getSession().getSAMLToken().getAssertion());
        return type.equals("HOSPITAL") ? KgssIdentifierType.NIHII_HOSPITAL : KgssIdentifierType.NIHII;
    }

    protected KmehrHelper getKmehrHelper() {
        return this.kmehrHelper;
    }

    protected byte[] getSealedData(ValidationPropertiesParam validationPropertiesParam) {
        return this.sealForRecipe(validationPropertiesParam, ValidationPropertiesParam.class);
    }

    private <T> byte[] sealForRecipe(T data, Class<T> type) {
        MarshallerHelper<Object, T> helper = new MarshallerHelper<Object, T>(Object.class, type);
        EncryptionToken etkRecipe = this.getEtkHelper().getRecipe_ETK().get(0);
        return this.sealRequest(etkRecipe, helper.toXMLByteArray(data));
    }

    public KeyResult getNewKey(String patientId) {
        if (this.keyCache.containsKey(patientId)) {
            return this.keyCache.get(patientId);
        }
        KeyResult key = this.getNewKeyFromKgss(patientId);
        this.keyCache.put(patientId, key);
        return key;
    }

    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#getNewKeyFromKgss")
    protected KeyResult getNewKeyFromKgss(String patientId) {
        Message.Cipher.Key key = this.keyRegistry.create(patientId);
        return new KeyResult(key.secret(), key.id().toString());
    }

    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#sealPrescriptionForUnknown")
    public byte[] sealPrescriptionForUnknown(KeyResult key, byte[] messageToProtect) {
        return this.crypto.seal(messageToProtect, key.getSecretKey(), key.getKeyId());
    }

    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#unsealFeedback")
    protected byte[] unsealFeedback(byte[] message) {
        return this.unsealNotiffeed(message);
    }

    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#sealNotification")
    protected byte[] sealNotification(EncryptionToken paramEncryptionToken, byte[] paramArrayOfByte) {
        return this.crypto.seal(paramEncryptionToken, paramArrayOfByte);
    }

    private <T> byte[] marshall(T data, Class<T> type) {
        MarshallerHelper<Object, T> helper = new MarshallerHelper<Object, T>(Object.class, type);
        return helper.toXMLByteArray(data);
    }

    protected byte[] getSealedData(ListRidsHistoryParam listRidHistoryParam) {
        return this.sealForRecipe(listRidHistoryParam, ListRidsHistoryParam.class);
    }

    protected byte[] getSealedData(GetPrescriptionStatusParam request) {
        return this.sealForRecipe(request, GetPrescriptionStatusParam.class);
    }

    protected byte[] getSealedData(PutVisionParam putVisionParam) {
        return this.sealForRecipe(putVisionParam, PutVisionParam.class);
    }

    protected byte[] getSealedData(ListOpenRidsParam listOpenRidsParam) {
        return this.sealForRecipe(listOpenRidsParam, ListOpenRidsParam.class);
    }

    protected void validateCreatePrescriptionDTOs(List<CreatePrescriptionDTO> dtos) {
        try {
            Validate.notNull(dtos);
            Validate.notEmpty(dtos);
        }
        catch (Exception e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.validation.list.empty.or.null"));
        }
        if (dtos.size() > 30) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.validation.too.many.items"));
        }
        ArrayList<Integer> seqNbrs = new ArrayList<Integer>();
        for (CreatePrescriptionDTO dto : dtos) {
            if (seqNbrs.contains(dto.getSequenceNumber())) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.validation.duplicate.sequencenumbers"));
            }
            seqNbrs.add(dto.getSequenceNumber());
        }
    }

    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4Impl#validateKmehr", logger="org.perf4j.TimingLogger_Common")
    public void validateKmehr(byte[] prescription, String prescriptionType, String expirationDateFromRequest) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            this.getKmehrHelper().assertValidKmehrPrescription(prescription, prescriptionType);
        }
        catch (IntegrationModuleValidationException e) {
            errors.addAll(e.getValidationErrors());
        }
        this.validateExpirationDateFromKmehr(prescription, errors, expirationDateFromRequest);
        if (CollectionUtils.isNotEmpty(errors)) {
            LOG.info("******************************************************");
            for (String error : errors) {
                LOG.info("Errors found in the kmehr:" + error);
            }
            LOG.info("******************************************************");
            throw new IntegrationModuleValidationException(I18nHelper.getLabel("error.xml.invalid"), errors);
        }
    }

    private void validateExpirationDateFromKmehr(byte[] xmlDocument, List<String> errors, String expirationDateFromRequest) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document kmehrDocument = builder.parse(new ByteArrayInputStream(xmlDocument));
            PropertyHandler propertyHandler = PropertyHandler.getInstance();
            XPath xpath = XPathFactory.newInstance().newXPath();
            String xpathStr = propertyHandler.getProperty("expirationdate.xpath");
            NodeList expirationDateNodeList = (NodeList)xpath.evaluate(xpathStr, kmehrDocument, XPathConstants.NODESET);
            if (expirationDateNodeList.item(0) != null) {
                String expirationDateFromKmehr = expirationDateNodeList.item(0).getTextContent();
                if (!expirationDateFromKmehr.contentEquals(expirationDateFromRequest)) {
                    errors.add(I18nHelper.getLabel("error.validation.expirationdate.different.message", new Object[]{expirationDateFromRequest, expirationDateFromKmehr}));
                }
            } else {
                errors.add(I18nHelper.getLabel("error.validation.expirationdate.kmehr"));
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            Exceptionutils.errorHandler(e);
        }
    }

    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4Impl#createSecuredContentType", logger="org.perf4j.TimingLogger_Common")
    public SecuredContentType createSecuredContentType(byte[] content) {
        SecuredContentType secured = new SecuredContentType();
        secured.setSecuredContent(content);
        return secured;
    }

    public Prescription.PlainText get(GetPrescription request) {
        return (Prescription.PlainText)this.target.get(request);
    }

    public ListPrescriptions.PartialResult<ListPrescriptions.Response.PlainText> list(ListPrescriptions request) {
        return this.target.list(request);
    }

    public void update(PutVisionOtherPrescribers request) {
        this.target.update(request);
    }
}

