/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.patient;

import be.business.connector.common.ehealth.EhealthCipher;
import be.business.connector.core.services.GenericWebserviceCaller;
import be.business.connector.core.services.GenericWebserviceRequest;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.recipe.AbstractRecipeClient;
import be.business.connector.recipe.utils.JAXB;
import be.business.connector.recipe.utils.PrescriptionViewerFormat;
import be.business.connector.recipe.utils.RejectedWithResponse;
import be.business.connector.recipe.utils.RuntimeExceptionWithResponse;
import be.fgov.ehealth.recipe.protocol.v4.CreateReservationRequest;
import be.fgov.ehealth.recipe.protocol.v4.CreateReservationResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetExecutorProfileRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetExecutorProfileResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListOpenPrescriptionsRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListOpenPrescriptionsResponse;
import be.fgov.ehealth.recipe.protocol.v4.PutVisionForPatientRequest;
import be.fgov.ehealth.recipe.protocol.v4.PutVisionForPatientResponse;
import be.fgov.ehealth.recipe.protocol.v4.RevokePrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v4.RevokePrescriptionResponse;
import be.fgov.ehealth.recipe.protocol.v4.UpdateReservationRequest;
import be.fgov.ehealth.recipe.protocol.v4.UpdateReservationResponse;
import be.recipe.api.ExecutorProfile;
import be.recipe.api.GetPrescriptionStatusResponse;
import be.recipe.api.Prescription;
import be.recipe.api.constraints.Rejected;
import be.recipe.api.constraints.ValidationReport;
import be.recipe.api.constraints.Violation;
import be.recipe.api.crypto.Message;
import be.recipe.api.executor.Executor;
import be.recipe.api.patient.AddReservation;
import be.recipe.api.patient.CancelReservation;
import be.recipe.api.patient.Dispatcher;
import be.recipe.api.patient.GetExecutorProfile;
import be.recipe.api.patient.GetPrescription;
import be.recipe.api.patient.GetPrescriptionStatus;
import be.recipe.api.patient.ListPrescriptions;
import be.recipe.api.patient.LockPrescription;
import be.recipe.api.patient.Patient;
import be.recipe.api.patient.PrescriptionService;
import be.recipe.api.patient.PutVisionExecutors;
import be.recipe.api.patient.PutVisionOtherPrescribers;
import be.recipe.api.patient.RevokePrescription;
import be.recipe.api.patient.UnlockPrescription;
import be.recipe.api.patient.UpdateContactDetails;
import be.recipe.api.prescriber.Prescriber;
import be.recipe.api.prescriber.PrescriberType;
import be.recipe.api.reservation.Reservation;
import be.recipe.api.reservation.patient.ReservationService;
import be.recipe.api.series.PartialResult;
import be.recipe.api.series.SortedBy;
import be.recipe.services.core.ContactPreference;
import be.recipe.services.core.PrescriptionAttribute;
import be.recipe.services.core.PrescriptionSortedBy;
import be.recipe.services.core.ReservationStatus;
import be.recipe.services.core.Reserved;
import be.recipe.services.core.ResponseType;
import be.recipe.services.core.VisionOtherPrescribers;
import be.recipe.services.core.VisionType;
import be.recipe.services.patient.CancelReservation;
import be.recipe.services.patient.CancelReservationResult;
import be.recipe.services.patient.ContactDetails;
import be.recipe.services.patient.ContactDetailsResult;
import be.recipe.services.patient.CreateReservationParam;
import be.recipe.services.patient.CreateReservationResult;
import be.recipe.services.patient.CreateReservationVersion;
import be.recipe.services.patient.GetExecutorProfileParam;
import be.recipe.services.patient.GetExecutorProfileResult;
import be.recipe.services.patient.GetOpenPrescriptionForPatient;
import be.recipe.services.patient.GetPrescriptionForPatientParam;
import be.recipe.services.patient.GetPrescriptionForPatientResult;
import be.recipe.services.patient.GetPrescriptionStatusParam;
import be.recipe.services.patient.GetPrescriptionStatusResult;
import be.recipe.services.patient.ListPatientPrescriptionsParam;
import be.recipe.services.patient.ListPatientPrescriptionsResult;
import be.recipe.services.patient.PutVisionParam;
import be.recipe.services.patient.PutVisionResult;
import be.recipe.services.patient.RevokePrescriptionParam;
import be.recipe.services.patient.RevokePrescriptionResult;
import be.recipe.services.patient.UpdateReservationParam;
import be.recipe.services.patient.UpdateReservationResult;
import java.util.Calendar;
import java.util.Collection;
import java8.util.Optional;
import java8.util.function.Consumer;
import java8.util.function.Function;
import java8.util.function.Supplier;
import java8.util.stream.RefStreams;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;
import org.joda.time.DateTime;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneId;

public class RecipePatientClient
extends AbstractRecipeClient
implements ReservationService.Simplified,
PrescriptionService.Simplified {
    public static final String addressKey = "endpoint.patient.v4";
    public Supplier<CreateReservationVersion> legacyCreateReservationVersion = new Supplier<CreateReservationVersion>(){

        public CreateReservationVersion get() {
            return CreateReservationVersion.ONE;
        }
    };

    public RecipePatientClient() {
        super(addressKey);
    }

    public RecipePatientClient(Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry, EhealthCipher cipher, Supplier<String> traceId) {
        super(addressKey, keyRegistry, (Message.Cipher)cipher, traceId);
    }

    public RecipePatientClient(PropertyHandler properties) {
        super(addressKey, properties);
    }

    public void add(AddReservation request) {
        this.add(this.toJAXB(request));
    }

    public void addLegacy(AddReservation request) {
        this.add(this.toJAXBLegacy(request));
    }

    private CreateReservationParam toJAXB(AddReservation from) {
        CreateReservationParam to = new CreateReservationParam();
        to.setRid(from.rid.toString());
        to.setExecutorId((String)Optional.ofNullable((Object)from.executorId).map(RecipePatientClient.toText()).orElse(null));
        to.setEmailAddress(from.email);
        to.setTelephoneNumber(from.phoneNumber);
        Optional.ofNullable((Object)from.contactPreference).map(RecipePatientClient.toName()).map(RecipePatientClient.toContactPreference()).ifPresent(RecipePatientClient.setContactPreference(to));
        to.setVersion(CreateReservationVersion.TWO);
        return to;
    }

    private static Consumer<ContactPreference> setContactPreference(final CreateReservationParam to) {
        return new Consumer<ContactPreference>(){

            public void accept(ContactPreference it) {
                to.setContactPreference(it);
            }
        };
    }

    private CreateReservationParam toJAXBLegacy(AddReservation from) {
        CreateReservationParam to = this.toJAXB(from);
        to.setVersion((CreateReservationVersion)this.legacyCreateReservationVersion.get());
        return to;
    }

    private void add(CreateReservationParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        CreateReservationRequest payload = new CreateReservationRequest();
        payload.setSecuredCreateReservationRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        payload.setIssueInstant(DateTime.now());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(AddReservation.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:createReservation\"");
        CreateReservationResponse response = GenericWebserviceCaller.callGenericWebservice(request, CreateReservationResponse.class);
        CreateReservationResult result = this.decrypt(response.getSecuredCreateReservationResponse().getSecuredContent(), CreateReservationResult.class);
        if (this.rejected(result.getStatus())) {
            throw new RejectedWithResponse(JAXB.from(result.getStatus().getValidationReport(), (Object)result), (ResponseType)result);
        }
    }

    public PartialResult<ListPrescriptions.Response.Encrypted> list(ListPrescriptions request) {
        return this.fromJAXB(this.list(this.toJAXB(request)));
    }

    private ListPatientPrescriptionsParam toJAXB(ListPrescriptions from) {
        ListPatientPrescriptionsParam to = new ListPatientPrescriptionsParam();
        to.setReserved((Reserved)Optional.ofNullable((Object)from.reserved).map(RecipePatientClient.toName()).map(RecipePatientClient.toReserved()).orElse(null));
        to.setPage(JAXB.to(from.page));
        Optional.ofNullable((Object)from.sortedBy).map(this.toPrescriptionSortedBy()).ifPresent(RecipePatientClient.setSortOptions(to));
        return to;
    }

    private static Consumer<PrescriptionSortedBy> setSortOptions(final ListPatientPrescriptionsParam to) {
        return new Consumer<PrescriptionSortedBy>(){

            public void accept(PrescriptionSortedBy it) {
                to.setSortOptions(it);
            }
        };
    }

    private Function<SortedBy<Prescription.Attribute>[], PrescriptionSortedBy> toPrescriptionSortedBy() {
        return new Function<SortedBy<Prescription.Attribute>[], PrescriptionSortedBy>(){

            public PrescriptionSortedBy apply(SortedBy<Prescription.Attribute>[] it) {
                return RecipePatientClient.this.toJAXB(it);
            }
        };
    }

    private static Function<String, Reserved> toReserved() {
        return new Function<String, Reserved>(){

            public Reserved apply(String it) {
                return Reserved.fromValue((String)it);
            }
        };
    }

    private PrescriptionSortedBy toJAXB(SortedBy<Prescription.Attribute>[] from) {
        PrescriptionSortedBy to = new PrescriptionSortedBy();
        RefStreams.of((Object[])from).map(this.toPrescriptionSortOrder()).forEach(RecipePatientClient.addSortOrder(to));
        return to;
    }

    private static Consumer<PrescriptionSortedBy.SortedBy> addSortOrder(final PrescriptionSortedBy to) {
        return new Consumer<PrescriptionSortedBy.SortedBy>(){

            public void accept(PrescriptionSortedBy.SortedBy it) {
                to.getSortedBies().add(it);
            }
        };
    }

    private Function<SortedBy<Prescription.Attribute>, PrescriptionSortedBy.SortedBy> toPrescriptionSortOrder() {
        return new Function<SortedBy<Prescription.Attribute>, PrescriptionSortedBy.SortedBy>(){

            public PrescriptionSortedBy.SortedBy apply(SortedBy<Prescription.Attribute> it) {
                return RecipePatientClient.this.toJAXB((SortedBy<Prescription.Attribute>)it);
            }
        };
    }

    private PrescriptionSortedBy.SortedBy toJAXB(SortedBy<Prescription.Attribute> from) {
        PrescriptionSortedBy.SortedBy to = new PrescriptionSortedBy.SortedBy();
        to.setAttribute(this.toJAXB((Prescription.Attribute)from.attribute));
        to.setOrder(JAXB.toJAXB(from.order));
        return to;
    }

    private PrescriptionAttribute toJAXB(Prescription.Attribute from) {
        switch (from) {
            case prescriptionDate: {
                return PrescriptionAttribute.PRESCRIPTION_DATE;
            }
            case reservationModificationDate: {
                return PrescriptionAttribute.RESERVATION_MODIFICATION_DATE;
            }
        }
        throw new IllegalArgumentException("Unknown attribute! [" + from + "]");
    }

    private ListPatientPrescriptionsResult list(ListPatientPrescriptionsParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        ListOpenPrescriptionsRequest payload = new ListOpenPrescriptionsRequest();
        payload.setSecuredListOpenPrescriptionsRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        payload.setIssueInstant(DateTime.now());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(ListPrescriptions.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:listOpenPrescriptions\"");
        ListOpenPrescriptionsResponse response = GenericWebserviceCaller.callGenericWebservice(request, ListOpenPrescriptionsResponse.class);
        return this.decrypt(response.getSecuredListOpenPrescriptionsResponse().getSecuredContent(), ListPatientPrescriptionsResult.class);
    }

    private PartialResult<ListPrescriptions.Response.Encrypted> fromJAXB(final ListPatientPrescriptionsResult from) {
        if (this.rejected(from.getStatus())) {
            if (from.getStatus().getMessageCode() != null && from.getStatus().getMessageCode().equals("GENERAL_ERROR")) {
                throw new RuntimeExceptionWithResponse((ResponseType)from);
            }
            throw new RejectedWithResponse(JAXB.from(from.getStatus().getValidationReport(), (Object)from), (ResponseType)from);
        }
        return PartialResult.Simple.of((Supplier)new Supplier<Stream<ListPrescriptions.Response.Encrypted>>(){

            public Stream<ListPrescriptions.Response.Encrypted> get() {
                return StreamSupport.stream((Collection)from.getPrescriptions()).map(RecipePatientClient.toListPrescriptionsResponseEncrypted());
            }
        }).hasMore(from.isHasMoreResults().booleanValue());
    }

    private static Function<GetOpenPrescriptionForPatient, ListPrescriptions.Response.Encrypted> toListPrescriptionsResponseEncrypted() {
        return new Function<GetOpenPrescriptionForPatient, ListPrescriptions.Response.Encrypted>(){

            public ListPrescriptions.Response.Encrypted apply(GetOpenPrescriptionForPatient it) {
                return RecipePatientClient.toResponse(it);
            }
        };
    }

    private static ListPrescriptions.Response.Encrypted toResponse(final GetOpenPrescriptionForPatient from) {
        ListPrescriptions.Response.Encrypted.Simple to = ListPrescriptions.Response.Encrypted.Simple.response((Prescription.RID)Prescription.RID.prescriptionID((String)from.getRid()));
        to.rid = Prescription.RID.prescriptionID((String)from.getRid());
        to.patient = Patient.ID.patientID((String)from.getPatientId());
        to.prescriber = Prescriber.ID.prescriberID((String)from.getPrescriberId());
        to.type = Prescription.Type.prescriptionType((String)from.getPrescriptionType());
        to.status = Prescription.Status.valueOf((String)from.getPrescriptionStatus().name());
        to.expirationDate = RecipePatientClient.toLocalDate(from.getExpirationDate());
        to.creationDate = RecipePatientClient.toLocalDateTime(from.getCreationDate());
        to.visibleToExecutors = PrescriptionViewerFormat.parse(from.getVision());
        to.visionOtherPrescribers = JAXB.from(from.getVisionOtherPrescribers());
        to.reservation = Optional.ofNullable((Object)from.getReservedAtNihii()).map((Function)new Function<String, ListPrescriptions.Response.Reservation>(){

            public ListPrescriptions.Response.Reservation apply(String ignored) {
                final ListPrescriptions.Response.Reservation.Simple reservation = new ListPrescriptions.Response.Reservation.Simple();
                reservation.executorId = Executor.ID.executorId((String)from.getReservedAtNihii());
                Optional.ofNullable((Object)from.getReservationDateTime()).ifPresent((Consumer)new Consumer<Calendar>(){

                    public void accept(Calendar calendar) {
                        reservation.creationDateTime = RecipePatientClient.fromJAXB(calendar);
                    }
                });
                Optional.ofNullable((Object)from.getReservationStatus()).ifPresent((Consumer)new Consumer<ReservationStatus>(){

                    public void accept(ReservationStatus status) {
                        reservation.status = Reservation.Status.valueOf((String)status.name());
                    }
                });
                Optional.ofNullable((Object)from.isReservationHasUpdates()).ifPresent((Consumer)new Consumer<Boolean>(){

                    public void accept(Boolean flag) {
                        reservation.hasUpdates = flag;
                    }
                });
                reservation.contactPreference = JAXB.from(from.getContactPreference());
                reservation.email = from.getEmailAddress();
                reservation.phoneNumber = from.getTelephoneNumber();
                reservation.feedbackToPatient = from.getFeedbackToPatient();
                return reservation;
            }
        });
        return to;
    }

    private static LocalDateTime fromJAXB(Calendar from) {
        return Instant.ofEpochMilli((long)from.getTimeInMillis()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public void update(PutVisionExecutors.Request request) {
        this.update(this.toJAXB(request), PutVisionExecutors.class);
    }

    private PutVisionParam toJAXB(PutVisionExecutors.Request from) {
        PutVisionParam to = new PutVisionParam();
        if (from.prescription != null) {
            to.setRid(from.prescription.toString());
        }
        if (from.viewer != null) {
            to.setVision(PrescriptionViewerFormat.toString(from.viewer));
        }
        return to;
    }

    private void update(PutVisionParam params, Class<?> usecaseType) {
        params.setSymmKey(this.symmKey.getEncoded());
        PutVisionForPatientRequest payload = new PutVisionForPatientRequest();
        payload.setSecuredPutVisionForPatientRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(usecaseType.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:putVisionForPatient\"");
        PutVisionForPatientResponse response = GenericWebserviceCaller.callGenericWebservice(request, PutVisionForPatientResponse.class);
        PutVisionResult result = this.decrypt(response.getSecuredPutVisionForPatientResponse().getSecuredContent(), PutVisionResult.class);
        if (this.rejected(result.getStatus())) {
            throw new RejectedWithResponse(JAXB.from(result.getStatus().getValidationReport(), (Object)result), (ResponseType)result);
        }
    }

    public GetExecutorProfile.Response getProfile(GetExecutorProfile request) {
        return this.fromJAXB(this.get(this.toJAXB(request)), request);
    }

    private GetExecutorProfileResult get(GetExecutorProfileParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        GetExecutorProfileRequest payload = new GetExecutorProfileRequest();
        payload.setSecuredGetExecutorProfileRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(GetExecutorProfile.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:getExecutorProfile\"");
        GetExecutorProfileResponse response = GenericWebserviceCaller.callGenericWebservice(request, GetExecutorProfileResponse.class);
        return this.decrypt(response.getSecuredGetExecutorProfileResponse().getSecuredContent(), GetExecutorProfileResult.class);
    }

    private GetExecutorProfileParam toJAXB(GetExecutorProfile from) {
        GetExecutorProfileParam to = new GetExecutorProfileParam();
        to.setExecutorId((String)Optional.ofNullable((Object)from.executorId).map(RecipePatientClient.toText()).orElse(null));
        return to;
    }

    private GetExecutorProfile.Response fromJAXB(GetExecutorProfileResult from, GetExecutorProfile request) {
        this.captureTraceId.accept((Object)from.getId());
        if (this.rejected(from.getStatus())) {
            throw new Rejected(JAXB.from(from.getStatus().getValidationReport(), (Object)request));
        }
        if (from.getProfile() == null) {
            return null;
        }
        return GetExecutorProfile.Response.Simple.profile().reservationFeature(ExecutorProfile.ReservationFeature.valueOf((String)from.getProfile().getReservationFeature().value())).communicationChannelSpecification(ExecutorProfile.CommunicationChannelSpecification.valueOf((String)from.getProfile().getCommunicationChannelSpecification().name()));
    }

    public CancelReservation.Response update(be.recipe.api.patient.CancelReservation request) {
        UpdateReservationParam params = this.updateReservationParams(request.rid);
        params.setCancel(this.toJAXB(request));
        return this.fromJAXB(this.update(params, be.recipe.api.patient.CancelReservation.class).getCancelReservationResult(), request);
    }

    public void update(CancelReservation.Legacy request) {
        this.add(this.toJAXB(request));
    }

    private CreateReservationParam toJAXB(CancelReservation.Legacy from) {
        CreateReservationParam to = new CreateReservationParam();
        to.setRid(from.rid.toString());
        return to;
    }

    private UpdateReservationParam updateReservationParams(Prescription.RID rid) {
        UpdateReservationParam params = new UpdateReservationParam();
        params.setRid((String)Optional.ofNullable((Object)rid).map(RecipePatientClient.toText()).orElse(null));
        params.setSymmKey(this.symmKey.getEncoded());
        return params;
    }

    private UpdateReservationResult update(UpdateReservationParam params, Class<?> usecaseType) {
        UpdateReservationRequest payload = new UpdateReservationRequest();
        payload.setSecuredUpdateReservationRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(usecaseType.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:updateReservation\"");
        UpdateReservationResponse response = GenericWebserviceCaller.callGenericWebservice(request, UpdateReservationResponse.class);
        return this.decrypt(response.getSecuredUpdateReservationResponse().getSecuredContent(), UpdateReservationResult.class);
    }

    private CancelReservation toJAXB(be.recipe.api.patient.CancelReservation from) {
        return new CancelReservation();
    }

    private CancelReservation.Response fromJAXB(CancelReservationResult from, be.recipe.api.patient.CancelReservation root) {
        if (this.rejected(from.getStatus())) {
            throw new Rejected(JAXB.from(from.getStatus().getValidationReport(), (Object)root));
        }
        return new CancelReservation.Response(){};
    }

    public UpdateContactDetails.Response update(UpdateContactDetails request) {
        UpdateReservationParam params = this.updateReservationParams(request.rid);
        params.setContactDetails(this.toJAXB(request));
        return this.fromJAXB(this.update(params, UpdateContactDetails.class).getContactDetailsResult(), request);
    }

    private ContactDetails toJAXB(UpdateContactDetails from) {
        ContactDetails to = new ContactDetails();
        to.setEmailAddress(from.email);
        to.setTelephoneNumber(from.phoneNumber);
        to.setContactPreference((ContactPreference)Optional.ofNullable((Object)from.contactPreference).map(RecipePatientClient.toName()).map(RecipePatientClient.toContactPreference()).orElse(null));
        return to;
    }

    private static Function<String, ContactPreference> toContactPreference() {
        return new Function<String, ContactPreference>(){

            public ContactPreference apply(String it) {
                return ContactPreference.valueOf((String)it);
            }
        };
    }

    private UpdateContactDetails.Response fromJAXB(ContactDetailsResult result, UpdateContactDetails request) {
        if (this.rejected(result.getStatus())) {
            throw new Rejected(JAXB.from(result.getStatus().getValidationReport(), (Object)request));
        }
        return new UpdateContactDetails.Response(){};
    }

    public Prescription.Encrypted get(GetPrescription request) {
        return this.get(this.toJAXB(request));
    }

    private Prescription.Encrypted fromJAXB(GetPrescriptionForPatientResult from, GetPrescriptionForPatientParam root) {
        if (this.rejected(from.getStatus())) {
            throw new Rejected(RecipePatientClient.fromJAXB(from.getStatus().getMessageCode(), root));
        }
        final Prescription.Encrypted.Simple to = new Prescription.Encrypted.Simple();
        to.setRid(Prescription.RID.prescriptionID((String)from.getRid()));
        if (from.getPrescriberId() != null) {
            to.setPrescriber(this.fromJAXB(from.getPrescriberId()));
        }
        if (from.getPatientId() != null) {
            to.setPatient((Patient)new Patient.Simple(Patient.ID.patientID((String)from.getPatientId().toString())));
        }
        to.setCreationDate(RecipePatientClient.toLocalDateTime(from.getCreationDate()));
        to.setEncryptedContent(from.getPrescription());
        to.setEncryptionKey(from.getEncryptionKeyId());
        to.setFeedbackAllowed(from.isFeedbackAllowed().booleanValue());
        if (from.getExpirationDate() != null) {
            to.setExpirationDate(RecipePatientClient.toLocalDate(from.getExpirationDate()));
        }
        to.setVisionOtherPrescribers(JAXB.from(from.getVisionOtherPrescribers()));
        Optional.ofNullable((Object)from.getReservation()).map(this.toGetPrescriptionReservationResponse((Prescription.Encrypted)to)).ifPresent((Consumer)new Consumer<Reservation>(){

            public void accept(Reservation reservation) {
                to.setReservation(reservation);
            }
        });
        return to;
    }

    private Function<GetPrescriptionForPatientResult.Reservation, Reservation> toGetPrescriptionReservationResponse(final Prescription.Encrypted prescription) {
        return new Function<GetPrescriptionForPatientResult.Reservation, Reservation>(){

            public Reservation apply(GetPrescriptionForPatientResult.Reservation reservation) {
                return RecipePatientClient.this.fromJAXB(reservation, prescription);
            }
        };
    }

    private Reservation fromJAXB(GetPrescriptionForPatientResult.Reservation from, Prescription.Encrypted prescription) {
        return Reservation.Simple.reservation((Prescription.Encrypted)prescription).executor(Executor.ID.executorId((String)from.getExecutorId())).status(Reservation.Status.valueOf((String)from.getStatus().name())).contactPreference(JAXB.from(from.getContactPreference())).email(from.getEmail()).phoneNumber(from.getPhoneNumber());
    }

    static ValidationReport fromJAXB(String code, GetPrescriptionForPatientParam root) {
        Violation.Simple.Builder violation = Violation.Simple.violation((String)code);
        if (code.equals("error.prescription.rid.unknown")) {
            violation.on("prescriptionId").value((Object)root.getRid());
        }
        return ValidationReport.Simple.from((Violation.Simple.Builder[])new Violation.Simple.Builder[]{violation});
    }

    private Prescriber fromJAXB(long prescriberId) {
        return new Prescriber.Simple(Prescriber.ID.prescriberID((String)String.valueOf(prescriberId)), PrescriberType.DOCTOR);
    }

    private Prescription.Encrypted get(GetPrescriptionForPatientParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        GetPrescriptionRequest payload = new GetPrescriptionRequest();
        payload.setSecuredGetPrescriptionRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(GetPrescription.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:getPrescription\"");
        GetPrescriptionResponse response = GenericWebserviceCaller.callGenericWebservice(request, GetPrescriptionResponse.class);
        GetPrescriptionForPatientResult result = this.decrypt(response.getSecuredGetPrescriptionResponse().getSecuredContent(), GetPrescriptionForPatientResult.class);
        if (this.rejected(result.getStatus())) {
            throw new RejectedWithResponse(JAXB.from(result.getStatus().getValidationReport(), (Object)result), (ResponseType)result);
        }
        return this.fromJAXB(result, params);
    }

    private GetPrescriptionForPatientParam toJAXB(GetPrescription from) {
        GetPrescriptionForPatientParam to = new GetPrescriptionForPatientParam();
        to.setRid(from.rid.toString());
        return to;
    }

    public void update(RevokePrescription request) {
        this.update(this.toJAXB(request));
    }

    private void update(RevokePrescriptionParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        RevokePrescriptionRequest payload = new RevokePrescriptionRequest();
        payload.setSecuredRevokePrescriptionRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(RevokePrescription.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(false);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:revokePrescription\"");
        RevokePrescriptionResponse response = GenericWebserviceCaller.callGenericWebservice(request, RevokePrescriptionResponse.class);
        RevokePrescriptionResult result = this.decrypt(response.getSecuredRevokePrescriptionResponse().getSecuredContent(), RevokePrescriptionResult.class);
        if (this.rejected(result.getStatus())) {
            throw new RejectedWithResponse(JAXB.from(result.getStatus().getValidationReport(), (Object)result), (ResponseType)result);
        }
    }

    private RevokePrescriptionParam toJAXB(RevokePrescription from) {
        RevokePrescriptionParam to = new RevokePrescriptionParam();
        to.setRid(from.rid.toString());
        to.setReason("-");
        return to;
    }

    public void lock(LockPrescription.Request from) {
        Dispatcher.lock((LockPrescription.Request)from, (PutVisionExecutors)this);
    }

    public void unlock(UnlockPrescription from) {
        Dispatcher.unlock((UnlockPrescription)from, (PutVisionExecutors)this);
    }

    public void update(PutVisionOtherPrescribers request) {
        this.update(this.fromJAXB(request), PutVisionOtherPrescribers.class);
    }

    private PutVisionParam fromJAXB(PutVisionOtherPrescribers from) {
        final PutVisionParam to = new PutVisionParam();
        Optional.ofNullable((Object)from.rid).ifPresent((Consumer)new Consumer<Prescription.RID>(){

            public void accept(Prescription.RID rid) {
                to.setRid(rid.toString());
            }
        });
        Optional.ofNullable((Object)from.vision).ifPresent((Consumer)new Consumer<be.recipe.api.prescriber.VisionOtherPrescribers>(){

            public void accept(be.recipe.api.prescriber.VisionOtherPrescribers it) {
                to.setVisionOtherPrescribers(VisionOtherPrescribers.valueOf((String)it.name()));
            }
        });
        to.setTarget(VisionType.PRESCRIBER);
        return to;
    }

    public GetPrescriptionStatusResponse get(GetPrescriptionStatus request) {
        return this.get(this.toJAXB(request));
    }

    private GetPrescriptionStatusResponse get(GetPrescriptionStatusParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        GetPrescriptionStatusRequest payload = new GetPrescriptionStatusRequest();
        payload.setSecuredGetPrescriptionStatusRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setIssueInstant(DateTime.now());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(GetPrescriptionStatus.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:getPrescriptionStatus\"");
        be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusResponse response = GenericWebserviceCaller.callGenericWebservice(request, be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusResponse.class);
        return this.fromJAXB(this.decrypt(response.getSecuredGetPrescriptionStatusResponse().getSecuredContent(), GetPrescriptionStatusResult.class), params);
    }

    private GetPrescriptionStatusResponse fromJAXB(GetPrescriptionStatusResult from, GetPrescriptionStatusParam root) {
        if (this.rejected(from.getStatus())) {
            throw new RejectedWithResponse(RecipePatientClient.fromJAXB(from.getStatus().getMessageCode(), root), (ResponseType)from);
        }
        return GetPrescriptionStatusResponse.Simple.response().status(JAXB.from(from.getPrescriptionStatus())).executor(JAXB.executor(from.getExecutorId()));
    }

    static ValidationReport fromJAXB(String code, GetPrescriptionStatusParam root) {
        Violation.Simple.Builder violation = Violation.Simple.violation((String)code);
        if (code.equals("error.prescription.rid.unknown")) {
            violation.on("prescriptionId").value((Object)root.getRid());
        }
        return ValidationReport.Simple.from((Violation.Simple.Builder[])new Violation.Simple.Builder[]{violation});
    }

    private GetPrescriptionStatusParam toJAXB(GetPrescriptionStatus from) {
        GetPrescriptionStatusParam to = new GetPrescriptionStatusParam();
        to.setRid(from.rid.toString());
        return to;
    }
}

