/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.executor.dto;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.recipe.services.core.ResponseType;
import be.recipe.services.executor.GetOpenPrescriptionForExecutor;
import java.util.Map;
import java.util.TreeMap;
import java8.util.Comparators;
import java8.util.Objects;
import java8.util.function.Function;
import java8.util.function.Predicate;
import java8.util.stream.StreamSupport;

public class ListOpenPrescriptionsResultWithExceptions
extends ResponseType {
    private final Map<GetOpenPrescriptionForExecutor, IntegrationModuleException> prescriptions = new TreeMap<GetOpenPrescriptionForExecutor, IntegrationModuleException>(Comparators.comparing(ListOpenPrescriptionsResultWithExceptions.toRID()));
    private Boolean hasMoreResults;
    private byte[] session;

    private static Function<GetOpenPrescriptionForExecutor, String> toRID() {
        return new Function<GetOpenPrescriptionForExecutor, String>(){

            public String apply(GetOpenPrescriptionForExecutor it) {
                return it.getRid();
            }
        };
    }

    public boolean exceptionOccurred() {
        return StreamSupport.stream(this.prescriptions.values()).anyMatch(ListOpenPrescriptionsResultWithExceptions.nonNull());
    }

    private static Predicate<IntegrationModuleException> nonNull() {
        return new Predicate<IntegrationModuleException>(){

            public boolean test(IntegrationModuleException it) {
                return Objects.nonNull((Object)it);
            }
        };
    }

    public void addPrescription(GetOpenPrescriptionForExecutor prescription, IntegrationModuleException exception) {
        this.prescriptions.put(prescription, exception);
    }

    public Boolean isHasMoreResults() {
        return this.hasMoreResults;
    }

    public void setHasMoreResults(Boolean value) {
        this.hasMoreResults = value;
    }

    public byte[] getSession() {
        return this.session;
    }

    public void setSession(byte[] value) {
        this.session = value;
    }

    public Boolean getHasMoreResults() {
        return this.hasMoreResults;
    }

    public Map<GetOpenPrescriptionForExecutor, IntegrationModuleException> getPrescriptions() {
        return this.prescriptions;
    }
}

