/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.executor;

import be.business.connector.common.StandaloneRequestorProvider;
import be.business.connector.common.ehealth.EhealthCipher;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.services.GenericWebserviceCaller;
import be.business.connector.core.services.GenericWebserviceRequest;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.recipe.AbstractRecipeClient;
import be.business.connector.recipe.utils.JAXB;
import be.business.connector.recipe.utils.Locales;
import be.business.connector.recipe.utils.PrescriptionViewerFormat;
import be.business.connector.recipe.utils.RejectedWithResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionForExecutorRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionForExecutorResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetProfileRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetProfileResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListOpenPrescriptionsRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListOpenPrescriptionsResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListRelationsRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListRelationsResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListReservationsRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListReservationsResponse;
import be.fgov.ehealth.recipe.protocol.v4.MarkAsArchivedRequest;
import be.fgov.ehealth.recipe.protocol.v4.MarkAsArchivedResponse;
import be.fgov.ehealth.recipe.protocol.v4.UpdateProfileRequest;
import be.fgov.ehealth.recipe.protocol.v4.UpdateProfileResponse;
import be.fgov.ehealth.recipe.protocol.v4.UpdateReservationRequest;
import be.fgov.ehealth.recipe.protocol.v4.UpdateReservationResponse;
import be.recipe.api.ExecutorProfile;
import be.recipe.api.GetPrescriptionStatusResponse;
import be.recipe.api.Prescription;
import be.recipe.api.constraints.Rejected;
import be.recipe.api.constraints.ValidationReport;
import be.recipe.api.constraints.Violation;
import be.recipe.api.crypto.Message;
import be.recipe.api.executor.AcceptReservation;
import be.recipe.api.executor.AcceptReservationCancellationRequest;
import be.recipe.api.executor.ArchivePrescription;
import be.recipe.api.executor.FulfillReservation;
import be.recipe.api.executor.GetPrescription;
import be.recipe.api.executor.GetPrescriptionAndPutInProcess;
import be.recipe.api.executor.GetPrescriptionStatus;
import be.recipe.api.executor.GetProfile;
import be.recipe.api.executor.ListMandatesByMandateHolder;
import be.recipe.api.executor.ListPrescriptions;
import be.recipe.api.executor.ListReservations;
import be.recipe.api.executor.MandateService;
import be.recipe.api.executor.PrescriptionService;
import be.recipe.api.executor.RejectReservation;
import be.recipe.api.executor.UpdateProfile;
import be.recipe.api.mandate.Mandate;
import be.recipe.api.mandate.MandateGiver;
import be.recipe.api.patient.Patient;
import be.recipe.api.prescriber.Prescriber;
import be.recipe.api.prescriber.PrescriberType;
import be.recipe.api.reservation.ContactPreference;
import be.recipe.api.reservation.Reservation;
import be.recipe.api.reservation.executor.ReservationService;
import be.recipe.api.series.PartialResult;
import be.recipe.api.series.SortedBy;
import be.recipe.common.util.CalendarAdapter;
import be.recipe.services.core.CommunicationChannelSpecification;
import be.recipe.services.core.ReservationAttribute;
import be.recipe.services.core.ReservationFeature;
import be.recipe.services.core.ReservationSortedBy;
import be.recipe.services.core.ResponseType;
import be.recipe.services.core.VoidResult;
import be.recipe.services.executor.AcceptCancellationRequest;
import be.recipe.services.executor.GetOpenPrescriptionForExecutor;
import be.recipe.services.executor.GetPrescriptionForExecutorParam;
import be.recipe.services.executor.GetPrescriptionForExecutorResultSealed;
import be.recipe.services.executor.GetPrescriptionStatusParam;
import be.recipe.services.executor.GetPrescriptionStatusResult;
import be.recipe.services.executor.GetProfileParam;
import be.recipe.services.executor.GetProfileResult;
import be.recipe.services.executor.ListOpenPrescriptionsParam;
import be.recipe.services.executor.ListOpenPrescriptionsResult;
import be.recipe.services.executor.ListRelationsItem;
import be.recipe.services.executor.ListRelationsParam;
import be.recipe.services.executor.ListRelationsResult;
import be.recipe.services.executor.ListReservationsParam;
import be.recipe.services.executor.ListReservationsResult;
import be.recipe.services.executor.ListReservationsResultItem;
import be.recipe.services.executor.MarkAsArchivedParam;
import be.recipe.services.executor.MarkAsArchivedResult;
import be.recipe.services.executor.UpdateProfileParam;
import be.recipe.services.executor.UpdateProfileResult;
import be.recipe.services.executor.UpdateReservationParam;
import be.recipe.services.executor.UpdateReservationResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java8.util.Optional;
import java8.util.function.Consumer;
import java8.util.function.Function;
import java8.util.function.Supplier;
import java8.util.stream.RefStreams;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.joda.time.DateTime;
import org.threeten.bp.LocalDate;

public class RecipeExecutorClient
extends AbstractRecipeClient
implements PrescriptionService.Simplified,
ReservationService.Simplified,
MandateService.Simplified {
    public static final String addressKey = "endpoint.executor.v4";
    private static final CalendarAdapter calendar = new CalendarAdapter();
    public Map<MultiKey, byte[]> sessionMap = new HashMap<MultiKey, byte[]>();

    public RecipeExecutorClient(PropertyHandler properties) throws DatatypeConfigurationException {
        super(addressKey, properties);
    }

    public RecipeExecutorClient(PropertyHandler properties, Map<MultiKey, byte[]> sessionMap) throws DatatypeConfigurationException {
        super(addressKey, properties);
        this.sessionMap = sessionMap;
    }

    public RecipeExecutorClient(Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry, EhealthCipher cipher, Supplier<String> traceId) throws DatatypeConfigurationException {
        super(addressKey, keyRegistry, (Message.Cipher)cipher, traceId);
    }

    public Prescription.Encrypted getAndPutInProcess(GetPrescriptionAndPutInProcess request) {
        return this.get(this.toJAXB((GetPrescription)request, false));
    }

    public Prescription.Encrypted get(GetPrescription request) {
        return this.get(this.toJAXB(request, true));
    }

    public PartialResult<ListPrescriptions.Response.Encrypted> list(ListPrescriptions request) {
        return this.list(this.toJAXB(request));
    }

    public PartialResult<ListReservations.Response> list(ListReservations.Request request) {
        return this.list(this.toJAXB(request));
    }

    private GetPrescriptionForExecutorParam toJAXB(GetPrescription from, boolean alreadyDelivered) {
        GetPrescriptionForExecutorParam to = new GetPrescriptionForExecutorParam();
        to.setRid(from.rid.toString());
        to.setVersion(this.properties.getProperty("connector.version", "v2"));
        to.setAlreadyDelivered(Boolean.valueOf(alreadyDelivered));
        return to;
    }

    private Prescription.Encrypted get(GetPrescriptionForExecutorParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        GetPrescriptionForExecutorRequest payload = new GetPrescriptionForExecutorRequest();
        payload.setSecuredGetPrescriptionForExecutorRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setEndpoint(this.address);
        request.setServiceName(GetPrescription.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:getPrescriptionForExecutor\"");
        GetPrescriptionForExecutorResponse response = GenericWebserviceCaller.callGenericWebservice(request, GetPrescriptionForExecutorResponse.class);
        return this.fromJAXB(this.decrypt(response.getSecuredGetPrescriptionForExecutorResponse().getSecuredContent(), GetPrescriptionForExecutorResultSealed.class), params);
    }

    private Prescription.Encrypted fromJAXB(GetPrescriptionForExecutorResultSealed from, GetPrescriptionForExecutorParam root) {
        if (this.rejected(from.getStatus())) {
            throw new RejectedWithResponse(RecipeExecutorClient.fromJAXB(from.getStatus().getMessageCode(), root), (ResponseType)from);
        }
        Prescription.Encrypted.Simple to = new Prescription.Encrypted.Simple();
        to.setRid(Prescription.RID.prescriptionID((String)from.getRid()));
        to.setPrescriber(this.fromJAXB(from.getPrescriberId()));
        to.setPatient((Patient)new Patient.Simple(Patient.ID.patientID((String)from.getPatientId())));
        to.setCreationDate(RecipeExecutorClient.toLocalDateTime(from.getCreationDate()));
        to.setEncryptedContent(from.getPrescription());
        to.setEncryptionKey(from.getEncryptionKeyId());
        to.setFeedbackAllowed(from.isFeedbackAllowed().booleanValue());
        to.setExpirationDate(RecipeExecutorClient.toLocalDate(from.getExpirationDate()));
        to.setVisibleToExecutors(PrescriptionViewerFormat.parse(from.getVision()));
        return to;
    }

    static ValidationReport fromJAXB(String code, GetPrescriptionForExecutorParam root) {
        Violation.Simple.Builder violation = Violation.Simple.violation((String)RecipeExecutorClient.normalize(code));
        if (code.equals("error.prescription.rid.unknown")) {
            violation.on("prescriptionId").value((Object)root.getRid());
        }
        if (code.equals("prescription.not.available.for.delivery")) {
            violation.on("").of(GetPrescriptionAndPutInProcess.class.getSimpleName());
        }
        return ValidationReport.Simple.from((Violation.Simple.Builder[])new Violation.Simple.Builder[]{violation});
    }

    private static String normalize(String code) {
        switch (code) {
            case "error.updatePrescriptionStatus.locked": {
                return "prescription.not.available.for.delivery";
            }
        }
        return code;
    }

    private Prescriber fromJAXB(String id) {
        return new Prescriber.Simple(Prescriber.ID.prescriberID((String)id), PrescriberType.DOCTOR);
    }

    private ListOpenPrescriptionsParam toJAXB(ListPrescriptions request) {
        ListOpenPrescriptionsParam params = new ListOpenPrescriptionsParam();
        params.setPatientId(request.patient == null ? null : request.patient.toString());
        params.setMandateHolderId(request.mandateHolder == null ? null : request.mandateHolder.toString());
        params.setPage(JAXB.to(request.page));
        return params;
    }

    private ListReservationsParam toJAXB(ListReservations.Request from) {
        ListReservationsParam to = new ListReservationsParam();
        to.setStartDate(calendar.unmarshal(LocalDate.now().minusWeeks(2L).toString()));
        to.setPage(JAXB.to(from.page));
        Optional.ofNullable((Object)from.sortedBy).map(this.toReservationSortedBy()).ifPresent(RecipeExecutorClient.setSortOptions(to));
        return to;
    }

    private static Consumer<ReservationSortedBy> setSortOptions(final ListReservationsParam to) {
        return new Consumer<ReservationSortedBy>(){

            public void accept(ReservationSortedBy it) {
                to.setSortOptions(it);
            }
        };
    }

    private Function<SortedBy<Reservation.Attribute>[], ReservationSortedBy> toReservationSortedBy() {
        return new Function<SortedBy<Reservation.Attribute>[], ReservationSortedBy>(){

            public ReservationSortedBy apply(SortedBy<Reservation.Attribute>[] sortedBIES) {
                return RecipeExecutorClient.this.toJAXB(sortedBIES);
            }
        };
    }

    private ReservationSortedBy toJAXB(SortedBy<Reservation.Attribute>[] from) {
        ReservationSortedBy to = new ReservationSortedBy();
        RefStreams.of((Object[])from).map(this.toReservationSortOrder()).forEach(RecipeExecutorClient.setSortedBy(to));
        return to;
    }

    private static Consumer<ReservationSortedBy.SortedBy> setSortedBy(final ReservationSortedBy to) {
        return new Consumer<ReservationSortedBy.SortedBy>(){

            public void accept(ReservationSortedBy.SortedBy it) {
                to.getSortedBies().add(it);
            }
        };
    }

    private Function<SortedBy<Reservation.Attribute>, ReservationSortedBy.SortedBy> toReservationSortOrder() {
        return new Function<SortedBy<Reservation.Attribute>, ReservationSortedBy.SortedBy>(){

            public ReservationSortedBy.SortedBy apply(SortedBy<Reservation.Attribute> it) {
                return RecipeExecutorClient.this.toJAXB((SortedBy<Reservation.Attribute>)it);
            }
        };
    }

    private ReservationSortedBy.SortedBy toJAXB(SortedBy<Reservation.Attribute> from) {
        ReservationSortedBy.SortedBy to = new ReservationSortedBy.SortedBy();
        to.setAttribute(this.toJAXB((Reservation.Attribute)from.attribute));
        to.setOrder(JAXB.toJAXB(from.order));
        return to;
    }

    private ReservationAttribute toJAXB(Reservation.Attribute from) {
        switch (from) {
            case modificationDate: {
                return ReservationAttribute.MODIFICATION_DATE;
            }
        }
        throw new IllegalArgumentException("Unknown attribute! [" + from + "]");
    }

    public PartialResult<ListPrescriptions.Response.Encrypted> list(ListOpenPrescriptionsParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        ListOpenPrescriptionsRequest payload = new ListOpenPrescriptionsRequest();
        payload.setSecuredListOpenPrescriptionsRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        payload.setIssueInstant(DateTime.now());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(ListPrescriptions.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:listOpenPrescriptions\"");
        ListOpenPrescriptionsResponse response = GenericWebserviceCaller.callGenericWebservice(request, ListOpenPrescriptionsResponse.class);
        return this.fromJAXB(this.decrypt(response.getSecuredListOpenPrescriptionsResponse().getSecuredContent(), ListOpenPrescriptionsResult.class), (Object)request);
    }

    public PartialResult<ListReservations.Response> list(ListReservationsParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        ListReservationsRequest payload = new ListReservationsRequest();
        payload.setSecuredListReservationsRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        payload.setIssueInstant(DateTime.now());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(ListReservations.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:listReservations\"");
        ListReservationsResponse response = GenericWebserviceCaller.callGenericWebservice(request, ListReservationsResponse.class);
        return this.fromJAXB(this.decrypt(response.getSecuredListReservationsResponse().getSecuredContent(), ListReservationsResult.class), (Object)request);
    }

    private PartialResult<ListPrescriptions.Response.Encrypted> fromJAXB(final ListOpenPrescriptionsResult from, Object root) {
        if (this.rejected(from.getStatus())) {
            throw new RejectedWithResponse(JAXB.from(from.getStatus().getValidationReport(), root), (ResponseType)from);
        }
        return PartialResult.Simple.of((Supplier)new Supplier<Stream<ListPrescriptions.Response.Encrypted>>(){

            public Stream<ListPrescriptions.Response.Encrypted> get() {
                return StreamSupport.stream((Collection)from.getPrescriptions()).map(RecipeExecutorClient.toLisPrescriptionsResponseEncrypted());
            }
        }).hasMore(from.isHasMoreResults().booleanValue());
    }

    private static Function<GetOpenPrescriptionForExecutor, ListPrescriptions.Response.Encrypted> toLisPrescriptionsResponseEncrypted() {
        return new Function<GetOpenPrescriptionForExecutor, ListPrescriptions.Response.Encrypted>(){

            public ListPrescriptions.Response.Encrypted apply(GetOpenPrescriptionForExecutor it) {
                return RecipeExecutorClient.toResponse(it);
            }
        };
    }

    private PartialResult<ListReservations.Response> fromJAXB(final ListReservationsResult from, Object root) {
        if (this.rejected(from.getStatus())) {
            throw new Rejected(JAXB.from(from.getStatus().getValidationReport(), root));
        }
        return PartialResult.Simple.of((Supplier)new Supplier<Stream<ListReservations.Response>>(){

            public Stream<ListReservations.Response> get() {
                return StreamSupport.stream((Collection)from.getItems()).map(RecipeExecutorClient.toListReservationsResponse());
            }
        }).hasMore(from.isHasMoreResults().booleanValue());
    }

    private static Function<ListReservationsResultItem, ListReservations.Response> toListReservationsResponse() {
        return new Function<ListReservationsResultItem, ListReservations.Response>(){

            public ListReservations.Response apply(ListReservationsResultItem it) {
                return RecipeExecutorClient.toResponse(it);
            }
        };
    }

    private static ListPrescriptions.Response.Encrypted toResponse(GetOpenPrescriptionForExecutor from) {
        ListPrescriptions.Response.Encrypted.Simple to = ListPrescriptions.Response.Encrypted.Simple.response((Prescription.RID)Prescription.RID.prescriptionID((String)from.getRid()));
        to.type = Prescription.Type.prescriptionType((String)from.getPrescriptionType());
        to.patient = Patient.ID.patientID((String)from.getPatientId());
        to.prescriber = Prescriber.ID.prescriberID((String)from.getPrescriberId());
        to.creationDate = RecipeExecutorClient.toLocalDateTime(from.getCreationDate());
        to.expirationDate = RecipeExecutorClient.toLocalDate(from.getExpirationDate());
        to.encryptedPrescriptionContent = from.getPrescription();
        to.encryptionKey = from.getEncryptionKeyId();
        to.feedbackAllowed = from.isFeedbackAllowed();
        to.status = Prescription.Status.valueOf((String)from.getPrescriptionStatus().name());
        to.visibleTo = PrescriptionViewerFormat.parse(from.getVision());
        return to;
    }

    private static ListReservations.Response toResponse(ListReservationsResultItem from) {
        ListReservations.Response.Simple to = new ListReservations.Response.Simple();
        to.rid = Prescription.RID.prescriptionID((String)from.getRid());
        to.visibleTo = PrescriptionViewerFormat.parse(from.getVision());
        to.reservationStatus = from.getStatus() != null ? Reservation.Status.valueOf((String)from.getStatus().name()) : Reservation.Status.REQUESTED_WITHOUT_COMMITMENT;
        to.createdOn = RecipeExecutorClient.toLocalDateTime(from.getCreationDateReservation());
        to.updatedOn = RecipeExecutorClient.toLocalDateTime(from.getLastUpdateReservation());
        if (from.getContactPreference() != null) {
            to.contactPreference = ContactPreference.valueOf((String)from.getContactPreference().name());
        }
        to.email = from.getEmailAddress();
        to.phoneNumber = from.getTelephoneNumber();
        to.prescription = RecipeExecutorClient.toResponse(from.getPrescription());
        return to;
    }

    public void update(AcceptReservation request) {
        UpdateReservationParam params = this.updateReservationParams(request.rid);
        params.setAccept(this.toJAXB(request));
        this.fromJAXB(this.update(params, AcceptReservation.class).getAcceptReservationResult(), request);
    }

    private void fromJAXB(VoidResult from, AcceptReservation root) {
        if (this.rejected(from.getStatus())) {
            throw new Rejected(JAXB.from(from.getStatus().getValidationReport(), (Object)root));
        }
    }

    private UpdateReservationParam updateReservationParams(Prescription.RID rid) {
        UpdateReservationParam params = new UpdateReservationParam();
        params.setRid((String)Optional.ofNullable((Object)rid).map(RecipeExecutorClient.toText()).orElse(null));
        params.setSymmKey(this.symmKey.getEncoded());
        return params;
    }

    private be.recipe.services.executor.AcceptReservation toJAXB(AcceptReservation from) {
        be.recipe.services.executor.AcceptReservation to = new be.recipe.services.executor.AcceptReservation();
        to.setMessage(from.message);
        return to;
    }

    private UpdateReservationResult update(UpdateReservationParam params, Class<?> usecaseType) {
        UpdateReservationRequest payload = new UpdateReservationRequest();
        payload.setSecuredUpdateReservationRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(usecaseType.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:updateReservation\"");
        UpdateReservationResponse response = GenericWebserviceCaller.callGenericWebservice(request, UpdateReservationResponse.class);
        return this.decrypt(response.getSecuredUpdateReservationResponse().getSecuredContent(), UpdateReservationResult.class);
    }

    public void update(RejectReservation request) {
        UpdateReservationParam params = this.updateReservationParams(request.rid);
        params.setReject(this.toJAXB(request));
        this.update(params, RejectReservation.class);
    }

    private be.recipe.services.executor.RejectReservation toJAXB(RejectReservation from) {
        be.recipe.services.executor.RejectReservation to = new be.recipe.services.executor.RejectReservation();
        to.setMessage(from.message);
        return to;
    }

    public void update(AcceptReservationCancellationRequest request) {
        UpdateReservationParam params = this.updateReservationParams(request.rid);
        params.setAcceptCancellationRequest(this.toJAXB(request));
        this.fromJAXB(this.update(params, AcceptReservationCancellationRequest.class).getAcceptReservationCancellationResult(), (Object)request);
    }

    private void fromJAXB(VoidResult from, Object root) {
        if (this.rejected(from.getStatus())) {
            throw new Rejected(JAXB.from(from.getStatus().getValidationReport(), root));
        }
    }

    private AcceptCancellationRequest toJAXB(AcceptReservationCancellationRequest from) {
        return new AcceptCancellationRequest();
    }

    public void update(FulfillReservation request) {
        UpdateReservationParam params = this.updateReservationParams(request.rid);
        params.setFulfill(this.toJAXB(request));
        this.update(params, FulfillReservation.class);
    }

    private be.recipe.services.executor.FulfillReservation toJAXB(FulfillReservation from) {
        be.recipe.services.executor.FulfillReservation fulfillReservation = new be.recipe.services.executor.FulfillReservation();
        fulfillReservation.setMessage(from.message);
        return fulfillReservation;
    }

    public void updateProfile(UpdateProfile request) {
        this.update(this.toJAXB(request));
    }

    private void update(UpdateProfileParam params) {
        UpdateProfileRequest payload = new UpdateProfileRequest();
        payload.setSecuredUpdateProfileRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(UpdateProfile.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:updateProfile\"");
        UpdateProfileResponse response = GenericWebserviceCaller.callGenericWebservice(request, UpdateProfileResponse.class);
        this.decrypt(response.getSecuredUpdateProfileResponse().getSecuredContent(), UpdateProfileResult.class);
    }

    private UpdateProfileParam toJAXB(UpdateProfile request) {
        UpdateProfileParam params = new UpdateProfileParam();
        params.setSymmKey(this.symmKey.getEncoded());
        if (request.reservationFeature() != null) {
            params.setReservationFeature(ReservationFeature.valueOf((String)request.reservationFeature().name().toUpperCase()));
        }
        if (request.communicationChannelSpecification() != null) {
            params.setCommunicationChannelSpecification(CommunicationChannelSpecification.valueOf((String)request.communicationChannelSpecification().name()));
        }
        return params;
    }

    public GetProfile.Response getProfile(GetProfile request) {
        return this.fromJAXB(this.get(this.toJAXB(request)));
    }

    private GetProfileParam toJAXB(GetProfile request) {
        GetProfileParam to = new GetProfileParam();
        to.setSymmKey(this.symmKey.getEncoded());
        return to;
    }

    private GetProfile.Response fromJAXB(GetProfileResult from) {
        this.captureTraceId.accept((Object)from.getId());
        if (from.getProfile() == null) {
            return null;
        }
        return GetProfile.Response.Simple.profile().reservationFeature(ExecutorProfile.ReservationFeature.valueOf((String)from.getProfile().getReservationFeature().value())).communicationChannelSpecification(ExecutorProfile.CommunicationChannelSpecification.valueOf((String)from.getProfile().getCommunicationChannelSpecification().name()));
    }

    private GetProfileResult get(GetProfileParam params) {
        GetProfileRequest payload = new GetProfileRequest();
        payload.setSecuredGetProfileRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(GetProfile.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:getProfile\"");
        GetProfileResponse response = GenericWebserviceCaller.callGenericWebservice(request, GetProfileResponse.class);
        return this.decrypt(response.getSecuredGetProfileResponse().getSecuredContent(), GetProfileResult.class);
    }

    public void update(ArchivePrescription request) {
        this.update(this.toJAXB(request));
    }

    private void update(MarkAsArchivedParam params) {
        MarkAsArchivedRequest payload = new MarkAsArchivedRequest();
        payload.setSecuredMarkAsArchivedRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(ArchivePrescription.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:markAsArchived\"");
        MarkAsArchivedResponse response = GenericWebserviceCaller.callGenericWebservice(request, MarkAsArchivedResponse.class);
        this.decrypt(response.getSecuredMarkAsArchivedResponse().getSecuredContent(), MarkAsArchivedResult.class);
    }

    private MarkAsArchivedParam toJAXB(ArchivePrescription from) {
        MarkAsArchivedParam to = new MarkAsArchivedParam();
        Optional.ofNullable((Object)from.rid).map(RecipeExecutorClient.toText()).ifPresent(RecipeExecutorClient.setRID(to));
        to.setSymmKey(this.symmKey.getEncoded());
        return to;
    }

    private static Consumer<String> setRID(final MarkAsArchivedParam to) {
        return new Consumer<String>(){

            public void accept(String it) {
                to.setRid(it);
            }
        };
    }

    public Stream<ListMandatesByMandateHolder.Response> listMandates(ListMandatesByMandateHolder request) {
        return this.fromJAXB(this.list(this.toJAXB(request)), request);
    }

    private Stream<ListMandatesByMandateHolder.Response> fromJAXB(ListRelationsResult from, ListMandatesByMandateHolder request) {
        this.sessionMap.put(RecipeExecutorClient.toSessionKey(request), from.getSession());
        return StreamSupport.stream((Collection)from.getItems()).map((Function)new Function<ListRelationsItem, ListMandatesByMandateHolder.Response>(){

            public ListMandatesByMandateHolder.Response apply(final ListRelationsItem from) {
                return new ListMandatesByMandateHolder.Response(){

                    public MandateGiver mandateGiver() {
                        return MandateGiver.Simple.mandateGiver((Patient.ID)Patient.ID.patientID((String)from.getPatientId())).firstName(from.getPatientFirstname()).lastName(from.getPatientLastname());
                    }

                    public Mandate.Type type() {
                        return Mandate.Type.valueOf((String)from.getMandateHolderType().name());
                    }
                };
            }
        });
    }

    private ListRelationsResult list(final ListRelationsParam params) {
        return this.withExceptionHandling(new Supplier<ListRelationsResult>(){

            public ListRelationsResult get() {
                ListRelationsRequest payload = new ListRelationsRequest();
                payload.setSecuredListRelationsRequest(RecipeExecutorClient.this.content(RecipeExecutorClient.this.encrypt(params)));
                payload.setIssueInstant(DateTime.now());
                payload.setProgramId(RecipeExecutorClient.this.programId());
                payload.setId((String)RecipeExecutorClient.this.traceId.get());
                GenericWebserviceRequest request = new GenericWebserviceRequest();
                request.setRequest(payload.unwrap());
                request.setRequestType(((Object)((Object)payload)).getClass());
                request.setEndpoint(RecipeExecutorClient.this.address);
                request.setServiceName(ListMandatesByMandateHolder.class.getSimpleName());
                request.setAddLoggingHandler(true);
                request.setAddSoapFaultHandler(true);
                request.setAddInsurabilityHandler(true);
                request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:listRelations\"");
                ListRelationsResponse response = GenericWebserviceCaller.callGenericWebservice(request, ListRelationsResponse.class);
                ListRelationsResult result = (ListRelationsResult)RecipeExecutorClient.this.decrypt(response.getSecuredListRelationsResponse().getSecuredContent(), ListRelationsResult.class);
                if (RecipeExecutorClient.this.rejected(result.getStatus())) {
                    if (result.getStatus().getValidationReport() != null) {
                        throw new Rejected(JAXB.from(result.getStatus().getValidationReport(), (Object)params));
                    }
                    throw new IntegrationModuleException(Locales.getLocalisedMsg(result.getStatus()), (ResponseType)result);
                }
                return result;
            }
        });
    }

    private ListRelationsParam toJAXB(ListMandatesByMandateHolder from) {
        ListRelationsParam to = new ListRelationsParam();
        if (from.mandateHolder != null) {
            to.setMandateHolderId(from.mandateHolder.toString());
        }
        to.setSymmKey(this.symmKey.getEncoded());
        to.setSession(this.sessionMap.get(RecipeExecutorClient.toSessionKey(from)));
        return to;
    }

    public static MultiKey toSessionKey(ListMandatesByMandateHolder from) {
        return new MultiKey((Object)StandaloneRequestorProvider.getRequestorIdInformation(), Optional.ofNullable((Object)from.mandateHolder).map((Function)new Function<Patient.ID, Object>(){

            public Object apply(Patient.ID it) {
                return it.toString();
            }
        }).orElse(null));
    }

    private <T> T withExceptionHandling(Supplier<T> task) {
        return this.withExceptionHandling("error.connection.executor", task);
    }

    public GetPrescriptionStatusResponse get(GetPrescriptionStatus request) {
        return this.get(this.toJAXB(request));
    }

    private GetPrescriptionStatusResponse get(GetPrescriptionStatusParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        GetPrescriptionStatusRequest payload = new GetPrescriptionStatusRequest();
        payload.setSecuredGetPrescriptionStatusRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setIssueInstant(DateTime.now());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(GetPrescriptionStatus.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:getPrescriptionStatus\"");
        be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusResponse response = GenericWebserviceCaller.callGenericWebservice(request, be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusResponse.class);
        return this.fromJAXB(this.decrypt(response.getSecuredGetPrescriptionStatusResponse().getSecuredContent(), GetPrescriptionStatusResult.class), params);
    }

    private GetPrescriptionStatusResponse fromJAXB(GetPrescriptionStatusResult from, GetPrescriptionStatusParam root) {
        if (this.rejected(from.getStatus())) {
            throw new RejectedWithResponse(RecipeExecutorClient.fromJAXB(from.getStatus().getMessageCode(), root), (ResponseType)from);
        }
        return GetPrescriptionStatusResponse.Simple.response().status(JAXB.from(from.getPrescriptionStatus())).executor(JAXB.executor(from.getExecutorId()));
    }

    static ValidationReport fromJAXB(String code, GetPrescriptionStatusParam root) {
        Violation.Simple.Builder violation = Violation.Simple.violation((String)RecipeExecutorClient.normalize(code));
        if (code.equals("error.prescription.rid.unknown")) {
            violation.on("prescriptionId").value((Object)root.getRid());
        }
        return ValidationReport.Simple.from((Violation.Simple.Builder[])new Violation.Simple.Builder[]{violation});
    }

    private GetPrescriptionStatusParam toJAXB(GetPrescriptionStatus from) {
        GetPrescriptionStatusParam to = new GetPrescriptionStatusParam();
        to.setRid(from.rid.toString());
        return to;
    }
}

