/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.executor;

import be.business.connector.common.StandaloneRequestorProvider;
import be.business.connector.core.domain.KgssIdentifierType;
import be.business.connector.core.utils.Exceptionutils;
import be.business.connector.core.utils.IOUtils;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.recipe.executor.AbstractExecutorIntegrationModule;
import be.business.connector.recipe.executor.ExecutorIntegrationModuleV4;
import be.business.connector.recipe.executor.RecipeExecutorClient;
import be.business.connector.recipe.executor.dto.ListOpenPrescriptionsResultWithExceptions;
import be.business.connector.recipe.executor.dto.ListReservationsResultWithExceptions;
import be.business.connector.recipe.utils.ExecutorDecryptionUtils;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.recipe.api.executor.ListMandatesByMandateHolder;
import be.recipe.api.executor.MandateService;
import be.recipe.services.executor.GetOpenPrescriptionForExecutor;
import be.recipe.services.executor.ListOpenPrescriptionsResult;
import be.recipe.services.executor.ListReservationsResult;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java8.util.stream.Stream;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.perf4j.aop.Profiled;

public abstract class AbstractExecutorIntegrationModuleV4
extends AbstractExecutorIntegrationModule
implements ExecutorIntegrationModuleV4 {
    protected static Map<MultiKey, byte[]> sessionMap = new HashMap<MultiKey, byte[]>();
    private final ExecutorDecryptionUtils utils;
    private final MandateService.Simplified mandateService;

    public AbstractExecutorIntegrationModuleV4() {
        try {
            PropertyHandler props = this.getPropertyHandler();
            this.utils = new ExecutorDecryptionUtils(props, this.getEncryptionUtils());
            this.mandateService = new RecipeExecutorClient(props, sessionMap);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#decryptGetOpenPrescriptionForExecutor")
    public GetOpenPrescriptionForExecutor decryptGetOpenPrescriptionForExecutor(GetOpenPrescriptionForExecutor gopfe) {
        try {
            String requestorIdInformation = StandaloneRequestorProvider.getRequestorIdInformation();
            KeyResult key = this.getKeyFromKgss(gopfe.getEncryptionKeyId(), this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_PHARMACY, requestorIdInformation).get(0).getEncoded());
            byte[] unsealedPrescription = this.unsealPrescriptionForUnknown(key, gopfe.getPrescription());
            GetOpenPrescriptionForExecutor finalResult = new GetOpenPrescriptionForExecutor();
            finalResult.setCreationDate(gopfe.getCreationDate());
            finalResult.setEncryptionKeyId(gopfe.getEncryptionKeyId());
            finalResult.setFeedbackAllowed(gopfe.isFeedbackAllowed());
            finalResult.setId(gopfe.getId());
            finalResult.setPatientId(gopfe.getPatientId());
            finalResult.setPrescriberId(gopfe.getPrescriberId());
            finalResult.setPrescription(IOUtils.decompress(unsealedPrescription));
            finalResult.setPrescriptionType(gopfe.getPrescriptionType());
            finalResult.setRid(gopfe.getRid());
            finalResult.setStatus(gopfe.getStatus());
            finalResult.setExpirationDate(gopfe.getExpirationDate());
            return finalResult;
        }
        catch (IOException ex) {
            Exceptionutils.errorHandler(ex, "error.data.uncompression");
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#decryptListOpenPrescriptionsResult")
    public ListOpenPrescriptionsResult decryptListOpenPrescriptionsResult(ListOpenPrescriptionsResult listOpenPrescriptionsResult) {
        try {
            return this.utils.decryptPrescriptions(listOpenPrescriptionsResult);
        }
        catch (Exception ex) {
            Exceptionutils.errorHandler(ex, "error.data.uncompression");
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#decryptListOpenPrescriptionsResultWithExceptions")
    public ListOpenPrescriptionsResultWithExceptions decryptListOpenPrescriptionsResultWithExceptions(ListOpenPrescriptionsResult listOpenPrescriptionsResult) {
        try {
            return this.utils.decryptPrescriptionsWithException(listOpenPrescriptionsResult);
        }
        catch (Exception ex) {
            Exceptionutils.errorHandler(ex, "error.data.uncompression");
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#decryptListReservationsResult")
    public ListReservationsResult decryptListReservationsResult(ListReservationsResult listReservationsResult) {
        try {
            return this.utils.decryptReservations(listReservationsResult);
        }
        catch (Exception ex) {
            Exceptionutils.errorHandler(ex, "error.data.uncompression");
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#decryptListReservationsResultWithExceptions")
    public ListReservationsResultWithExceptions decryptListReservationsResultWithExceptions(ListReservationsResult listReservationsResult) {
        try {
            return this.utils.decryptReservationsWithExceptions(listReservationsResult);
        }
        catch (Exception ex) {
            Exceptionutils.errorHandler(ex, "error.data.uncompression");
            return null;
        }
    }

    public Stream<ListMandatesByMandateHolder.Response> listMandates(ListMandatesByMandateHolder request) {
        return this.mandateService.listMandates(request);
    }
}

