/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import be.business.connector.core.exceptions.IntegrationModuleEhealthException;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.STSHelper;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SAMLTokenValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLTokenValidator.class);

    private static boolean hasExpired(Element assertion) {
        if (assertion != null && STSHelper.getConditions(assertion).getLength() > 0) {
            Calendar calNotOnOrAfter = Calendar.getInstance();
            calNotOnOrAfter.setTime(STSHelper.getNotOnOrAfterConditions(assertion).getTime());
            Calendar now = Calendar.getInstance();
            return !now.before(calNotOnOrAfter);
        }
        return true;
    }

    private static boolean hasValidAttributes(Element assertion) {
        NodeList attributes = STSHelper.getAttributes(assertion);
        if (attributes == null || attributes.getLength() == 0) {
            return false;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Element attribute = (Element)attributes.item(i);
            LOG.debug("SAML AttributeName : " + attribute.getAttribute("AttributeName") + " : TextContent : " + attribute.getTextContent());
            if (!"".equals(attribute.getTextContent().trim())) continue;
            LOG.error("Empty SAML attribute designator, eHealth doesn't recognised you... contact eHealth");
            throw new IntegrationModuleEhealthException(I18nHelper.getLabel("error.saml.attribute", new String[]{attribute.getAttribute("AttributeName")}));
        }
        return true;
    }

    private static boolean hasValidPharmacyAttributes(Element assertion) {
        NodeList attributes = STSHelper.getAttributes(assertion);
        if (attributes == null || attributes.getLength() == 0) {
            return false;
        }
        HashMap<String, String> failedAttributes = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Element attribute = (Element)attributes.item(i);
            LOG.debug("SAML AttributeName : " + attribute.getAttribute("AttributeName") + " : TextContent : " + attribute.getTextContent());
            if ("urn:be:fgov:ehealth:1.0:pharmacy:nihii-number:recognisedpharmacy:boolean".equals(attribute.getAttribute("AttributeName")) && attribute.getTextContent().equals("false")) {
                failedAttributes.put(attribute.getAttribute("AttributeName"), attribute.getTextContent());
            }
            if ("urn:be:fgov:ehealth:1.0:pharmacy:nihii-number:person:ssin:ehealth:1.0:pharmacy-holder:boolean".equals(attribute.getAttribute("AttributeName")) && attribute.getTextContent().equals("false")) {
                failedAttributes.put(attribute.getAttribute("AttributeName"), attribute.getTextContent());
            }
            if (failedAttributes.size() <= 0) continue;
            LOG.error("Not a recognized , eHealth doesn't recognised you... contact eHealth");
            throw new IntegrationModuleEhealthException(I18nHelper.getLabel("error.false.saml.attribute", new Object[]{SAMLTokenValidator.toString(failedAttributes)}));
        }
        return true;
    }

    private static boolean hasValidHospitalPharmacyAttributes(Element assertion) {
        NodeList attributes = STSHelper.getAttributes(assertion);
        if (attributes == null || attributes.getLength() == 0) {
            return false;
        }
        HashMap<String, String> failedAttributes = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Element attribute = (Element)attributes.item(i);
            LOG.debug("SAML AttributeName : " + attribute.getAttribute("AttributeName") + " : TextContent : " + attribute.getTextContent());
            if ("urn:be:fgov:ehealth:1.0:pharmacy:nihii-number:recognisedhospitalpharmacy:boolean".equals(attribute.getAttribute("AttributeName")) && attribute.getTextContent().equals("false")) {
                failedAttributes.put(attribute.getAttribute("AttributeName"), attribute.getTextContent());
            }
            if ("urn:be:fgov:ehealth:1.0:certificateholder:hospital:nihii-number:recognisedhospital:boolean".equals(attribute.getAttribute("AttributeName")) && attribute.getTextContent().equals("false")) {
                failedAttributes.put(attribute.getAttribute("AttributeName"), attribute.getTextContent());
            }
            if (failedAttributes.size() <= 0) continue;
            LOG.error("Not a recognized , eHealth doesn't recognised you... contact eHealth");
            throw new IntegrationModuleEhealthException(I18nHelper.getLabel("error.false.saml.attribute", new Object[]{SAMLTokenValidator.toString(failedAttributes)}));
        }
        return true;
    }

    private static String toString(Map<String, String> failedAttributes) {
        StringBuilder sb = new StringBuilder();
        for (String key : failedAttributes.keySet()) {
            String value = failedAttributes.get(key);
            sb.append(key + "[" + value + "];");
        }
        return sb.toString();
    }

    public static boolean isValid(Element assertion) {
        return assertion != null && !SAMLTokenValidator.hasExpired(assertion) && SAMLTokenValidator.hasValidAttributes(assertion);
    }

    public static boolean isValidPharmacySession(Element assertion) {
        return assertion != null && !SAMLTokenValidator.hasExpired(assertion) && SAMLTokenValidator.hasValidAttributes(assertion) && SAMLTokenValidator.hasValidPharmacyAttributes(assertion);
    }

    public static boolean isValidHospitalPharmacySession(Element assertion) {
        return assertion != null && !SAMLTokenValidator.hasExpired(assertion) && SAMLTokenValidator.hasValidAttributes(assertion) && SAMLTokenValidator.hasValidHospitalPharmacyAttributes(assertion);
    }
}

