/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.Exceptionutils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.IOUtils;
import be.business.connector.core.utils.PropertyHandler;
import be.fgov.ehealth.etee.crypto.decrypt.DataUnsealer;
import be.fgov.ehealth.etee.crypto.decrypt.DataUnsealerBuilder;
import be.fgov.ehealth.etee.crypto.decrypt.UnsealedData;
import be.fgov.ehealth.etee.crypto.encrypt.DataSealer;
import be.fgov.ehealth.etee.crypto.encrypt.DataSealerBuilder;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.etee.crypto.policies.EncryptionCredentials;
import be.fgov.ehealth.etee.crypto.policies.EncryptionPolicy;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.etee.crypto.policies.SigningCredential;
import be.fgov.ehealth.etee.crypto.policies.SigningPolicy;
import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import be.fgov.ehealth.etee.crypto.status.NotificationError;
import be.fgov.ehealth.etee.crypto.status.NotificationWarning;
import be.fgov.ehealth.etee.crypto.utils.KeyManager;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionUtils {
    private static final String KEYSTORE_DIR = "KEYSTORE_DIR";
    private static final String TSA_KEYSTORE_TYPE = "timestamp.signature.keystore.type";
    private static final String TSA_KEYSTORE_FILE = "timestamp.signature.keystore.path";
    private static final String TSA_KEYSTORE_PASSWORD = "timestamp.signature.keystore.pwd";
    private static final char[] DEFAULT_PASSWORD = "hello!".toCharArray();
    public static final String AUTHENTICATION_ALIAS = "authentication";
    private static final String AUTHENTICATION_FALLBACK_ALIAS = "authentication_fallback";
    public static final String PROP_KEYSTORE_FILE = "sessionmanager.holderofkey.keystore";
    private static final String PROP_OLD_KEYSTORE_FILE = "OLD_KEYSTORE_FILE";
    private static final String PKCS12 = "PKCS12";
    public static final String PROP_KEYSTORE_PASSWORD = "KEYSTORE_PASSWORD";
    private static final String PROP_OLD_KEYSTORE_PASSWORD = "OLD_KEYSTORE_PASSWORD";
    public static final String PROP_KEYSTORE_P12_FOLDER = "KEYSTORE_DIR";
    private static final String PROP_KEYSTORE_OLD_P12_FOLDER = "KEYSTORE_AUTH_OLD_P12_FOLDER";
    private static final String PERSONAL_KEYSTORE = "PERSONAL_KEYSTORE";
    private static final String PROP_KEYSTORE_MANDATE_FILE = "KEYSTORE_FILE_MANDATE_ORGANISATION";
    private static final String PROP_KEYSTORE_MANDATE_PASSWORD = "KEYSTORE_PASSWORD_MANDATE_ORGANISATION";
    private static final String PROP_KEYSTORE_RIZIV_KBO = "PROP_KEYSTORE_RIZIV_KBO";
    private static final String PROP_OLD_KEYSTORE_RIZIV_KBO = "PROP_OLD_KEYSTORE_RIZIV_KBO";
    private static final String LOCAL_CA_CERTIFICATES_STORE_FILE = "CAKEYSTORE_LOCATION";
    private static final String LOCAL_CA_CERTIFICATES_STORE_TYPE = "LOCAL_CA_CERTIFICATES_STORE_TYPE";
    private static final String LOCAL_CA_CERTIFICATES_STORE_PASSWORD = "CAKEYSTORE_PASSWORD";
    private static final String SYMM_KEY_PROPERTY = "symmKey";
    private KeyStore keyStore;
    private KeyStore tsaKeyStore;
    private KeyStore mandateKeyStore;
    private KeyStore oldKeyStore;
    private List<String> tsaStoreAliases;
    private PropertyHandler propertyHandler = null;
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionUtils.class);
    private static EncryptionUtils instance = null;
    private String systemKeystorePath;
    private String oldSystemKeystorePath;
    private String caCertificateKeystoreLocation;
    private final String encryptionSignature = "ENCRYPTI0NS1GNATURE";

    public EncryptionUtils(PropertyHandler propertyHandler) {
        this.propertyHandler = propertyHandler;
        instance = this;
    }

    public static EncryptionUtils getInstance() {
        return instance;
    }

    public SecretKey generateSecretKey() throws IntegrationModuleException {
        try {
            if (this.propertyHandler.hasProperty(SYMM_KEY_PROPERTY)) {
                String base64key = this.propertyHandler.getProperty(SYMM_KEY_PROPERTY);
                DESedeKeySpec keyspec = new DESedeKeySpec(Base64.decode((String)base64key));
                SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
                SecretKey key = keyfactory.generateSecret(keyspec);
                return key;
            }
            KeyGenerator keyGen = KeyGenerator.getInstance("DESede");
            return keyGen.generateKey();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IntegrationModuleException(e);
        }
    }

    public static byte[] unsealWithSymmKey(Key symmKey, byte[] objectToUnseal) {
        try {
            Cipher cipher = Cipher.getInstance("DESede");
            cipher.init(2, symmKey);
            return cipher.doFinal(objectToUnseal);
        }
        catch (Exception e) {
            LOG.error("unsealWithSymmKey Error", (Throwable)e);
            return null;
        }
    }

    public synchronized KeyStore getKeyStore() throws IntegrationModuleException {
        if (this.keyStore == null) {
            try {
                InputStream stream = this.getSystemKeystoreStream();
                String pwd = this.getSystemKeystorePassword();
                try {
                    this.keyStore = KeyManager.getKeyStore((InputStream)stream, (String)PKCS12, (char[])pwd.toCharArray());
                }
                catch (IOException ex) {
                    if (ex.getCause() instanceof BadPaddingException) {
                        throw new IntegrationModuleException(I18nHelper.getLabel("error.keystore.password"), ex);
                    }
                    throw new IntegrationModuleException(I18nHelper.getLabel("error.corrupt.system.certificate"), ex);
                }
                LOG.debug("Iterating over keyStore.aliases()");
                Enumeration<String> aliases = this.keyStore.aliases();
                ArrayList<String> keyEntries = new ArrayList<String>();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    LOG.debug("Checking key : " + alias);
                    if (!this.keyStore.isKeyEntry(alias)) continue;
                    keyEntries.add(alias);
                }
                LOG.debug("Deleting entries of keyStore.aliases()");
                for (String alias : keyEntries) {
                    Key key = this.keyStore.getKey(alias, pwd.toCharArray());
                    Certificate[] chain = this.keyStore.getCertificateChain(alias);
                    this.keyStore.deleteEntry(alias);
                    this.keyStore.setKeyEntry(alias, key, DEFAULT_PASSWORD, chain);
                }
                this.dumpKeyStore(this.keyStore);
            }
            catch (Throwable t) {
                LOG.error("Invalid keystore configuration", t);
                Exceptionutils.errorHandler(t, "error.keystore");
            }
        }
        return this.keyStore;
    }

    public KeyStore getTSAKeyStore() throws IntegrationModuleException {
        if (this.tsaKeyStore == null) {
            try {
                InputStream stream = null;
                char[] pwd = null;
                stream = this.getTSAKeystoreStream();
                pwd = this.propertyHandler.getProperty(TSA_KEYSTORE_PASSWORD).toCharArray();
                try {
                    this.tsaKeyStore = KeyManager.getKeyStore((InputStream)stream, (String)this.propertyHandler.getProperty(TSA_KEYSTORE_TYPE), (char[])pwd);
                }
                catch (IOException ex) {
                    if (ex.getCause() instanceof BadPaddingException) {
                        throw new IntegrationModuleException(I18nHelper.getLabel("error.tsaStore.password"), ex);
                    }
                    throw new IntegrationModuleException(I18nHelper.getLabel("error.corrupt.system.certificate"), ex);
                }
                LOG.debug("Iterating over tsaKeyStore.aliases()");
                Enumeration<String> aliases = this.tsaKeyStore.aliases();
                this.tsaStoreAliases = new ArrayList<String>();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    LOG.debug("Checking key : " + alias);
                    this.tsaStoreAliases.add(alias);
                }
            }
            catch (Throwable t) {
                LOG.error("Invalid keystore configuration", t);
                Exceptionutils.errorHandler(t, "error.tsaStore");
            }
        }
        return this.tsaKeyStore;
    }

    public List<String> getTsaStoreAliases() {
        return this.tsaStoreAliases;
    }

    private InputStream getSystemKeystoreStream() throws IOException, IntegrationModuleException {
        return IOUtils.getResourceAsStream(this.getSystemKeystorePath());
    }

    public String getSystemKeystorePath() throws IntegrationModuleException {
        if (!StringUtils.isBlank((String)this.systemKeystorePath)) {
            return this.systemKeystorePath;
        }
        if (this.propertyHandler.hasProperty("KEYSTORE_DIR") && this.propertyHandler.hasProperty(PROP_KEYSTORE_RIZIV_KBO)) {
            String directory = this.propertyHandler.getProperty("KEYSTORE_DIR");
            String riziv = this.propertyHandler.getProperty(PROP_KEYSTORE_RIZIV_KBO);
            List<String> files = IOUtils.getP12FileList(directory, riziv);
            String file = files.get(0);
            return file;
        }
        if (this.propertyHandler.hasProperty(PROP_KEYSTORE_FILE) && this.propertyHandler.hasProperty("KEYSTORE_DIR")) {
            String keyStoreDir = this.propertyHandler.getProperty("KEYSTORE_DIR");
            String keyStoreFile = this.propertyHandler.getProperty(PROP_KEYSTORE_FILE);
            String keyStoreFilePath = "";
            keyStoreFilePath = StringUtils.endsWith((String)keyStoreDir, (String)"/") ? keyStoreDir + keyStoreFile : keyStoreDir + "/" + keyStoreFile;
            return keyStoreFilePath;
        }
        throw new IntegrationModuleException(I18nHelper.getLabel("error.property.not.found.keystore.file"));
    }

    private InputStream getTSAKeystoreStream() throws IOException, IntegrationModuleException {
        InputStream stream = null;
        String tSAKeyStoreDir = this.propertyHandler.getProperty("KEYSTORE_DIR");
        String tSAKeyStoreFile = this.propertyHandler.getProperty(TSA_KEYSTORE_FILE);
        String keyStoreFilePath = "";
        keyStoreFilePath = StringUtils.endsWith((String)tSAKeyStoreDir, (String)"/") ? tSAKeyStoreDir + tSAKeyStoreFile : tSAKeyStoreDir + "/" + tSAKeyStoreFile;
        stream = IOUtils.getResourceAsStream(keyStoreFilePath);
        return stream;
    }

    public KeyStore getOldKeyStore() throws IntegrationModuleException {
        block6: {
            if (this.oldKeyStore == null) {
                try {
                    InputStream stream = this.getOldSystemKeystoreStream();
                    String pwd = this.getOldSystemKeystorePassword();
                    if (stream == null) break block6;
                    try {
                        this.oldKeyStore = KeyManager.getKeyStore((InputStream)stream, (String)PKCS12, (char[])pwd.toCharArray());
                    }
                    catch (IOException ex) {
                        throw new IntegrationModuleException(I18nHelper.getLabel("error.keystore.password"), ex);
                    }
                    ArrayList<String> list = Collections.list(this.oldKeyStore.aliases());
                    for (String alias : list) {
                        LOG.debug("Checking key : " + alias);
                        if (!this.oldKeyStore.isKeyEntry(alias)) continue;
                        Key key = this.oldKeyStore.getKey(alias, pwd.toCharArray());
                        Certificate[] chain = this.oldKeyStore.getCertificateChain(alias);
                        this.oldKeyStore.deleteEntry(alias);
                        this.oldKeyStore.setKeyEntry(alias, key, DEFAULT_PASSWORD, chain);
                    }
                    this.dumpKeyStore(this.oldKeyStore);
                }
                catch (Exception e) {
                    LOG.error("Invalid old keystore configuration", (Throwable)e);
                    throw new IntegrationModuleException(I18nHelper.getLabel("error.keystore"), e);
                }
            }
        }
        return this.oldKeyStore;
    }

    public String getOldSystemKeystorePath() {
        if (!StringUtils.isEmpty((String)this.oldSystemKeystorePath)) {
            return this.oldSystemKeystorePath;
        }
        if (this.propertyHandler.hasProperty(PROP_KEYSTORE_OLD_P12_FOLDER) && this.propertyHandler.hasProperty(PROP_OLD_KEYSTORE_RIZIV_KBO)) {
            String directory = this.propertyHandler.getProperty(PROP_KEYSTORE_OLD_P12_FOLDER);
            String riziv = this.propertyHandler.getProperty(PROP_OLD_KEYSTORE_RIZIV_KBO);
            List<String> files = IOUtils.getP12FileList(directory, riziv);
            return files.get(0);
        }
        if (this.propertyHandler.hasProperty(PROP_OLD_KEYSTORE_FILE)) {
            return this.propertyHandler.getProperty(PROP_OLD_KEYSTORE_FILE);
        }
        return null;
    }

    private InputStream getOldSystemKeystoreStream() throws IOException {
        String path = this.getOldSystemKeystorePath();
        return StringUtils.isBlank((String)path) ? null : IOUtils.getResourceAsStream(path);
    }

    public KeyStore getMandateOrganisationKeyStore() {
        if (this.mandateKeyStore == null) {
            try {
                InputStream stream = null;
                char[] pwd = null;
                if (!this.propertyHandler.hasProperty(PROP_KEYSTORE_MANDATE_FILE)) {
                    throw new IntegrationModuleException(I18nHelper.getLabel("error.property.not.found.keystore.file"));
                }
                stream = IOUtils.getResourceAsStream(this.propertyHandler.getProperty(PROP_KEYSTORE_MANDATE_FILE));
                if (!this.propertyHandler.hasProperty(PROP_KEYSTORE_MANDATE_PASSWORD)) {
                    throw new IntegrationModuleException(I18nHelper.getLabel("error.property.not.found.keystore.password"));
                }
                pwd = this.propertyHandler.getProperty(PROP_KEYSTORE_MANDATE_PASSWORD).toCharArray();
                this.mandateKeyStore = KeyManager.getKeyStore((InputStream)stream, (String)PKCS12, (char[])pwd);
                Enumeration<String> aliases = this.mandateKeyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    LOG.debug("Checking key : " + alias);
                    if (!this.mandateKeyStore.isKeyEntry(alias)) continue;
                    Key key = this.mandateKeyStore.getKey(alias, pwd);
                    Certificate[] chain = this.mandateKeyStore.getCertificateChain(alias);
                    this.mandateKeyStore.deleteEntry(alias);
                    this.mandateKeyStore.setKeyEntry(alias, key, DEFAULT_PASSWORD, chain);
                }
                this.dumpKeyStore(this.mandateKeyStore);
            }
            catch (Exception e) {
                LOG.error("Invalid keystore configuration", (Throwable)e);
                throw new IllegalArgumentException(I18nHelper.getLabel("error.keystore"), e);
            }
        }
        return this.mandateKeyStore;
    }

    public void clearKeystore() {
        this.keyStore = null;
    }

    public void clearOldKeystore() {
        this.oldKeyStore = null;
    }

    public void clearMandateKeystore() {
        this.mandateKeyStore = null;
    }

    private void dumpKeyStore(KeyStore keyStore) {
        try {
            LOG.debug("Current Keystore content : ================");
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                StringBuffer sb = new StringBuffer();
                sb.append("alias=" + alias + " : ");
                sb.append("isCertificateEntry=" + keyStore.isCertificateEntry(alias) + ",");
                sb.append("isKey=" + keyStore.isKeyEntry(alias) + ",");
                LOG.debug(sb.toString());
            }
            LOG.debug("========================================");
        }
        catch (KeyStoreException e) {
            LOG.error("KeyStoreException", (Throwable)e);
        }
    }

    public static String getThumbPrint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return EncryptionUtils.hexify(digest);
    }

    public static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }

    public DataSealer initSealing() throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, IOException, IntegrationModuleException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyStore.PrivateKeyEntry keyAndCerts = KeyManager.getKeyAndCertificates((KeyStore)this.getKeyStore(), (String)AUTHENTICATION_ALIAS, (char[])DEFAULT_PASSWORD);
        PrivateKey clientAuthenticationKey = keyAndCerts.getPrivateKey();
        X509Certificate clientAuthCertificate = this.getCertificate();
        LOG.debug("Encryption initialized for SubjectDN: " + clientAuthCertificate.getSubjectDN());
        LOG.debug("Encryption initialized for SerialNumber: " + clientAuthCertificate.getSerialNumber());
        LOG.debug("Encryption initialized for ThumbPrint: " + EncryptionUtils.getThumbPrint(clientAuthCertificate));
        SigningCredential signingCredential = SigningCredential.create((PrivateKey)clientAuthenticationKey, (X509Certificate[])new X509Certificate[]{clientAuthCertificate});
        DataSealer dataSealer = DataSealerBuilder.newBuilder().addOCSPPolicy(OCSPPolicy.NONE).addSigningPolicy(SigningPolicy.EHEALTH_CERT, signingCredential).addPublicKeyPolicy(EncryptionPolicy.KNOWN_RECIPIENT).addSecretKeyPolicy(EncryptionPolicy.UNKNOWN_RECIPIENT).build();
        return dataSealer;
    }

    public DataSealer initOldSealing() throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IntegrationModuleException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyStore.PrivateKeyEntry keyAndCerts = KeyManager.getKeyAndCertificates((KeyStore)this.getOldKeyStore(), (String)AUTHENTICATION_ALIAS, (char[])DEFAULT_PASSWORD);
        PrivateKey clientAuthenticationKey = keyAndCerts.getPrivateKey();
        X509Certificate clientAuthCertificate = this.getOldCertificate();
        LOG.debug("Encryption initialized for :" + clientAuthCertificate.getSubjectDN());
        SigningCredential signingCredential = SigningCredential.create((PrivateKey)clientAuthenticationKey, (X509Certificate[])new X509Certificate[]{clientAuthCertificate});
        DataSealer dataSealer = DataSealerBuilder.newBuilder().addOCSPPolicy(OCSPPolicy.NONE).addSigningPolicy(SigningPolicy.EHEALTH_CERT, signingCredential).addPublicKeyPolicy(EncryptionPolicy.KNOWN_RECIPIENT).addSecretKeyPolicy(EncryptionPolicy.UNKNOWN_RECIPIENT).build();
        return dataSealer;
    }

    public DataUnsealer initUnsealing() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IntegrationModuleException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyStore caCertificatesKeystore = KeyManager.getKeyStore((InputStream)this.getCaCertificateKeystoreIs(), (String)this.propertyHandler.getProperty(LOCAL_CA_CERTIFICATES_STORE_TYPE), (char[])this.propertyHandler.getProperty(LOCAL_CA_CERTIFICATES_STORE_PASSWORD).toCharArray());
        Map clientDecryptionKeys = KeyManager.getDecryptionKeys((KeyStore)this.getKeyStore(), (char[])DEFAULT_PASSWORD);
        for (String key : clientDecryptionKeys.keySet()) {
            LOG.debug("Key Available for decryption : " + key);
        }
        DataUnsealer dataUnsealer = DataUnsealerBuilder.newBuilder().addOCSPPolicy(OCSPPolicy.NONE).addSigningPolicy(caCertificatesKeystore, new SigningPolicy[]{SigningPolicy.EHEALTH_CERT, SigningPolicy.EID}).addPublicKeyPolicy(EncryptionPolicy.KNOWN_RECIPIENT, EncryptionCredentials.from((Map)clientDecryptionKeys)).build();
        return dataUnsealer;
    }

    public DataUnsealer initOldUnSealing() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, IntegrationModuleException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyStore caCertificatesKeystore = KeyManager.getKeyStore((InputStream)this.getCaCertificateKeystoreIs(), (String)this.propertyHandler.getProperty(LOCAL_CA_CERTIFICATES_STORE_TYPE), (char[])this.propertyHandler.getProperty(LOCAL_CA_CERTIFICATES_STORE_PASSWORD).toCharArray());
        Map clientDecryptionKeys = KeyManager.getDecryptionKeys((KeyStore)this.getOldKeyStore(), (char[])DEFAULT_PASSWORD);
        for (String key : clientDecryptionKeys.keySet()) {
            LOG.debug("Key Available for decryption : " + key);
        }
        DataUnsealer dataUnsealer = DataUnsealerBuilder.newBuilder().addOCSPPolicy(OCSPPolicy.NONE).addSigningPolicy(caCertificatesKeystore, new SigningPolicy[]{SigningPolicy.EHEALTH_CERT, SigningPolicy.EID}).addPublicKeyPolicy(EncryptionPolicy.KNOWN_RECIPIENT, EncryptionCredentials.from((Map)clientDecryptionKeys)).build();
        return dataUnsealer;
    }

    public void unlockPersonalKey(String niss, String pwd) throws IntegrationModuleException {
        String file = null;
        if (StringUtils.isEmpty((String)pwd)) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.personal.keystore.password.null"));
        }
        if (this.propertyHandler.hasProperty(PERSONAL_KEYSTORE)) {
            file = this.propertyHandler.getProperty(PERSONAL_KEYSTORE);
        } else {
            if (!this.propertyHandler.hasProperty("KEYSTORE_DIR")) {
                LOG.error("Undefined property KEYSTORE_DIR");
                throw new IntegrationModuleException(I18nHelper.getLabel("error.property.not.found.personal.keystore"));
            }
            List<String> files = IOUtils.getP12FileList(this.propertyHandler.getProperty("KEYSTORE_DIR"), niss);
            if (files.size() == 0) {
                LOG.error("No P12 file found marching pattern '*" + niss + "*.p12' in folder " + this.propertyHandler.getProperty("KEYSTORE_DIR"));
                throw new IntegrationModuleException(I18nHelper.getLabel("error.property.not.found.personal.keystore.pattern", new Object[]{niss}));
            }
            if (files.size() > 1) {
                LOG.error("Too many files matching pattern '*" + niss + "*.p12', please clean folder : " + this.propertyHandler.getProperty("KEYSTORE_DIR"));
                throw new IntegrationModuleException(I18nHelper.getLabel("error.property.found.to.much.keystores"));
            }
            file = files.get(0);
        }
        try {
            InputStream stream = IOUtils.getResourceAsStream(file);
            KeyStore personalKeyStore = KeyManager.getKeyStore((InputStream)stream, (String)PKCS12, (char[])pwd.toCharArray());
            X509Certificate certificate = (X509Certificate)personalKeyStore.getCertificate(AUTHENTICATION_ALIAS);
            if (certificate != null) {
                try {
                    certificate.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    throw new IntegrationModuleException(I18nHelper.getLabel("error.expired.personal.certificate"), e);
                }
                catch (CertificateNotYetValidException e) {
                    throw new IntegrationModuleException(I18nHelper.getLabel("error.invalid.personal.certificate"), e);
                }
            } else {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.notfound.personal.certificate"));
            }
            Enumeration<String> aliases = personalKeyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                LOG.debug("Importing : " + alias);
                Certificate[] chain = personalKeyStore.getCertificateChain(alias);
                Key key = personalKeyStore.getKey(alias, pwd.toCharArray());
                if (key == null) continue;
                String tAlias = AUTHENTICATION_ALIAS.equals(alias) ? AUTHENTICATION_FALLBACK_ALIAS : alias;
                this.getKeyStore().setKeyEntry(tAlias, key, DEFAULT_PASSWORD, chain);
            }
        }
        catch (IOException e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.password"), e);
        }
        catch (KeyStoreException e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.keystore.fallback "), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.keystore.fallback "), e);
        }
        catch (CertificateException e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.keystore.fallback "), e);
        }
        catch (UnrecoverableKeyException e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.keystore.fallback "), e);
        }
    }

    public byte[] unsealingData(CryptoResult<UnsealedData> rslt) throws IOException {
        byte[] unsealedData = null;
        if (rslt.hasData()) {
            if (!rslt.hasErrors()) {
                LOG.debug("from author: " + ((UnsealedData)rslt.getData()).getAuthenticationCert().getSubjectDN());
                InputStream unsealedDataStream = ((UnsealedData)rslt.getData()).getContent();
                unsealedData = IOUtils.getBytes(unsealedDataStream);
                LOG.debug("unsealed data: " + new String(unsealedData));
            } else {
                for (NotificationError error : rslt.getErrors()) {
                    LOG.error("error: " + error);
                }
                for (NotificationWarning warning : rslt.getWarnings()) {
                    LOG.warn("failure: " + warning);
                }
                if (rslt.getFatal() != null) {
                    LOG.error("Fatal: " + rslt.getFatal().getErrorMessage());
                }
                InputStream unsealedDataStream = ((UnsealedData)rslt.getData()).getContent();
                unsealedData = IOUtils.getBytes(unsealedDataStream);
                LOG.debug("unsealed data: " + new String(unsealedData));
                if (!rslt.getErrors().contains(NotificationError.INNER_CERTIFICATE_EXPECTED_BUT_NOT_PRESENT)) {
                    LOG.debug("author certificate: " + ((UnsealedData)rslt.getData()).getAuthenticationCert());
                }
            }
        } else {
            LOG.debug("the msg could not be unsealed, because:" + rslt.getFatal());
        }
        return unsealedData;
    }

    private InputStream getCaCertificateKeystoreIs() throws IntegrationModuleException {
        try {
            return IOUtils.getResourceAsStream(this.getCaCertificateKeystoreLocation());
        }
        catch (IOException e) {
            throw new IntegrationModuleException("error.loading.cakeystore", e);
        }
    }

    private String getCaCertificateKeystoreLocation() {
        if (this.caCertificateKeystoreLocation == null) {
            this.caCertificateKeystoreLocation = this.propertyHandler.getProperty("KEYSTORE_DIR") + this.propertyHandler.getProperty(LOCAL_CA_CERTIFICATES_STORE_FILE);
        }
        return this.caCertificateKeystoreLocation;
    }

    private String getCaCertificateKeystorePwd() throws IntegrationModuleException {
        if (this.propertyHandler.hasProperty(LOCAL_CA_CERTIFICATES_STORE_PASSWORD)) {
            return this.propertyHandler.getProperty(LOCAL_CA_CERTIFICATES_STORE_PASSWORD);
        }
        throw new IntegrationModuleException(I18nHelper.getLabel("error.property.not.found.keystore.password"));
    }

    public KeyStore loadCaKeystore() throws IntegrationModuleException {
        return this.loadKeyStore(this.getCaCertificateKeystoreIs(), this.getCaCertificateKeystorePwd().toCharArray());
    }

    public KeyStore loadKeyStore(InputStream stream, char[] pwd) throws IntegrationModuleException {
        KeyStore keyStore = null;
        try {
            keyStore = KeyManager.getKeyStore((InputStream)stream, (String)"JKS", (char[])pwd);
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof BadPaddingException) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.keystore.password"), ex);
            }
            throw new IntegrationModuleException(I18nHelper.getLabel("error.corrupt.system.certificate"), ex);
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
        }
        return keyStore;
    }

    public X509Certificate getCertificate() throws IntegrationModuleException {
        try {
            return (X509Certificate)this.getKeyStore().getCertificate(AUTHENTICATION_ALIAS);
        }
        catch (KeyStoreException e) {
            LOG.error("KeyStoreException", (Throwable)e);
            return null;
        }
    }

    public X509Certificate getOldCertificate() throws IntegrationModuleException {
        try {
            return (X509Certificate)this.getOldKeyStore().getCertificate(AUTHENTICATION_ALIAS);
        }
        catch (KeyStoreException e) {
            LOG.error("KeyStoreException", (Throwable)e);
            return null;
        }
    }

    private PrivateKey getPrivateKey(KeyStore key, String privateKeyAlias, char[] privateKeyPassword) {
        try {
            KeyStore.PrivateKeyEntry keyAndCerts = KeyManager.getKeyAndCertificates((KeyStore)key, (String)privateKeyAlias, (char[])privateKeyPassword);
            return keyAndCerts.getPrivateKey();
        }
        catch (UnrecoverableKeyException e) {
            LOG.error("UnrecoverableKeyException", (Throwable)e);
            return null;
        }
    }

    private PublicKey getPublicKey(KeyStore key, String privateKeyAlias, char[] privateKeyPassword) {
        try {
            KeyStore.PrivateKeyEntry keyAndCerts = KeyManager.getKeyAndCertificates((KeyStore)key, (String)privateKeyAlias, (char[])privateKeyPassword);
            return keyAndCerts.getCertificate().getPublicKey();
        }
        catch (UnrecoverableKeyException e) {
            LOG.error("UnrecoverableKeyException", (Throwable)e);
            return null;
        }
    }

    public PrivateKey getPrivateKey() throws IntegrationModuleException {
        return this.getPrivateKey(this.getKeyStore(), AUTHENTICATION_ALIAS, DEFAULT_PASSWORD);
    }

    public PrivateKey getOldPrivateKey() throws IntegrationModuleException {
        return this.getPrivateKey(this.getOldKeyStore(), AUTHENTICATION_ALIAS, DEFAULT_PASSWORD);
    }

    public PublicKey getPublicKey() throws IntegrationModuleException {
        return this.getPublicKey(this.getKeyStore(), AUTHENTICATION_ALIAS, DEFAULT_PASSWORD);
    }

    public PublicKey getOldPublicKey() throws IntegrationModuleException {
        return this.getPublicKey(this.getOldKeyStore(), AUTHENTICATION_ALIAS, DEFAULT_PASSWORD);
    }

    public PrivateKey getMandatePrivateKey() {
        return this.getPrivateKey(this.getMandateOrganisationKeyStore(), AUTHENTICATION_ALIAS, DEFAULT_PASSWORD);
    }

    public PublicKey getMandatePublicKey() {
        return this.getPublicKey(this.getMandateOrganisationKeyStore(), AUTHENTICATION_ALIAS, DEFAULT_PASSWORD);
    }

    public PrivateKey getFallbackPrivateKey() throws IntegrationModuleException {
        return this.getPrivateKey(this.getKeyStore(), AUTHENTICATION_FALLBACK_ALIAS, DEFAULT_PASSWORD);
    }

    public PublicKey getFallbackPublicKey() throws IntegrationModuleException {
        return this.getPublicKey(this.getKeyStore(), AUTHENTICATION_FALLBACK_ALIAS, DEFAULT_PASSWORD);
    }

    public X509Certificate getFallbackCertificate() throws IntegrationModuleException {
        try {
            return (X509Certificate)this.getKeyStore().getCertificate(AUTHENTICATION_FALLBACK_ALIAS);
        }
        catch (KeyStoreException e) {
            LOG.error("KeyStoreException", (Throwable)e);
            return null;
        }
    }

    public X509Certificate getMandateCertificate() {
        try {
            return (X509Certificate)this.getMandateOrganisationKeyStore().getCertificate(AUTHENTICATION_ALIAS);
        }
        catch (KeyStoreException e) {
            LOG.error("KeyStoreException", (Throwable)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public void verifyDecryption(EncryptionToken myETK) throws IntegrationModuleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setSystemKeystorePassword(String systemKeystorePassword) {
        if (StringUtils.isNotBlank((String)systemKeystorePassword)) {
            this.propertyHandler.getProperties().put(PROP_KEYSTORE_PASSWORD, systemKeystorePassword);
        }
    }

    public String getSystemKeystorePassword() throws IntegrationModuleException {
        if (this.propertyHandler.hasProperty(PROP_KEYSTORE_PASSWORD)) {
            return this.propertyHandler.getProperty(PROP_KEYSTORE_PASSWORD);
        }
        throw new IntegrationModuleException(I18nHelper.getLabel("error.property.not.found.keystore.password"));
    }

    public void setSystemKeystorePath(String systemKeystorePath) {
        if (StringUtils.isNotBlank((String)systemKeystorePath)) {
            this.systemKeystorePath = systemKeystorePath;
        }
    }

    public void setSystemKeystoreDirectory(String systemKeystoreDirectory) {
        if (StringUtils.isNotBlank((String)systemKeystoreDirectory)) {
            this.propertyHandler.getProperties().put("KEYSTORE_DIR", systemKeystoreDirectory);
        }
    }

    public void setSystemKeystoreRiziv(String systemKeystoreRiziv) {
        if (StringUtils.isNotBlank((String)systemKeystoreRiziv)) {
            this.propertyHandler.getProperties().put(PROP_KEYSTORE_RIZIV_KBO, systemKeystoreRiziv);
        }
    }

    public void setOldSystemKeystorePath(String oldSystemKeystorePath) {
        if (StringUtils.isNotBlank((String)oldSystemKeystorePath)) {
            this.oldSystemKeystorePath = oldSystemKeystorePath;
        }
    }

    public void setOldSystemKeystorePassword(String oldSystemKeystorePassword) {
        if (StringUtils.isNotBlank((String)oldSystemKeystorePassword)) {
            this.propertyHandler.setProperty(PROP_OLD_KEYSTORE_PASSWORD, oldSystemKeystorePassword);
        }
    }

    public String getOldSystemKeystorePassword() {
        return this.propertyHandler.getProperty(PROP_OLD_KEYSTORE_PASSWORD);
    }

    public void setOldSystemKeystoreDirectory(String oldSystemKeystoreDirectory) {
        if (StringUtils.isNotBlank((String)oldSystemKeystoreDirectory)) {
            this.propertyHandler.getProperties().put(PROP_KEYSTORE_OLD_P12_FOLDER, oldSystemKeystoreDirectory);
        }
    }

    public String getOldSystemKeystoreDirectory() {
        return this.propertyHandler.getProperty(PROP_KEYSTORE_OLD_P12_FOLDER);
    }

    public void setOldSystemKeystoreRiziv(String oldSystemKeystoreRiziv) {
        if (StringUtils.isNotBlank((String)oldSystemKeystoreRiziv)) {
            this.propertyHandler.getProperties().put(PROP_OLD_KEYSTORE_RIZIV_KBO, oldSystemKeystoreRiziv);
        }
    }

    public String getOldSystemKeystoreRiziv() {
        return this.propertyHandler.getProperty(PROP_OLD_KEYSTORE_RIZIV_KBO);
    }

    public byte[] queueEncrypt(byte[] data, PublicKey publicKey) throws IntegrationModuleException {
        String s = new String(data);
        s = s + "ENCRYPTI0NS1GNATURE";
        data = s.getBytes();
        try {
            String key = publicKey.toString().substring(0, 16);
            SecretKeySpec symKey = new SecretKeySpec(key.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            int rest = 0;
            int length = 0;
            byte[] newbuf = null;
            if (cipher.getBlockSize() > 0) {
                rest = data.length % cipher.getBlockSize();
                length = data.length + (cipher.getBlockSize() - rest);
                newbuf = new byte[length];
                System.arraycopy(data, 0, newbuf, 0, data.length);
            } else {
                newbuf = new byte[data.length];
                System.arraycopy(data, 0, newbuf, 0, data.length);
            }
            cipher.init(1, symKey);
            byte[] cipherData = cipher.doFinal(newbuf);
            return Base64.encode((byte[])cipherData);
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    public String queueDecrypt(byte[] data, PublicKey publicKey) throws IntegrationModuleException {
        try {
            LOG.debug("**************** SIZE BYTES ********** " + data.length);
            byte[] decodeData = Base64.decode((byte[])data);
            String key = publicKey.toString().substring(0, 16);
            SecretKeySpec symKey = new SecretKeySpec(key.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, symKey);
            byte[] cipherData = cipher.doFinal(decodeData);
            LOG.debug("************** cipherData ************* " + Arrays.toString(cipherData));
            String s = new String(cipherData);
            LOG.debug("******************** GOING OUT: " + s + " **********************");
            int i = s.lastIndexOf("ENCRYPTI0NS1GNATURE");
            s = s.substring(0, i);
            LOG.debug("******************** GOING OUT SUBSTRING2: " + s + " **********************");
            return s;
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }
}

