/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ClasspathLSResourceResolver
implements LSResourceResolver {
    private final Map<String, String> fileMapping;

    public ClasspathLSResourceResolver(Map<String, String> fileMapping) {
        this.fileMapping = fileMapping;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        return new ClasspathLSInput(publicId, systemId, ClasspathLSResourceResolver.class.getResourceAsStream(this.getResource(namespaceURI)));
    }

    private String getResource(String namespace) {
        if (this.fileMapping.containsKey(namespace)) {
            return this.fileMapping.get(namespace);
        }
        throw new IllegalStateException("No mapping found for " + namespace);
    }

    public static class ClasspathLSInput
    implements LSInput {
        private final String publicId;
        private final String systemId;
        private final InputStream inputStream;

        public ClasspathLSInput(String publicId, String systemId, InputStream inputStream) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.inputStream = inputStream;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public InputStream getByteStream() {
            return this.inputStream;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getEncoding() {
            return StandardCharsets.UTF_8.toString();
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }
    }
}

