/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.services;

import be.apb.gfddpp.common.utils.JaxContextCentralizer;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.handlers.InsurabilityHandler;
import be.business.connector.core.handlers.LoggingHandler;
import be.business.connector.core.handlers.MustUnderstandHandler;
import be.business.connector.core.handlers.SoapFaultHandler;
import be.business.connector.core.services.GenericWebserviceRequest;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.core.utils.SessionValidator;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.ehealth.technicalconnector.ws.GenericWsSender;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import be.ehealth.technicalconnector.ws.impl.GenericWsSenderImpl;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericWebserviceCaller {
    private static final Logger LOG = LoggerFactory.getLogger(GenericWebserviceCaller.class);
    private static GenericWsSender sender = new GenericWsSenderImpl();

    public static <T> T callGenericWebservice(Object request, Class<?> requestType, Class<T> responseType, String endpoint, String serviceName, boolean addLoggingHandler, boolean addSoapFaultHandler, boolean addMustUnderstandHandler, boolean addInsurabilityHandler) throws IntegrationModuleException {
        GenericWebserviceRequest genericWebserviceRequest = new GenericWebserviceRequest();
        genericWebserviceRequest.setRequest(request);
        genericWebserviceRequest.setRequestType(requestType);
        genericWebserviceRequest.setEndpoint(endpoint);
        genericWebserviceRequest.setServiceName(serviceName);
        genericWebserviceRequest.setAddLoggingHandler(addLoggingHandler);
        genericWebserviceRequest.setAddSoapFaultHandler(addSoapFaultHandler);
        genericWebserviceRequest.setAddMustUnderstandHandler(addMustUnderstandHandler);
        genericWebserviceRequest.setAddInsurabilityHandler(addInsurabilityHandler);
        return GenericWebserviceCaller.callGenericWebservice(genericWebserviceRequest, responseType);
    }

    public static <T> T callGenericWebservice(Object request, Class<T> responseType, String endpointName, String serviceName, boolean addLoggingHandler, boolean addSoapFaultHandler, boolean addMustUnderstandHandler, boolean addInsurabilityHandler, String soapAction) {
        GenericWebserviceRequest genericWebserviceRequest = new GenericWebserviceRequest();
        genericWebserviceRequest.setRequest(request);
        genericWebserviceRequest.setRequestType(request.getClass());
        genericWebserviceRequest.setEndpoint(endpointName);
        genericWebserviceRequest.setServiceName(serviceName);
        genericWebserviceRequest.setAddLoggingHandler(addLoggingHandler);
        genericWebserviceRequest.setAddSoapFaultHandler(addSoapFaultHandler);
        genericWebserviceRequest.setAddMustUnderstandHandler(addMustUnderstandHandler);
        genericWebserviceRequest.setAddInsurabilityHandler(addInsurabilityHandler);
        genericWebserviceRequest.setSoapAction(soapAction);
        return GenericWebserviceCaller.callGenericWebservice(genericWebserviceRequest, responseType);
    }

    public static <T> T callGenericWebservice(GenericWebserviceRequest genericWebserviceRequest, Class<T> responseType) throws IntegrationModuleException {
        Validate.notNull((Object)genericWebserviceRequest, (String)"genericWebserviceRequest must be specified", (Object[])new Object[0]);
        Validate.notNull((Object)genericWebserviceRequest.getRequest(), (String)"request must be specified", (Object[])new Object[0]);
        Validate.notNull((Object)genericWebserviceRequest.getEndpoint(), (String)"endpoint must be specified", (Object[])new Object[0]);
        String serviceName = StringUtils.defaultString((String)genericWebserviceRequest.getServiceName());
        try {
            GenericRequest genericRequest = new GenericRequest();
            genericRequest.setPayload(genericWebserviceRequest.getRequest());
            genericRequest.setEndpoint(genericWebserviceRequest.getEndpoint());
            genericRequest.setSoapAction(genericWebserviceRequest.getSoapAction());
            HandlerChain handlerChain = new HandlerChain();
            if (genericWebserviceRequest.isAddLoggingHandler()) {
                LOG.info("LoggingHandler will be added");
                handlerChain.register(HandlerPosition.AFTER, (SOAPHandler)new LoggingHandler());
            }
            if (genericWebserviceRequest.isAddSoapFaultHandler()) {
                LOG.info("SoapFaultHandler will be added");
                handlerChain.register(HandlerPosition.AFTER, (SOAPHandler)new SoapFaultHandler());
            }
            if (genericWebserviceRequest.isAddMustUnderstandHandler()) {
                for (String property : PropertyHandler.getInstance().getMatchingProperties("connector.defaulthandlerchain.aftersecurity")) {
                    if (!property.contains("MustUnderstandHandler")) continue;
                    LOG.info("MustUnderstandHandler will be added");
                    handlerChain.register(HandlerPosition.AFTER, (SOAPHandler)new MustUnderstandHandler());
                }
            }
            if (genericWebserviceRequest.isAddInsurabilityHandler()) {
                LOG.info("InsurabilityHandler will be added");
                handlerChain.register(HandlerPosition.AFTER, (SOAPHandler)new InsurabilityHandler());
            }
            genericRequest.addHandlerChain(handlerChain);
            SessionItem sessionItem = Session.getInstance().getSession();
            SessionValidator.assertValidSession(sessionItem);
            genericRequest.setSamlSecured(sessionItem.getSAMLToken().getAssertion(), sessionItem.getHolderOfKeyCredential());
            GenericResponse resp = sender.send(genericRequest);
            LOG.info(serviceName + "GenericWebservice received a response from service with endpoint:" + genericWebserviceRequest.getEndpoint());
            T response = JaxContextCentralizer.getInstance().toObject(responseType, resp.asString());
            return response;
        }
        catch (ConnectorException | SOAPException e) {
            LOG.error(String.format("%s generic webservice", e.getClass().getSimpleName()), e);
            String eHealthMessage = e.getLocalizedMessage();
            if (e.getCause() != null && StringUtils.isNotEmpty((CharSequence)e.getCause().getLocalizedMessage())) {
                eHealthMessage = eHealthMessage + " \nCause is: " + e.getCause().getLocalizedMessage();
            }
            throw new IntegrationModuleException(I18nHelper.getLabel("technical.connector.error.generic.webserive", new Object[]{serviceName, eHealthMessage}), e);
        }
        catch (Exception e) {
            LOG.error("Error generic webservice", (Throwable)e);
            throw new IntegrationModuleException(e);
        }
    }
}

