/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.common.module;

import be.apb.gfddpp.common.utils.JaxContextCentralizer;
import be.business.connector.common.ApplicationConfig;
import be.business.connector.core.ehealth.services.KgssService;
import be.business.connector.core.ehealth.services.KgssServiceImpl;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.technical.connector.utils.Crypto;
import be.business.connector.core.utils.ETKHelper;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.Exceptionutils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.MapNamespaceContext;
import be.business.connector.core.utils.MarshallerHelper;
import be.business.connector.core.utils.MessageDumper;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.core.utils.Qualities;
import be.business.connector.core.utils.STSHelper;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.ehealth.technicalconnector.utils.ConnectorCryptoUtils;
import be.fgov.ehealth.etee.crypto.decrypt.DataUnsealer;
import be.fgov.ehealth.etee.crypto.decrypt.UnsealedData;
import be.fgov.ehealth.etee.crypto.encrypt.DataSealer;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import be.fgov.ehealth.etee.crypto.status.CryptoResultException;
import be.fgov.ehealth.etee.crypto.status.NotificationError;
import be.fgov.ehealth.etee.crypto.status.NotificationWarning;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetKeyRequestContent;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetKeyResponseContent;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilder;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationError;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import be.recipe.services.core.Page;
import be.recipe.services.core.PageFactory;
import be.recipe.services.executor.ArchiveStandard;
import be.recipe.services.executor.GetPrescriptionForExecutorResultSealed;
import be.recipe.services.executor.ID;
import be.recipe.services.executor.MessageText;
import be.recipe.services.executor.Properties;
import be.recipe.services.executor.Property;
import be.recipe.services.executor.RuleId;
import be.recipe.services.executor.RuleMessage;
import be.recipe.services.executor.TimestampedPrescription;
import be.recipe.services.executor.ValidationWarning;
import be.recipe.services.executor.ValidationWarnings;
import be.recipe.services.patient.GetPrescriptionForPatientResultSealed;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.bc.BcRSASignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.bouncycastle.util.encoders.Base64;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractIntegrationModule {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIntegrationModule.class);
    private static final String VERSION_1 = "v1";
    private static final String VERSION_2 = "v2";
    public static final String EHEALTH_SUCCESS_CODE_100 = "100";
    public static final String EHEALTH_SUCCESS_CODE_200 = "200";
    public static final String EHEALTH_SUCCESS_CODE_300 = "300";
    public static final String EHEALTH_SUCCESS_CODE_400 = "400";
    public static final String EHEALTH_SUCCESS_CODE_500 = "500";
    protected DataUnsealer dataUnsealer = null;
    private DataSealer oldDataSealer = null;
    private DataUnsealer oldDataUnsealer = null;
    private ETKHelper etkHelper;
    private Key symmKey = null;
    private final KgssService kgssService = KgssServiceImpl.getInstance();

    public AbstractIntegrationModule() {
        ApplicationConfig.getInstance().assertInitialized();
        this.init();
    }

    protected void init() {
        try {
            LOG.info("Init abstractIntegrationModule!");
            this.getJaxContextCentralizer().addContext(GetKeyRequestContent.class);
            this.getJaxContextCentralizer().addContext(GetKeyResponseContent.class);
            Security.addProvider((Provider)new BouncyCastleProvider());
            MessageDumper.getInstance().init(this.getPropertyHandler());
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            System.setProperty("javax.xml.soap.SOAPFactory", "com.sun.xml.messaging.saaj.soap.ver1_1.SOAPFactory1_1Impl");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Curdir : " + new File(".").getCanonicalPath());
                LOG.debug("Support P12 keystores : " + KeyStore.getInstance("PKCS12"));
            }
            this.initEncryption();
            LOG.info("End Init abstractIntegrationModule!");
        }
        catch (Throwable t) {
            LOG.error("Exception in init abstractIntegrationModule: ", t);
            Exceptionutils.errorHandler(t);
        }
    }

    public void initEncryption() {
        try {
            LOG.info("Init the encryption - create symmKey");
            this.symmKey = this.getEncryptionUtils().generateSecretKey();
            if (this.getEncryptionUtils().getOldKeyStore() != null) {
                this.oldDataSealer = this.getEncryptionUtils().initOldSealing();
                this.oldDataUnsealer = this.getEncryptionUtils().initOldUnSealing();
            }
            LOG.info("Init the encryption - init etkHelper");
            this.etkHelper = new ETKHelper(this.getPropertyHandler(), this.getEncryptionUtils());
        }
        catch (Exception t) {
            Exceptionutils.errorHandler(t, "error.initialization");
        }
    }

    @Profiled(logFailuresSeparately=true, tag="0.AbstractIntegrationModule#sealRequest", logger="org.perf4j.TimingLogger_Common")
    public synchronized byte[] sealRequest(EncryptionToken paramEncryptionToken, byte[] paramArrayOfByte) {
        return new Crypto().seal(paramEncryptionToken, paramArrayOfByte);
    }

    @Profiled(logFailuresSeparately=true, tag="0.AbstractIntegrationModule#unsealRequest", logger="org.perf4j.TimingLogger_Common")
    protected byte[] unsealRequest(byte[] message) {
        return new Crypto().unseal(message);
    }

    protected byte[] unsealNotif(byte[] message) {
        return new Crypto().unseal(message);
    }

    protected byte[] unsealNotifOld(byte[] message) {
        CryptoResult result = this.getOldDataUnsealer().unseal(message);
        if (result != null && result.hasData()) {
            if (result.hasErrors()) {
                for (NotificationError error : result.getErrors()) {
                    LOG.error(error.name());
                }
                for (NotificationWarning warning : result.getWarnings()) {
                    LOG.error(warning.name());
                }
                if (result.getFatal() != null) {
                    LOG.error(result.getFatal().getErrorMessage());
                }
            }
            return be.business.connector.core.utils.IOUtils.getBytes(((UnsealedData)result.getData()).getContent());
        }
        return null;
    }

    protected byte[] unsealNotiffeed(byte[] message) {
        byte[] unsealedNotification = null;
        boolean calledUnsealNotifOld = false;
        try {
            LOG.debug("Start unseal notification: " + IOUtils.toString((byte[])message, (String)"UTF-8"));
            unsealedNotification = new Crypto().unseal(message);
            if (unsealedNotification != null) {
                return unsealedNotification;
            }
            if (this.getOldDataUnsealer() != null) {
                LOG.debug("Unseal notification was null. Start unseal notification with old keystore: " + Arrays.toString(message));
                calledUnsealNotifOld = true;
                unsealedNotification = this.unsealNotifOld(message);
                if (unsealedNotification != null) {
                    return this.unsealNotifOld(message);
                }
            } else {
                LOG.debug("OldDataUnsealer is null.");
            }
        }
        catch (Throwable t) {
            LOG.error("Exception occured with unsealing notification: ", t);
            if (calledUnsealNotifOld) {
                if (t instanceof CryptoResultException && t.getMessage().contains("There is no data available")) {
                    return null;
                }
                Exceptionutils.errorHandler(t, "error.data.unseal");
            }
            try {
                LOG.debug("Exception occured with unsealing notification. Trying to unseal notification with old keystore: " + Arrays.toString(message));
                unsealedNotification = this.unsealNotifOld(message);
            }
            catch (Throwable te) {
                if (t instanceof CryptoResultException && t.getMessage().contains("There is no data available")) {
                    return null;
                }
                Exceptionutils.errorHandler(te, "error.data.unseal");
            }
        }
        if (unsealedNotification == null) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.data.unseal"));
        }
        return unsealedNotification;
    }

    @Profiled(logFailuresSeparately=true, tag="0.AbstractIntegrationModule#unsealPrescriptionForUnknown", logger="org.perf4j.TimingLogger_Common")
    protected byte[] unsealPrescriptionForUnknown(KeyResult key, byte[] protectedMessage) {
        return new Crypto().unsealForUnknown(key, protectedMessage);
    }

    protected byte[] unsealForUnknown(KeyResult key, byte[] protectedMessage) {
        return new Crypto().unsealForUnknown(key, protectedMessage);
    }

    protected KeyResult getKeyFromKgss(String keyId) {
        return this.getKeyFromKgss(keyId, null);
    }

    @Profiled(logFailuresSeparately=true, tag="0.AbstractIntegrationModule#getKeyFromKgss", logger="org.perf4j.TimingLogger_Common")
    public KeyResult getKeyFromKgss(String keyId, byte[] myEtk) {
        KeyResult keyResult = null;
        try {
            if (this.getPropertyHandler().hasProperty("test_kgss_key")) {
                String part1 = this.getPropertyHandler().getProperty("test_kgss_key").split(";")[0];
                String part2 = this.getPropertyHandler().getProperty("test_kgss_key").split(";")[1];
                byte[] keyResponse = Base64.decode((String)part2);
                return new KeyResult((SecretKey)new SecretKeySpec(keyResponse, "AES"), part1);
            }
            keyResult = this.kgssService.retrieveKeyFromKgss(keyId.getBytes(), myEtk, this.etkHelper.getKGSS_ETK().get(0).getEncoded());
        }
        catch (Throwable t) {
            LOG.error("Exception in getKeyFromKgss abstractIntegrationModule: ", t);
            Exceptionutils.errorHandler(t);
        }
        return keyResult;
    }

    public Key getSymmKey() {
        return this.symmKey;
    }

    public EncryptionUtils getEncryptionUtils() {
        return EncryptionUtils.getInstance();
    }

    public PropertyHandler getPropertyHandler() {
        return PropertyHandler.getInstance();
    }

    public void setOldDataUnsealer(DataUnsealer oldDataUnsealer) {
        this.oldDataUnsealer = oldDataUnsealer;
    }

    public DataUnsealer getOldDataUnsealer() {
        return this.oldDataUnsealer;
    }

    public void setOldDataSealer(DataSealer oldDataSealer) {
        this.oldDataSealer = oldDataSealer;
    }

    public DataSealer getOldDataSealer() {
        return this.oldDataSealer;
    }

    public ETKHelper getEtkHelper() {
        return this.etkHelper;
    }

    public void setDataUnsealer(DataUnsealer dataUnsealer) {
        this.dataUnsealer = dataUnsealer;
    }

    public JaxContextCentralizer getJaxContextCentralizer() {
        return JaxContextCentralizer.getInstance();
    }

    public byte[] unsealWithSymKey(GetPrescriptionForExecutorResultSealed result, KeyResult key, String identifier, String type) {
        try {
            byte[] sealedPrescription;
            String timestampedPrescriptionVersion = VERSION_2;
            TimestampedPrescription tp = null;
            try {
                MarshallerHelper<TimestampedPrescription, TimestampedPrescription> helper = new MarshallerHelper<TimestampedPrescription, TimestampedPrescription>(TimestampedPrescription.class, TimestampedPrescription.class);
                tp = helper.unmarsh(result.getPrescription());
                sealedPrescription = tp.getPrescriptionWithSecurityToken().getPrescriptionSealed();
            }
            catch (Exception ex) {
                LOG.debug("Prescription is version 1: ", (Throwable)ex);
                timestampedPrescriptionVersion = VERSION_1;
                sealedPrescription = result.getPrescription();
            }
            byte[] unsealedPrescription = this.unsealPrescriptionForUnknown(key, sealedPrescription);
            unsealedPrescription = be.business.connector.core.utils.IOUtils.decompress(unsealedPrescription);
            this.archivePrescription(unsealedPrescription, result, sealedPrescription, timestampedPrescriptionVersion, tp, key, identifier, type);
            return unsealedPrescription;
        }
        catch (TechnicalConnectorException | IOException | XPathExpressionException ex) {
            Exceptionutils.errorHandler(ex, "error.data.uncompression");
            return null;
        }
    }

    protected byte[] unsealWithSymKey(GetPrescriptionForPatientResultSealed result, KeyResult key, String identifier, String type) {
        try {
            byte[] sealedPrescription;
            TimestampedPrescription tp = null;
            try {
                MarshallerHelper<TimestampedPrescription, TimestampedPrescription> helper = new MarshallerHelper<TimestampedPrescription, TimestampedPrescription>(TimestampedPrescription.class, TimestampedPrescription.class);
                tp = helper.unmarsh(result.getPrescription());
                sealedPrescription = tp.getPrescriptionWithSecurityToken().getPrescriptionSealed();
            }
            catch (Exception ex) {
                LOG.debug("Prescription is version 1: ", (Throwable)ex);
                sealedPrescription = result.getPrescription();
            }
            byte[] unsealedPrescription = this.unsealPrescriptionForUnknown(key, sealedPrescription);
            unsealedPrescription = be.business.connector.core.utils.IOUtils.decompress(unsealedPrescription);
            return unsealedPrescription;
        }
        catch (IOException ex) {
            Exceptionutils.errorHandler(ex, "error.data.uncompression");
            return null;
        }
    }

    private void archivePrescription(byte[] unsealedPrescription, GetPrescriptionForExecutorResultSealed result, byte[] sealedPrescription, String timestampedPrescriptionVersion, TimestampedPrescription tp, KeyResult key, String identifier, String type) throws IOException, TechnicalConnectorException, XPathExpressionException {
        boolean archivePrescription = Boolean.parseBoolean(this.getPropertyHandler().getProperty("ArchivePrescription-xml", "false"));
        ID prescriberFromKmehr = this.getPrescriberIdFromKmehr(new ByteArrayInputStream(unsealedPrescription));
        ArchiveStandard archiveStandard = new ArchiveStandard();
        LOG.debug("To archive prescription: " + new String(unsealedPrescription, StandardCharsets.UTF_8));
        if (Boolean.parseBoolean(this.getPropertyHandler().getProperty("validate.befor.archiving", "true"))) {
            this.validatePrescriber(tp, archiveStandard, prescriberFromKmehr);
            if (VERSION_2.equalsIgnoreCase(timestampedPrescriptionVersion)) {
                this.validateXadesT(result, archiveStandard, SignatureVerificationError.CERTIFICATE_CHAIN_COULD_NOT_BE_VERIFIED, SignatureVerificationError.XADES_SIGNEDPROPS_INVALID_SIGNINGTIME);
            } else {
                this.validateTimeStamping(result, archiveStandard);
            }
        }
        if (archivePrescription) {
            String archivingPath = this.getArchivedFilePath(result.getRid());
            archiveStandard = this.getArchiveStandard(result, unsealedPrescription, sealedPrescription, timestampedPrescriptionVersion, tp, key, identifier, type, prescriberFromKmehr, archiveStandard);
            MarshallerHelper<ArchiveStandard, ArchiveStandard> helper = new MarshallerHelper<ArchiveStandard, ArchiveStandard>(ArchiveStandard.class, ArchiveStandard.class);
            helper.writePrescriptionToFile(helper.toXMLByteArray(archiveStandard), archivingPath);
        }
    }

    protected String getArchivedFilePath(String rid) {
        String archivingPath = this.getPropertyHandler().getProperty("ArchivePrescriptionDirectory");
        String string = archivingPath = archivingPath == null ? null : archivingPath.trim();
        if (archivingPath != null) {
            archivingPath = archivingPath.endsWith("/") ? archivingPath.concat(rid) : archivingPath.concat("/").concat(rid);
            archivingPath = archivingPath.concat(".xml");
        }
        return archivingPath;
    }

    public byte[] getArchivedPrescription(String archivedFilePath, String ... options) {
        try {
            return Files.readAllBytes(Paths.get(archivedFilePath, new String[0]));
        }
        catch (IOException ex) {
            InputStream is = this.getClass().getResourceAsStream(archivedFilePath);
            return be.business.connector.core.utils.IOUtils.getBytes(is);
        }
        catch (Exception ex) {
            LOG.warn("Could not read file [" + archivedFilePath + "].", (Throwable)ex);
            throw new IntegrationModuleException(I18nHelper.getLabel("error.archive.file", options));
        }
    }

    public XMLGregorianCalendar getCurrentXMLGregorianCalendar() {
        XMLGregorianCalendar xgcal = null;
        try {
            GregorianCalendar gcal = new GregorianCalendar();
            gcal.setTimeInMillis(System.currentTimeMillis());
            xgcal = DatatypeFactory.newInstance().newXMLGregorianCalendar(gcal);
        }
        catch (DatatypeConfigurationException ex) {
            LOG.error("Error creating a xml gregorian calendat!! ", (Throwable)ex);
        }
        return xgcal;
    }

    private ArchiveStandard getArchiveStandard(GetPrescriptionForExecutorResultSealed result, byte[] unsealedPrescription, byte[] sealedPrescription, String timestampedPrescriptionVersion, TimestampedPrescription tp, KeyResult key, String identifier, String type, ID id, ArchiveStandard archiveStandard) {
        archiveStandard.setCreationDate((Calendar)this.getCurrentXMLGregorianCalendar().toGregorianCalendar());
        if (VERSION_1.equalsIgnoreCase(timestampedPrescriptionVersion)) {
            archiveStandard.setPrescriptionSealed(sealedPrescription);
            archiveStandard.setTimestampeId(result.getTimestampingId());
            archiveStandard.setPatientId(this.getID(result.getPatientId(), "SSIN", Qualities.CITIZEN.name()));
            archiveStandard.setPrescriberId(this.getID(result.getPrescriberId(), "NIHII", Qualities.DOCTOR.name()));
        } else {
            archiveStandard.setTimestampedPrescription(result.getPrescription());
            archiveStandard.setPatientId(tp.getPrescriptionWithSecurityToken().getPatientId());
            ID prescId = tp.getPrescriptionWithSecurityToken().getPrescriberId();
            prescId.setIdType(prescId.getIdType().replace("NIHHI", "NIHII"));
            archiveStandard.setPrescriberId(prescId);
        }
        archiveStandard.setExecutorId(this.getID(identifier, type, Qualities.PHARMACY.name()));
        archiveStandard.setPrescriptionPrescriberId(id);
        archiveStandard.setPrescriptionType(result.getPrescriptionType());
        archiveStandard.setRid(result.getRid());
        archiveStandard.setEncryptionKeyId(result.getEncryptionKeyId());
        archiveStandard.setEncryptionKey(key.getSecretKey().getEncoded());
        archiveStandard.setTimestampedPrescriptionVersion(timestampedPrescriptionVersion);
        archiveStandard.setUnsealedPrescription(unsealedPrescription);
        Properties properties = new Properties();
        properties.getProperties().add(this.getProperty("sdkVersion", this.getPropertyHandler().getProperty("sdk.version")));
        properties.getProperties().add(this.getProperty("SupportedPrescriptionVersion", this.getPropertyHandler().getProperty("supported.prescription.version")));
        properties.getProperties().add(this.getProperty("prescriptionVersion", PropertyHandler.getInstance().getProperty("prescription.version")));
        properties.getProperties().add(this.getProperty("samv2", AbstractIntegrationModule.extractReferenceSourceVersionFromKmehr(unsealedPrescription)));
        if (result != null && result.getExpirationDate() != null && result.getExpirationDate().getTime() != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            properties.getProperties().add(this.getProperty("expirationDate", df.format(result.getExpirationDate().getTime())));
        }
        archiveStandard.setProperties(properties);
        return archiveStandard;
    }

    @Profiled(logFailuresSeparately=true, tag="0.AbstractIntegraionModule#extractReferenceSourceVersionFromKmehr", logger="org.perf4j.TimingLogger_Common")
    public static String extractReferenceSourceVersionFromKmehr(byte[] xmlDocument) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document kmehrDocument = builder.parse(new ByteArrayInputStream(xmlDocument));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String xpathStr1 = PropertyHandler.getInstance().getProperty("referenceSourceVersion.xpath1");
            NodeList referenceSourceVersionNodeList1 = (NodeList)xpath.evaluate(xpathStr1, kmehrDocument, XPathConstants.NODESET);
            String referenceSourceVersionPart1 = "";
            if (referenceSourceVersionNodeList1.item(0) != null) {
                referenceSourceVersionPart1 = referenceSourceVersionNodeList1.item(0).getTextContent();
            }
            String xpathStr2 = PropertyHandler.getInstance().getProperty("referenceSourceVersion.xpath2");
            NodeList referenceSourceVersionNodeList2 = (NodeList)xpath.evaluate(xpathStr2, kmehrDocument, XPathConstants.NODESET);
            String referenceSourceVersionPart2 = "";
            if (referenceSourceVersionNodeList2.item(0) != null) {
                referenceSourceVersionPart2 = referenceSourceVersionPart2 + referenceSourceVersionNodeList2.item(0).getTextContent();
            }
            if (StringUtils.isNotBlank((CharSequence)referenceSourceVersionPart1) && StringUtils.isNotBlank((CharSequence)referenceSourceVersionPart2)) {
                return referenceSourceVersionPart1 + ":" + referenceSourceVersionPart2;
            }
            return "Unknown";
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            Exceptionutils.errorHandler(e);
            return null;
        }
    }

    @Profiled(logFailuresSeparately=true, tag="0.AbstractIntegraionModule#extractExpirationDateFromKmehr", logger="org.perf4j.TimingLogger_Common")
    public String extractExpirationDateFromKmehr(byte[] xmlDocument) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document kmehrDocument = builder.parse(new ByteArrayInputStream(xmlDocument));
            PropertyHandler propertyHandler = PropertyHandler.getInstance();
            XPath xpath = XPathFactory.newInstance().newXPath();
            String xpathStr = propertyHandler.getProperty("expirationdate.xpath");
            NodeList prescriptionVersionNodeList = (NodeList)xpath.evaluate(xpathStr, kmehrDocument, XPathConstants.NODESET);
            if (prescriptionVersionNodeList.item(0) != null) {
                String prescriptionVersion = prescriptionVersionNodeList.item(0).getTextContent();
                return prescriptionVersion;
            }
            return "";
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            Exceptionutils.errorHandler(e);
            return null;
        }
    }

    private Property getProperty(String key, String value) {
        Property property = new Property();
        property.setKey(key);
        property.setValue(value);
        return property;
    }

    private void validatePrescriber(TimestampedPrescription tp, ArchiveStandard archiveStandard, ID prescriberFromKmehr) {
        if (tp != null) {
            try {
                byte[] samlToken = tp.getPrescriptionWithSecurityToken().getSecurityToken();
                Document doc = this.obtenerDocumentDeByte(samlToken);
                String nihiiInSamlToken = STSHelper.getNihii(doc.getDocumentElement());
                String type = STSHelper.getType(doc.getDocumentElement());
                boolean errorOccurs = false;
                if (StringUtils.isNotBlank((CharSequence)prescriberFromKmehr.getValue()) && StringUtils.isNotBlank((CharSequence)nihiiInSamlToken)) {
                    LOG.debug("NIHII found in the Saml Assertion is [" + nihiiInSamlToken + "], and the one in the kmehr message [" + prescriberFromKmehr.getValue() + "].");
                    LOG.debug("Quality is [" + type + "].");
                    if (!"HOSPITAL".equalsIgnoreCase(type) && !prescriberFromKmehr.getValue().substring(0, 8).equals(nihiiInSamlToken.substring(0, 8))) {
                        errorOccurs = true;
                    }
                } else {
                    errorOccurs = true;
                }
                if (errorOccurs) {
                    LOG.error("Prescriber mismach between kmehr and SAMLToken!! [" + prescriberFromKmehr.getValue() + "]-[" + nihiiInSamlToken + "]");
                    archiveStandard.setValidationWarnings(this.getValidationWarnings(archiveStandard.getValidationWarnings(), "RECIPE", "1041", "ERROR", "error.validation.presciber.mismach", prescriberFromKmehr.getValue(), nihiiInSamlToken));
                }
            }
            catch (Throwable ex) {
                LOG.error("Problems validating the prescriber in the samlToken against the one in the Kmehr!!!", ex);
                archiveStandard.setValidationWarnings(this.getValidationWarnings(archiveStandard.getValidationWarnings(), "RECIPE", "1042", "ERROR", "error.validation.presciber", new String[0]));
            }
        }
    }

    private Document obtenerDocumentDeByte(byte[] documentoXml) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(documentoXml));
    }

    private ID getPrescriberIdFromKmehr(InputStream is) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        MapNamespaceContext nsCtx = new MapNamespaceContext("http://www.ehealth.fgov.be/standards/kmehr/schema/v1");
        xPath.setNamespaceContext(nsCtx);
        InputSource inputSource = new InputSource(is);
        Document doc = (Document)xPath.evaluate("/", inputSource, XPathConstants.NODE);
        String idValue = xPath.evaluate("/ns1:kmehrmessage/ns1:header/ns1:sender/ns1:hcparty/ns1:id[@S='ID-HCPARTY' and @SV='1.0']/text()", doc);
        String type = xPath.evaluate("/ns1:kmehrmessage/ns1:header/ns1:sender/ns1:hcparty/ns1:cd[@S='CD-HCPARTY' and @SV='1.0']/text()", doc);
        ID id = new ID();
        id.setIdType("NIHII");
        id.setValue(idValue);
        id.setType(type);
        return id;
    }

    private SignatureVerificationResult validateXadesT(GetPrescriptionForExecutorResultSealed gpfers, ArchiveStandard archiveStandard, SignatureVerificationError ... errors) throws TechnicalConnectorException {
        LOG.debug("Verify XadesT signature.");
        String toSignStringOrig = new String(gpfers.getPrescription());
        String toSignDoc = toSignStringOrig.substring(0, toSignStringOrig.indexOf("<ds:Signature")) + "</ns2:timestampedPrescription>";
        String signatureString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + toSignStringOrig.substring(toSignStringOrig.indexOf("<ds:Signature"), toSignStringOrig.indexOf("</ds:Signature>") + "</ds:Signature>".length());
        LOG.debug("To sign document [" + toSignDoc + "].");
        LOG.debug("Signature [" + signatureString + "].");
        SignatureBuilder builder1 = SignatureBuilderFactory.getSignatureBuilder((AdvancedElectronicSignatureEnumeration)AdvancedElectronicSignatureEnumeration.XAdES_T);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("followNestedManifest", Boolean.TRUE);
        options.put("encapsulate", Boolean.TRUE);
        SignatureVerificationResult result = builder1.verify(toSignDoc.trim().getBytes(), signatureString.getBytes(Charset.forName("UTF-8")), options);
        for (SignatureVerificationError error : errors) {
            result.getErrors().remove(error);
        }
        for (SignatureVerificationError error : result.getErrors()) {
            LOG.warn("ERROR: " + error.getErrorName());
            ValidationWarnings warnings = this.getValidationWarnings(archiveStandard.getValidationWarnings(), "RECIPE", error.getErrorName(), "ERROR", "error.validation.signature", error.getMessage());
            archiveStandard.setValidationWarnings(warnings);
        }
        return result;
    }

    private ValidationWarnings getValidationWarnings(ValidationWarnings warnings, String ruleIDType, String ruleIdValue, String sevirity, String key, String ... args) {
        ArrayList<ValidationWarning> validationWarnings = new ArrayList<ValidationWarning>();
        ValidationWarning warning = new ValidationWarning();
        RuleId ruleID = new RuleId();
        ruleID.setIdType(ruleIDType);
        ruleID.setValue(ruleIdValue);
        warning.setRuleId(ruleID);
        RuleMessage ruleMessage = new RuleMessage();
        ArrayList<MessageText> messageTexts = new ArrayList<MessageText>();
        Map<String, String> labels = I18nHelper.getAllLanguagesLabels(key, args);
        Iterator<Map.Entry<String, String>> iterator = labels.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> pair = entry = iterator.next();
            MessageText messageText = new MessageText();
            messageText.setLanguage(pair.getKey());
            messageText.setValue(pair.getValue());
            messageTexts.add(messageText);
        }
        ruleMessage.getMessageTexts().addAll(messageTexts);
        warning.setRuleMessage(ruleMessage);
        warning.setSeverity(sevirity);
        validationWarnings.add(warning);
        if (warnings == null) {
            warnings = new ValidationWarnings();
        }
        warnings.getValidationWarnings().addAll(validationWarnings);
        return warnings;
    }

    private ID getID(String idValue, String ... type) {
        ID id = new ID();
        id.setIdType(type[0]);
        if (type.length > 1) {
            id.setType(type[1]);
        }
        id.setValue(idValue);
        return id;
    }

    private void validateTimeStamping(GetPrescriptionForExecutorResultSealed result, ArchiveStandard aStandard) {
        try {
            ValidationWarnings warnings;
            TimeStampResponse response = new TimeStampResponse(Base64.decode((byte[])result.getTimestampingId().getBytes()));
            boolean isValid = true;
            TimeStampToken tsToken = response.getTimeStampToken();
            byte[] tokenDigestValue = tsToken.getTimeStampInfo().getMessageImprintDigest();
            String algo = tsToken.getTimeStampInfo().getHashAlgorithm().getAlgorithm().getId();
            byte[] calculatedDigest = ConnectorCryptoUtils.calculateDigest((String)algo, (byte[])result.getPrescription());
            if (!MessageDigest.isEqual(calculatedDigest, tokenDigestValue)) {
                isValid = false;
            }
            Attribute scV1 = tsToken.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificate);
            Attribute scV2 = tsToken.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
            if (scV1 == null && scV2 == null) {
                isValid = false;
                warnings = this.getValidationWarnings(aStandard.getValidationWarnings(), "RECIPE", "1038", "ERROR", "error.validation.missing.certificate", new String[0]);
                aStandard.setValidationWarnings(warnings);
            }
            if (scV1 != null && scV2 != null) {
                isValid = false;
                warnings = this.getValidationWarnings(aStandard.getValidationWarnings(), "RECIPE", "1039", "ERROR", "error.validation.conflicting.certificate.attribute", new String[0]);
                aStandard.setValidationWarnings(warnings);
            }
            if (isValid) {
                this.validateTimeStampToken(tsToken);
            }
        }
        catch (Throwable ex) {
            LOG.warn("Validation error: ", ex);
            ValidationWarnings warnings = this.getValidationWarnings(aStandard.getValidationWarnings(), "RECIPE", "1040", "ERROR", "error.validation.timestamp", ex.getMessage());
            aStandard.setValidationWarnings(warnings);
        }
    }

    private boolean validateTimeStampToken(TimeStampToken tsToken) throws Exception {
        boolean result = false;
        KeyStore keyStore = this.getEncryptionUtils().getTSAKeyStore();
        List<String> aliases = this.getEncryptionUtils().getTsaStoreAliases();
        if (aliases == null || keyStore == null) {
            throw new IllegalStateException("keystore or aliases not initialised yet : aliases : [" + aliases + "] and keystore : [" + keyStore + "]");
        }
        TimeStampTokenInfo tsi = tsToken.getTimeStampInfo();
        LOG.info("GenTime:" + tsi.getGenTime());
        LOG.info("ImprintAlgOID:" + tsi.getMessageImprintAlgOID());
        LOG.info("Policy:" + tsi.getPolicy());
        LOG.info("HashAlgorithm:" + tsi.getHashAlgorithm().getAlgorithm().getId());
        boolean signatureValid = false;
        Exception lastException = null;
        for (String alias : aliases) {
            try {
                X509Certificate ttsaCert = (X509Certificate)keyStore.getCertificate(alias);
                String t = ttsaCert.getSubjectX500Principal().getName("RFC1779");
                LOG.debug("Trying to validate timestamp against certificate with alias [" + alias + "] : [" + t + "]");
                X509CertificateHolder tokenSigner = new X509CertificateHolder(ttsaCert.getEncoded());
                SignerInformationVerifier verifier = new BcRSASignerInfoVerifierBuilder((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), (DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder(), (DigestCalculatorProvider)new BcDigestCalculatorProvider()).build(tokenSigner);
                tsToken.validate(verifier);
                signatureValid = true;
                break;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (!signatureValid) {
            result = false;
            throw new Exception("timestamp is not valid ", lastException);
        }
        result = true;
        LOG.debug("timestampToken is valid");
        return result;
    }

    protected Page buildDefaultPage() {
        Page page = PageFactory.defaultPage();
        page.setMonth(Calendar.getInstance().get(2) - 1);
        page.setYear(Calendar.getInstance().get(1));
        return page;
    }

    public String getId() {
        return "id" + UUID.randomUUID().toString();
    }
}

