/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.common;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.MessageDumper;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.core.utils.SessionValidator;
import be.ehealth.technicalconnector.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationConfig.class);
    private static ApplicationConfig instance;

    private ApplicationConfig() {
    }

    public static ApplicationConfig getInstance() {
        if (instance == null) {
            instance = new ApplicationConfig();
        }
        return instance;
    }

    public void assertValidSession() {
        SessionValidator.assertValidSession(Session.getInstance().getSession());
    }

    public void assertValidPharmacySession() {
        SessionValidator.assertValidPharmacySession(Session.getInstance().getSession());
    }

    public void assertValidHospitalPharmacySession() {
        SessionValidator.assertValidHospitalPharmacySession(Session.getInstance().getSession());
    }

    public void assertInitialized() {
        if (PropertyHandler.getInstance() == null || EncryptionUtils.getInstance() == null) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.system.not.initialized"));
        }
    }

    public void setSystemKeystoreProperties(String systemKeystorePassword, String systemKeystorePath, String systemKeystoreDirectory, String systemKeystoreNIHIIPHARMACYCBE) {
        this.assertInitialized();
        LOG.info("Setting key store : path " + systemKeystorePath + " directory : " + systemKeystoreDirectory + " Nihii : " + systemKeystoreNIHIIPHARMACYCBE);
        EncryptionUtils.getInstance().setSystemKeystorePassword(systemKeystorePassword);
        EncryptionUtils.getInstance().setSystemKeystorePath(systemKeystorePath);
        EncryptionUtils.getInstance().setSystemKeystoreDirectory(systemKeystoreDirectory);
        EncryptionUtils.getInstance().setSystemKeystoreRiziv(systemKeystoreNIHIIPHARMACYCBE);
        LOG.info("Setting key store - completed");
    }

    public void setOldSystemKeystoreProperties(String systemKeystorePassword, String systemKeystorePath, String systemKeystoreDirectory, String systemKeystoreNIHIIPHARMACYCBE) {
        this.assertInitialized();
        EncryptionUtils.getInstance().setOldSystemKeystorePassword(systemKeystorePassword);
        EncryptionUtils.getInstance().setOldSystemKeystorePath(systemKeystorePath);
        EncryptionUtils.getInstance().setOldSystemKeystoreDirectory(systemKeystoreDirectory);
        EncryptionUtils.getInstance().setOldSystemKeystoreRiziv(systemKeystoreNIHIIPHARMACYCBE);
    }

    public void initialize() {
        this.initialize(null, null);
    }

    public void initialize(String propertyfile, String validationFile) {
        this.initialize(propertyfile, validationFile, null);
    }

    public void initialize(String propertyfile, String vslidationFile, String urlConf) {
        this.initialize(new PropertyHandler(propertyfile, vslidationFile, urlConf));
        LOG.info("Initialized applicationConfig for propertyFile [" + propertyfile + "], validationFile [" + vslidationFile + "] and urlConfig [" + urlConf + "].");
    }

    public void initialize(PropertyHandler props) {
        LOG.info("Initializing applicationConfig.");
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        System.setProperty("javax.xml.soap.SOAPFactory", "com.sun.xml.messaging.saaj.soap.ver1_1.SOAPFactory1_1Impl");
        this.initPropertyHandlerSingleton(props);
        this.initEncryptionUtilsSingleton();
        LOG.info("Application config successfully initialized.");
    }

    public void setProperty(String key, String value) {
        PropertyHandler.getInstance().setProperty(key, value);
    }

    public void setSystemProperty(String key, String value) {
        System.setProperty(key, value);
        LOG.info("System property: " + key + " is set with value: " + value);
    }

    private PropertyHandler initPropertyHandlerSingleton(String propertyfile, String vslidationFile, String urlConf) throws IntegrationModuleException {
        PropertyHandler propertyHandler = new PropertyHandler(propertyfile, vslidationFile, urlConf);
        MessageDumper.getInstance().init(propertyHandler);
        return propertyHandler;
    }

    private PropertyHandler initPropertyHandlerSingleton(PropertyHandler props) throws IntegrationModuleException {
        MessageDumper.getInstance().init(props);
        return props;
    }

    private void initEncryptionUtilsSingleton() {
        new EncryptionUtils(PropertyHandler.getInstance());
    }
}

