package be.business.connector.recipe.utils;

import be.business.connector.core.exceptions.IntegrationModuleException;

public class Locales {
  public static String getLocalisedMsg(final be.recipe.services.core.StatusType status) {
    final String locale = IntegrationModuleException.getUserLocale();
    for (final be.recipe.services.core.LocalisedString msg : status.getMessages()) {
      if (msg.getLang() != null && locale.equalsIgnoreCase(msg.getLang().value())) {
        return msg.getValue();
      }
    }
    if (status.getMessages().size() > 0) {
      return status.getMessages().get(0).getValue();
    }
    return status.getCode();
  }
}
