/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.services.patient;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(namespace="http:/services.recipe.be/patient")
public class GetPrescriptionForPatientResultSealed {
    private String rid;
    private Calendar creationDate;
    private String patientId;
    private boolean feedbackAllowed = true;
    private byte[] prescription;
    private String prescriptionType;
    private String encryptionKeyId;
    private String timestampingId;
    private String prescriberId;

    public GetPrescriptionForPatientResultSealed() {
    }

    GetPrescriptionForPatientResultSealed(String rid, Date creationDate, String patientId, boolean feedbackAllowed, boolean feedbackAllowedByPatient, byte[] prescription, String encryptionKeyId, String prescriptionType, String timestampingId, String prescriberId) {
        this.rid = rid;
        this.creationDate = new GregorianCalendar();
        this.creationDate.setTime(creationDate);
        this.patientId = String.format("%011d", patientId);
        this.feedbackAllowed = feedbackAllowed && feedbackAllowedByPatient;
        this.prescription = prescription;
        this.encryptionKeyId = encryptionKeyId;
        this.prescriptionType = prescriptionType;
        this.timestampingId = timestampingId;
        this.prescriberId = prescriberId;
    }

    public String getPrescriberId() {
        return this.prescriberId;
    }

    public void setPrescriberId(String prescriberId) {
        this.prescriberId = prescriberId;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public String getPrescriptionType() {
        return this.prescriptionType;
    }

    public void setPrescriptionType(String prescriptionType) {
        this.prescriptionType = prescriptionType;
    }

    public void setFeedbackAllowed(boolean feedbackAllowed) {
        this.feedbackAllowed = feedbackAllowed;
    }

    public boolean isFeedbackAllowed() {
        return this.feedbackAllowed;
    }

    @Deprecated
    public void setFeedbackRequested(boolean feedbackAllowed) {
        this.feedbackAllowed = feedbackAllowed;
    }

    public String getRid() {
        return this.rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public String getPatientId() {
        return this.patientId;
    }

    public void setPatientId(String patientId) {
        this.patientId = patientId;
    }

    public byte[] getPrescription() {
        return this.prescription;
    }

    public void setPrescription(byte[] prescription) {
        this.prescription = prescription;
    }

    public String getEncryptionKeyId() {
        return this.encryptionKeyId;
    }

    public void setEncryptionKeyId(String encryptionKeyId) {
        this.encryptionKeyId = encryptionKeyId;
    }

    public String getTimestampingId() {
        return this.timestampingId;
    }

    public void setTimestampingId(String timestampingId) {
        this.timestampingId = timestampingId;
    }
}

