/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.utils.prescribercreatebulkprescriptions;

import be.business.connector.core.utils.IOUtils;
import be.business.connector.core.utils.MarshallerHelper;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.projects.common.utils.ValidationUtils;
import be.business.connector.recipe.AbstractRecipeClient;
import be.business.connector.recipe.prescriber.AbstractPrescriberIntegrationModule;
import be.business.connector.recipe.prescriber.RecipePrescriberClient;
import be.business.connector.recipe.prescriber.dto.CreatePrescriptionDTO;
import be.business.connector.recipe.prescriber.services.RecipePrescriberServiceV4;
import be.business.connector.recipe.prescriber.services.RecipePrescriberServiceV4Impl;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.ehealth.technicalconnector.service.sts.security.impl.KeyPairCredential;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.recipe.core.v4.CreatePrescriptionAdministrativeInformationType;
import be.fgov.ehealth.recipe.protocol.v4.CreatePrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v4.CreatePrescriptionResponse;
import be.recipe.services.core.ResponseType;
import be.recipe.services.prescriber.CreatePrescriptionParam;
import be.recipe.services.prescriber.CreatePrescriptionResult;
import java.security.Key;
import java.util.concurrent.Semaphore;
import org.joda.time.DateTime;
import org.w3c.dom.Element;

public class CreateEncryptedPrescriptionsTask {
    private final CreatePrescriptionDTO createPrescriptionDTO;
    private final Semaphore semaphore;
    private final KeyResult key;
    private final Key symmKey;
    private final EncryptionToken recipeEtk;
    private final AbstractPrescriberIntegrationModule prescriptionIntegrationModule;
    private final Element assertion;
    private final KeyPairCredential keyPairCredential;

    public CreateEncryptedPrescriptionsTask(Semaphore available, CreatePrescriptionDTO createPrescriptionDTO, KeyResult key, Key symmKey, EncryptionToken recipeEtk, AbstractPrescriberIntegrationModule prescriptionIntegrationModule, Element assertion, KeyPairCredential keyPairCredential) {
        this.semaphore = available;
        this.createPrescriptionDTO = createPrescriptionDTO;
        this.key = key;
        this.symmKey = symmKey;
        this.recipeEtk = recipeEtk;
        this.prescriptionIntegrationModule = prescriptionIntegrationModule;
        this.assertion = assertion;
        this.keyPairCredential = keyPairCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ValidationUtils.validatePatientId(this.createPrescriptionDTO.getPatientId());
            ValidationUtils.validateVisi(this.createPrescriptionDTO.getVisi(), false);
            String expirationDate = this.prescriptionIntegrationModule.extractExpirationDateFromKmehr(this.createPrescriptionDTO.getPrescription());
            ValidationUtils.validateExpirationDate(expirationDate);
            this.prescriptionIntegrationModule.validateKmehr(this.createPrescriptionDTO.getPrescription(), this.createPrescriptionDTO.getPrescriptionType(), expirationDate);
            byte[] message = IOUtils.compress(this.createPrescriptionDTO.getPrescription());
            byte[] sealedMessage = this.prescriptionIntegrationModule.sealPrescriptionForUnknown(this.key, message);
            CreatePrescriptionParam params = new CreatePrescriptionParam();
            params.setPrescription(sealedMessage);
            params.setPrescriptionType(this.createPrescriptionDTO.getPrescriptionType());
            params.setFeedbackRequested(this.createPrescriptionDTO.isFeedbackRequested());
            params.setKeyId(this.key.getKeyId());
            params.setSymmKey(this.symmKey.getEncoded());
            params.setPatientId(this.createPrescriptionDTO.getPatientId());
            params.setExpirationDate(expirationDate);
            params.setVision(this.createPrescriptionDTO.getVisi());
            params.setVisionOtherPrescribers(RecipePrescriberClient.toJAXB(this.createPrescriptionDTO.getVisionOtherPrescribers()));
            MarshallerHelper<CreatePrescriptionResult, CreatePrescriptionParam> helper = new MarshallerHelper<CreatePrescriptionResult, CreatePrescriptionParam>(CreatePrescriptionResult.class, CreatePrescriptionParam.class);
            CreatePrescriptionRequest request = new CreatePrescriptionRequest();
            request.setSecuredCreatePrescriptionRequest(this.prescriptionIntegrationModule.createSecuredContentType(this.prescriptionIntegrationModule.sealRequest(this.recipeEtk, helper.toXMLByteArray(params))));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setId(this.prescriptionIntegrationModule.getId());
            request.setIssueInstant(new DateTime());
            CreatePrescriptionAdministrativeInformationType adminValue = new CreatePrescriptionAdministrativeInformationType();
            adminValue.setKeyIdentifier(this.key.getKeyId().getBytes());
            adminValue.setPrescriptionVersion(PropertyHandler.getInstance().getProperty("prescription.version"));
            adminValue.setReferenceSourceVersion(AbstractPrescriberIntegrationModule.extractReferenceSourceVersionFromKmehr(this.createPrescriptionDTO.getPrescription()));
            adminValue.setPrescriptionType(this.createPrescriptionDTO.getPrescriptionType());
            request.setAdministrativeInformation(adminValue);
            RecipePrescriberServiceV4 prescriberService = RecipePrescriberServiceV4Impl.getInstance();
            CreatePrescriptionResponse response = prescriberService.createPrescription(request, this.assertion, this.keyPairCredential);
            CreatePrescriptionResult result = helper.unsealWithSymmKey(response.getSecuredCreatePrescriptionResponse().getSecuredContent(), this.symmKey);
            this.prescriptionIntegrationModule.checkStatus((ResponseType)result);
            this.createPrescriptionDTO.setRid(result.getRid());
            this.createPrescriptionDTO.setErrorOccured(false);
        }
        catch (Exception exception) {
            this.createPrescriptionDTO.setException(exception);
            this.createPrescriptionDTO.setErrorOccured(true);
        }
        finally {
            this.semaphore.release();
        }
    }

    public CreatePrescriptionDTO getData() {
        return this.createPrescriptionDTO;
    }
}

