/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.utils.executorlistopenprescriptions;

import be.business.connector.common.StandaloneRequestorProvider;
import be.business.connector.core.domain.KgssIdentifierType;
import be.business.connector.core.ehealth.services.OptimizedKgssServiceImpl;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.technical.connector.utils.Crypto;
import be.business.connector.core.utils.ETKHelper;
import be.business.connector.core.utils.IOUtils;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.recipe.services.executor.GetOpenPrescriptionForExecutor;
import be.recipe.services.executor.ListOpenPrescriptionsResult;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadedExecutorListOpenPrescriptionsUseCase {
    private static final Logger LOG = LoggerFactory.getLogger(SingleThreadedExecutorListOpenPrescriptionsUseCase.class);
    private final ETKHelper etkHelper;
    private final Crypto crypto;

    public SingleThreadedExecutorListOpenPrescriptionsUseCase(ETKHelper etkHelper) {
        this.etkHelper = etkHelper;
        this.crypto = new Crypto();
    }

    public ListOpenPrescriptionsResult execute(ListOpenPrescriptionsResult listOpenPrescriptionsResult) throws IntegrationModuleException {
        if (listOpenPrescriptionsResult == null || CollectionUtils.isEmpty((Collection)listOpenPrescriptionsResult.getPrescriptions())) {
            return listOpenPrescriptionsResult;
        }
        long startList = System.currentTimeMillis();
        Map<String, KeyResult> kgssKeys = this.retrieveKgssKeys(listOpenPrescriptionsResult);
        long stopList = System.currentTimeMillis();
        LOG.debug("Retrieving KGSS keys took {} ms", (Object)(stopList - startList));
        long startDecrypt = System.currentTimeMillis();
        ListOpenPrescriptionsResult decryptedPrescriptions = this.doDecryptions(listOpenPrescriptionsResult, kgssKeys);
        long stopDecrypt = System.currentTimeMillis();
        LOG.debug("Unsealing all prescriptions took {} ms", (Object)(stopDecrypt - startDecrypt));
        return decryptedPrescriptions;
    }

    private byte[] getPharmacyEtkAsBytes() {
        return this.etkHelper.getEtks(KgssIdentifierType.NIHII_PHARMACY, StandaloneRequestorProvider.getRequestorIdInformation()).get(0).getEncoded();
    }

    private ListOpenPrescriptionsResult doDecryptions(ListOpenPrescriptionsResult prescriptionList, Map<String, KeyResult> kgssKeys) {
        ListOpenPrescriptionsResult finalResult = new ListOpenPrescriptionsResult();
        prescriptionList.getPrescriptions().forEach(prescription -> {
            KeyResult kgssKey = (KeyResult)kgssKeys.get(prescription.getEncryptionKeyId());
            GetOpenPrescriptionForExecutor decryptedPrescription = this.decrypt((GetOpenPrescriptionForExecutor)prescription, kgssKey);
            finalResult.getPrescriptions().add(decryptedPrescription);
        });
        finalResult.setHasMoreResults(prescriptionList.isHasMoreResults());
        finalResult.setSession(prescriptionList.getSession());
        finalResult.getPrescriptions().sort((f1, f2) -> f2.getCreationDate().compareTo(f1.getCreationDate()));
        return finalResult;
    }

    private Map<String, KeyResult> retrieveKgssKeys(ListOpenPrescriptionsResult prescriptionList) {
        long startRetrieve = System.currentTimeMillis();
        Set<String> keyIds = prescriptionList.getPrescriptions().stream().map(GetOpenPrescriptionForExecutor::getEncryptionKeyId).collect(Collectors.toSet());
        byte[] pharmacyEtkAsBytes = this.getPharmacyEtkAsBytes();
        byte[] kgssEtkAsBytes = this.etkHelper.getKGSS_ETK().get(0).getEncoded();
        Map<String, KeyResult> stringKeyResultMap = new OptimizedKgssServiceImpl().retrieveMultipleKeysWithoutCache(keyIds, pharmacyEtkAsBytes, kgssEtkAsBytes);
        long stopRetrieve = System.currentTimeMillis();
        LOG.debug("Retrieving {} unique kgss keys took {} ms", (Object)keyIds.size(), (Object)(stopRetrieve - startRetrieve));
        return stringKeyResultMap;
    }

    private GetOpenPrescriptionForExecutor decrypt(GetOpenPrescriptionForExecutor prescription, KeyResult kgssKey) {
        byte[] unsealedPrescription = this.crypto.unsealForUnknown(kgssKey, prescription.getPrescription());
        try {
            prescription.setPrescription(IOUtils.decompress(unsealedPrescription));
        }
        catch (IOException e) {
            throw new IntegrationModuleException(e);
        }
        return prescription;
    }
}

