/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.utils;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.exceptions.IntegrationModuleValidationException;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.IOUtils;
import be.business.connector.core.utils.MapNamespaceContext;
import be.business.connector.core.utils.PropertyHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class KmehrHelper {
    public static final String W3C_XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";
    private static final String KMEHR_ASSERT = "kmehr.assert.";
    private static final Logger LOG = LoggerFactory.getLogger(KmehrHelper.class);
    private static final Properties properties = PropertyHandler.getInstance().getProperties();
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";

    public void assertValidKmehrPrescription(InputStream xmlFile, String prescriptionType) throws IntegrationModuleException {
        byte[] xmlStream = IOUtils.getBytes(xmlFile);
        this.assertValidKmehrPrescription(xmlStream, prescriptionType);
    }

    public void assertValidNotification(InputStream xmlFile) throws IntegrationModuleException, SAXException {
        byte[] xmlStream = IOUtils.getBytes(xmlFile);
        this.assertValidNotification(xmlStream);
    }

    public void assertValidFeedback(List<String> errors, InputStream xmlFile) throws IntegrationModuleException, SAXException {
        byte[] xmlStream = IOUtils.getBytes(xmlFile);
        this.assertValidFeedback(xmlStream);
        if (CollectionUtils.isNotEmpty(errors)) {
            throw new IntegrationModuleValidationException(this.getLabel("error.xml.invalid"), errors);
        }
    }

    @Profiled(logFailuresSeparately=true, tag="IntegrationModule#XMLNotificationValidation")
    public void assertValidNotification(byte[] xmlDocument) throws IntegrationModuleException {
        ArrayList<String> errors = new ArrayList<String>();
        this.validateXsd(errors, xmlDocument, "notification.XSD");
        if (CollectionUtils.isNotEmpty(errors)) {
            throw new IntegrationModuleValidationException(this.getLabel("error.xml.invalid"), errors);
        }
    }

    @Profiled(logFailuresSeparately=true, tag="0.IntegrationModule#XMLFeedbackValidation")
    public void assertValidFeedback(byte[] xmlDocument) throws IntegrationModuleException {
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(this.validateXsd(new ArrayList<String>(), xmlDocument, "feedback.XSD"));
        if (CollectionUtils.isNotEmpty(errors)) {
            throw new IntegrationModuleValidationException(this.getLabel("error.xml.invalid"), errors);
        }
    }

    @Profiled(logFailuresSeparately=true, tag="0.IntegrationModule#XMLPrescriptionValidation")
    public void assertValidKmehrPrescription(byte[] xmlDocument, String prescriptionType) throws IntegrationModuleException {
        try {
            ArrayList<String> errors = new ArrayList<String>();
            this.validateXsd(errors, xmlDocument, "kmehr.XSD");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document kmehrDocument = builder.parse(new ByteArrayInputStream(xmlDocument));
            this.validateXpath(errors, kmehrDocument, prescriptionType);
            if (CollectionUtils.isNotEmpty(errors)) {
                throw new IntegrationModuleValidationException(this.getLabel("error.xml.invalid"), errors);
            }
        }
        catch (IOException | ParserConfigurationException e) {
            LOG.debug("Bad Prescription : " + new String(xmlDocument));
            throw new IntegrationModuleException(this.getLabel("error.xml.invalid"), e);
        }
        catch (IntegrationModuleException e) {
            LOG.error("Error occured : ", (Throwable)e);
            throw e;
        }
        catch (IntegrationModuleValidationException e) {
            LOG.error("Error occured : ", (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            LOG.error("Error occured : ", t);
            throw new IntegrationModuleException(this.getLabel("error.xml.invalid"), t);
        }
    }

    private List<String> validateXsd(List<String> errors, byte[] xmlDocument, String xsdPropertyName) throws IntegrationModuleException {
        if (ArrayUtils.isEmpty((byte[])xmlDocument)) {
            throw new IntegrationModuleValidationException(this.getLabel("error.xml.invalid"), errors);
        }
        try {
            String xsdVersion = "28";
            String xsdName = properties.getProperty(xsdPropertyName);
            if (xsdName == null) {
                xsdName = properties.getProperty(xsdPropertyName + "." + "28");
            }
            if (xsdName == null || !new File(xsdName).exists()) {
                LOG.error(xsdPropertyName + "." + "28" + " property is not correctly set, invalid file " + xsdPropertyName + " = " + xsdName);
                throw new RuntimeException(xsdPropertyName + "." + "28" + " property is not correctly set, invalid file " + xsdPropertyName + " = " + xsdName);
            }
            File xsd = new File(xsdName);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (!factory.getClass().getName().startsWith("org.apache")) {
                LOG.warn("Non supported parser : " + factory.getClass().getName());
            }
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA_NS_URI);
            factory.setAttribute(JAXP_SCHEMA_SOURCE, new String[]{xsd.getCanonicalPath()});
            DocumentBuilder builderNamespaceAware = factory.newDocumentBuilder();
            builderNamespaceAware.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException arg0) throws SAXException {
                    LOG.warn("XSD Warning", (Throwable)arg0);
                }

                @Override
                public void fatalError(SAXParseException arg0) throws SAXException {
                    LOG.error("XSD fatalError", (Throwable)arg0);
                    throw arg0;
                }

                @Override
                public void error(SAXParseException arg0) throws SAXException {
                    LOG.error("XSD error", (Throwable)arg0);
                    throw arg0;
                }
            });
            builderNamespaceAware.parse(new ByteArrayInputStream(xmlDocument));
        }
        catch (IOException | ParserConfigurationException e) {
            throw new IntegrationModuleException(this.getLabel("error.xml.invalid"), e);
        }
        catch (SAXException e) {
            int lineNbr = ((SAXParseException)e).getLineNumber();
            int columnNbr = ((SAXParseException)e).getColumnNumber();
            String msg = ((SAXParseException)e).getMessage();
            errors.add(msg + ". LineNumber: " + lineNbr + ", columnNumber: " + columnNbr);
            return errors;
        }
        return errors;
    }

    private String getLabel(String key) {
        return I18nHelper.getLabel(key);
    }

    private List<String> validateXpath(List<String> errors, Document doc, String prescriptionType) throws IntegrationModuleException {
        try {
            int i = 1;
            String xpathCountWithVersion1 = "";
            String xpathCountWithoutVersion1 = "";
            String xpathCountWithVersion2 = "";
            String xpathCountWithoutVersion2 = "";
            String keyCountWithoutVersion1 = "";
            String keyCountWithVersion1 = "";
            String keyCountWithoutVersion2 = "";
            String keyCountWithVersion2 = "";
            String xpathConfigWithVersion = "";
            String xpathConfigWithoutVersion = "";
            String keyWithoutVersion = "";
            String keyWithVersion = "";
            while (true) {
                String version;
                if (StringUtils.isBlank((CharSequence)(version = (String)properties.get("kmehr.version")))) {
                    keyWithoutVersion = KMEHR_ASSERT + prescriptionType + "." + i;
                    keyCountWithoutVersion1 = KMEHR_ASSERT + prescriptionType + ".1." + i;
                    keyCountWithoutVersion2 = KMEHR_ASSERT + prescriptionType + ".2." + i;
                    xpathConfigWithoutVersion = (String)properties.get(keyWithoutVersion);
                    xpathCountWithoutVersion1 = (String)properties.get(keyCountWithoutVersion1);
                    xpathCountWithoutVersion2 = (String)properties.get(keyCountWithoutVersion2);
                } else {
                    version = version + ".";
                    keyWithVersion = KMEHR_ASSERT + prescriptionType + "." + version + i;
                    keyCountWithVersion1 = KMEHR_ASSERT + prescriptionType + ".1." + i;
                    keyCountWithVersion2 = KMEHR_ASSERT + prescriptionType + ".2." + i;
                    xpathConfigWithVersion = (String)properties.get(keyWithVersion);
                    xpathCountWithVersion1 = (String)properties.get(keyCountWithVersion1);
                    xpathCountWithVersion2 = (String)properties.get(keyCountWithVersion2);
                }
                if (!(StringUtils.isBlank((CharSequence)xpathConfigWithVersion) && StringUtils.isBlank((CharSequence)xpathConfigWithoutVersion) && StringUtils.isBlank((CharSequence)xpathCountWithVersion1) && StringUtils.isBlank((CharSequence)xpathCountWithVersion2) && StringUtils.isBlank((CharSequence)xpathCountWithoutVersion1) && StringUtils.isBlank((CharSequence)xpathCountWithoutVersion2))) {
                    String[] xpathConfigsWithVersion = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xpathConfigWithVersion}) ? xpathConfigWithVersion.split(";") : null;
                    String[] xpathConfigsWithoutVersion = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xpathConfigWithoutVersion}) ? xpathConfigWithoutVersion.split(";") : null;
                    String[] xpathConfCountWithVersion1 = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xpathCountWithVersion1}) ? xpathCountWithVersion1.split(";") : null;
                    String[] xpathConfCountWithoutVersion1 = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xpathCountWithoutVersion1}) ? xpathCountWithoutVersion1.split(";") : null;
                    String[] xpathConfCountWithVersion2 = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xpathCountWithVersion2}) ? xpathCountWithVersion2.split(";") : null;
                    String[] xpathConfCountWithoutVersion2 = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xpathCountWithoutVersion2}) ? xpathCountWithoutVersion2.split(";") : null;
                    String message = "";
                    if (StringUtils.isNotBlank((CharSequence)message)) {
                        errors.add(message);
                    }
                    LOG.debug("validate xpathConfigsWithVersion[" + i + "][" + xpathConfigWithVersion + "] or xpathConfigsWithoutVersion[" + i + "][" + xpathConfigWithoutVersion + "].");
                    if (!(this.verifyXpath(xpathConfigsWithVersion, doc) || this.verifyXpath(xpathConfigsWithoutVersion, doc) || this.verifyXpath(xpathConfCountWithVersion1, xpathConfCountWithVersion2, doc) || this.verifyXpath(xpathConfCountWithoutVersion1, xpathConfCountWithoutVersion2, doc))) {
                        if (xpathConfigsWithVersion != null) {
                            message = "xpathConfigsWithVersion[" + i + "][" + xpathConfigWithVersion + "] is not valide.";
                        } else if (xpathConfigsWithoutVersion != null) {
                            message = "xpathConfigsWithoutVersion[" + i + "][" + xpathConfigWithoutVersion + "] is not valide.";
                        } else if (xpathConfCountWithVersion1 != null && xpathConfCountWithVersion2 != null) {
                            message = "xpathConfCountWithVersion1[" + i + "][" + xpathCountWithVersion1 + "] is not valide.";
                            message = message + "or xpathConfCountWithVersion2[" + i + "][" + xpathCountWithVersion2 + "] is not valide.";
                            message = message + " or xpathConfCountWithoutVersion1[" + i + "][" + xpathCountWithoutVersion1 + "] is not valide.";
                            message = message + "or xpathConfCountWithoutVersion2[" + i + "][" + xpathCountWithoutVersion2 + "] is not valide.";
                        }
                        errors.add(message);
                        return errors;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (XPathExpressionException e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.xml.invalid"), e);
        }
        return errors;
    }

    private boolean verifyXpath(String[] xpathConfigs, Document doc) {
        if (xpathConfigs == null) {
            return false;
        }
        int min = 0;
        int max = 0;
        if (xpathConfigs.length == 3) {
            min = Integer.parseInt(xpathConfigs[1].trim());
            max = Integer.parseInt(xpathConfigs[2].trim());
        } else if (xpathConfigs.length == 2) {
            min = Integer.parseInt(xpathConfigs[1].trim());
            max = Integer.MAX_VALUE;
        } else if (xpathConfigs.length == 1) {
            min = Integer.MIN_VALUE;
            max = Integer.MAX_VALUE;
        }
        String xpathStr = xpathConfigs[0];
        XPath xpath = XPathFactory.newInstance().newXPath();
        MapNamespaceContext nsCtx = new MapNamespaceContext();
        xpath.setNamespaceContext(nsCtx);
        try {
            NodeList nodes = (NodeList)xpath.evaluate(xpathStr, doc, XPathConstants.NODESET);
            if (nodes.getLength() < min || nodes.getLength() > max) {
                LOG.error("FAILED Xpath query : " + xpathStr);
                return false;
            }
            return true;
        }
        catch (XPathExpressionException ex) {
            try {
                boolean ok = (Boolean)xpath.evaluate(xpathStr, doc, XPathConstants.BOOLEAN);
                if (!ok) {
                    LOG.error("FAILED Xpath query : " + xpathStr);
                    return false;
                }
                return true;
            }
            catch (XPathExpressionException ex1) {
                LOG.error("FAILED Xpath query : " + ex1.getMessage());
                return false;
            }
        }
    }

    private boolean verifyXpath(String[] xpathConfigs1, String[] xpathConfigs2, Document doc) throws XPathExpressionException {
        if (xpathConfigs1 == null || xpathConfigs2 == null) {
            return false;
        }
        String xpathStr1 = xpathConfigs1[0];
        String xpathStr2 = xpathConfigs2[0];
        XPath xpath = XPathFactory.newInstance().newXPath();
        MapNamespaceContext nsCtx = new MapNamespaceContext();
        xpath.setNamespaceContext(nsCtx);
        Double count1 = (Double)xpath.evaluate(xpathStr1, doc, XPathConstants.NUMBER);
        Double count2 = (Double)xpath.evaluate(xpathStr2, doc, XPathConstants.NUMBER);
        if (!Objects.equals(count1, count2)) {
            LOG.error("FAILED Xpath query : " + xpathStr1 + " <==> " + xpathStr2);
            return false;
        }
        return true;
    }
}

