/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.utils;

import be.business.connector.common.StandaloneRequestorProvider;
import be.business.connector.core.domain.KgssIdentifierType;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.ETKHelper;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.recipe.executor.dto.ListOpenPrescriptionsResultWithExceptions;
import be.business.connector.recipe.executor.dto.ListReservationsResultWithExceptions;
import be.business.connector.recipe.utils.ReservationDecryptorThread;
import be.business.connector.recipe.utils.executorlistopenprescriptions.MultiThreadedExecutorListOpenPrescriptionsUseCase;
import be.business.connector.recipe.utils.executorlistopenprescriptions.SingleThreadedExecutorListOpenPrescriptionsUseCase;
import be.recipe.services.executor.ListOpenPrescriptionsResult;
import be.recipe.services.executor.ListReservationsResult;
import be.recipe.services.executor.ListReservationsResultItem;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.commons.collections.CollectionUtils;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorDecryptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorDecryptionUtils.class);
    private final ETKHelper etkHelper;

    public ExecutorDecryptionUtils(PropertyHandler propertyHandler, EncryptionUtils encryptionUtils) {
        this.etkHelper = new ETKHelper(propertyHandler, encryptionUtils);
    }

    public ListOpenPrescriptionsResult decryptPrescriptions(ListOpenPrescriptionsResult listOpenPrescriptionsResult) throws IntegrationModuleException {
        return new MultiThreadedExecutorListOpenPrescriptionsUseCase(this.etkHelper).execute(listOpenPrescriptionsResult);
    }

    public ListOpenPrescriptionsResult decryptPrescriptionsSingleThreaded(ListOpenPrescriptionsResult listOpenPrescriptionsResult) throws IntegrationModuleException {
        return new SingleThreadedExecutorListOpenPrescriptionsUseCase(this.etkHelper).execute(listOpenPrescriptionsResult);
    }

    @Profiled(logFailuresSeparately=true, tag="0.DecompressionUtil#decryptReservations")
    public ListReservationsResult decryptReservations(ListReservationsResult listReservationsResult) throws IntegrationModuleException {
        if (listReservationsResult == null || listReservationsResult != null && CollectionUtils.isEmpty((Collection)listReservationsResult.getItems())) {
            return listReservationsResult;
        }
        return this.doDecryptions(listReservationsResult);
    }

    @Profiled(logFailuresSeparately=true, tag="0.DecompressionUtil#decryptPrescriptionsWithException")
    public ListOpenPrescriptionsResultWithExceptions decryptPrescriptionsWithException(ListOpenPrescriptionsResult listOpenPrescriptionsResult) throws IntegrationModuleException {
        return new MultiThreadedExecutorListOpenPrescriptionsUseCase(this.etkHelper).executeWithExceptions(listOpenPrescriptionsResult);
    }

    @Profiled(logFailuresSeparately=true, tag="0.DecompressionUtil#decryptReservationsWithExceptions")
    public ListReservationsResultWithExceptions decryptReservationsWithExceptions(ListReservationsResult listReservationsResult) throws IntegrationModuleException {
        if (listReservationsResult == null || listReservationsResult != null && CollectionUtils.isEmpty((Collection)listReservationsResult.getItems())) {
            return new ListReservationsResultWithExceptions();
        }
        Map<ListReservationsResultItem, ReservationDecryptorThread> dataMap = this.createThreads(listReservationsResult);
        ListReservationsResultWithExceptions finalResult = new ListReservationsResultWithExceptions();
        for (ReservationDecryptorThread decryptorThread : dataMap.values()) {
            finalResult.addItem(decryptorThread.getListReservationsResultItem(), decryptorThread.getError());
        }
        finalResult.setHasMoreResults(listReservationsResult.isHasMoreResults());
        finalResult.setSession(listReservationsResult.getSession());
        return finalResult;
    }

    private ListReservationsResult doDecryptions(ListReservationsResult listReservationsResult) {
        Map<ListReservationsResultItem, ReservationDecryptorThread> dataMap = this.createThreads(listReservationsResult);
        ListReservationsResult finalResult = new ListReservationsResult();
        for (ReservationDecryptorThread thread : dataMap.values()) {
            finalResult.getItems().add(thread.getListReservationsResultItem());
        }
        finalResult.setHasMoreResults(listReservationsResult.isHasMoreResults());
        finalResult.setSession(listReservationsResult.getSession());
        Collections.sort(finalResult.getItems(), new Comparator<ListReservationsResultItem>(){

            @Override
            public int compare(ListReservationsResultItem f1, ListReservationsResultItem f2) {
                return f2.getCreationDate().compareTo(f1.getCreationDate());
            }
        });
        return finalResult;
    }

    private Map<ListReservationsResultItem, ReservationDecryptorThread> createThreads(ListReservationsResult listReservationsResult) {
        int threadLimit = PropertyHandler.getInstance().getIntegerProperty("decryption.thread.number", "50");
        Semaphore semaphore = new Semaphore(threadLimit, true);
        HashMap<ListReservationsResultItem, ReservationDecryptorThread> dataMap = new HashMap<ListReservationsResultItem, ReservationDecryptorThread>();
        String requestorIdInformation = StandaloneRequestorProvider.getRequestorIdInformation();
        byte[] pharmacyEtk = this.etkHelper.getEtks(KgssIdentifierType.NIHII_PHARMACY, requestorIdInformation).get(0).getEncoded();
        byte[] kgssEtk = this.etkHelper.getKGSS_ETK().get(0).getEncoded();
        for (ListReservationsResultItem listReservationResultItem : listReservationsResult.getItems()) {
            if (listReservationResultItem.getPrescription() == null || listReservationResultItem.getPrescription().getPrescription() == null) continue;
            ReservationDecryptorThread decryptorThread = new ReservationDecryptorThread(semaphore, listReservationResultItem, pharmacyEtk, kgssEtk);
            dataMap.put(listReservationResultItem, decryptorThread);
        }
        for (ReservationDecryptorThread decryptorThread : dataMap.values()) {
            semaphore.acquireUninterruptibly();
            decryptorThread.start();
        }
        try {
            semaphore.acquireUninterruptibly(threadLimit);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Incorrect Thread configuration : " + e);
        }
        return dataMap;
    }
}

