/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.prescriber;

import be.business.connector.core.services.GenericWebserviceCaller;
import be.business.connector.core.services.GenericWebserviceRequest;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.recipe.AbstractRecipeClient;
import be.business.connector.recipe.utils.JAXB;
import be.business.connector.recipe.utils.RejectedWithResponse;
import be.fgov.ehealth.recipe.core.v4.CreatePrescriptionAdministrativeInformationType;
import be.fgov.ehealth.recipe.protocol.v4.CreatePrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v4.CreatePrescriptionResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListPrescriptionsRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListPrescriptionsResponse;
import be.fgov.ehealth.recipe.protocol.v4.PutVisionForPrescriberRequest;
import be.fgov.ehealth.recipe.protocol.v4.PutVisionForPrescriberResponse;
import be.fgov.ehealth.recipe.protocol.v4.RevokePrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v4.RevokePrescriptionResponse;
import be.recipe.api.GetPrescriptionStatusResponse;
import be.recipe.api.Prescription;
import be.recipe.api.ThreadLocals;
import be.recipe.api.constraints.Rejected;
import be.recipe.api.constraints.ValidationReport;
import be.recipe.api.constraints.Violation;
import be.recipe.api.crypto.Message;
import be.recipe.api.executor.ExecutorViewer;
import be.recipe.api.patient.Patient;
import be.recipe.api.prescriber.GetPrescription;
import be.recipe.api.prescriber.GetPrescriptionStatus;
import be.recipe.api.prescriber.ListPrescriptions;
import be.recipe.api.prescriber.Prescriber;
import be.recipe.api.prescriber.PrescriberType;
import be.recipe.api.prescriber.PrescriptionService;
import be.recipe.api.prescriber.PutVisionOtherPrescribers;
import be.recipe.api.prescriber.RevokePrescription;
import be.recipe.api.projections.SearchResult;
import be.recipe.api.series.PartialResult;
import be.recipe.api.series.Window;
import be.recipe.api.time.LocalDateRange;
import be.recipe.api.viewer.AllViewer;
import be.recipe.api.viewer.ExecutorViewer;
import be.recipe.api.viewer.PatientViewer;
import be.recipe.services.core.Between;
import be.recipe.services.core.Page;
import be.recipe.services.core.PageFactory;
import be.recipe.services.core.PrescriberForPrescription;
import be.recipe.services.core.PrescriberForSearchResult;
import be.recipe.services.core.PrescriptionStatus;
import be.recipe.services.core.ResponseType;
import be.recipe.services.core.VisionOtherPrescribers;
import be.recipe.services.core.VisionType;
import be.recipe.services.prescriber.CreatePrescription;
import be.recipe.services.prescriber.CreatePrescriptionParam;
import be.recipe.services.prescriber.CreatePrescriptionResult;
import be.recipe.services.prescriber.GetPrescriptionForPrescriberParam;
import be.recipe.services.prescriber.GetPrescriptionForPrescriberResult;
import be.recipe.services.prescriber.GetPrescriptionStatusParam;
import be.recipe.services.prescriber.GetPrescriptionStatusResult;
import be.recipe.services.prescriber.ListPrescriptionsParam;
import be.recipe.services.prescriber.ListPrescriptionsResult;
import be.recipe.services.prescriber.PutVisionParam;
import be.recipe.services.prescriber.PutVisionResult;
import be.recipe.services.prescriber.RevokePrescriptionParam;
import be.recipe.services.prescriber.RevokePrescriptionResult;
import java.math.BigInteger;
import java.util.Collection;
import java8.util.Optional;
import java8.util.function.Consumer;
import java8.util.function.Function;
import java8.util.function.Supplier;
import java8.util.stream.RefStreams;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.threeten.bp.LocalDate;

public class RecipePrescriberClient
extends AbstractRecipeClient
implements PrescriptionService.Simplified {
    private static final String addressKey = "endpoint.prescriber.v4";
    private DatatypeFactory factory = DatatypeFactory.newInstance();

    public RecipePrescriberClient() throws DatatypeConfigurationException {
        super(addressKey);
    }

    public RecipePrescriberClient(Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry, Message.Cipher cipher, Supplier<String> traceId) throws DatatypeConfigurationException {
        super(addressKey, keyRegistry, cipher, traceId);
    }

    public RecipePrescriberClient(PropertyHandler properties) throws DatatypeConfigurationException {
        super(addressKey, properties);
    }

    public RecipePrescriberClient(Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry, Message.Cipher cipher, PropertyHandler properties) throws DatatypeConfigurationException {
        super(addressKey, keyRegistry, cipher, properties);
    }

    public ListPrescriptions.PartialResult<ListPrescriptions.Response.Encrypted> list(ListPrescriptions filters) {
        return this.list(this.toJAXB(filters));
    }

    public ListPrescriptions.PartialResult<ListPrescriptions.Response.Encrypted> list(ListPrescriptionsParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        ListPrescriptionsRequest payload = new ListPrescriptionsRequest();
        payload.setSecuredListPrescriptionsRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setIssueInstant(DateTime.now());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(ListPrescriptions.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:listPrescriptions\"");
        ListPrescriptionsResponse response = GenericWebserviceCaller.callGenericWebservice(request, ListPrescriptionsResponse.class);
        return this.fromJAXB(this.decrypt(response.getSecuredListPrescriptionsResponse().getSecuredContent(), ListPrescriptionsResult.class), request);
    }

    private ListPrescriptions.PartialResult<ListPrescriptions.Response.Encrypted> fromJAXB(final ListPrescriptionsResult from, Object root) {
        if (this.rejected(from.getStatus())) {
            throw new Rejected(JAXB.from(from.getStatus().getValidationReport(), root));
        }
        return ListPrescriptions.PartialResult.Simple.wrap((PartialResult)PartialResult.Simple.of((Supplier)new Supplier<Stream<ListPrescriptions.Response.Encrypted>>(){

            public Stream<ListPrescriptions.Response.Encrypted> get() {
                return StreamSupport.stream((Collection)from.getPartial().getPrescriptions()).map(RecipePrescriberClient.toListPrescriptionsResponseEncrypted());
            }
        }).hasMore(from.getPartial().isHasMoreResults())).hasHidden(from.getPartial().isHasHidden());
    }

    private static Function<ListPrescriptionsResult.Partial.Prescription, ListPrescriptions.Response.Encrypted> toListPrescriptionsResponseEncrypted() {
        return new Function<ListPrescriptionsResult.Partial.Prescription, ListPrescriptions.Response.Encrypted>(){

            public ListPrescriptions.Response.Encrypted apply(ListPrescriptionsResult.Partial.Prescription prescription) {
                return RecipePrescriberClient.toResponse(prescription);
            }
        };
    }

    private static ListPrescriptions.Response.Encrypted toResponse(ListPrescriptionsResult.Partial.Prescription prescription) {
        ListPrescriptions.Response.Encrypted.Simple response = ListPrescriptions.Response.Encrypted.Simple.response((Prescription.RID)Prescription.RID.prescriptionID((String)prescription.getRid()));
        response.creationDate = RecipePrescriberClient.fromJAXB(prescription.getDate());
        response.expirationDate = RecipePrescriberClient.fromJAXB(prescription.getValidUntil());
        response.status = Prescription.Status.valueOf((String)prescription.getStatus().name());
        response.prescriber = RecipePrescriberClient.toPrescriber(prescription.getPrescriber());
        response.visionOtherPrescribers = prescription.getVisionOtherPrescribers() != null ? be.recipe.api.prescriber.VisionOtherPrescribers.valueOf((String)prescription.getVisionOtherPrescribers().name()) : null;
        response.encryptedPrescriptionContent = prescription.getEncryptedContent();
        response.encryptionKey = prescription.getEncryptionKey();
        return response;
    }

    private static LocalDate fromJAXB(XMLGregorianCalendar from) {
        return LocalDate.of((int)from.getYear(), (int)from.getMonth(), (int)from.getDay());
    }

    private static SearchResult.Prescriber toPrescriber(PrescriberForSearchResult prescriber) {
        return SearchResult.Prescriber.Simple.type((PrescriberType)((PrescriberType)Optional.ofNullable((Object)prescriber.getType()).map((Function)new Function<String, PrescriberType>(){

            public PrescriberType apply(String it) {
                return PrescriberType.valueOf((String)it);
            }
        }).orElse(null))).id(Prescriber.ID.prescriberID((String)prescriber.getId()));
    }

    private ListPrescriptionsParam toJAXB(ListPrescriptions request) {
        ListPrescriptionsParam params = new ListPrescriptionsParam();
        params.setPatientId(request.patient == null ? null : request.patient.toString());
        params.setStatus(this.toJAXB(request.status));
        params.setBetween(this.toJAXB(request.between));
        params.setExpiringBetween(this.toJAXB(request.expiringBetween));
        params.setPrescriberId(this.toJAXB(request.prescriberId));
        if (request.window.offset > 0) {
            params.setPage(this.toJAXB(request.window));
        }
        params.setSortOptions(JAXB.toJAXB(request.sortedBy));
        return params;
    }

    private String toJAXB(Prescriber.ID prescriberId) {
        if (prescriberId == null) {
            return null;
        }
        return prescriberId.toString();
    }

    private Between toJAXB(LocalDateRange from) {
        if (from == null) {
            return null;
        }
        Between to = new Between();
        to.setFrom(this.toJAXB(from.getStart()));
        to.setToInclusive(this.toJAXB(from.getEndInclusive()));
        return to;
    }

    private XMLGregorianCalendar toJAXB(LocalDate dt) {
        return this.factory.newXMLGregorianCalendar(dt.toString());
    }

    private ListPrescriptionsParam.Status toJAXB(Prescription.Status[] status) {
        if (status == null) {
            return null;
        }
        ListPrescriptionsParam.Status to = new ListPrescriptionsParam.Status();
        RefStreams.of((Object[])status).map(this.toPrescriptionStatus()).forEach(RecipePrescriberClient.setStatus(to));
        return to;
    }

    private static Consumer<PrescriptionStatus> setStatus(final ListPrescriptionsParam.Status to) {
        return new Consumer<PrescriptionStatus>(){

            public void accept(PrescriptionStatus it) {
                to.getStatuses().add(it);
            }
        };
    }

    private Function<Prescription.Status, PrescriptionStatus> toPrescriptionStatus() {
        return new Function<Prescription.Status, PrescriptionStatus>(){

            public PrescriptionStatus apply(Prescription.Status status) {
                return RecipePrescriberClient.this.toJAXB(status);
            }
        };
    }

    private PrescriptionStatus toJAXB(Prescription.Status status) {
        return PrescriptionStatus.valueOf((String)status.name());
    }

    private Page toJAXB(Window from) {
        Page to = PageFactory.defaultPage();
        BigInteger offset = BigInteger.valueOf(from.offset);
        BigInteger pageSize = BigInteger.valueOf(from.count);
        to.setPageNumber(offset.divide(pageSize));
        return to;
    }

    public Prescription.Encrypted get(GetPrescription request) {
        return this.get(this.toJAXB(request));
    }

    private Prescription.Encrypted get(GetPrescriptionForPrescriberParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        GetPrescriptionRequest payload = new GetPrescriptionRequest();
        payload.setSecuredGetPrescriptionRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setIssueInstant(DateTime.now());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(GetPrescription.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:getPrescription\"");
        GetPrescriptionResponse response = GenericWebserviceCaller.callGenericWebservice(request, GetPrescriptionResponse.class);
        return this.fromJAXB(this.decrypt(response.getSecuredGetPrescriptionResponse().getSecuredContent(), GetPrescriptionForPrescriberResult.class), params);
    }

    public GetPrescriptionStatusResponse get(GetPrescriptionStatus request) {
        return this.get(this.toJAXB(request));
    }

    private GetPrescriptionStatusResponse get(GetPrescriptionStatusParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        GetPrescriptionStatusRequest payload = new GetPrescriptionStatusRequest();
        payload.setSecuredGetPrescriptionStatusRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setIssueInstant(DateTime.now());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(GetPrescriptionStatus.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:getPrescriptionStatus\"");
        be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusResponse response = GenericWebserviceCaller.callGenericWebservice(request, be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusResponse.class);
        return this.fromJAXB(this.decrypt(response.getSecuredGetPrescriptionStatusResponse().getSecuredContent(), GetPrescriptionStatusResult.class));
    }

    private GetPrescriptionStatusResponse fromJAXB(GetPrescriptionStatusResult from) {
        return GetPrescriptionStatusResponse.Simple.response().status(JAXB.from(from.getPrescriptionStatus())).executor(JAXB.executor(from.getExecutorId()));
    }

    private GetPrescriptionStatusParam toJAXB(GetPrescriptionStatus from) {
        GetPrescriptionStatusParam to = new GetPrescriptionStatusParam();
        to.setRid(from.rid.toString());
        return to;
    }

    private Prescription.Encrypted fromJAXB(GetPrescriptionForPrescriberResult from, GetPrescriptionForPrescriberParam root) {
        if (this.rejected(from.getStatus())) {
            throw new Rejected(RecipePrescriberClient.fromJAXB(from.getStatus().getMessageCode(), root));
        }
        PrescriptionWithGetResult to = new PrescriptionWithGetResult();
        to.result = from;
        to.setRid(Prescription.RID.prescriptionID((String)from.getRid()));
        to.setPrescriber(this.fromJAXB(from.getPrescriber()));
        to.setPatient((Patient)new Patient.Simple(Patient.ID.patientID((String)from.getPatientId())));
        to.setCreationDate(RecipePrescriberClient.toLocalDateTime(from.getCreationDate()));
        to.setEncryptedContent(from.getPrescription());
        to.setEncryptionKey(from.getEncryptionKeyId());
        to.setFeedbackAllowed(from.isFeedbackAllowed());
        to.setStatus(Prescription.Status.valueOf((String)from.getPrescriptionStatus().name()));
        to.setExpirationDate(RecipePrescriberClient.toLocalDate(from.getExpirationDate()));
        return to;
    }

    static ValidationReport fromJAXB(String code, GetPrescriptionForPrescriberParam root) {
        Violation.Simple.Builder violation = Violation.Simple.violation((String)code);
        if (code.equals("error.prescription.rid.unknown")) {
            violation.on("prescriptionId").value((Object)root.getRid());
        }
        return ValidationReport.Simple.from((Violation.Simple.Builder[])new Violation.Simple.Builder[]{violation});
    }

    private Prescriber fromJAXB(PrescriberForPrescription from) {
        return new Prescriber.Simple(Prescriber.ID.prescriberID((String)from.getId()), PrescriberType.valueOf((String)from.getType()));
    }

    private GetPrescriptionForPrescriberParam toJAXB(GetPrescription from) {
        GetPrescriptionForPrescriberParam to = new GetPrescriptionForPrescriberParam();
        to.setRid(from.rid.toString());
        return to;
    }

    public Prescription.Encrypted add(be.recipe.api.prescriber.CreatePrescription<Prescription.Encrypted.Specification> request) {
        return this.add(this.toJAXB(request), request);
    }

    private Prescription.Encrypted add(CreatePrescriptionParam params, be.recipe.api.prescriber.CreatePrescription<Prescription.Encrypted.Specification> from) {
        params.setSymmKey(this.symmKey.getEncoded());
        CreatePrescriptionRequest payload = new CreatePrescriptionRequest();
        payload.setAdministrativeInformation(this.translate(params, from.customizations));
        payload.setSecuredCreatePrescriptionRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        payload.setIssueInstant(DateTime.now());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(CreatePrescription.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:createPrescription\"");
        CreatePrescriptionResponse response = GenericWebserviceCaller.callGenericWebservice(request, CreatePrescriptionResponse.class);
        return this.fromJAXB(this.decrypt(response.getSecuredCreatePrescriptionResponse().getSecuredContent(), CreatePrescriptionResult.class), params);
    }

    private CreatePrescriptionAdministrativeInformationType translate(CreatePrescriptionParam from, Prescription.Specification customizations) {
        CreatePrescriptionAdministrativeInformationType to = new CreatePrescriptionAdministrativeInformationType();
        to.setPrescriptionType(from.getPrescriptionType());
        to.setPrescriptionVersion(this.properties.getProperty("prescription.version"));
        to.setReferenceSourceVersion(customizations.productCode.toString());
        to.setKeyIdentifier(from.getKeyId().getBytes());
        return to;
    }

    private Prescription.Encrypted fromJAXB(CreatePrescriptionResult from, CreatePrescriptionParam params) {
        if (this.rejected(from.getStatus())) {
            throw new RejectedWithResponse(JAXB.from(from.getStatus().getValidationReport(), (Object)from), (ResponseType)from);
        }
        Prescription.Encrypted.Simple to = new Prescription.Encrypted.Simple();
        to.rid(Prescription.RID.prescriptionID((String)from.getRid()));
        return to;
    }

    private CreatePrescriptionParam toJAXB(final be.recipe.api.prescriber.CreatePrescription<Prescription.Encrypted.Specification> from) {
        CreatePrescriptionParam to = new CreatePrescriptionParam();
        to.setPatientId(((Prescription.Encrypted.Specification)from.customizations).patient.id().toString());
        to.setPrescription(((Prescription.Encrypted.Specification)from.customizations).encryptedContent);
        to.setPrescriptionType(((Prescription.Encrypted.Specification)from.customizations).type.toString());
        to.setFeedbackRequested(((Prescription.Encrypted.Specification)from.customizations).feedbackAllowed);
        to.setKeyId(((Prescription.Encrypted.Specification)from.customizations).encryptionKeyId);
        to.setExpirationDate((String)Optional.ofNullable((Object)ThreadLocals.expirationDate()).orElseGet((Supplier)new Supplier<String>(){

            public String get() {
                return ((Prescription.Encrypted.Specification)from.customizations).expirationDate == null ? null : ((Prescription.Encrypted.Specification)from.customizations).expirationDate.toString();
            }
        }));
        to.setVision(this.toJAXB(((Prescription.Encrypted.Specification)from.customizations).visibleToExecutor));
        to.setVisionOtherPrescribers(RecipePrescriberClient.toJAXB(((Prescription.Encrypted.Specification)from.customizations).visionOtherPrescribers));
        return to;
    }

    private String toJAXB(be.recipe.api.executor.ExecutorViewer viewer) {
        final ViewerToStringProcessor processor = new ViewerToStringProcessor();
        processor.all = "";
        Optional.ofNullable((Object)viewer).ifPresent((Consumer)new Consumer<be.recipe.api.executor.ExecutorViewer>(){

            public void accept(be.recipe.api.executor.ExecutorViewer it) {
                it.visit((ExecutorViewer.Visitor)processor);
            }
        });
        return processor.toString();
    }

    public static VisionOtherPrescribers toJAXB(be.recipe.api.prescriber.VisionOtherPrescribers it) {
        return (VisionOtherPrescribers)Optional.ofNullable((Object)it).map((Function)new Function<be.recipe.api.prescriber.VisionOtherPrescribers, VisionOtherPrescribers>(){

            public VisionOtherPrescribers apply(be.recipe.api.prescriber.VisionOtherPrescribers from) {
                return VisionOtherPrescribers.valueOf((String)from.name());
            }
        }).orElse(null);
    }

    public void update(PutVisionOtherPrescribers request) {
        this.update(this.toJAXB(request), PutVisionOtherPrescribers.class);
    }

    private void update(PutVisionParam params, Class<?> usecaseType) {
        params.setSymmKey(this.symmKey.getEncoded());
        PutVisionForPrescriberRequest payload = new PutVisionForPrescriberRequest();
        payload.setSecuredPutVisionForPrescriberRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setIssueInstant(DateTime.now());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(usecaseType.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:putVisionForPrescriber\"");
        PutVisionForPrescriberResponse response = GenericWebserviceCaller.callGenericWebservice(request, PutVisionForPrescriberResponse.class);
        PutVisionResult result = this.decrypt(response.getSecuredPutVisionForPrescriberResponse().getSecuredContent(), PutVisionResult.class);
        if (this.rejected(result.getStatus())) {
            throw new Rejected(JAXB.from(result.getStatus().getValidationReport(), (Object)result));
        }
    }

    private PutVisionParam toJAXB(PutVisionOtherPrescribers from) {
        PutVisionParam to = new PutVisionParam();
        to.setType(VisionType.PRESCRIBER);
        to.setRid((String)Optional.ofNullable((Object)from.prescription).map(RecipePrescriberClient.toText()).orElse(null));
        to.setVisionOtherPrescribers((VisionOtherPrescribers)Optional.ofNullable((Object)from.vision).map(RecipePrescriberClient.toName()).map(RecipePrescriberClient.toVisionOtherPrescribers()).orElse(null));
        return to;
    }

    private static Function<String, VisionOtherPrescribers> toVisionOtherPrescribers() {
        return new Function<String, VisionOtherPrescribers>(){

            public VisionOtherPrescribers apply(String it) {
                return VisionOtherPrescribers.valueOf((String)it);
            }
        };
    }

    public void update(RevokePrescription request) {
        this.update(this.toJAXB(request));
    }

    private void update(RevokePrescriptionParam params) {
        params.setSymmKey(this.symmKey.getEncoded());
        RevokePrescriptionRequest payload = new RevokePrescriptionRequest();
        payload.setSecuredRevokePrescriptionRequest(this.content(this.encrypt(params)));
        payload.setProgramId(this.programId());
        payload.setId((String)this.traceId.get());
        GenericWebserviceRequest request = new GenericWebserviceRequest();
        request.setRequest(payload.unwrap());
        request.setRequestType(((Object)((Object)payload)).getClass());
        request.setEndpoint(this.address);
        request.setServiceName(RevokePrescription.class.getSimpleName());
        request.setAddLoggingHandler(true);
        request.setAddSoapFaultHandler(true);
        request.setAddInsurabilityHandler(true);
        request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:revokePrescription\"");
        RevokePrescriptionResponse response = GenericWebserviceCaller.callGenericWebservice(request, RevokePrescriptionResponse.class);
        RevokePrescriptionResult result = this.decrypt(response.getSecuredRevokePrescriptionResponse().getSecuredContent(), RevokePrescriptionResult.class);
        if (this.rejected(result.getStatus())) {
            throw new RejectedWithResponse(JAXB.from(result.getStatus().getValidationReport(), (Object)result), (ResponseType)result);
        }
    }

    private RevokePrescriptionParam toJAXB(RevokePrescription from) {
        RevokePrescriptionParam to = new RevokePrescriptionParam();
        to.setRid(from.rid.toString());
        to.setReason("-");
        return to;
    }

    private static class ViewerToStringProcessor
    implements ExecutorViewer.Visitor {
        private String visi;
        String all;

        private ViewerToStringProcessor() {
        }

        public void on(AllViewer it) {
            this.visi = this.all;
        }

        public void on(PatientViewer it) {
            this.visi = "locked";
        }

        public void on(ExecutorViewer it) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.visi;
        }
    }

    public static class PrescriptionWithGetResult
    extends Prescription.Encrypted.Simple {
        public GetPrescriptionForPrescriberResult result;
    }
}

