/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.prescriber;

import be.business.connector.common.ApplicationConfig;
import be.business.connector.core.domain.KgssIdentifierType;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.Exceptionutils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.IOUtils;
import be.business.connector.core.utils.MarshallerHelper;
import be.business.connector.core.utils.OnlineProperties;
import be.business.connector.core.utils.OnlinePropertiesHolder;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.projects.common.utils.ValidationUtils;
import be.business.connector.recipe.AbstractRecipeClient;
import be.business.connector.recipe.prescriber.AbstractPrescriberIntegrationModule;
import be.business.connector.recipe.prescriber.PrescriberIntegrationModuleV4;
import be.business.connector.recipe.prescriber.RecipePrescriberClient;
import be.business.connector.recipe.prescriber.domain.ListFeedbackItem;
import be.business.connector.recipe.prescriber.dto.CreatePrescriptionDTO;
import be.business.connector.recipe.prescriber.services.RecipePrescriberServiceV4Impl;
import be.business.connector.recipe.utils.RidValidator;
import be.business.connector.recipe.utils.prescribercreatebulkprescriptions.PrescriberCreateBulkPrescriptionsUseCase;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.recipe.core.v4.CreatePrescriptionAdministrativeInformationType;
import be.fgov.ehealth.recipe.protocol.v4.CreatePrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v4.CreatePrescriptionResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetValidationPropertiesRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetValidationPropertiesResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListFeedbacksRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListFeedbacksResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListOpenRidsRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListOpenRidsResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListRidsHistoryRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListRidsHistoryResponse;
import be.fgov.ehealth.recipe.protocol.v4.PutFeedbackFlagRequest;
import be.fgov.ehealth.recipe.protocol.v4.PutFeedbackFlagResponse;
import be.fgov.ehealth.recipe.protocol.v4.PutVisionForPrescriberRequest;
import be.fgov.ehealth.recipe.protocol.v4.PutVisionForPrescriberResponse;
import be.fgov.ehealth.recipe.protocol.v4.RevokePrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v4.RevokePrescriptionResponse;
import be.fgov.ehealth.recipe.protocol.v4.SendNotificationRequest;
import be.fgov.ehealth.recipe.protocol.v4.SendNotificationResponse;
import be.recipe.api.Prescription;
import be.recipe.api.PrescriptionContent;
import be.recipe.api.patient.Patient;
import be.recipe.api.prescriber.VisionOtherPrescribers;
import be.recipe.services.core.ResponseType;
import be.recipe.services.prescriber.CreatePrescriptionParam;
import be.recipe.services.prescriber.CreatePrescriptionResult;
import be.recipe.services.prescriber.GetPrescriptionForPrescriberParam;
import be.recipe.services.prescriber.GetPrescriptionForPrescriberResult;
import be.recipe.services.prescriber.GetPrescriptionStatusParam;
import be.recipe.services.prescriber.GetPrescriptionStatusResult;
import be.recipe.services.prescriber.ListFeedbacksParam;
import be.recipe.services.prescriber.ListFeedbacksResult;
import be.recipe.services.prescriber.ListOpenRidsParam;
import be.recipe.services.prescriber.ListOpenRidsResult;
import be.recipe.services.prescriber.ListRidsHistoryParam;
import be.recipe.services.prescriber.ListRidsHistoryResult;
import be.recipe.services.prescriber.PutVisionParam;
import be.recipe.services.prescriber.PutVisionResult;
import be.recipe.services.prescriber.RevokePrescriptionParam;
import be.recipe.services.prescriber.RevokePrescriptionResult;
import be.recipe.services.prescriber.SendNotificationParam;
import be.recipe.services.prescriber.SendNotificationResult;
import be.recipe.services.prescriber.UpdateFeedbackFlagParam;
import be.recipe.services.prescriber.UpdateFeedbackFlagResult;
import be.recipe.services.prescriber.ValidationPropertiesParam;
import be.recipe.services.prescriber.ValidationPropertiesResult;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.validation.Schema;
import javax.xml.ws.WebServiceException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrescriberIntegrationModuleV4Impl
extends AbstractPrescriberIntegrationModule
implements PrescriberIntegrationModuleV4 {
    private static final Logger LOG = LoggerFactory.getLogger(PrescriberIntegrationModuleV4Impl.class);
    final MarshallerHelper<CreatePrescriptionResult, CreatePrescriptionParam> helper = new MarshallerHelper<CreatePrescriptionResult, CreatePrescriptionParam>(CreatePrescriptionResult.class, CreatePrescriptionParam.class);
    private final PrescriberCreateBulkPrescriptionsUseCase encryptionUtils = new PrescriberCreateBulkPrescriptionsUseCase(PropertyHandler.getInstance(), EncryptionUtils.getInstance(), this.keyCache);

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#createPrescription")
    public String createPrescription(boolean feedbackRequested, String patientId, byte[] prescription, String prescriptionType) {
        return this.createPrescription(feedbackRequested, patientId, prescription, prescriptionType, null, this.getDefaultExpirationDate());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#createPrescription")
    public String createPrescription(boolean feedbackRequested, String patientId, byte[] prescription, String prescriptionType, String visi, String expirationDate) {
        return this.createPrescription(feedbackRequested, patientId, prescription, prescriptionType, visi, null, expirationDate);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#createPrescription")
    public String createPrescription(boolean feedbackRequested, String patientId, byte[] prescription, String prescriptionType, String visi, VisionOtherPrescribers visionOtherPrescribers, String expirationDate) {
        ApplicationConfig.getInstance().assertValidSession();
        ValidationUtils.validatePatientId(patientId);
        ValidationUtils.validateVisi(visi, false);
        try {
            PropertyHandler propertyHandler = PropertyHandler.getInstance();
            ValidationUtils.validateExpirationDate(expirationDate);
            this.validateKmehr(prescription, prescriptionType, expirationDate);
            List<EncryptionToken> etkRecipes = this.getEtkHelper().getRecipe_ETK();
            byte[] message = IOUtils.compress(prescription);
            PrescriptionContent.Encrypted enciphered = this.prescriptionContentFactory.create(message).encrypt(Patient.ID.patientID((String)patientId), Prescription.Type.prescriptionType((String)prescriptionType));
            message = enciphered.bytes();
            CreatePrescriptionParam params = new CreatePrescriptionParam();
            params.setPrescription(message);
            params.setPrescriptionType(prescriptionType);
            params.setFeedbackRequested(feedbackRequested);
            params.setKeyId(enciphered.key().toString());
            params.setSymmKey(this.getSymmKey().getEncoded());
            params.setPatientId(patientId);
            params.setExpirationDate(expirationDate);
            params.setVision(visi);
            params.setVisionOtherPrescribers(RecipePrescriberClient.toJAXB(visionOtherPrescribers));
            CreatePrescriptionRequest request = new CreatePrescriptionRequest();
            byte[] xmlBytes = this.helper.toXMLByteArray(params);
            request.setSecuredCreatePrescriptionRequest(this.createSecuredContentType(this.sealRequest(etkRecipes.get(0), xmlBytes)));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setId(this.getId());
            request.setIssueInstant(new DateTime());
            CreatePrescriptionAdministrativeInformationType adminValue = new CreatePrescriptionAdministrativeInformationType();
            adminValue.setKeyIdentifier(enciphered.key().toString().getBytes());
            adminValue.setPrescriptionVersion(PropertyHandler.getInstance().getProperty("prescription.version"));
            adminValue.setReferenceSourceVersion(PrescriberIntegrationModuleV4Impl.extractReferenceSourceVersionFromKmehr(prescription));
            adminValue.setPrescriptionType(prescriptionType);
            request.setAdministrativeInformation(adminValue);
            CreatePrescriptionResponse response = RecipePrescriberServiceV4Impl.getInstance().createPrescription(request);
            CreatePrescriptionResult result = this.helper.unsealWithSymmKey(response.getSecuredCreatePrescriptionResponse().getSecuredContent(), this.getSymmKey());
            this.checkStatus((ResponseType)result);
            return result.getRid();
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#createPrescriptions")
    public List<CreatePrescriptionDTO> createPrescriptions(List<CreatePrescriptionDTO> dtos) {
        ApplicationConfig.getInstance().assertValidSession();
        this.validateCreatePrescriptionDTOs(dtos);
        try {
            return this.encryptionUtils.execute(dtos, this);
        }
        catch (TechnicalConnectorException e) {
            Exceptionutils.errorHandler(e);
            return Collections.emptyList();
        }
    }

    private String getDefaultExpirationDate() {
        Calendar defaultExpirationDate = Calendar.getInstance();
        defaultExpirationDate.add(2, 3);
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(defaultExpirationDate.getTime());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="PrescriberIntegrationModule#prepareCreatePrescription")
    public void prepareCreatePrescription(String patientId) {
        ApplicationConfig.getInstance().assertValidSession();
        this.getEtkHelper().getRecipe_ETK();
        this.getEtkHelper().getKGSS_ETK();
        this.getEtkHelper().getSystemETK();
        if (!this.keyCache.containsKey(patientId)) {
            this.keyCache.put(patientId, this.getNewKeyFromKgss(patientId));
        }
        try {
            EncryptionUtils.getInstance().initSealing();
            EncryptionUtils.getInstance().initUnsealing();
        }
        catch (Exception e) {
            LOG.error("Failed to store the online properties to disk", (Throwable)e);
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#getPrescription")
    public GetPrescriptionForPrescriberResult getPrescription(String rid) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidSession();
        try {
            MarshallerHelper<GetPrescriptionForPrescriberResult, GetPrescriptionForPrescriberParam> helper = new MarshallerHelper<GetPrescriptionForPrescriberResult, GetPrescriptionForPrescriberParam>(GetPrescriptionForPrescriberResult.class, GetPrescriptionForPrescriberParam.class);
            GetPrescriptionForPrescriberParam param = new GetPrescriptionForPrescriberParam();
            param.setRid(rid);
            param.setSymmKey(this.getSymmKey().getEncoded());
            GetPrescriptionRequest request = new GetPrescriptionRequest();
            request.setSecuredGetPrescriptionRequest(this.createSecuredContentType(this.sealForRecipe(param, GetPrescriptionForPrescriberParam.class)));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            GetPrescriptionResponse response = null;
            try {
                response = RecipePrescriberServiceV4Impl.getInstance().getPrescriptionForPrescriber(request);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.prescriber"), cte);
            }
            GetPrescriptionForPrescriberResult result = helper.unsealWithSymmKey(response.getSecuredGetPrescriptionResponse().getSecuredContent(), this.getSymmKey());
            this.checkStatus((ResponseType)result);
            if (result.getPrescription() != null) {
                KeyResult key = this.getKeyFromKgss(result.getEncryptionKeyId(), this.getEtkHelper().getSystemETK().get(0).getEncoded());
                byte[] unsealedPrescription = IOUtils.decompress(this.unsealPrescriptionForUnknown(key, result.getPrescription()));
                result.setPrescription(unsealedPrescription);
            }
            return result;
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#revokePrescription")
    public void revokePrescription(String rid, String reason) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidSession();
        try {
            MarshallerHelper<Object, RevokePrescriptionParam> helper = new MarshallerHelper<Object, RevokePrescriptionParam>(Object.class, RevokePrescriptionParam.class);
            List<EncryptionToken> etkRecipes = this.getEtkHelper().getRecipe_ETK();
            RevokePrescriptionParam params = new RevokePrescriptionParam();
            params.setRid(rid);
            params.setReason(reason);
            params.setSymmKey(this.getSymmKey().getEncoded());
            RevokePrescriptionRequest request = new RevokePrescriptionRequest();
            request.setSecuredRevokePrescriptionRequest(this.createSecuredContentType(this.sealRequest(etkRecipes.get(0), helper.toXMLByteArray(params))));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            try {
                RevokePrescriptionResponse response = RecipePrescriberServiceV4Impl.getInstance().revokePrescription(request);
                MarshallerHelper<RevokePrescriptionResult, Object> marshaller = new MarshallerHelper<RevokePrescriptionResult, Object>(RevokePrescriptionResult.class, Object.class);
                RevokePrescriptionResult result = marshaller.unsealWithSymmKey(response.getSecuredRevokePrescriptionResponse().getSecuredContent(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.prescriber"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
        }
    }

    @Override
    public void sendNotification(byte[] notificationText, String patientId, String executorId) {
        this.sendNotification(notificationText, patientId, executorId, executorId);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="PrescriberIntegrationModule#sendNotification")
    public void sendNotification(byte[] notificationText, String patientId, String executorId, String hospitalId) {
        ApplicationConfig.getInstance().assertValidSession();
        try {
            this.getKmehrHelper().assertValidNotification(notificationText);
            ValidationUtils.validatePatientId(patientId);
            MarshallerHelper<Object, SendNotificationParam> helper = new MarshallerHelper<Object, SendNotificationParam>(Object.class, SendNotificationParam.class);
            List<EncryptionToken> etkRecipes = this.getEtkHelper().getRecipe_ETK();
            ArrayList<EncryptionToken> etkRecipients = new ArrayList<EncryptionToken>();
            try {
                etkRecipients.addAll(this.getEtkHelper().getEtks(KgssIdentifierType.NIHII, executorId));
            }
            catch (Exception e) {
                try {
                    etkRecipients.addAll(this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_PHARMACY, executorId));
                }
                catch (Exception e1) {
                    try {
                        etkRecipients.addAll(this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_HOSPITAL, hospitalId));
                    }
                    catch (Exception e2) {
                        Exceptionutils.errorHandler(e1, e.getMessage() + e2.getMessage());
                    }
                }
            }
            byte[] notificationZip = IOUtils.compress(notificationText);
            for (int i = 0; i < etkRecipients.size(); ++i) {
                EncryptionToken etkRecipient = (EncryptionToken)etkRecipients.get(0);
                byte[] notificationSealed = this.sealNotification(etkRecipient, notificationZip);
                SendNotificationParam param = new SendNotificationParam();
                param.setContent(notificationSealed);
                param.setExecutorId(executorId);
                param.setPatientId(patientId);
                param.setSymmKey(this.getSymmKey().getEncoded());
                SendNotificationRequest request = new SendNotificationRequest();
                request.setSecuredSendNotificationRequest(this.createSecuredContentType(this.sealRequest(etkRecipes.get(0), helper.toXMLByteArray(param))));
                request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
                request.setIssueInstant(new DateTime());
                request.setId(this.getId());
                try {
                    SendNotificationResponse response = RecipePrescriberServiceV4Impl.getInstance().sendNotification(request);
                    MarshallerHelper<SendNotificationResult, SendNotificationResult> helper1 = new MarshallerHelper<SendNotificationResult, SendNotificationResult>(SendNotificationResult.class, SendNotificationResult.class);
                    SendNotificationResult result = helper1.unsealWithSymmKey(response.getSecuredSendNotificationResponse().getSecuredContent(), this.getSymmKey());
                    this.checkStatus((ResponseType)result);
                    continue;
                }
                catch (WebServiceException cte) {
                    throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.prescriber"), cte);
                }
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#updateFeedbackFlag")
    public void updateFeedbackFlag(String rid, boolean feedbackAllowed) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidSession();
        try {
            MarshallerHelper<Object, UpdateFeedbackFlagParam> helper = new MarshallerHelper<Object, UpdateFeedbackFlagParam>(Object.class, UpdateFeedbackFlagParam.class);
            List<EncryptionToken> etkRecipes = this.getEtkHelper().getRecipe_ETK();
            UpdateFeedbackFlagParam param = new UpdateFeedbackFlagParam();
            param.setAllowFeedback(feedbackAllowed);
            param.setRid(rid);
            param.setSymmKey(this.getSymmKey().getEncoded());
            PutFeedbackFlagRequest request = new PutFeedbackFlagRequest();
            request.setSecuredPutFeedbackFlagRequest(this.createSecuredContentType(this.sealRequest(etkRecipes.get(0), helper.toXMLByteArray(param))));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            try {
                PutFeedbackFlagResponse response = RecipePrescriberServiceV4Impl.getInstance().putFeedbackFlag(request);
                MarshallerHelper<UpdateFeedbackFlagResult, UpdateFeedbackFlagResult> helper2 = new MarshallerHelper<UpdateFeedbackFlagResult, UpdateFeedbackFlagResult>(UpdateFeedbackFlagResult.class, UpdateFeedbackFlagResult.class);
                UpdateFeedbackFlagResult result = helper2.unsealWithSymmKey(response.getSecuredPutFeedbackFlagResponse().getSecuredContent(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.prescriber"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#listFeedback")
    public List<be.recipe.services.prescriber.ListFeedbackItem> listFeedback(boolean readFlag) {
        ApplicationConfig.getInstance().assertValidSession();
        try {
            MarshallerHelper<ListFeedbacksResult, ListFeedbacksParam> helper = new MarshallerHelper<ListFeedbacksResult, ListFeedbacksParam>(ListFeedbacksResult.class, ListFeedbacksParam.class);
            List<EncryptionToken> etkRecipes = this.getEtkHelper().getRecipe_ETK();
            ListFeedbacksParam param = new ListFeedbacksParam();
            param.setReadFlag(readFlag);
            param.setSymmKey(this.getSymmKey().getEncoded());
            ListFeedbacksRequest request = new ListFeedbacksRequest();
            request.setSecuredListFeedbacksRequest(this.createSecuredContentType(this.sealRequest(etkRecipes.get(0), helper.toXMLByteArray(param))));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            ListFeedbacksResponse response = null;
            try {
                response = RecipePrescriberServiceV4Impl.getInstance().listFeedbacks(request);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.prescriber"), cte);
            }
            ListFeedbacksResult result = helper.unsealWithSymmKey(response.getSecuredListFeedbacksResponse().getSecuredContent(), this.getSymmKey());
            this.checkStatus((ResponseType)result);
            List feedbacks = result.getFeedbacks();
            for (int i = 0; i < feedbacks.size(); ++i) {
                ListFeedbackItem item = new ListFeedbackItem((be.recipe.services.prescriber.ListFeedbackItem)feedbacks.get(i));
                byte[] content = item.getContent();
                try {
                    content = this.unsealFeedback(content);
                    content = content == null ? content : IOUtils.decompress(content);
                    item.setContent(content);
                }
                catch (Throwable t) {
                    item.setLinkedException(t);
                }
                feedbacks.set(i, item);
            }
            return feedbacks;
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#getData(ValidationPropertiesParam)")
    public ValidationPropertiesResult getData(ValidationPropertiesParam param) {
        ApplicationConfig.getInstance().assertValidSession();
        if (!OnlineProperties.isLoaded()) {
            try {
                GetValidationPropertiesRequest validationProperties = this.getValidationProperties(param);
                GetValidationPropertiesResponse response = RecipePrescriberServiceV4Impl.getInstance().getValidationProperties(validationProperties);
                ValidationPropertiesResult result = this.unsealValidationPropertiesResponse(response);
                this.checkStatus((ResponseType)result);
                OnlineProperties onlineProperties = OnlinePropertiesHolder.getInstance();
                ValidationPropertiesResult.Properties properties = result.getProperties();
                String clientVersion = this.readPropertiesVersionFromDisk();
                if (result.getServerPropertiesVersion() == null || result.getServerPropertiesVersion() != null && result.getServerPropertiesVersion().equals("")) {
                    this.deleteOnlineProperties();
                } else if (result.getServerPropertiesVersion() != null && clientVersion != null && !result.getServerPropertiesVersion().equals(clientVersion)) {
                    this.deleteOnlineProperties();
                }
                if (StringUtils.isNotBlank((String)result.getServerPropertiesVersion()) && !result.getServerPropertiesVersion().equals(clientVersion)) {
                    HashMap<String, String> targetProperties = new HashMap<String, String>();
                    if (properties != null && CollectionUtils.isNotEmpty((Collection)properties.getEntries())) {
                        for (ValidationPropertiesResult.Properties.Entry obj : properties.getEntries()) {
                            targetProperties.put(obj.getKey(), obj.getValue());
                        }
                        onlineProperties.setProperties(targetProperties);
                    }
                    if (result.getXsdValidationFiles() != null && CollectionUtils.isNotEmpty((Collection)result.getXsdValidationFiles().getEntries())) {
                        ValidationPropertiesResult.XsdValidationFiles xsdFiles = result.getXsdValidationFiles();
                        HashMap<String, byte[]> targetMap = new HashMap<String, byte[]>();
                        for (ValidationPropertiesResult.XsdValidationFiles.Entry item : xsdFiles.getEntries()) {
                            targetMap.put(item.getKey(), item.getValue());
                        }
                        onlineProperties.setXsdValidationFiles(targetMap);
                        OnlinePropertiesHolder.setXsdSet(true);
                        this.storeXsdsOnDisk(targetMap);
                        for (ValidationPropertiesResult.XsdValidationFiles.Entry item : xsdFiles.getEntries()) {
                            targetProperties.put(item.getKey().split(":")[0].replace("_", "."), this.getPropertyHandler().getProperty("online.xsd.path") + File.separator + item.getKey().split(":")[0] + File.separator + item.getKey().split(":")[1]);
                        }
                    }
                    this.storePropertiesVersionToDisk(result.getServerPropertiesVersion());
                    this.storePropertiesOnDisk(targetProperties);
                    OnlinePropertiesHolder.reloadProperties();
                } else {
                    this.readFromDisk();
                }
                ValidationPropertiesResult validationPropertiesResult = result;
                return validationPropertiesResult;
            }
            catch (Exception cte) {
                this.readFromDisk();
            }
            catch (Throwable t) {
                Exceptionutils.errorHandler(t);
            }
            finally {
                OnlineProperties.setLoaded(true);
            }
        }
        return null;
    }

    private void deleteOnlineProperties() {
        String directory = this.getPropertyHandler().getProperty("online.properties.file");
        try {
            FileUtils.deleteDirectory((File)new File(directory));
        }
        catch (IOException e) {
            LOG.error("Failed to delete online properties from local cache", (Throwable)e);
        }
    }

    protected GetValidationPropertiesRequest getValidationProperties(ValidationPropertiesParam param) {
        param.setSymmKey(this.getSymmKey().getEncoded());
        GetValidationPropertiesRequest request = new GetValidationPropertiesRequest();
        request.setSecuredGetValidationPropertiesRequest(this.createSecuredContentType(this.getSealedData(param)));
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setIssueInstant(new DateTime());
        request.setId(this.getId());
        return request;
    }

    @Override
    protected byte[] getSealedData(ValidationPropertiesParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(data, ValidationPropertiesParam.class);
    }

    public <T> byte[] sealForRecipe(T data, Class<T> type) {
        MarshallerHelper<Object, T> helper = new MarshallerHelper<Object, T>(Object.class, type);
        EncryptionToken etkRecipe = this.getEtkHelper().getRecipe_ETK().get(0);
        return this.sealRequest(etkRecipe, helper.toXMLByteArray(data));
    }

    private void storePropertiesOnDisk(Map<String, String> map) {
        if (CollectionUtils.isNotEmpty(map.values())) {
            try {
                Properties temp = new Properties();
                for (String key : map.keySet()) {
                    temp.put(key, map.get(key));
                }
                temp.store(new FileOutputStream(this.getPropertyHandler().getProperty("online.properties.file") + "/online.properties.txt"), null);
            }
            catch (IOException e) {
                LOG.error("Failed to store the online properties to disk", (Throwable)e);
            }
        }
    }

    private void storeXsdsOnDisk(Map<String, byte[]> xsdValidationFile) {
        if (CollectionUtils.isNotEmpty(xsdValidationFile.values())) {
            for (String key : xsdValidationFile.keySet()) {
                try {
                    PrescriberIntegrationModuleV4Impl.unzip(xsdValidationFile.get(key), this.getPropertyHandler().getProperty("online.xsd.path") + File.separator + key.split(":")[0]);
                }
                catch (Exception e) {
                    LOG.error("Failed to store the online xsds to disk", (Throwable)e);
                }
            }
        }
    }

    private static void unzip(byte[] compressedData, String destDir) {
        File dir = new File(destDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        byte[] buffer = new byte[1024];
        try {
            ByteArrayInputStream fis = new ByteArrayInputStream(compressedData);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(destDir + File.separator + fileName);
                LOG.debug("Unzipping to " + newFile.getAbsolutePath());
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            fis.close();
        }
        catch (IOException e) {
            LOG.error("Error while unzipping the xsd files from the server: ", (Throwable)e);
        }
    }

    private void readFromDisk() throws Exception {
        try {
            Properties prop = new Properties();
            File file = new File(this.getPropertyHandler().getProperty("online.properties.file") + "/online.properties.txt");
            if (file != null && file.exists()) {
                prop.load(new FileInputStream(file));
                OnlineProperties onlineProperties = OnlinePropertiesHolder.getInstance();
                HashMap<String, String> targetProperties = new HashMap<String, String>();
                Enumeration<Object> iterator = prop.keys();
                while (iterator.hasMoreElements()) {
                    String key = (String)iterator.nextElement();
                    targetProperties.put(key, prop.getProperty(key));
                }
                onlineProperties.setProperties(targetProperties);
                OnlinePropertiesHolder.reloadProperties();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to read online properties from disk, using default properties as default.", (Throwable)e);
        }
    }

    protected void storePropertiesVersionToDisk(String serverPropertiesVersion) {
        try {
            String path = this.getPropertyHandler().getProperty("online.properties.version.path");
            File file = new File(path + "/online.properties.version.txt");
            FileUtils.writeStringToFile((File)file, (String)serverPropertiesVersion);
        }
        catch (IOException e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readPropertiesVersionFromDisk() {
        try {
            String path = this.getPropertyHandler().getProperty("online.properties.version.path");
            File file = new File(path + "/online.properties.version.txt");
            if (!file.exists()) {
                return this.getPropertyHandler().getProperty("online.properties.version");
            }
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String st = br.readLine();
                if (st == null) {
                    String string = this.getPropertyHandler().getProperty("online.properties.version");
                    return string;
                }
                String string = st;
                return string;
            }
        }
        catch (Exception e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), e);
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#getData(GetPrescriptionStatusParam)")
    public GetPrescriptionStatusResult getData(GetPrescriptionStatusParam param) {
        RidValidator.validateRid(param.getRid());
        ApplicationConfig.getInstance().assertValidSession();
        try {
            GetPrescriptionStatusRequest getPrescriptionStatusRequest = this.getGetPrescriptionStatus(param);
            try {
                GetPrescriptionStatusResponse response = RecipePrescriberServiceV4Impl.getInstance().getPrescriptionStatus(getPrescriptionStatusRequest);
                GetPrescriptionStatusResult result = this.unsealGetPrescriptionStatusResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    public GetPrescriptionStatusRequest getGetPrescriptionStatus(GetPrescriptionStatusParam param) {
        param.setSymmKey(this.getSymmKey().getEncoded());
        GetPrescriptionStatusRequest request = new GetPrescriptionStatusRequest();
        request.setSecuredGetPrescriptionStatusRequest(this.createSecuredContentType(this.getSealedData(param)));
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setIssueInstant(new DateTime());
        request.setId(this.getId());
        return request;
    }

    public GetPrescriptionStatusResult unsealGetPrescriptionStatusResponse(GetPrescriptionStatusResponse response) {
        MarshallerHelper<GetPrescriptionStatusResult, Object> marshaller = new MarshallerHelper<GetPrescriptionStatusResult, Object>(GetPrescriptionStatusResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getSecuredGetPrescriptionStatusResponse().getSecuredContent(), this.getSymmKey());
    }

    private ValidationPropertiesResult unsealValidationPropertiesResponse(GetValidationPropertiesResponse response) {
        MarshallerHelper<ValidationPropertiesResult, Schema> marshaller = new MarshallerHelper<ValidationPropertiesResult, Schema>(ValidationPropertiesResult.class, Schema.class);
        return marshaller.unsealWithSymmKey(response.getSecuredGetValidationPropertiesResponse().getSecuredContent(), this.getSymmKey());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#getData(ListPrescriptionHistoryParam)")
    public ListRidsHistoryResult getData(ListRidsHistoryParam param) {
        ApplicationConfig.getInstance().assertValidSession();
        ValidationUtils.validatePatientId(param.getPatientId());
        try {
            ListRidsHistoryRequest listRidsHistory = this.getListPrescriptionHistoryRequest(param);
            try {
                ListRidsHistoryResponse response = RecipePrescriberServiceV4Impl.getInstance().listRidsHistory(listRidsHistory);
                ListRidsHistoryResult result = this.unsealListPrescriptionHistoryResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    private ListRidsHistoryRequest getListPrescriptionHistoryRequest(ListRidsHistoryParam listRidHistoryParam) {
        listRidHistoryParam.setSymmKey(this.getSymmKey().getEncoded());
        ListRidsHistoryRequest listRidsHistory = new ListRidsHistoryRequest();
        listRidsHistory.setSecuredListRidsHistoryRequest(this.createSecuredContentType(this.getSealedData(listRidHistoryParam)));
        listRidsHistory.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        listRidsHistory.setId(this.getId());
        listRidsHistory.setIssueInstant(new DateTime());
        return listRidsHistory;
    }

    private ListRidsHistoryResult unsealListPrescriptionHistoryResponse(ListRidsHistoryResponse response) {
        MarshallerHelper<ListRidsHistoryResult, Object> marshaller = new MarshallerHelper<ListRidsHistoryResult, Object>(ListRidsHistoryResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getSecuredListRidsHistoryResponse().getSecuredContent(), this.getSymmKey());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#putData(PutVisionParam)")
    public PutVisionResult putData(PutVisionParam param) {
        RidValidator.validateRid(param.getRid());
        ValidationUtils.validateVisi(param.getVision(), false);
        ApplicationConfig.getInstance().assertValidSession();
        try {
            PutVisionForPrescriberRequest putVision = this.putVisionRequest(param);
            try {
                PutVisionForPrescriberResponse response = RecipePrescriberServiceV4Impl.getInstance().putVisionForPrescriber(putVision);
                PutVisionResult result = this.unsealPutVisionResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    protected PutVisionForPrescriberRequest putVisionRequest(PutVisionParam param) {
        param.setSymmKey(this.getSymmKey().getEncoded());
        PutVisionForPrescriberRequest request = new PutVisionForPrescriberRequest();
        request.setSecuredPutVisionForPrescriberRequest(this.createSecuredContentType(this.getSealedData(param)));
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setIssueInstant(new DateTime());
        request.setId(this.getId());
        return request;
    }

    private PutVisionResult unsealPutVisionResponse(PutVisionForPrescriberResponse response) {
        MarshallerHelper<PutVisionResult, Object> marshaller = new MarshallerHelper<PutVisionResult, Object>(PutVisionResult.class, Object.class);
        PutVisionResult result = marshaller.unsealWithSymmKey(response.getSecuredPutVisionForPrescriberResponse().getSecuredContent(), this.getSymmKey());
        return result;
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#getData(ListOpenRidsParam)")
    public ListOpenRidsResult getData(ListOpenRidsParam param) {
        ApplicationConfig.getInstance().assertValidSession();
        ValidationUtils.validatePatientId(param.getPatientId());
        try {
            ListOpenRidsRequest listOpenRids = this.getListOpenRids(param);
            try {
                ListOpenRidsResponse response = RecipePrescriberServiceV4Impl.getInstance().listOpenRids(listOpenRids);
                ListOpenRidsResult result = this.unsealListOpenRidsResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    public ListOpenRidsRequest getListOpenRids(ListOpenRidsParam param) {
        param.setSymmKey(this.getSymmKey().getEncoded());
        ListOpenRidsRequest request = new ListOpenRidsRequest();
        request.setSecuredListOpenRidsRequest(this.createSecuredContentType(this.getSealedData(param)));
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setIssueInstant(new DateTime());
        request.setId(this.getId());
        return request;
    }

    public ListOpenRidsResult unsealListOpenRidsResponse(ListOpenRidsResponse response) {
        MarshallerHelper<ListOpenRidsResult, Object> marshaller = new MarshallerHelper<ListOpenRidsResult, Object>(ListOpenRidsResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getSecuredListOpenRidsResponse().getSecuredContent(), this.getSymmKey());
    }
}

