/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.prescriber;

import be.business.connector.common.ApplicationConfig;
import be.business.connector.core.domain.KgssIdentifierType;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.Exceptionutils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.IOUtils;
import be.business.connector.core.utils.MarshallerHelper;
import be.business.connector.core.utils.OnlineProperties;
import be.business.connector.core.utils.OnlinePropertiesHolder;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.core.utils.SessionValidator;
import be.business.connector.projects.common.utils.ValidationUtils;
import be.business.connector.recipe.AbstractRecipeClient;
import be.business.connector.recipe.prescriber.AbstractPrescriberIntegrationModule;
import be.business.connector.recipe.prescriber.PrescriberIntegrationModuleDevV4;
import be.business.connector.recipe.prescriber.PrescriberIntegrationModuleDevV4Impl;
import be.business.connector.recipe.prescriber.RecipePrescriberClient;
import be.business.connector.recipe.prescriber.domain.ListFeedbackItem;
import be.business.connector.recipe.prescriber.dto.CreatePrescriptionDTO;
import be.business.connector.recipe.prescriber.services.RecipePrescriberServiceDevV4Impl;
import be.business.connector.recipe.utils.RidValidator;
import be.business.connector.recipe.utils.prescribercreatebulkprescriptions.PrescriberCreateBulkPrescriptionsUseCase;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.recipe.api.prescriber.VisionOtherPrescribers;
import be.recipe.services.core.ResponseType;
import be.recipe.services.prescriber.CreatePrescription;
import be.recipe.services.prescriber.CreatePrescriptionParam;
import be.recipe.services.prescriber.CreatePrescriptionResponse;
import be.recipe.services.prescriber.CreatePrescriptionResult;
import be.recipe.services.prescriber.GetPrescriptionForPrescriber;
import be.recipe.services.prescriber.GetPrescriptionForPrescriberParam;
import be.recipe.services.prescriber.GetPrescriptionForPrescriberResponse;
import be.recipe.services.prescriber.GetPrescriptionForPrescriberResult;
import be.recipe.services.prescriber.GetPrescriptionStatus;
import be.recipe.services.prescriber.GetPrescriptionStatusParam;
import be.recipe.services.prescriber.GetPrescriptionStatusResponse;
import be.recipe.services.prescriber.GetPrescriptionStatusResult;
import be.recipe.services.prescriber.ListFeedbacks;
import be.recipe.services.prescriber.ListFeedbacksParam;
import be.recipe.services.prescriber.ListFeedbacksResponse;
import be.recipe.services.prescriber.ListFeedbacksResult;
import be.recipe.services.prescriber.ListOpenRids;
import be.recipe.services.prescriber.ListOpenRidsParam;
import be.recipe.services.prescriber.ListOpenRidsResponse;
import be.recipe.services.prescriber.ListOpenRidsResult;
import be.recipe.services.prescriber.ListRidsHistory;
import be.recipe.services.prescriber.ListRidsHistoryParam;
import be.recipe.services.prescriber.ListRidsHistoryResponse;
import be.recipe.services.prescriber.ListRidsHistoryResult;
import be.recipe.services.prescriber.PutVision;
import be.recipe.services.prescriber.PutVisionParam;
import be.recipe.services.prescriber.PutVisionResponse;
import be.recipe.services.prescriber.PutVisionResult;
import be.recipe.services.prescriber.RevokePrescription;
import be.recipe.services.prescriber.RevokePrescriptionParam;
import be.recipe.services.prescriber.RevokePrescriptionResponse;
import be.recipe.services.prescriber.RevokePrescriptionResult;
import be.recipe.services.prescriber.SendNotification;
import be.recipe.services.prescriber.SendNotificationParam;
import be.recipe.services.prescriber.SendNotificationResponse;
import be.recipe.services.prescriber.SendNotificationResult;
import be.recipe.services.prescriber.UpdateFeedbackFlag;
import be.recipe.services.prescriber.UpdateFeedbackFlagParam;
import be.recipe.services.prescriber.UpdateFeedbackFlagResponse;
import be.recipe.services.prescriber.UpdateFeedbackFlagResult;
import be.recipe.services.prescriber.ValidationProperties;
import be.recipe.services.prescriber.ValidationPropertiesParam;
import be.recipe.services.prescriber.ValidationPropertiesResponse;
import be.recipe.services.prescriber.ValidationPropertiesResult;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.validation.Schema;
import javax.xml.ws.WebServiceException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HospitalPrescriberIntegrationModuleDevV4Impl
extends AbstractPrescriberIntegrationModule
implements PrescriberIntegrationModuleDevV4 {
    private static final Logger LOG = LoggerFactory.getLogger(PrescriberIntegrationModuleDevV4Impl.class);
    private final PrescriberCreateBulkPrescriptionsUseCase encryptionUtils;

    public HospitalPrescriberIntegrationModuleDevV4Impl() {
        this.encryptionUtils = new PrescriberCreateBulkPrescriptionsUseCase(PropertyHandler.getInstance(), EncryptionUtils.getInstance(), this.keyCache);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#createPrescription")
    public String createPrescription(boolean feedbackRequested, String patientId, byte[] prescription, String prescriptionType) {
        return this.createPrescription(feedbackRequested, patientId, prescription, prescriptionType, null, this.getDefaultExpirationDate());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#createPrescription")
    public String createPrescription(boolean feedbackRequested, String patientId, byte[] prescription, String prescriptionType, String visi, String expirationDate) {
        return this.createPrescription(feedbackRequested, patientId, prescription, prescriptionType, visi, null, expirationDate);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#createPrescription")
    public String createPrescription(boolean feedbackRequested, String patientId, byte[] prescription, String prescriptionType, String visi, VisionOtherPrescribers visionOtherPrescribers, String expirationDate) {
        ApplicationConfig.getInstance().assertValidSession();
        ValidationUtils.validatePatientId(patientId);
        ValidationUtils.validateVisi(visi, false);
        try {
            PropertyHandler propertyHandler = PropertyHandler.getInstance();
            ValidationUtils.validateExpirationDate(expirationDate);
            this.validateKmehr(prescription, prescriptionType, expirationDate);
            MarshallerHelper<CreatePrescriptionResult, CreatePrescriptionParam> helper = new MarshallerHelper<CreatePrescriptionResult, CreatePrescriptionParam>(CreatePrescriptionResult.class, CreatePrescriptionParam.class);
            List<EncryptionToken> etkRecipes = this.getEtkHelper().getRecipe_ETK();
            byte[] message = IOUtils.compress(prescription);
            KeyResult key = this.getNewKey(patientId);
            message = this.sealPrescriptionForUnknown(key, message);
            CreatePrescriptionParam params = new CreatePrescriptionParam();
            params.setPrescription(message);
            params.setPrescriptionType(prescriptionType);
            params.setFeedbackRequested(feedbackRequested);
            params.setKeyId(key.getKeyId());
            params.setSymmKey(this.getSymmKey().getEncoded());
            params.setPatientId(patientId);
            params.setExpirationDate(this.getDefaultExpirationDate(expirationDate));
            params.setVision(visi);
            params.setVisionOtherPrescribers(RecipePrescriberClient.toJAXB(visionOtherPrescribers));
            CreatePrescription request = new CreatePrescription();
            request.setCreatePrescriptionParamSealed(this.sealRequest(etkRecipes.get(0), helper.toXMLByteArray(params)));
            request.setKeyId(key.getKeyId());
            request.setPrescriptionType(prescriptionType);
            request.setDocumentId(this.generateRid(prescriptionType));
            request.setPrescriptionVersion(PropertyHandler.getInstance().getProperty("prescription.version"));
            request.setReferenceSourceVersion(HospitalPrescriberIntegrationModuleDevV4Impl.extractReferenceSourceVersionFromKmehr(prescription));
            request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setMguid(UUID.randomUUID().toString());
            SessionItem sessionItem = Session.getInstance().getSession();
            SessionValidator.assertValidSession(sessionItem);
            request.setSecurityToken((Object)sessionItem.getSAMLToken().getAssertion());
            CreatePrescriptionResponse response = RecipePrescriberServiceDevV4Impl.getInstance().createPrescription(request);
            CreatePrescriptionResult result = helper.unsealWithSymmKey(response.getCreatePrescriptionResultSealed(), this.getSymmKey());
            this.checkStatus((ResponseType)result);
            return result.getRid();
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    private String getDefaultExpirationDate() {
        return this.getDefaultExpirationDate(null);
    }

    private String getDefaultExpirationDate(String expirationDate) {
        if (StringUtils.isBlank((String)expirationDate)) {
            Calendar defaultExpirationDate = Calendar.getInstance();
            defaultExpirationDate.add(2, 3);
            String pattern = "yyyy-MM-dd";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.format(defaultExpirationDate.getTime());
        }
        return expirationDate;
    }

    private String generateRid(String prescriptionType) {
        String rid = "BE" + prescriptionType + "JNT" + RandomStringUtils.random((int)5, (boolean)true, (boolean)false).toUpperCase();
        rid = rid.replace('I', 'J').replace('O', 'A').replace('U', 'V');
        return rid;
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="PrescriberIntegrationModule#prepareCreatePrescription")
    public void prepareCreatePrescription(String patientId) {
        ApplicationConfig.getInstance().assertValidSession();
        this.getEtkHelper().getRecipe_ETK();
        this.getEtkHelper().getKGSS_ETK();
        this.getEtkHelper().getSystemETK();
        if (!this.keyCache.containsKey(patientId)) {
            this.keyCache.put(patientId, this.getNewKeyFromKgss(patientId));
        }
        try {
            EncryptionUtils.getInstance().initSealing();
            EncryptionUtils.getInstance().initUnsealing();
        }
        catch (Exception e) {
            LOG.error("Failed to store the online properties to disk", (Throwable)e);
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#getPrescription")
    public GetPrescriptionForPrescriberResult getPrescription(String rid) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidSession();
        try {
            MarshallerHelper<GetPrescriptionForPrescriberResult, GetPrescriptionForPrescriberParam> helper = new MarshallerHelper<GetPrescriptionForPrescriberResult, GetPrescriptionForPrescriberParam>(GetPrescriptionForPrescriberResult.class, GetPrescriptionForPrescriberParam.class);
            List<EncryptionToken> etkRecipes = this.getEtkHelper().getRecipe_ETK();
            GetPrescriptionForPrescriberParam param = new GetPrescriptionForPrescriberParam();
            param.setRid(rid);
            param.setSymmKey(this.getSymmKey().getEncoded());
            GetPrescriptionForPrescriber request = new GetPrescriptionForPrescriber();
            request.setGetPrescriptionForPrescriberParamSealed(this.sealRequest(etkRecipes.get(0), helper.toXMLByteArray(param)));
            request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setMguid(UUID.randomUUID().toString());
            GetPrescriptionForPrescriberResponse response = null;
            try {
                response = RecipePrescriberServiceDevV4Impl.getInstance().getPrescriptionForPrescriber(request);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.prescriber"), cte);
            }
            GetPrescriptionForPrescriberResult result = helper.unsealWithSymmKey(response.getGetPrescriptionForPrescriberResultSealed(), this.getSymmKey());
            this.checkStatus((ResponseType)result);
            if (result.getPrescription() != null) {
                KeyResult key = this.getKeyFromKgss(result.getEncryptionKeyId(), this.getEtkHelper().getSystemETK().get(0).getEncoded());
                byte[] unsealedPrescription = IOUtils.decompress(this.unsealPrescriptionForUnknown(key, result.getPrescription()));
                result.setPrescription(unsealedPrescription);
            }
            return result;
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#revokePrescription")
    public void revokePrescription(String rid, String reason) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidSession();
        try {
            MarshallerHelper<Object, RevokePrescriptionParam> helper = new MarshallerHelper<Object, RevokePrescriptionParam>(Object.class, RevokePrescriptionParam.class);
            List<EncryptionToken> etkRecipes = this.getEtkHelper().getRecipe_ETK();
            RevokePrescriptionParam params = new RevokePrescriptionParam();
            params.setRid(rid);
            params.setReason(reason);
            params.setSymmKey(this.getSymmKey().getEncoded());
            RevokePrescription request = new RevokePrescription();
            request.setRevokePrescriptionParamSealed(this.sealRequest(etkRecipes.get(0), helper.toXMLByteArray(params)));
            request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setMguid(UUID.randomUUID().toString());
            try {
                RevokePrescriptionResponse response = RecipePrescriberServiceDevV4Impl.getInstance().revokePrescription(request);
                MarshallerHelper<RevokePrescriptionResult, Object> marshaller = new MarshallerHelper<RevokePrescriptionResult, Object>(RevokePrescriptionResult.class, Object.class);
                RevokePrescriptionResult result = marshaller.unsealWithSymmKey(response.getRevokePrescriptionResultSealed(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.prescriber"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
        }
    }

    @Override
    public void sendNotification(byte[] notificationText, String patientId, String executorId) {
        this.sendNotification(notificationText, patientId, executorId, executorId);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="PrescriberIntegrationModule#sendNotification")
    public void sendNotification(byte[] notificationText, String patientId, String executorId, String hospitalId) {
        ValidationUtils.validatePatientId(patientId);
        ApplicationConfig.getInstance().assertValidSession();
        try {
            this.getKmehrHelper().assertValidNotification(notificationText);
            ValidationUtils.validatePatientId(patientId);
            MarshallerHelper<Object, SendNotificationParam> helper = new MarshallerHelper<Object, SendNotificationParam>(Object.class, SendNotificationParam.class);
            List<EncryptionToken> etkRecipes = this.getEtkHelper().getRecipe_ETK();
            ArrayList<EncryptionToken> etkRecipients = new ArrayList<EncryptionToken>();
            try {
                etkRecipients.addAll(this.getEtkHelper().getEtks(KgssIdentifierType.NIHII, executorId));
            }
            catch (Exception e) {
                try {
                    etkRecipients.addAll(this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_PHARMACY, executorId));
                }
                catch (Exception e1) {
                    try {
                        etkRecipients.addAll(this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_HOSPITAL, hospitalId));
                    }
                    catch (Exception e2) {
                        Exceptionutils.errorHandler(e1, e.getMessage() + e2.getMessage());
                    }
                }
            }
            byte[] notificationZip = IOUtils.compress(notificationText);
            for (int i = 0; i < etkRecipients.size(); ++i) {
                EncryptionToken etkRecipient = (EncryptionToken)etkRecipients.get(0);
                byte[] notificationSealed = this.sealNotification(etkRecipient, notificationZip);
                SendNotificationParam param = new SendNotificationParam();
                param.setContent(notificationSealed);
                param.setExecutorId(executorId);
                param.setPatientId(patientId);
                param.setSymmKey(this.getSymmKey().getEncoded());
                SendNotification request = new SendNotification();
                request.setSendNotificationParamSealed(this.sealRequest(etkRecipes.get(0), helper.toXMLByteArray(param)));
                request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
                request.setMguid(UUID.randomUUID().toString());
                try {
                    SendNotificationResponse response = RecipePrescriberServiceDevV4Impl.getInstance().sendNotification(request);
                    MarshallerHelper<SendNotificationResult, SendNotificationResult> helper1 = new MarshallerHelper<SendNotificationResult, SendNotificationResult>(SendNotificationResult.class, SendNotificationResult.class);
                    SendNotificationResult result = helper1.unsealWithSymmKey(response.getSendNotificationResultSealed(), this.getSymmKey());
                    this.checkStatus((ResponseType)result);
                    continue;
                }
                catch (WebServiceException cte) {
                    throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.prescriber"), cte);
                }
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#updateFeedbackFlag")
    public void updateFeedbackFlag(String rid, boolean feedbackAllowed) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidSession();
        try {
            MarshallerHelper<Object, UpdateFeedbackFlagParam> helper = new MarshallerHelper<Object, UpdateFeedbackFlagParam>(Object.class, UpdateFeedbackFlagParam.class);
            List<EncryptionToken> etkRecipes = this.getEtkHelper().getRecipe_ETK();
            UpdateFeedbackFlagParam param = new UpdateFeedbackFlagParam();
            param.setAllowFeedback(feedbackAllowed);
            param.setRid(rid);
            param.setSymmKey(this.getSymmKey().getEncoded());
            UpdateFeedbackFlag request = new UpdateFeedbackFlag();
            request.setUpdateFeedbackFlagParamSealed(this.sealRequest(etkRecipes.get(0), helper.toXMLByteArray(param)));
            request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setMguid(UUID.randomUUID().toString());
            try {
                UpdateFeedbackFlagResponse response = RecipePrescriberServiceDevV4Impl.getInstance().putFeedbackFlag(request);
                MarshallerHelper<UpdateFeedbackFlagResult, UpdateFeedbackFlagResult> helper1 = new MarshallerHelper<UpdateFeedbackFlagResult, UpdateFeedbackFlagResult>(UpdateFeedbackFlagResult.class, UpdateFeedbackFlagResult.class);
                UpdateFeedbackFlagResult result = helper1.unsealWithSymmKey(response.getUpdateFeedbackFlagResultSealed(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.prescriber"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#listFeedback")
    public List<be.recipe.services.prescriber.ListFeedbackItem> listFeedback(boolean readFlag) {
        ApplicationConfig.getInstance().assertValidSession();
        try {
            MarshallerHelper<ListFeedbacksResult, ListFeedbacksParam> helper = new MarshallerHelper<ListFeedbacksResult, ListFeedbacksParam>(ListFeedbacksResult.class, ListFeedbacksParam.class);
            List<EncryptionToken> etkRecipes = this.getEtkHelper().getRecipe_ETK();
            ListFeedbacksParam param = new ListFeedbacksParam();
            param.setReadFlag(readFlag);
            param.setSymmKey(this.getSymmKey().getEncoded());
            ListFeedbacks request = new ListFeedbacks();
            request.setListFeedbacksParamSealed(this.sealRequest(etkRecipes.get(0), helper.toXMLByteArray(param)));
            request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setMguid(UUID.randomUUID().toString());
            ListFeedbacksResponse response = null;
            try {
                response = RecipePrescriberServiceDevV4Impl.getInstance().listFeedbacks(request);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.prescriber"), cte);
            }
            ListFeedbacksResult result = helper.unsealWithSymmKey(response.getListFeedbacksResultSealed(), this.getSymmKey());
            this.checkStatus((ResponseType)result);
            List feedbacks = result.getFeedbacks();
            for (int i = 0; i < feedbacks.size(); ++i) {
                ListFeedbackItem item = new ListFeedbackItem((be.recipe.services.prescriber.ListFeedbackItem)feedbacks.get(i));
                byte[] content = item.getContent();
                try {
                    content = this.unsealFeedback(content);
                    content = content == null ? content : IOUtils.decompress(content);
                    item.setContent(content);
                }
                catch (Throwable t) {
                    item.setLinkedException(t);
                }
                feedbacks.set(i, item);
            }
            return feedbacks;
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#getData(ValidationPropertiesParam)")
    public ValidationPropertiesResult getData(ValidationPropertiesParam param) {
        if (!OnlineProperties.isLoaded()) {
            ApplicationConfig.getInstance().assertValidSession();
            try {
                ValidationProperties request = this.getValidationProperties(param);
                ValidationPropertiesResponse response = RecipePrescriberServiceDevV4Impl.getInstance().getValidationProperties(request);
                ValidationPropertiesResult result = this.unsealValidationPropertiesResponse(response);
                this.checkStatus((ResponseType)result);
                OnlineProperties onlineProperties = OnlinePropertiesHolder.getInstance();
                ValidationPropertiesResult.Properties properties = result.getProperties();
                String clientVersion = this.readPropertiesVersionFromDisk();
                if (result.getServerPropertiesVersion() == null || result.getServerPropertiesVersion() != null && result.getServerPropertiesVersion().equals("")) {
                    this.deleteOnlineProperties();
                } else if (result.getServerPropertiesVersion() != null && clientVersion != null && !result.getServerPropertiesVersion().equals(clientVersion)) {
                    this.deleteOnlineProperties();
                }
                if (StringUtils.isNotBlank((String)result.getServerPropertiesVersion()) && !result.getServerPropertiesVersion().equals(clientVersion)) {
                    HashMap<String, String> targetProperties = new HashMap<String, String>();
                    if (properties != null && CollectionUtils.isNotEmpty((Collection)properties.getEntries())) {
                        for (ValidationPropertiesResult.Properties.Entry obj : properties.getEntries()) {
                            targetProperties.put(obj.getKey(), obj.getValue());
                        }
                        onlineProperties.setProperties(targetProperties);
                    }
                    if (result.getXsdValidationFiles() != null && CollectionUtils.isNotEmpty((Collection)result.getXsdValidationFiles().getEntries())) {
                        ValidationPropertiesResult.XsdValidationFiles xsdFiles = result.getXsdValidationFiles();
                        HashMap<String, byte[]> targetMap = new HashMap<String, byte[]>();
                        for (ValidationPropertiesResult.XsdValidationFiles.Entry item : xsdFiles.getEntries()) {
                            targetMap.put(item.getKey(), item.getValue());
                        }
                        onlineProperties.setXsdValidationFiles(targetMap);
                        OnlinePropertiesHolder.setXsdSet(true);
                        this.storeXsdsOnDisk(targetMap);
                        for (ValidationPropertiesResult.XsdValidationFiles.Entry item : xsdFiles.getEntries()) {
                            targetProperties.put(item.getKey().split(":")[0].replace("_", "."), this.getPropertyHandler().getProperty("online.xsd.path") + File.separator + item.getKey().split(":")[0] + File.separator + item.getKey().split(":")[1]);
                        }
                    }
                    this.storePropertiesVersionToDisk(result.getServerPropertiesVersion());
                    this.storePropertiesOnDisk(targetProperties);
                    OnlinePropertiesHolder.reloadProperties();
                } else {
                    this.readFromDisk();
                }
                ValidationPropertiesResult validationPropertiesResult = result;
                return validationPropertiesResult;
            }
            catch (Exception cte) {
                this.readFromDisk();
            }
            catch (Throwable t) {
                Exceptionutils.errorHandler(t);
            }
            finally {
                OnlineProperties.setLoaded(true);
            }
        }
        return null;
    }

    private void deleteOnlineProperties() {
        String directory = this.getPropertyHandler().getProperty("online.properties.file");
        try {
            FileUtils.deleteDirectory((File)new File(directory));
        }
        catch (IOException e) {
            LOG.error("Failed to delete online properties from local cache", (Throwable)e);
        }
    }

    protected ValidationProperties getValidationProperties(ValidationPropertiesParam param) {
        param.setSymmKey(this.getSymmKey().getEncoded());
        ValidationProperties request = new ValidationProperties();
        request.setValidationPropertiesParamSealed(this.getSealedData(param));
        request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setMguid(UUID.randomUUID().toString());
        return request;
    }

    private void storePropertiesOnDisk(Map<String, String> map) {
        if (CollectionUtils.isNotEmpty(map.values())) {
            try {
                Properties temp = new Properties();
                for (String key : map.keySet()) {
                    temp.put(key, map.get(key));
                }
                temp.store(new FileOutputStream(this.getPropertyHandler().getProperty("online.properties.file") + "/online.properties.txt"), null);
            }
            catch (IOException e) {
                LOG.error("Failed to store the online properties to disk", (Throwable)e);
            }
        }
    }

    private void storeXsdsOnDisk(Map<String, byte[]> xsdValidationFile) {
        if (CollectionUtils.isNotEmpty(xsdValidationFile.values())) {
            for (String key : xsdValidationFile.keySet()) {
                try {
                    HospitalPrescriberIntegrationModuleDevV4Impl.unzip(xsdValidationFile.get(key), this.getPropertyHandler().getProperty("online.xsd.path") + File.separator + key.split(":")[0]);
                }
                catch (Exception e) {
                    LOG.error("Failed to store the online xsds to disk", (Throwable)e);
                }
            }
        }
    }

    private static void unzip(byte[] compressedData, String destDir) {
        File dir = new File(destDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        byte[] buffer = new byte[1024];
        try {
            ByteArrayInputStream fis = new ByteArrayInputStream(compressedData);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(destDir + File.separator + fileName);
                LOG.debug("Unzipping to " + newFile.getAbsolutePath());
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            fis.close();
        }
        catch (IOException e) {
            LOG.error("Error while unzipping the xsd files from the server: ", (Throwable)e);
        }
    }

    private void readFromDisk() throws Exception {
        try {
            Properties prop = new Properties();
            File file = new File(this.getPropertyHandler().getProperty("online.properties.file") + "/online.properties.txt");
            if (file != null && file.exists()) {
                prop.load(new FileInputStream(file));
                OnlineProperties onlineProperties = OnlinePropertiesHolder.getInstance();
                HashMap<String, String> targetProperties = new HashMap<String, String>();
                Enumeration<Object> iterator = prop.keys();
                while (iterator.hasMoreElements()) {
                    String key = (String)iterator.nextElement();
                    targetProperties.put(key, prop.getProperty(key));
                }
                onlineProperties.setProperties(targetProperties);
                OnlinePropertiesHolder.reloadProperties();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to read online properties from disk, using default properties as default.", (Throwable)e);
        }
    }

    protected void storePropertiesVersionToDisk(String serverPropertiesVersion) {
        try {
            String path = this.getPropertyHandler().getProperty("online.properties.version.path");
            File file = new File(path + "/online.properties.version.txt");
            FileUtils.writeStringToFile((File)file, (String)serverPropertiesVersion);
        }
        catch (IOException e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readPropertiesVersionFromDisk() {
        try {
            String path = this.getPropertyHandler().getProperty("online.properties.version.path");
            File file = new File(path + "/online.properties.version.txt");
            if (!file.exists()) {
                return this.getPropertyHandler().getProperty("online.properties.version");
            }
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String st = br.readLine();
                if (st == null) {
                    String string = this.getPropertyHandler().getProperty("online.properties.version");
                    return string;
                }
                String string = st;
                return string;
            }
        }
        catch (Exception e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), e);
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#getData(GetPrescriptionStatusParam)")
    public GetPrescriptionStatusResult getData(GetPrescriptionStatusParam param) {
        RidValidator.validateRid(param.getRid());
        ApplicationConfig.getInstance().assertValidSession();
        try {
            GetPrescriptionStatus getPrescriptionStatus = this.getGetPrescriptionStatus(param);
            try {
                GetPrescriptionStatusResponse response = RecipePrescriberServiceDevV4Impl.getInstance().getPrescriptionStatus(getPrescriptionStatus);
                GetPrescriptionStatusResult result = this.unsealGetPrescriptionStatusResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    protected GetPrescriptionStatus getGetPrescriptionStatus(GetPrescriptionStatusParam param) {
        param.setSymmKey(this.getSymmKey().getEncoded());
        GetPrescriptionStatus request = new GetPrescriptionStatus();
        request.setGetPrescriptionStatusParamSealed(this.getSealedData(param));
        request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setMguid(UUID.randomUUID().toString());
        return request;
    }

    private GetPrescriptionStatusResult unsealGetPrescriptionStatusResponse(GetPrescriptionStatusResponse response) {
        MarshallerHelper<GetPrescriptionStatusResult, Object> marshaller = new MarshallerHelper<GetPrescriptionStatusResult, Object>(GetPrescriptionStatusResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getGetPrescriptionStatusResultSealed(), this.getSymmKey());
    }

    private ValidationPropertiesResult unsealValidationPropertiesResponse(ValidationPropertiesResponse response) {
        MarshallerHelper<ValidationPropertiesResult, Schema> marshaller = new MarshallerHelper<ValidationPropertiesResult, Schema>(ValidationPropertiesResult.class, Schema.class);
        return marshaller.unsealWithSymmKey(response.getValidationPropertiesResultSealed(), this.getSymmKey());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#getData(ListPrescriptionHistoryParam)")
    public ListRidsHistoryResult getData(ListRidsHistoryParam param) {
        ApplicationConfig.getInstance().assertValidSession();
        ValidationUtils.validatePatientId(param.getPatientId());
        try {
            ListRidsHistory listPrescriptionHistory = this.getListPrescriptionHistoryRequest(param);
            try {
                ListRidsHistoryResponse response = RecipePrescriberServiceDevV4Impl.getInstance().listRidsHistory(listPrescriptionHistory);
                ListRidsHistoryResult result = this.unsealListPrescriptionHistoryResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    private ListRidsHistory getListPrescriptionHistoryRequest(ListRidsHistoryParam listRidHistoryParam) {
        listRidHistoryParam.setSymmKey(this.getSymmKey().getEncoded());
        ListRidsHistory listRidsHistory = new ListRidsHistory();
        listRidsHistory.setListRidsHistoryParamSealed(this.getSealedData(listRidHistoryParam));
        listRidsHistory.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        listRidsHistory.setMguid(UUID.randomUUID().toString());
        return listRidsHistory;
    }

    private ListRidsHistoryResult unsealListPrescriptionHistoryResponse(ListRidsHistoryResponse response) {
        MarshallerHelper<ListRidsHistoryResult, Object> marshaller = new MarshallerHelper<ListRidsHistoryResult, Object>(ListRidsHistoryResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getListRidsHistoryResultSealed(), this.getSymmKey());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#putData(PutVisionParam)")
    public PutVisionResult putData(PutVisionParam param) {
        RidValidator.validateRid(param.getRid());
        ValidationUtils.validateVisi(param.getVision(), false);
        ApplicationConfig.getInstance().assertValidSession();
        try {
            try {
                PutVision putVision = this.putVisionRequest(param);
                PutVisionResponse response = RecipePrescriberServiceDevV4Impl.getInstance().putVisionForPrescriber(putVision);
                PutVisionResult result = this.unsealPutVisionResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    protected PutVision putVisionRequest(PutVisionParam putVisionParam) {
        putVisionParam.setSymmKey(this.getSymmKey().getEncoded());
        PutVision putVision = new PutVision();
        putVision.setPutVisionParamSealed(this.getSealedData(putVisionParam));
        putVision.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        putVision.setMguid(UUID.randomUUID().toString());
        return putVision;
    }

    private PutVisionResult unsealPutVisionResponse(PutVisionResponse response) {
        MarshallerHelper<PutVisionResult, Object> marshaller = new MarshallerHelper<PutVisionResult, Object>(PutVisionResult.class, Object.class);
        PutVisionResult result = marshaller.unsealWithSymmKey(response.getPutVisionResultSealed(), this.getSymmKey());
        return result;
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModuleV4#getData(ListOpenRidsParam)")
    public ListOpenRidsResult getData(ListOpenRidsParam param) {
        ApplicationConfig.getInstance().assertValidSession();
        ValidationUtils.validatePatientId(param.getPatientId());
        try {
            ListOpenRids listOpenPrescriptions = this.getListOpenRids(param);
            try {
                ListOpenRidsResponse response = RecipePrescriberServiceDevV4Impl.getInstance().listOpenRids(listOpenPrescriptions);
                ListOpenRidsResult result = this.unsealListOpenRidsResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    protected ListOpenRids getListOpenRids(ListOpenRidsParam param) {
        param.setSymmKey(this.getSymmKey().getEncoded());
        ListOpenRids request = new ListOpenRids();
        request.setListOpenRidsParamSealed(this.getSealedData(param));
        request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setMguid(UUID.randomUUID().toString());
        return request;
    }

    private ListOpenRidsResult unsealListOpenRidsResponse(ListOpenRidsResponse response) {
        MarshallerHelper<ListOpenRidsResult, Object> marshaller = new MarshallerHelper<ListOpenRidsResult, Object>(ListOpenRidsResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getListOpenRidsResultSealed(), this.getSymmKey());
    }

    @Override
    public List<CreatePrescriptionDTO> createPrescriptions(List<CreatePrescriptionDTO> dtos) {
        ApplicationConfig.getInstance().assertValidSession();
        this.validateCreatePrescriptionDTOs(dtos);
        try {
            return this.encryptionUtils.execute(dtos, this);
        }
        catch (TechnicalConnectorException e) {
            Exceptionutils.errorHandler(e);
            return Collections.emptyList();
        }
    }
}

