/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.patient.utils;

import be.business.connector.core.ehealth.services.KgssServiceImpl;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.technical.connector.utils.Crypto;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.IOUtils;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.recipe.services.patient.GetOpenPrescriptionForPatient;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang3.Validate;
import org.perf4j.aop.Profiled;

public class PatientPrescriptionDecryptorThread
extends Thread {
    private GetOpenPrescriptionForPatient prescription;
    private Semaphore semaphore;
    private byte[] patientEtk;
    private byte[] kgssEtk;
    private IntegrationModuleException error;

    public PatientPrescriptionDecryptorThread(Semaphore available, GetOpenPrescriptionForPatient prescription, byte[] userEtk, byte[] kgssEtk) {
        Validate.notNull((Object)available);
        Validate.notNull((Object)prescription);
        Validate.notNull((Object)prescription.getPrescription());
        Validate.notNull((Object)userEtk);
        Validate.notNull((Object)kgssEtk);
        this.semaphore = available;
        this.prescription = prescription;
        this.patientEtk = userEtk;
        this.kgssEtk = kgssEtk;
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PrescriptionDecryptorThread#decryption", logger="org.perf4j.TimingLogger_Common")
    public void run() {
        try {
            KeyResult keyResult = KgssServiceImpl.getInstance().retrieveKeyFromKgss(this.prescription.getEncryptionKeyId().getBytes(), this.patientEtk, this.kgssEtk);
            byte[] unsealedPrescription = new Crypto().unsealForUnknown(keyResult, this.prescription.getPrescription());
            this.prescription.setPrescription(IOUtils.decompress(unsealedPrescription));
        }
        catch (Exception e) {
            this.error = new IntegrationModuleException(I18nHelper.getLabel("technical.connector.error.retrieve.key"), e);
        }
        finally {
            this.semaphore.release();
        }
    }

    public GetOpenPrescriptionForPatient getPrescription() {
        return this.prescription;
    }

    public void clean() {
        this.semaphore = null;
        this.prescription = null;
        this.patientEtk = null;
        this.kgssEtk = null;
        this.error = null;
    }
}

