/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.patient;

import be.business.connector.common.StandaloneRequestorProvider;
import be.business.connector.common.module.AbstractIntegrationModule;
import be.business.connector.core.domain.KgssIdentifierType;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.Exceptionutils;
import be.business.connector.core.utils.IOUtils;
import be.business.connector.core.utils.MarshallerHelper;
import be.business.connector.recipe.patient.PatientIntegrationModuleV4;
import be.business.connector.recipe.patient.domain.GetVisionParam;
import be.business.connector.recipe.patient.domain.PutReservationParam;
import be.business.connector.recipe.patient.domain.PutVisionParam;
import be.business.connector.recipe.patient.utils.PatientDecryptionUtils;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.fgov.ehealth.commons.core.v1.LocalisedString;
import be.fgov.ehealth.commons.protocol.v1.ResponseType;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.recipe.core.v4.SecuredContentType;
import be.recipe.services.core.StatusType;
import be.recipe.services.patient.GetPrescriptionForPatientParam;
import be.recipe.services.patient.GetPrescriptionForPatientResult;
import be.recipe.services.patient.GetPrescriptionForPatientResultSealed;
import be.recipe.services.patient.ListPatientPrescriptionsParam;
import be.recipe.services.patient.ListPatientPrescriptionsResult;
import be.recipe.services.patient.RevokePrescriptionParam;
import java.io.IOException;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPatientIntegrationModule
extends AbstractIntegrationModule
implements PatientIntegrationModuleV4 {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPatientIntegrationModule.class);
    private final PatientDecryptionUtils utils = new PatientDecryptionUtils(this.getPropertyHandler(), this.getEncryptionUtils());

    protected GetPrescriptionForPatientResult unsealPrescription(byte[] result) throws IOException {
        MarshallerHelper<GetPrescriptionForPatientResult, Object> marshaller = new MarshallerHelper<GetPrescriptionForPatientResult, Object>(GetPrescriptionForPatientResult.class, Object.class);
        GetPrescriptionForPatientResult unsealedResult = marshaller.unsealWithSymmKey(result, this.getSymmKey());
        this.checkStatus((be.recipe.services.core.ResponseType)unsealedResult);
        this.unsealPrescriptionBytes(unsealedResult);
        return unsealedResult;
    }

    private void unsealPrescriptionBytes(GetPrescriptionForPatientResult result) throws IOException {
        KeyResult key = this.getKeyFromKgss(result.getEncryptionKeyId(), this.getEtkHelper().getSystemETK().get(0).getEncoded());
        byte[] unsealedPrescription = IOUtils.decompress(this.unsealPrescriptionForUnknown(key, result.getPrescription()));
        result.setPrescription(unsealedPrescription);
    }

    protected GetPrescriptionForPatientResult createGetPrescriptionForPatientResult(byte[] sealedExecutorResponse) {
        MarshallerHelper<GetPrescriptionForPatientResultSealed, Object> marshaller = new MarshallerHelper<GetPrescriptionForPatientResultSealed, Object>(GetPrescriptionForPatientResultSealed.class, Object.class);
        String requestorIdInformation = StandaloneRequestorProvider.getRequestorIdInformation();
        String requestorTypeInformation = StandaloneRequestorProvider.getRequestorTypeInformation();
        GetPrescriptionForPatientResultSealed sealedResult = marshaller.unsealWithSymmKey(sealedExecutorResponse, this.getSymmKey());
        KeyResult key = this.getKeyFromKgss(sealedResult.getEncryptionKeyId(), this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_PHARMACY, requestorIdInformation).get(0).getEncoded());
        byte[] unsealedPrescription = this.unsealWithSymKey(sealedResult, key, requestorIdInformation, requestorTypeInformation);
        GetPrescriptionForPatientResult finalResult = new GetPrescriptionForPatientResult();
        finalResult.setPrescription(unsealedPrescription);
        return finalResult;
    }

    public byte[] getSealedGetPrescriptionForPatientParam(String rid) {
        GetPrescriptionForPatientParam param = new GetPrescriptionForPatientParam();
        param.setRid(rid);
        param.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(param, GetPrescriptionForPatientParam.class);
    }

    protected <T> byte[] sealForRecipe(T data, Class<T> type) {
        MarshallerHelper<Object, T> helper = new MarshallerHelper<Object, T>(Object.class, type);
        EncryptionToken etkRecipe = this.getEtkHelper().getRecipe_ETK().get(0);
        return this.sealRequest(etkRecipe, helper.toXMLByteArray(data));
    }

    protected <T> byte[] marshall(T data, Class<T> type) {
        MarshallerHelper<Object, T> helper = new MarshallerHelper<Object, T>(Object.class, type);
        return helper.toXMLByteArray(data);
    }

    protected SecuredContentType createSecuredContentType(byte[] content) {
        SecuredContentType secured = new SecuredContentType();
        secured.setSecuredContent(content);
        return secured;
    }

    protected void checkStatus(ResponseType response) {
        if (!"100".equals(response.getStatus().getCode()) && !"200".equals(response.getStatus().getCode())) {
            LOG.error("Error Status received : " + response.getStatus().getCode());
            throw new IntegrationModuleException(this.getLocalisedMsg(response.getStatus()));
        }
    }

    protected void checkStatus(be.recipe.services.core.ResponseType response) {
        if (response != null && response.getStatus() != null && !"100".equals(response.getStatus().getCode()) && !"200".equals(response.getStatus().getCode())) {
            LOG.error("Error Status received : " + response.getStatus().getCode());
            throw new IntegrationModuleException(this.getLocalisedMsg(response.getStatus()), response);
        }
    }

    private String getLocalisedMsg(be.fgov.ehealth.commons.core.v1.StatusType status) {
        String locale = IntegrationModuleException.getUserLocale();
        for (LocalisedString msg : status.getMessages()) {
            if (msg.getLang() == null || !locale.equalsIgnoreCase(msg.getLang().value())) continue;
            return msg.getValue();
        }
        if (status.getMessages().size() > 0) {
            return ((LocalisedString)status.getMessages().get(0)).getValue();
        }
        return status.getCode();
    }

    private String getLocalisedMsg(StatusType status) {
        String locale = IntegrationModuleException.getUserLocale();
        for (be.recipe.services.core.LocalisedString msg : status.getMessages()) {
            if (msg.getLang() == null || !locale.equalsIgnoreCase(msg.getLang().value())) continue;
            return msg.getValue();
        }
        if (status.getMessages().size() > 0) {
            return ((be.recipe.services.core.LocalisedString)status.getMessages().get(0)).getValue();
        }
        return status.getCode();
    }

    protected byte[] getSealedRevokePrescriptionParam(String rid, String reason) {
        RevokePrescriptionParam param = new RevokePrescriptionParam();
        param.setRid(rid);
        param.setReason(reason);
        param.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(param, RevokePrescriptionParam.class);
    }

    protected byte[] getSealedData(GetVisionParam getVisionParam) {
        return this.sealForRecipe(getVisionParam, GetVisionParam.class);
    }

    protected byte[] getSealedData(PutReservationParam putReservationParam) {
        return this.sealForRecipe(putReservationParam, PutReservationParam.class);
    }

    protected byte[] getSealedData(PutVisionParam putVisionParam) {
        return this.sealForRecipe(putVisionParam, PutVisionParam.class);
    }

    protected byte[] getSealedData(ListPatientPrescriptionsParam request) {
        request.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(request, ListPatientPrescriptionsParam.class);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#decryptListOpenPrescriptionsResult")
    public ListPatientPrescriptionsResult decryptListPatientPrescriptionsResult(ListPatientPrescriptionsResult listPatientPrescriptionsResult) {
        try {
            return this.utils.decryptPrescriptions(listPatientPrescriptionsResult);
        }
        catch (Exception ex) {
            Exceptionutils.errorHandler(ex, "error.data.uncompression");
            return null;
        }
    }
}

