/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.executor;

import be.business.connector.common.ApplicationConfig;
import be.business.connector.common.StandaloneRequestorProvider;
import be.business.connector.core.domain.KgssIdentifierType;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.Exceptionutils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.IOUtils;
import be.business.connector.core.utils.MarshallerHelper;
import be.business.connector.projects.common.utils.ValidationUtils;
import be.business.connector.recipe.AbstractRecipeClient;
import be.business.connector.recipe.executor.AbstractExecutorIntegrationModuleV4;
import be.business.connector.recipe.executor.ExecutorIntegrationModuleDevV4;
import be.business.connector.recipe.executor.domain.GetPrescriptionForExecutorResult;
import be.business.connector.recipe.executor.dto.ListOpenPrescriptionsResultWithExceptions;
import be.business.connector.recipe.executor.dto.ListReservationsResultWithExceptions;
import be.business.connector.recipe.executor.services.RecipeExecutorServiceDevV4Impl;
import be.business.connector.recipe.utils.RidValidator;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.recipe.services.core.MandateHolderType;
import be.recipe.services.core.PageFactory;
import be.recipe.services.core.ResponseType;
import be.recipe.services.executor.CreateFeedback;
import be.recipe.services.executor.CreateFeedbackResponse;
import be.recipe.services.executor.CreateFeedbackResult;
import be.recipe.services.executor.GetOpenPrescriptionForExecutor;
import be.recipe.services.executor.GetPrescriptionForExecutor;
import be.recipe.services.executor.GetPrescriptionForExecutorResponse;
import be.recipe.services.executor.GetPrescriptionForExecutorResultSealed;
import be.recipe.services.executor.GetPrescriptionStatus;
import be.recipe.services.executor.GetPrescriptionStatusParam;
import be.recipe.services.executor.GetPrescriptionStatusResponse;
import be.recipe.services.executor.GetPrescriptionStatusResult;
import be.recipe.services.executor.ListNotifications;
import be.recipe.services.executor.ListNotificationsItem;
import be.recipe.services.executor.ListNotificationsResponse;
import be.recipe.services.executor.ListNotificationsResult;
import be.recipe.services.executor.ListOpenPrescriptions;
import be.recipe.services.executor.ListOpenPrescriptionsParam;
import be.recipe.services.executor.ListOpenPrescriptionsResponse;
import be.recipe.services.executor.ListOpenPrescriptionsResult;
import be.recipe.services.executor.ListRelations;
import be.recipe.services.executor.ListRelationsParam;
import be.recipe.services.executor.ListRelationsResponse;
import be.recipe.services.executor.ListRelationsResult;
import be.recipe.services.executor.ListReservations;
import be.recipe.services.executor.ListReservationsParam;
import be.recipe.services.executor.ListReservationsResponse;
import be.recipe.services.executor.ListReservationsResult;
import be.recipe.services.executor.ListRidsHistory;
import be.recipe.services.executor.ListRidsHistoryParam;
import be.recipe.services.executor.ListRidsHistoryResponse;
import be.recipe.services.executor.ListRidsHistoryResult;
import be.recipe.services.executor.ListRidsInProcess;
import be.recipe.services.executor.ListRidsInProcessParam;
import be.recipe.services.executor.ListRidsInProcessResponse;
import be.recipe.services.executor.ListRidsInProcessResult;
import be.recipe.services.executor.MarkAsArchived;
import be.recipe.services.executor.MarkAsArchivedResponse;
import be.recipe.services.executor.MarkAsArchivedResult;
import be.recipe.services.executor.MarkAsDelivered;
import be.recipe.services.executor.MarkAsDeliveredResponse;
import be.recipe.services.executor.MarkAsDeliveredResult;
import be.recipe.services.executor.MarkAsUnDelivered;
import be.recipe.services.executor.MarkAsUnDeliveredResponse;
import be.recipe.services.executor.MarkAsUndeliveredResult;
import be.recipe.services.executor.PutRidsInProcess;
import be.recipe.services.executor.PutRidsInProcessParam;
import be.recipe.services.executor.PutRidsInProcessResponse;
import be.recipe.services.executor.PutRidsInProcessResult;
import be.recipe.services.executor.RevokePrescription;
import be.recipe.services.executor.RevokePrescriptionResponse;
import be.recipe.services.executor.RevokePrescriptionResult;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import javax.xml.ws.WebServiceException;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.commons.lang.StringUtils;
import org.perf4j.aop.Profiled;

public class ExecutorIntegrationModuleDevV4Impl
extends AbstractExecutorIntegrationModuleV4
implements ExecutorIntegrationModuleDevV4 {
    @Override
    @Profiled(logFailuresSeparately=true, tag="ExecutorIntegrationModuleV4#getData(GetOpenPrescriptionListParam)")
    public ListOpenPrescriptionsResult getData(ListOpenPrescriptionsParam param) {
        ApplicationConfig.getInstance().assertValidPharmacySession();
        ValidationUtils.validatePatientId(param.getPatientId());
        ValidationUtils.validateMandateHolderId(param.getMandateHolderId(), true);
        ListOpenPrescriptions getOpenPrescriptionList = this.getOpenPrescriptionList(param);
        try {
            try {
                ListOpenPrescriptionsResponse response = RecipeExecutorServiceDevV4Impl.getInstance().listOpenPrescriptions(getOpenPrescriptionList);
                ListOpenPrescriptionsResult result = this.unsealGetDataResponse(response);
                this.checkStatus((ResponseType)result);
                sessionMap.put(new MultiKey((Object)StandaloneRequestorProvider.getRequestorIdInformation(), (Object)(param.getMandateHolderId() != null ? param.getMandateHolderId() : param.getPatientId())), result.getSession());
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, getOpenPrescriptionList.getMguid());
            return null;
        }
    }

    private ListOpenPrescriptions getOpenPrescriptionList(ListOpenPrescriptionsParam param) {
        param.setSession((byte[])sessionMap.get(new MultiKey((Object)StandaloneRequestorProvider.getRequestorIdInformation(), (Object)(StringUtils.isNotBlank((String)param.getMandateHolderId()) ? param.getMandateHolderId() : param.getPatientId()))));
        ListOpenPrescriptions request = new ListOpenPrescriptions();
        request.setListOpenPrescriptionsParamSealed(this.getSealedData(param));
        request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setMguid(UUID.randomUUID().toString());
        return request;
    }

    private byte[] getSealedData(ListOpenPrescriptionsParam listOpenPrescriptionsParam) {
        listOpenPrescriptionsParam.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(listOpenPrescriptionsParam, ListOpenPrescriptionsParam.class);
    }

    private ListOpenPrescriptionsResult unsealGetDataResponse(ListOpenPrescriptionsResponse response) {
        MarshallerHelper<ListOpenPrescriptionsResult, Object> marshaller = new MarshallerHelper<ListOpenPrescriptionsResult, Object>(ListOpenPrescriptionsResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getListOpenPrescriptionsResultSealed(), this.getSymmKey());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#getData(GetPrescriptionStatusParam)")
    public GetPrescriptionStatusResult getData(GetPrescriptionStatusParam param) {
        RidValidator.validateRid(param.getRid());
        ApplicationConfig.getInstance().assertValidPharmacySession();
        GetPrescriptionStatus getPrescriptionStatus = this.getPrescriptionStatus(param);
        try {
            try {
                GetPrescriptionStatusResponse response = RecipeExecutorServiceDevV4Impl.getInstance().getPrescriptionStatus(getPrescriptionStatus);
                GetPrescriptionStatusResult result = this.unsealGetPrescriptionStatusResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, getPrescriptionStatus.getMguid());
            return null;
        }
    }

    private GetPrescriptionStatus getPrescriptionStatus(GetPrescriptionStatusParam getPrescriptionStatusParam) {
        GetPrescriptionStatus getPrescriptionStatus = new GetPrescriptionStatus();
        getPrescriptionStatus.setGetPrescriptionStatusParamSealed(this.getSealedData(getPrescriptionStatusParam));
        getPrescriptionStatus.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        getPrescriptionStatus.setMguid(UUID.randomUUID().toString());
        return getPrescriptionStatus;
    }

    private GetPrescriptionStatusResult unsealGetPrescriptionStatusResponse(GetPrescriptionStatusResponse response) {
        MarshallerHelper<GetPrescriptionStatusResult, Object> marshaller = new MarshallerHelper<GetPrescriptionStatusResult, Object>(GetPrescriptionStatusResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getGetPrescriptionStatusResultSealed(), this.getSymmKey());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#getData(ListRidsHistoryParam)")
    public ListRidsHistoryResult getData(ListRidsHistoryParam param) {
        ApplicationConfig.getInstance().assertValidPharmacySession();
        ValidationUtils.validatePatientId(param.getPatientId());
        ListRidsHistory listPrescriptionHistory = this.getListRidsHistory(param);
        try {
            try {
                ListRidsHistoryResponse response = RecipeExecutorServiceDevV4Impl.getInstance().listRidsHistory(listPrescriptionHistory);
                ListRidsHistoryResult result = this.unsealListRidsHistoryResponse(response);
                this.checkStatus((ResponseType)result);
                sessionMap.put(new MultiKey((Object)StandaloneRequestorProvider.getRequestorIdInformation(), (Object)param.getPatientId()), result.getSession());
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, listPrescriptionHistory.getMguid());
            return null;
        }
    }

    private ListRidsHistory getListRidsHistory(ListRidsHistoryParam listRidsHistoryParam) {
        listRidsHistoryParam.setSession((byte[])sessionMap.get(new MultiKey((Object)StandaloneRequestorProvider.getRequestorIdInformation(), (Object)listRidsHistoryParam.getPatientId())));
        ListRidsHistory listPrescriptionHistory = new ListRidsHistory();
        listPrescriptionHistory.setListRidsHistoryParamSealed(this.getSealedData(listRidsHistoryParam));
        listPrescriptionHistory.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        listPrescriptionHistory.setMguid(UUID.randomUUID().toString());
        return listPrescriptionHistory;
    }

    private byte[] getSealedData(ListRidsHistoryParam listRidsHistoryParam) {
        listRidsHistoryParam.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(listRidsHistoryParam, ListRidsHistoryParam.class);
    }

    private ListRidsHistoryResult unsealListRidsHistoryResponse(ListRidsHistoryResponse response) {
        MarshallerHelper<ListRidsHistoryResult, Object> marshaller = new MarshallerHelper<ListRidsHistoryResult, Object>(ListRidsHistoryResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getListRidsHistoryResultSealed(), this.getSymmKey());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="ExecutorIntegrationModuleV4#getPrescription")
    public GetPrescriptionForExecutorResult getPrescription(String rid) {
        return this.getPrescription(rid, null, null, false);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="ExecutorIntegrationModuleV4#getPrescription")
    public GetPrescriptionForExecutorResult getPrescription(String rid, boolean skipInProcess) {
        return this.getPrescription(rid, null, null, skipInProcess);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="ExecutorIntegrationModuleV4#getPrescription")
    public GetPrescriptionForExecutorResult getPrescription(String rid, String mandateHolderId, MandateHolderType mandateHolderType) {
        return this.getPrescription(rid, null, null, false);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="ExecutorIntegrationModuleV4#getPrescription")
    public GetPrescriptionForExecutorResult getPrescription(String rid, String mandateHolderId, MandateHolderType mandateHolderType, boolean skipInProcess) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidPharmacySession();
        String guid = UUID.randomUUID().toString();
        try {
            byte[] sealedGetPrescriptionForExecutorParam = this.getSealedGetPrescriptionForExecutorParam(rid, null, mandateHolderId, mandateHolderType, skipInProcess);
            GetPrescriptionForExecutor request = new GetPrescriptionForExecutor();
            request.setDisablePatientInsurabilityCheckParam(Boolean.valueOf(Boolean.parseBoolean(this.getPropertyHandler().getProperty("patient.insurability.disable"))));
            request.setGetPrescriptionForExecutorParamSealed(sealedGetPrescriptionForExecutorParam);
            request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setMguid(guid);
            GetPrescriptionForExecutorResponse response = null;
            try {
                response = RecipeExecutorServiceDevV4Impl.getInstance().getPrescriptionForExecutor(request);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
            be.recipe.services.executor.GetPrescriptionForExecutorResult executorResult = response.getGetPrescriptionForExecutorResult();
            GetPrescriptionForExecutorResult finalResult = this.createGetPrescriptionForExecutorResult(executorResult.getGetPrescriptionForExecutorResultSealed());
            this.checkStatus((ResponseType)finalResult);
            ExecutorIntegrationModuleDevV4Impl.getPrescriptionCache().put(rid, finalResult);
            return finalResult;
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, guid);
            return null;
        }
    }

    protected GetPrescriptionForExecutorResult createGetPrescriptionForExecutorResult(byte[] securedContent) {
        MarshallerHelper<GetPrescriptionForExecutorResultSealed, Object> marshaller = new MarshallerHelper<GetPrescriptionForExecutorResultSealed, Object>(GetPrescriptionForExecutorResultSealed.class, Object.class);
        String requestorIdInformation = StandaloneRequestorProvider.getRequestorIdInformation();
        String requestorTypeInformation = StandaloneRequestorProvider.getRequestorTypeInformation();
        GetPrescriptionForExecutorResultSealed sealedResult = marshaller.unsealWithSymmKey(securedContent, this.getSymmKey());
        GetPrescriptionForExecutorResult finalResult = new GetPrescriptionForExecutorResult(sealedResult);
        finalResult.setStatus(sealedResult.getStatus());
        this.checkStatus((ResponseType)finalResult);
        finalResult.setSealedContent(sealedResult.getPrescription());
        KeyResult key = this.getKeyFromKgss(sealedResult.getEncryptionKeyId(), this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_PHARMACY, requestorIdInformation).get(0).getEncoded());
        byte[] unsealedPrescription = this.unsealWithSymKey(sealedResult, key, requestorIdInformation, requestorTypeInformation);
        finalResult.setPrescription(unsealedPrescription);
        finalResult.setEncryptionKey(key.getSecretKey().getEncoded());
        return finalResult;
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#decryptGetOpenPrescriptionForExecutor")
    public GetOpenPrescriptionForExecutor decryptGetOpenPrescriptionForExecutor(GetOpenPrescriptionForExecutor gopfe) {
        try {
            String requestorIdInformation = StandaloneRequestorProvider.getRequestorIdInformation();
            KeyResult key = this.getKeyFromKgss(gopfe.getEncryptionKeyId(), this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_PHARMACY, requestorIdInformation).get(0).getEncoded());
            byte[] unsealedPrescription = this.unsealPrescriptionForUnknown(key, gopfe.getPrescription());
            GetOpenPrescriptionForExecutor finalResult = new GetOpenPrescriptionForExecutor();
            finalResult.setCreationDate(gopfe.getCreationDate());
            finalResult.setEncryptionKeyId(gopfe.getEncryptionKeyId());
            finalResult.setFeedbackAllowed(gopfe.isFeedbackAllowed());
            finalResult.setId(gopfe.getId());
            finalResult.setPatientId(gopfe.getPatientId());
            finalResult.setPrescriberId(gopfe.getPrescriberId());
            finalResult.setPrescription(IOUtils.decompress(unsealedPrescription));
            finalResult.setPrescriptionType(gopfe.getPrescriptionType());
            finalResult.setRid(gopfe.getRid());
            finalResult.setStatus(gopfe.getStatus());
            finalResult.setExpirationDate(gopfe.getExpirationDate());
            return finalResult;
        }
        catch (IOException ex) {
            Exceptionutils.errorHandler(ex, "error.data.uncompression");
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#markAsArchived")
    public void markAsArchived(String rid) {
        this.markAsArchived(rid, null, null);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#markAsArchived")
    public void markAsArchived(String rid, String mandateHolderId, MandateHolderType mandateHolderType) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidPharmacySession();
        MarkAsArchived request = new MarkAsArchived();
        request.setMguid(UUID.randomUUID().toString());
        try {
            byte[] sealedMarkAsArchivedParam = this.getSealedMarkAsArchivedParam(rid, mandateHolderId, mandateHolderType);
            request.setMarkAsArchivedParamSealed(sealedMarkAsArchivedParam);
            request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            try {
                MarkAsArchivedResponse response = RecipeExecutorServiceDevV4Impl.getInstance().markAsArchived(request);
                MarshallerHelper<MarkAsArchivedResult, Object> marshaller = new MarshallerHelper<MarkAsArchivedResult, Object>(MarkAsArchivedResult.class, Object.class);
                MarkAsArchivedResult result = marshaller.unsealWithSymmKey(response.getMarkAsArchivedResultSealed(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getMguid());
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#markAsDelivered")
    public void markAsDelivered(String rid) {
        this.markAsDelivered(rid, null, null);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#markAsDelivered")
    public void markAsDelivered(String rid, String mandateHolderId, MandateHolderType mandateHolderType) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidPharmacySession();
        MarkAsDelivered request = new MarkAsDelivered();
        request.setMguid(UUID.randomUUID().toString());
        try {
            byte[] sealedMarkAsDeliveredParam = this.getSealedMarkAsDeliveredParam(rid, mandateHolderId, mandateHolderType);
            request.setMarkAsDeliveredParamSealed(sealedMarkAsDeliveredParam);
            request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            MarkAsDeliveredResponse response = null;
            try {
                response = RecipeExecutorServiceDevV4Impl.getInstance().markAsDelivered(request);
                MarshallerHelper<MarkAsDeliveredResult, Object> marshaller = new MarshallerHelper<MarkAsDeliveredResult, Object>(MarkAsDeliveredResult.class, Object.class);
                MarkAsDeliveredResult result = marshaller.unsealWithSymmKey(response.getMarkAsDeliveredResultSealed(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getMguid());
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#markAsUnDelivered")
    public void markAsUndelivered(String rid) {
        this.markAsUndelivered(rid, null, null);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#markAsUnDelivered")
    public void markAsUndelivered(String rid, String mandateHolderId, MandateHolderType mandateHolderType) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidPharmacySession();
        MarkAsUnDelivered request = new MarkAsUnDelivered();
        request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setMguid(UUID.randomUUID().toString());
        try {
            byte[] sealedMarkAsUnDeliveredParam = this.getSealedMarkAsUnDeliveredParam(rid, mandateHolderId, mandateHolderType);
            request.setMarkAsUndeliveredParamSealed(sealedMarkAsUnDeliveredParam);
            MarkAsUnDeliveredResponse response = null;
            try {
                response = RecipeExecutorServiceDevV4Impl.getInstance().markAsUnDelivered(request);
                MarshallerHelper<MarkAsUndeliveredResult, Object> marshaller = new MarshallerHelper<MarkAsUndeliveredResult, Object>(MarkAsUndeliveredResult.class, Object.class);
                MarkAsUndeliveredResult result = marshaller.unsealWithSymmKey(response.getMarkAsUnDeliveredResultSealed(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getMguid());
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#revokePrescription")
    public void revokePrescription(String rid, String reason) {
        this.revokePrescription(rid, reason, null, null);
    }

    @Override
    public void revokePrescription(String rid, String reason, String mandateHolderId, MandateHolderType mandateHolderType) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidPharmacySession();
        RevokePrescription request = new RevokePrescription();
        try {
            byte[] sealedRevokePrescriptionParam = this.getSealedRevokePrescriptionParam(rid, reason, mandateHolderId, mandateHolderType);
            request.setRevokePrescriptionParamSealed(sealedRevokePrescriptionParam);
            request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setMguid(UUID.randomUUID().toString());
            RevokePrescriptionResponse response = null;
            try {
                response = RecipeExecutorServiceDevV4Impl.getInstance().revokePrescriptionForExecutor(request);
                MarshallerHelper<RevokePrescriptionResult, Object> marshaller = new MarshallerHelper<RevokePrescriptionResult, Object>(RevokePrescriptionResult.class, Object.class);
                RevokePrescriptionResult result = marshaller.unsealWithSymmKey(response.getRevokePrescriptionResultSealed(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getMguid());
        }
    }

    @Override
    public List<ListNotificationsItem> listNotifications(boolean readFlag) {
        return this.listNotifications(readFlag, null, null);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#listNotifications")
    public List<ListNotificationsItem> listNotifications(boolean readFlag, String mandateHolderId, MandateHolderType mandateHolderType) {
        ApplicationConfig.getInstance().assertValidPharmacySession();
        ListNotifications request = new ListNotifications();
        request.setMguid(UUID.randomUUID().toString());
        try {
            byte[] sealedListNotificationsParam = this.getSealedListNotificationsParam(readFlag, mandateHolderId, mandateHolderType);
            request.setListNotificationsParamSealed(sealedListNotificationsParam);
            request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            ListNotificationsResponse response = null;
            try {
                response = RecipeExecutorServiceDevV4Impl.getInstance().listNotifications(request);
                MarshallerHelper<ListNotificationsResult, Object> marshaller = new MarshallerHelper<ListNotificationsResult, Object>(ListNotificationsResult.class, Object.class);
                ListNotificationsResult result = marshaller.unsealWithSymmKey(response.getListNotificationsResultSealed(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
            byte[] securedContent = response.getListNotificationsResultSealed();
            return this.createListNotificationItems(securedContent);
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getMguid());
            return null;
        }
    }

    @Override
    public void createFeedback(String prescriberId, String rid, byte[] feedbackText) {
        this.createFeedback(prescriberId, rid, feedbackText, null, null);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#createFeedback")
    public void createFeedback(String prescriberId, String rid, byte[] feedbackText, String mandateHolderId, MandateHolderType mandateHolderType) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidPharmacySession();
        CreateFeedback request = new CreateFeedback();
        request.setMguid(UUID.randomUUID().toString());
        try {
            this.getKmehrHelper().assertValidFeedback(feedbackText);
            ArrayList<EncryptionToken> etkRecipients = new ArrayList<EncryptionToken>();
            try {
                etkRecipients.addAll(this.getEtkHelper().getEtks(KgssIdentifierType.NIHII, prescriberId));
            }
            catch (Exception e) {
                try {
                    etkRecipients.addAll(this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_PHARMACY, prescriberId));
                }
                catch (Exception e1) {
                    try {
                        etkRecipients.addAll(this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_HOSPITAL, prescriberId));
                    }
                    catch (Exception e2) {
                        Exceptionutils.errorHandler(e1, e.getMessage() + e2.getMessage());
                    }
                }
            }
            for (int i = 0; i < etkRecipients.size(); ++i) {
                EncryptionToken etkRecipient = (EncryptionToken)etkRecipients.get(i);
                byte[] sealedCreateFeedbackParam = this.getSealedCreateFeedbackParam(feedbackText, etkRecipient, rid, prescriberId, mandateHolderId, mandateHolderType);
                request.setCreateFeedbackParamSealed(sealedCreateFeedbackParam);
                request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
                try {
                    CreateFeedbackResponse response = RecipeExecutorServiceDevV4Impl.getInstance().createFeedback(request);
                    MarshallerHelper<CreateFeedbackResult, Object> marshaller1 = new MarshallerHelper<CreateFeedbackResult, Object>(CreateFeedbackResult.class, Object.class);
                    CreateFeedbackResult result = marshaller1.unsealWithSymmKey(response.getCreateFeedbackResultSealed(), this.getSymmKey());
                    this.checkStatus((ResponseType)result);
                    continue;
                }
                catch (WebServiceException cte) {
                    throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
                }
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getMguid());
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#getData(ListReservationsParam)")
    public ListReservationsResult getData(ListReservationsParam param) {
        ApplicationConfig.getInstance().assertValidPharmacySession();
        Calendar lastSyncDate = Calendar.getInstance();
        try {
            try {
                ListReservationsResult result;
                ListReservationsResult completeResult = new ListReservationsResult();
                do {
                    if (param.getPage() == null) {
                        param.setPage(PageFactory.defaultPage());
                    }
                    BigInteger currentPage = param.getPage() != null && param.getPage().getPageNumber() == null ? BigInteger.valueOf(0L) : param.getPage().getPageNumber();
                    param.getPage().setPageNumber(currentPage);
                    ListReservations request = this.getListReservations(param);
                    ListReservationsResponse response = RecipeExecutorServiceDevV4Impl.getInstance().listReservations(request);
                    result = this.unsealListReservationsResponse(response);
                    this.checkStatus((ResponseType)result);
                    completeResult.getItems().addAll(result.getItems());
                    completeResult.setHasMoreResults(result.getHasMoreResults());
                    param.getPage().setPageNumber(BigInteger.valueOf(currentPage.intValue() + 1));
                } while (result != null && result.isHasMoreResults() != null && result.isHasMoreResults().booleanValue());
                this.writeReservationsOnDisk(param, completeResult, lastSyncDate);
                return completeResult;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    private ListReservations getListReservations(ListReservationsParam param) {
        param.setSymmKey(this.getSymmKey().getEncoded());
        param.setStartDate(param.getStartDate() == null ? this.readLastDateToDisk() : param.getStartDate());
        ListReservations listReservations = new ListReservations();
        listReservations.setListReservationsParamSealed(this.getSealedData(param));
        listReservations.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        listReservations.setMguid(UUID.randomUUID().toString());
        return listReservations;
    }

    private byte[] getSealedData(ListReservationsParam listReservationsParam) {
        return this.sealForRecipe(listReservationsParam, ListReservationsParam.class);
    }

    private ListReservationsResult unsealListReservationsResponse(ListReservationsResponse response) {
        MarshallerHelper<ListReservationsResult, Object> marshaller = new MarshallerHelper<ListReservationsResult, Object>(ListReservationsResult.class, Object.class);
        ListReservationsResult result = marshaller.unsealWithSymmKey(response.getListReservationsResultSealed(), this.getSymmKey());
        return result;
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#getData(ListRidsInProcessParam)")
    public ListRidsInProcessResult getData(ListRidsInProcessParam param) {
        ApplicationConfig.getInstance().assertValidPharmacySession();
        ListRidsInProcess request = this.getListRidsInProcess(param);
        try {
            try {
                ListRidsInProcessResponse response = RecipeExecutorServiceDevV4Impl.getInstance().listRidsInProcess(request);
                ListRidsInProcessResult result = this.unsealListRidsInProcessResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getMguid());
            return null;
        }
    }

    private ListRidsInProcess getListRidsInProcess(ListRidsInProcessParam listRidsInProcessParam) {
        listRidsInProcessParam.setSymmKey(this.getSymmKey().getEncoded());
        ListRidsInProcess getAllRidInProcess = new ListRidsInProcess();
        getAllRidInProcess.setListRidsInProcessParamSealed(this.getSealedData(listRidsInProcessParam));
        getAllRidInProcess.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        getAllRidInProcess.setMguid(UUID.randomUUID().toString());
        return getAllRidInProcess;
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#putData(PutAllRidInProcessParam)")
    public PutRidsInProcessResult putData(PutRidsInProcessParam param) {
        ApplicationConfig.getInstance().assertValidPharmacySession();
        PutRidsInProcess request = this.getPutAllRidInProcess(param);
        try {
            try {
                PutRidsInProcessResponse response = RecipeExecutorServiceDevV4Impl.getInstance().putRidsInProcess(request);
                PutRidsInProcessResult result = this.unsealPutRidsInProcessResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getMguid());
            return null;
        }
    }

    private PutRidsInProcess getPutAllRidInProcess(PutRidsInProcessParam putRidsInProcessParam) {
        putRidsInProcessParam.setSymmKey(this.getSymmKey().getEncoded());
        PutRidsInProcess putAllRidInProcess = new PutRidsInProcess();
        putAllRidInProcess.setPutRidsInProcessParamSealed(this.getSealedData(putRidsInProcessParam));
        putAllRidInProcess.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        putAllRidInProcess.setMguid(UUID.randomUUID().toString());
        return putAllRidInProcess;
    }

    private byte[] getSealedData(PutRidsInProcessParam putRidsInProcessParam) {
        return this.sealForRecipe(putRidsInProcessParam, PutRidsInProcessParam.class);
    }

    private byte[] getSealedData(ListRidsInProcessParam litRidsInProcessParam) {
        return this.sealForRecipe(litRidsInProcessParam, ListRidsInProcessParam.class);
    }

    private PutRidsInProcessResult unsealPutRidsInProcessResponse(PutRidsInProcessResponse response) {
        MarshallerHelper<PutRidsInProcessResult, Object> marshaller = new MarshallerHelper<PutRidsInProcessResult, Object>(PutRidsInProcessResult.class, Object.class);
        PutRidsInProcessResult result = marshaller.unsealWithSymmKey(response.getPutRidsInProcessResultSealed(), this.getSymmKey());
        return result;
    }

    private ListRidsInProcessResult unsealListRidsInProcessResponse(ListRidsInProcessResponse response) {
        MarshallerHelper<ListRidsInProcessResult, Object> marshaller = new MarshallerHelper<ListRidsInProcessResult, Object>(ListRidsInProcessResult.class, Object.class);
        ListRidsInProcessResult result = marshaller.unsealWithSymmKey(response.getListRidsInProcessResultSealed(), this.getSymmKey());
        return result;
    }

    @Override
    public GetPrescriptionForExecutorResult getAndMarkAsDelivered(String rid) {
        return this.getAndMarkAsDelivered(rid, null, null);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#getAndMarkAsDelivered")
    public GetPrescriptionForExecutorResult getAndMarkAsDelivered(String rid, String mandateHolderId, MandateHolderType mandateHolderType) {
        try {
            GetPrescriptionForExecutorResult getPrescriptionForExecutorResult = ExecutorIntegrationModuleDevV4Impl.getPrescriptionCache().containsKey(rid) ? ExecutorIntegrationModuleDevV4Impl.getPrescriptionCache().get(rid) : this.getPrescription(rid, mandateHolderId, mandateHolderType);
            this.markAsDelivered(rid, mandateHolderId, mandateHolderType);
            return getPrescriptionForExecutorResult;
        }
        catch (Exception t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    @Override
    public List<GetPrescriptionForExecutorResult> getAndMarkAsDelivered(List<String> rids) {
        return null;
    }

    @Override
    public ListRelationsResult getData(ListRelationsParam patientRelationParam) {
        ApplicationConfig.getInstance().assertValidPharmacySession();
        ListRelations request = this.getListPatientRelation(patientRelationParam);
        try {
            try {
                ListRelationsResponse dataResponse = RecipeExecutorServiceDevV4Impl.getInstance().listRelations(request);
                ListRelationsResult unsealedResponse = this.unsealListRelationsResponse(dataResponse);
                this.checkStatus((ResponseType)unsealedResponse);
                sessionMap.put(new MultiKey((Object)StandaloneRequestorProvider.getRequestorIdInformation(), (Object)patientRelationParam.getMandateHolderId()), unsealedResponse.getSession());
                return unsealedResponse;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getMguid());
            return null;
        }
    }

    private ListRelations getListPatientRelation(ListRelationsParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        data.setSession((byte[])sessionMap.get(new MultiKey((Object)StandaloneRequestorProvider.getRequestorIdInformation(), (Object)data.getMandateHolderId())));
        ListRelations patientRelation = new ListRelations();
        patientRelation.setListRelationsParamSealed(this.getSealedData(data));
        patientRelation.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        patientRelation.setMguid(UUID.randomUUID().toString());
        return patientRelation;
    }

    private byte[] getSealedData(ListRelationsParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(data, ListRelationsParam.class);
    }

    private ListRelationsResult unsealListRelationsResponse(ListRelationsResponse response) {
        MarshallerHelper<ListRelationsResult, Object> marshaller = new MarshallerHelper<ListRelationsResult, Object>(ListRelationsResult.class, Object.class);
        ListRelationsResult result = marshaller.unsealWithSymmKey(response.getListRelationsResultSealed(), this.getSymmKey());
        return result;
    }

    @Override
    public ListReservationsResult listReservationsDecrypted(ListReservationsParam request) {
        return this.decryptListReservationsResult(this.getData(request));
    }

    @Override
    public ListReservationsResultWithExceptions listReservationsDecryptedWithExceptions(ListReservationsParam request) {
        return this.decryptListReservationsResultWithExceptions(this.getData(request));
    }

    @Override
    public ListOpenPrescriptionsResult listOpenPrescriptionsDecrypted(ListOpenPrescriptionsParam request) {
        return this.decryptListOpenPrescriptionsResult(this.getData(request));
    }

    @Override
    public ListOpenPrescriptionsResult listOpenPrescriptionsDecryptedSingleThreaded(ListOpenPrescriptionsParam request) {
        return this.decryptListOpenPrescriptionsResultSingleThreaded(this.getData(request));
    }

    @Override
    public ListOpenPrescriptionsResultWithExceptions listOpenPrescriptionsWithExceptionsDecrypted(ListOpenPrescriptionsParam request) {
        return this.decryptListOpenPrescriptionsResultWithExceptions(this.getData(request));
    }

    @Override
    public void clearSession() {
        sessionMap.clear();
    }
}

