/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.executor;

import be.business.connector.common.StandaloneRequestorProvider;
import be.business.connector.common.module.AbstractIntegrationModule;
import be.business.connector.core.domain.KgssIdentifierType;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.IOUtils;
import be.business.connector.core.utils.MarshallerHelper;
import be.business.connector.recipe.executor.domain.GetPrescriptionForExecutorResult;
import be.business.connector.recipe.executor.domain.ListNotificationsItem;
import be.business.connector.recipe.utils.KmehrHelper;
import be.business.connector.recipe.utils.Locales;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.fgov.ehealth.commons.core.v1.IdentifierType;
import be.fgov.ehealth.commons.core.v1.LocalisedString;
import be.fgov.ehealth.commons.core.v1.StatusType;
import be.fgov.ehealth.commons.protocol.v1.ResponseType;
import be.fgov.ehealth.commons.protocol.v2.ObjectFactory;
import be.fgov.ehealth.commons.protocol.v2.StatusResponseType;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.recipe.core.v4.SecuredContentType;
import be.recipe.services.core.MandateHolderType;
import be.recipe.services.core.PageFactory;
import be.recipe.services.executor.CreateFeedbackParam;
import be.recipe.services.executor.GetPrescriptionForExecutorParam;
import be.recipe.services.executor.GetPrescriptionForExecutorResultSealed;
import be.recipe.services.executor.GetPrescriptionStatusParam;
import be.recipe.services.executor.ListNotificationsParam;
import be.recipe.services.executor.ListNotificationsResult;
import be.recipe.services.executor.ListReservations;
import be.recipe.services.executor.ListReservationsParam;
import be.recipe.services.executor.ListReservationsResult;
import be.recipe.services.executor.ListReservationsResultItem;
import be.recipe.services.executor.MarkAsArchivedParam;
import be.recipe.services.executor.MarkAsDeliveredParam;
import be.recipe.services.executor.MarkAsUndeliveredParam;
import be.recipe.services.executor.RevokePrescriptionParam;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecutorIntegrationModule
extends AbstractIntegrationModule {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractExecutorIntegrationModule.class);
    private static Map<String, GetPrescriptionForExecutorResult> prescriptionCache;

    public static Map<String, GetPrescriptionForExecutorResult> getPrescriptionCache() {
        if (prescriptionCache == null) {
            prescriptionCache = new HashMap<String, GetPrescriptionForExecutorResult>();
        }
        return prescriptionCache;
    }

    protected KmehrHelper getKmehrHelper() {
        return new KmehrHelper();
    }

    protected byte[] getSealedRevokePrescriptionParam(String rid, String reason, String mandateHolderId, MandateHolderType mandateHolderType) {
        RevokePrescriptionParam param = new RevokePrescriptionParam();
        param.setRid(rid);
        param.setReason(reason);
        param.setExecutorId(StandaloneRequestorProvider.getRequestorIdInformation());
        param.setSymmKey(this.getSymmKey().getEncoded());
        if (mandateHolderId != null) {
            param.setMandateHolderId(mandateHolderId);
        }
        return this.sealForRecipe(param, RevokePrescriptionParam.class);
    }

    public byte[] getSealedMarkAsArchivedParam(String rid, String mandateHolderId, MandateHolderType mandateHolderType) {
        MarkAsArchivedParam param = new MarkAsArchivedParam();
        param.setRid(rid);
        param.setExecutorId(StandaloneRequestorProvider.getRequestorIdInformation());
        param.setSymmKey(this.getSymmKey().getEncoded());
        if (mandateHolderId != null) {
            param.setMandateHolderId(mandateHolderId);
        }
        return this.sealForRecipe(param, MarkAsArchivedParam.class);
    }

    public byte[] getSealedMarkAsDeliveredParam(String rid, String mandateHolderId, MandateHolderType mandateHolderType) {
        MarkAsDeliveredParam param = new MarkAsDeliveredParam();
        param.setRid(rid);
        param.setExecutorId(StandaloneRequestorProvider.getRequestorIdInformation());
        param.setSymmKey(this.getSymmKey().getEncoded());
        if (mandateHolderId != null) {
            param.setMandateHolderId(mandateHolderId);
        }
        return this.sealForRecipe(param, MarkAsDeliveredParam.class);
    }

    public byte[] getSealedMarkAsUnDeliveredParam(String rid, String mandateHolderId, MandateHolderType mandateHolderType) {
        MarkAsUndeliveredParam param = new MarkAsUndeliveredParam();
        param.setRid(rid);
        param.setExecutorId(StandaloneRequestorProvider.getRequestorIdInformation());
        param.setSymmKey(this.getSymmKey().getEncoded());
        if (mandateHolderId != null) {
            param.setMandateHolderId(mandateHolderId);
        }
        return this.sealForRecipe(param, MarkAsUndeliveredParam.class);
    }

    public byte[] getSealedGetPrescriptionForExecutorParam(String rid) {
        return this.getSealedGetPrescriptionForExecutorParam(rid, null, null, null, false);
    }

    protected byte[] getSealedGetPrescriptionForExecutorParam(String rid, String patientId, String madateHolderId, MandateHolderType mandateHolderType, boolean alreadyDelivered) {
        GetPrescriptionForExecutorParam param = new GetPrescriptionForExecutorParam();
        param.setRid(rid);
        param.setPatientId(patientId);
        param.setSymmKey(this.getSymmKey().getEncoded());
        param.setVersion(this.getPropertyHandler().getProperty("connector.version", "v2"));
        param.setExecutorId(StandaloneRequestorProvider.getRequestorIdInformation());
        param.setAlreadyDelivered(Boolean.valueOf(alreadyDelivered));
        param.setMandateHolderId(madateHolderId);
        return this.sealForRecipe(param, GetPrescriptionForExecutorParam.class);
    }

    protected byte[] getSealedCreateFeedbackParam(byte[] feedbackText, EncryptionToken etkRecipient, String rid, String prescriberId, String mandateHolderId, MandateHolderType mandateHolderType) throws Exception {
        byte[] message = IOUtils.compress(feedbackText);
        message = this.sealRequest(etkRecipient, message);
        CreateFeedbackParam param = new CreateFeedbackParam();
        param.setRid(rid);
        param.setContent(message);
        param.setSymmKey(this.getSymmKey().getEncoded());
        param.setPrescriberId(prescriberId);
        param.setExecutorId(StandaloneRequestorProvider.getRequestorIdInformation());
        param.setMandateHolderId(mandateHolderId);
        return this.sealForRecipe(param, CreateFeedbackParam.class);
    }

    public byte[] getSealedListNotificationsParam(boolean readFlag, String mandateHoldeId, MandateHolderType mandateHolderType) {
        ListNotificationsParam param = new ListNotificationsParam();
        param.setSymmKey(this.getSymmKey().getEncoded());
        param.setReadFlag(readFlag);
        param.setExecutorId(StandaloneRequestorProvider.getRequestorIdInformation());
        param.setMandateHolderId(mandateHoldeId);
        param.setPage(PageFactory.defaultPage());
        return this.sealForRecipe(param, ListNotificationsParam.class);
    }

    public byte[] getSealedData(GetPrescriptionStatusParam getPrescriptionStatusParam) {
        getPrescriptionStatusParam.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(getPrescriptionStatusParam, GetPrescriptionStatusParam.class);
    }

    protected <T> byte[] sealForRecipe(T data, Class<T> type) {
        MarshallerHelper<Object, T> helper = new MarshallerHelper<Object, T>(Object.class, type);
        EncryptionToken etkRecipe = this.getEtkHelper().getRecipe_ETK().get(0);
        return this.sealRequest(etkRecipe, helper.toXMLByteArray(data));
    }

    protected GetPrescriptionForExecutorResult createGetPrescriptionForExecutorResult(GetPrescriptionForExecutorResultSealed getPrescriptionForExecutorResultSealed) {
        String requestorIdInformation = StandaloneRequestorProvider.getRequestorIdInformation();
        String requestorTypeInformation = StandaloneRequestorProvider.getRequestorTypeInformation();
        KeyResult key = this.getKeyFromKgss(getPrescriptionForExecutorResultSealed.getEncryptionKeyId(), this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_PHARMACY, requestorIdInformation).get(0).getEncoded());
        byte[] unsealedPrescription = this.unsealWithSymKey(getPrescriptionForExecutorResultSealed, key, requestorIdInformation, requestorTypeInformation);
        GetPrescriptionForExecutorResult finalResult = new GetPrescriptionForExecutorResult(getPrescriptionForExecutorResultSealed);
        finalResult.setSealedContent(getPrescriptionForExecutorResultSealed.getPrescription());
        finalResult.setPrescription(unsealedPrescription);
        finalResult.setEncryptionKey(key.getSecretKey().getEncoded());
        return finalResult;
    }

    protected List<be.recipe.services.executor.ListNotificationsItem> createListNotificationItems(byte[] sealedExecutorResponse) {
        MarshallerHelper<ListNotificationsResult, Object> marshaller = new MarshallerHelper<ListNotificationsResult, Object>(ListNotificationsResult.class, Object.class);
        ListNotificationsResult result = marshaller.unsealWithSymmKey(sealedExecutorResponse, this.getSymmKey());
        List items = result.getNotifications();
        for (int i = 0; i < items.size(); ++i) {
            ListNotificationsItem item = new ListNotificationsItem((be.recipe.services.executor.ListNotificationsItem)items.get(i));
            if (item != null && item.getContent() != null) {
                try {
                    byte[] bytes = this.unsealNotiffeed(item.getContent());
                    if (bytes != null) {
                        item.setContent(IOUtils.decompress(bytes));
                    }
                }
                catch (IOException e) {
                    item.setLinkedException(e);
                }
            }
            items.set(i, item);
        }
        return items;
    }

    public void checkStatus(ResponseType responseType) {
        if (!"100".equals(responseType.getStatus().getCode()) && !"200".equals(responseType.getStatus().getCode())) {
            LOG.error("Error Status received : " + responseType.getStatus().getCode());
            throw new IntegrationModuleException(this.getLocalisedMsg(responseType.getStatus()));
        }
    }

    protected void checkResponseStatus(StatusResponseType statusType) {
        ObjectFactory of = new ObjectFactory();
        if (!"urn:be:fgov:ehealth:2.0:status:Success".equals(statusType.getStatus().getStatusCode())) {
            LOG.error("Error Status received : " + statusType.getStatus().getStatusCode());
            throw new IntegrationModuleException(statusType.getStatus().getStatusMessage());
        }
    }

    public void checkStatus(be.recipe.services.core.ResponseType responseType) {
        if (!"100".equals(responseType.getStatus().getCode()) && !"200".equals(responseType.getStatus().getCode())) {
            LOG.error("Error Status received : " + responseType.getStatus().getCode());
            throw new IntegrationModuleException(Locales.getLocalisedMsg(responseType.getStatus()), responseType);
        }
    }

    private String getLocalisedMsg(StatusType status) {
        String locale = IntegrationModuleException.getUserLocale();
        for (LocalisedString msg : status.getMessages()) {
            if (msg.getLang() == null || !locale.equalsIgnoreCase(msg.getLang().value())) continue;
            return msg.getValue();
        }
        if (status.getMessages().size() > 0) {
            return ((LocalisedString)status.getMessages().get(0)).getValue();
        }
        return status.getCode();
    }

    protected IdentifierType createIdentifierType(String id, String type) {
        IdentifierType ident = new IdentifierType();
        ident.setId(id);
        ident.setType(type);
        return ident;
    }

    private SecuredContentType getSealedData(ListReservations listReservations) {
        SecuredContentType sct = new SecuredContentType();
        sct.setSecuredContent(this.sealForRecipe(listReservations, ListReservations.class));
        return sct;
    }

    protected void writeReservationsOnDisk(ListReservationsParam listReservationsParam, ListReservationsResult listReservationsResult, Calendar lastSyncDate) {
        if (!listReservationsResult.isHasMoreResults().booleanValue()) {
            this.writeLastDateToDisk(listReservationsParam, lastSyncDate);
        }
        this.writeRidsToDisk(listReservationsResult);
    }

    private void writeRidsToDisk(ListReservationsResult listReservationsResult) {
        String path = this.getPropertyHandler().getProperty("reservation.path");
        File folder = new File(path);
        for (ListReservationsResultItem item : listReservationsResult.getItems()) {
            try {
                File file;
                String creationDate;
                SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                String dateToPrintToFile = creationDate = df.format(item.getCreationDate().getTime());
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                if (!(file = new File(folder + "/" + item.getRid() + ".txt")).exists()) {
                    file.createNewFile();
                }
                FileWriter fw = new FileWriter(file.getAbsoluteFile());
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(dateToPrintToFile);
                bw.close();
            }
            catch (IOException e) {
                LOG.error("Error writing rids reservations to disk. Path: " + path + ". error: " + e.getMessage(), (Throwable)e);
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), e);
            }
        }
    }

    protected void writeLastDateToDisk(ListReservationsParam listReservationsParam, Calendar lastSyncDate) {
        try {
            String path = this.getPropertyHandler().getProperty("reservation.path");
            File filePath = new File(path);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            File file = new File(path + "/lastReservationSyncDate.txt");
            file.createNewFile();
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(file.getAbsoluteFile()));){
                SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                String date = df.format(lastSyncDate.getTime());
                bw.write(date);
                bw.flush();
            }
        }
        catch (IOException e) {
            LOG.error("Error writing last date to lastReservationSyncDate.txt file; " + e.getMessage(), (Throwable)e);
            throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Calendar readLastDateToDisk() {
        try {
            String path = this.getPropertyHandler().getProperty("reservation.path");
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            File file = new File(path + "/lastReservationSyncDate.txt");
            if (!file.exists()) {
                return null;
            }
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String st = br.readLine();
                if (st == null) {
                    Calendar calendar = null;
                    return calendar;
                }
                Date date = df.parse(st);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                Calendar calendar2 = calendar;
                return calendar2;
            }
        }
        catch (Exception e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), e);
        }
    }
}

