/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe;

import be.business.connector.common.ehealth.EhealthCipher;
import be.business.connector.common.ehealth.EhealthKeyRegistry;
import be.business.connector.common.ehealth.EhealthResponseKey;
import be.business.connector.common.ehealth.EhealthSystemKey;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.ETKHelper;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.MarshallerHelper;
import be.business.connector.core.utils.PropertyHandler;
import be.fgov.ehealth.recipe.core.v4.SecuredContentType;
import be.recipe.api.Prescription;
import be.recipe.api.constraints.Rejected;
import be.recipe.api.crypto.Message;
import be.recipe.services.core.StatusType;
import java.util.Calendar;
import java.util.Properties;
import java.util.UUID;
import java8.util.function.Consumer;
import java8.util.function.Function;
import java8.util.function.Supplier;
import javax.crypto.SecretKey;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;

public class AbstractRecipeClient {
    private static final String CODE_RED = "300";
    static Properties metadata;
    protected final String addressKey;
    private Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry;
    private RuntimeException exceptionToRaise;
    protected Message.Cipher.Key responseKey;
    protected Message.Cipher.Key systemKey;
    protected PropertyHandler properties;
    protected Message.Cipher cipher;
    private ETKHelper etkHelper;
    protected SecretKey symmKey;
    protected String address;
    public Supplier<String> traceId = new Supplier<String>(){

        public String get() {
            return "id" + UUID.randomUUID();
        }
    };
    public Consumer<String> captureTraceId = new Consumer<String>(){

        public void accept(String ignored) {
        }
    };

    public AbstractRecipeClient(String addressKey) {
        this.addressKey = addressKey;
    }

    public AbstractRecipeClient(String addressKey, Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry, Message.Cipher cipher, Supplier<String> traceId) {
        this(addressKey);
        this.keyRegistry = keyRegistry;
        this.traceId = traceId;
        this.cipher = cipher;
    }

    public AbstractRecipeClient(String addressKey, PropertyHandler properties) {
        this(addressKey, null, (Message.Cipher)new EhealthCipher(), new Supplier<String>(){

            public String get() {
                return "id" + UUID.randomUUID();
            }
        });
        this.refresh(properties);
    }

    public AbstractRecipeClient(String addressKey, Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry, Message.Cipher cipher, PropertyHandler properties) {
        this(addressKey, keyRegistry, cipher, new Supplier<String>(){

            public String get() {
                return UUID.randomUUID().toString();
            }
        });
        this.refresh(properties);
    }

    protected static LocalDateTime toLocalDateTime(Calendar calendar) {
        return AbstractRecipeClient.toZonedDateTime(calendar).toLocalDateTime();
    }

    protected static LocalDate toLocalDate(Calendar calendar) {
        return AbstractRecipeClient.toZonedDateTime(calendar).toLocalDate();
    }

    private static ZonedDateTime toZonedDateTime(Calendar calendar) {
        return ZonedDateTime.ofInstant((Instant)Instant.ofEpochMilli((long)calendar.getTimeInMillis()), (ZoneId)ZoneId.systemDefault());
    }

    protected static Function<Enum, String> toName() {
        return new Function<Enum, String>(){

            public String apply(Enum it) {
                return it.name();
            }
        };
    }

    protected static Function<String, String> toLowerCase() {
        return new Function<String, String>(){

            public String apply(String it) {
                return it.toLowerCase();
            }
        };
    }

    protected static Function<Object, String> toText() {
        return new Function<Object, String>(){

            public String apply(Object it) {
                return it.toString();
            }
        };
    }

    public void refresh(PropertyHandler properties) {
        EncryptionUtils encryptionUtils = new EncryptionUtils(PropertyHandler.getInstance());
        this.address = properties.getProperty(this.addressKey);
        this.etkHelper = new ETKHelper(properties, encryptionUtils);
        this.systemKey = new EhealthSystemKey(this.etkHelper);
        this.properties = properties;
        if (this.keyRegistry != null && this.keyRegistry instanceof EhealthKeyRegistry) {
            ((EhealthKeyRegistry)this.keyRegistry).refresh(this.etkHelper, properties);
        }
        this.initEncryption(encryptionUtils);
    }

    public void initEncryption(EncryptionUtils encryptionUtils) {
        ((EhealthCipher)this.cipher).crypto = null;
        this.symmKey = encryptionUtils.generateSecretKey();
        this.responseKey = new EhealthResponseKey(this.symmKey);
    }

    protected <T> byte[] encrypt(T it) {
        MarshallerHelper helper = new MarshallerHelper(Object.class, it.getClass());
        return this.cipher.encrypt(helper.toXMLByteArray(it), (Object)this.systemKey);
    }

    protected <T> T decrypt(byte[] bytes, Class<T> type) {
        MarshallerHelper<T, Object> marshaller = new MarshallerHelper<T, Object>(type, Object.class);
        return marshaller.toObject(this.cipher.decrypt(bytes, (Object)this.responseKey));
    }

    protected boolean rejected(StatusType status) {
        return status.getCode().equals(CODE_RED);
    }

    protected SecuredContentType content(byte[] encryptedBytes) {
        SecuredContentType content = new SecuredContentType();
        content.setSecuredContent(encryptedBytes);
        return content;
    }

    protected String programId() {
        return AbstractRecipeClient.programId(this.getClass().getSimpleName());
    }

    public static String programId(String defaultPrefix) {
        return PropertyHandler.getInstance().getProperty("programIdentification", defaultPrefix) + "-Recip-e-" + AbstractRecipeClient.metadata().get("version");
    }

    public static Properties metadata() {
        if (metadata != null) {
            return metadata;
        }
        metadata = AbstractRecipeClient.metadataWithoutCache();
        return metadata;
    }

    static Properties metadataWithoutCache() {
        Properties metadata = new Properties();
        metadata.setProperty("version", "5.5.10-SNAPSHOT");
        return metadata;
    }

    public void raise(RuntimeException e) {
        this.exceptionToRaise = e;
    }

    protected <T> T withExceptionHandling(String code, Supplier<T> task) {
        try {
            this.before();
            return (T)task.get();
        }
        catch (IntegrationModuleException | Rejected e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IntegrationModuleException(I18nHelper.getLabel(code), e);
        }
    }

    private void before() {
        if (this.exceptionToRaise != null) {
            throw this.exceptionToRaise;
        }
    }
}

