/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.projects.common.utils;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.exceptions.IntegrationModuleValidationException;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.projects.common.utils.INSZUtils;
import java8.util.Optional;
import java8.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.perf4j.aop.Profiled;

public class ValidationUtils {
    private static final String PHARMACY_NIHII = "-PHARMACY.NIHII";
    public static final String LOCKED = "locked";

    private ValidationUtils() {
    }

    public static void validatePatientIdNotBlank(String patientId) {
        if (StringUtils.isBlank((String)patientId)) {
            throw new IntegrationModuleException("Patient ID is 0.");
        }
    }

    @Profiled(logFailuresSeparately=true, tag="0.ValidationUtils#validatePatientId", logger="org.perf4j.TimingLogger_Common")
    public static void validatePatientId(String patientId) {
        if (!INSZUtils.isValidINSZ(patientId)) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.validation.patientid.incorrect"));
        }
    }

    public static void validateMandateHolderId(String mandateHolderId, boolean optional) {
        if (optional ? !StringUtils.isEmpty((String)mandateHolderId) && !INSZUtils.isValidINSZ(mandateHolderId) : StringUtils.isEmpty((String)mandateHolderId) || !INSZUtils.isValidINSZ(mandateHolderId)) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.validation.mandateholderid.incorrect"));
        }
    }

    public static void validateExpirationDate(String expirationDateText) throws IntegrationModuleValidationException {
        ValidationUtils.validateExpirationDate((LocalDate)Optional.ofNullable((Object)expirationDateText).map((Function)new Function<String, LocalDate>(){

            public LocalDate apply(String dateText) {
                return ValidationUtils.parseDate(dateText, "error.validation.expirationdate4");
            }
        }).orElse(null));
    }

    private static void validateExpirationDate(LocalDate expirationDate) throws IntegrationModuleValidationException {
        ValidationUtils.validateExpirationDate(expirationDate, LocalDate.now());
    }

    public static void validateExpirationDate(LocalDate expirationDate, LocalDate today) {
        if (expirationDate == null) {
            String label = I18nHelper.getLabel("error.validation.expirationdate1", null);
            throw new IntegrationModuleValidationException(label, label);
        }
    }

    private static LocalDate parseDate(String dateText, String errorKey) {
        try {
            return LocalDate.parse((String)dateText, (DateTimeFormatter)ISODateTimeFormat.date());
        }
        catch (Exception ex) {
            String label = I18nHelper.getLabel(errorKey, new Object[]{dateText});
            throw new IntegrationModuleValidationException(label, label);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Profiled(logFailuresSeparately=true, tag="0.ValidationUtils#validateVisi", logger="org.perf4j.TimingLogger_Common")
    public static void validateVisi(String vision, boolean patient) {
        if (patient) {
            String executorNbr;
            if (vision != null && !vision.equals("") && !vision.equalsIgnoreCase("null") && !vision.equalsIgnoreCase(LOCKED) && !vision.endsWith(PHARMACY_NIHII)) throw new IntegrationModuleValidationException(I18nHelper.getLabel("error.validation.vision.invalid.message", new Object[]{vision}));
            if (vision == null || !vision.endsWith(PHARMACY_NIHII) || StringUtils.isNumeric((String)(executorNbr = vision.replaceAll(PHARMACY_NIHII, "")))) return;
            throw new IntegrationModuleValidationException(I18nHelper.getLabel("error.validation.vision.invalid.message", new Object[]{vision}));
        }
        if (vision == null || vision.equals("") || vision.equalsIgnoreCase("null") || vision.equalsIgnoreCase(LOCKED)) return;
        throw new IntegrationModuleValidationException(I18nHelper.getLabel("error.validation.vision.invalid.prescriber.message", new Object[]{vision}));
    }
}

