/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.projects.common.utils;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;

public class INSZUtils {
    public static final BigInteger NINETY_SEVEN = new BigInteger("97");

    public static boolean isValidINSZ(String inss) {
        if (inss == null || StringUtils.isBlank((CharSequence)inss) || inss.length() != 11) {
            return false;
        }
        return INSZUtils.isNumeric(inss) && INSZUtils.check97MinusModulo97(inss) && INSZUtils.validDate(inss);
    }

    private static boolean isNumeric(String s) {
        return s != null && s.replaceAll("\\D", "").equals(s);
    }

    private static boolean check97MinusModulo97(String fieldValue) {
        boolean res = false;
        if (StringUtils.isNotBlank((CharSequence)fieldValue) && fieldValue.length() > 1) {
            Integer checkValue = new Integer(fieldValue.substring(fieldValue.length() - 2));
            BigInteger fullNumber = new BigInteger(fieldValue.substring(0, fieldValue.length() - 2));
            int modulo = fullNumber.mod(NINETY_SEVEN).intValue();
            boolean bl = res = checkValue == 97 - modulo;
            if (checkValue == 97) {
                res = INSZUtils.checkModulo97(fieldValue);
            }
            if (!res) {
                fieldValue = "2" + fieldValue;
                fullNumber = new BigInteger(fieldValue.substring(0, fieldValue.length() - 2));
                modulo = fullNumber.mod(NINETY_SEVEN).intValue();
                boolean bl2 = res = checkValue == 97 - modulo;
                if (checkValue == 97) {
                    res = INSZUtils.checkModulo97(fieldValue);
                }
            }
        }
        return res;
    }

    private static boolean checkModulo97(String fieldValue) {
        boolean res = false;
        Integer checkValue = new Integer(fieldValue.substring(fieldValue.length() - 2));
        Integer specialCheckValue = new Integer("97");
        if (checkValue.intValue() == specialCheckValue.intValue()) {
            Integer checkNull = new Integer("0");
            BigInteger fullNumber = new BigInteger(fieldValue.substring(0, fieldValue.length() - 2));
            Integer modulo = new Integer(fullNumber.mod(new BigInteger("97")).intValue());
            int isTrue = checkNull.compareTo(modulo);
            if (isTrue == 0) {
                res = true;
            }
        } else {
            BigInteger fullNumber = new BigInteger(fieldValue.substring(0, fieldValue.length() - 2));
            Integer modulo = new Integer(fullNumber.mod(new BigInteger("97")).intValue());
            res = checkValue.intValue() == modulo.intValue();
        }
        return res;
    }

    private static boolean validDate(String fieldValue) {
        boolean res = false;
        if (StringUtils.isNotBlank((CharSequence)fieldValue) && fieldValue.length() > 1) {
            String sDay;
            String sYear = fieldValue.substring(0, 2);
            String sMonth = fieldValue.substring(2, 4);
            int iMonth = Integer.parseInt(sMonth);
            if (iMonth > 40) {
                iMonth -= 40;
            } else if (iMonth > 20) {
                iMonth -= 20;
            }
            String realMonth = String.format("%02d", iMonth);
            if (realMonth.equals("00")) {
                realMonth = "01";
            }
            if ((sDay = fieldValue.substring(4, 6)).equals("00")) {
                sDay = "01";
            }
            String yearRealMonthDay = sYear + realMonth + sDay;
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
            sdf.setLenient(false);
            try {
                sdf.parse(yearRealMonthDay);
                res = true;
            }
            catch (Exception e) {
                res = false;
            }
        }
        return res;
    }
}

