/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.SAMLTokenValidator;
import be.ehealth.technicalconnector.session.SessionItem;

public class SessionValidator {
    public static void assertValidSession(SessionItem sessionItem) throws IntegrationModuleException {
        if (!SessionValidator.isValidSession(sessionItem)) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.invalid.session"));
        }
    }

    public static void assertValidPharmacySession(SessionItem sessionItem) throws IntegrationModuleException {
        if (!SessionValidator.isValidPharmacySession(sessionItem)) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.invalid.session"));
        }
    }

    public static void assertValidHospitalPharmacySession(SessionItem sessionItem) throws IntegrationModuleException {
        if (!SessionValidator.isValidHospitalPharmacySession(sessionItem)) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.invalid.session"));
        }
    }

    public static boolean isValidSession(SessionItem sessionItem) {
        return sessionItem != null && sessionItem.getSAMLToken() != null && SAMLTokenValidator.isValid(sessionItem.getSAMLToken().getAssertion());
    }

    public static boolean isValidPharmacySession(SessionItem sessionItem) {
        return sessionItem != null && sessionItem.getSAMLToken() != null && SAMLTokenValidator.isValidPharmacySession(sessionItem.getSAMLToken().getAssertion());
    }

    public static boolean isValidHospitalPharmacySession(SessionItem sessionItem) {
        return sessionItem != null && sessionItem.getSAMLToken() != null && SAMLTokenValidator.isValidHospitalPharmacySession(sessionItem.getSAMLToken().getAssertion());
    }
}

